# Generated by default/object.tt
package Paws::Route53Resolver::FirewallConfig;
  use Moose;
  has FirewallFailOpen => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has OwnerId => (is => 'ro', isa => 'Str');
  has ResourceId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53Resolver::FirewallConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Route53Resolver::FirewallConfig object:

  $service_obj->Method(Att1 => { FirewallFailOpen => $value, ..., ResourceId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Route53Resolver::FirewallConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->FirewallFailOpen

=head1 DESCRIPTION

Configuration of the firewall behavior provided by DNS Firewall for a
single VPC from Amazon Virtual Private Cloud (Amazon VPC).

=head1 ATTRIBUTES


=head2 FirewallFailOpen => Str

Determines how DNS Firewall operates during failures, for example when
all traffic that is sent to DNS Firewall fails to receive a reply.

=over

=item *

By default, fail open is disabled, which means the failure mode is
closed. This approach favors security over availability. DNS Firewall
returns a failure error when it is unable to properly evaluate a query.

=item *

If you enable this option, the failure mode is open. This approach
favors availability over security. DNS Firewall allows queries to
proceed if it is unable to properly evaluate them.

=back

This behavior is only enforced for VPCs that have at least one DNS
Firewall rule group association.


=head2 Id => Str

The ID of the firewall configuration.


=head2 OwnerId => Str

The AWS account ID of the owner of the VPC that this firewall
configuration applies to.


=head2 ResourceId => Str

The ID of the VPC that this firewall configuration applies to.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Route53Resolver>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

