# Generated by default/object.tt
package Paws::Glue::RegistryId;
  use Moose;
  has RegistryArn => (is => 'ro', isa => 'Str');
  has RegistryName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::RegistryId

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::RegistryId object:

  $service_obj->Method(Att1 => { RegistryArn => $value, ..., RegistryName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::RegistryId object:

  $result = $service_obj->Method(...);
  $result->Att1->RegistryArn

=head1 DESCRIPTION

A wrapper structure that may contain the registry name and Amazon
Resource Name (ARN).

=head1 ATTRIBUTES


=head2 RegistryArn => Str

Arn of the registry to be updated. One of C<RegistryArn> or
C<RegistryName> has to be provided.


=head2 RegistryName => Str

Name of the registry. Used only for lookup. One of C<RegistryArn> or
C<RegistryName> has to be provided.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

