# Generated by default/object.tt
package Paws::IoT::DetectMitigationActionsTaskSummary;
  use Moose;
  has ActionsDefinition => (is => 'ro', isa => 'ArrayRef[Paws::IoT::MitigationAction]', request_name => 'actionsDefinition', traits => ['NameInRequest']);
  has OnlyActiveViolationsIncluded => (is => 'ro', isa => 'Bool', request_name => 'onlyActiveViolationsIncluded', traits => ['NameInRequest']);
  has SuppressedAlertsIncluded => (is => 'ro', isa => 'Bool', request_name => 'suppressedAlertsIncluded', traits => ['NameInRequest']);
  has Target => (is => 'ro', isa => 'Paws::IoT::DetectMitigationActionsTaskTarget', request_name => 'target', traits => ['NameInRequest']);
  has TaskEndTime => (is => 'ro', isa => 'Str', request_name => 'taskEndTime', traits => ['NameInRequest']);
  has TaskId => (is => 'ro', isa => 'Str', request_name => 'taskId', traits => ['NameInRequest']);
  has TaskStartTime => (is => 'ro', isa => 'Str', request_name => 'taskStartTime', traits => ['NameInRequest']);
  has TaskStatistics => (is => 'ro', isa => 'Paws::IoT::DetectMitigationActionsTaskStatistics', request_name => 'taskStatistics', traits => ['NameInRequest']);
  has TaskStatus => (is => 'ro', isa => 'Str', request_name => 'taskStatus', traits => ['NameInRequest']);
  has ViolationEventOccurrenceRange => (is => 'ro', isa => 'Paws::IoT::ViolationEventOccurrenceRange', request_name => 'violationEventOccurrenceRange', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::DetectMitigationActionsTaskSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::DetectMitigationActionsTaskSummary object:

  $service_obj->Method(Att1 => { ActionsDefinition => $value, ..., ViolationEventOccurrenceRange => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::DetectMitigationActionsTaskSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ActionsDefinition

=head1 DESCRIPTION

The summary of the mitigation action tasks.

=head1 ATTRIBUTES


=head2 ActionsDefinition => ArrayRef[L<Paws::IoT::MitigationAction>]

The definition of the actions.


=head2 OnlyActiveViolationsIncluded => Bool

Includes only active violations.


=head2 SuppressedAlertsIncluded => Bool

Includes suppressed alerts.


=head2 Target => L<Paws::IoT::DetectMitigationActionsTaskTarget>

Specifies the ML Detect findings to which the mitigation actions are
applied.


=head2 TaskEndTime => Str

The date the task ended.


=head2 TaskId => Str

The unique identifier of the task.


=head2 TaskStartTime => Str

The date the task started.


=head2 TaskStatistics => L<Paws::IoT::DetectMitigationActionsTaskStatistics>

The statistics of a mitigation action task.


=head2 TaskStatus => Str

The status of the task.


=head2 ViolationEventOccurrenceRange => L<Paws::IoT::ViolationEventOccurrenceRange>

Specifies the time period of which violation events occurred between.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

