# Generated by default/object.tt
package Paws::CodeBuild::ExportedEnvironmentVariable;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Value => (is => 'ro', isa => 'Str', request_name => 'value', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeBuild::ExportedEnvironmentVariable

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeBuild::ExportedEnvironmentVariable object:

  $service_obj->Method(Att1 => { Name => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeBuild::ExportedEnvironmentVariable object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Contains information about an exported environment variable.

Exported environment variables are used in conjunction with
CodePipeline to export environment variables from the current build
stage to subsequent stages in the pipeline. For more information, see
Working with variables
(https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-variables.html)
in the I<CodePipeline User Guide>.

During a build, the value of a variable is available starting with the
C<install> phase. It can be updated between the start of the C<install>
phase and the end of the C<post_build> phase. After the C<post_build>
phase ends, the value of exported variables cannot change.

=head1 ATTRIBUTES


=head2 Name => Str

The name of the exported environment variable.


=head2 Value => Str

The value assigned to the exported environment variable.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeBuild>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

