Tkx.pm
------

The Tkx module provides yet another Tk interface for Perl.  Tk is a GUI
toolkit tied to the Tcl language, and Tkx provides a bridge to Tcl that
allows Tk based applications to be written in Perl.

The main idea behind Tkx is that it is a very thin wrapper on top of
Tcl, i.e. that what you get is exactly the behaviour you read about in
the Tcl/Tk documentation with no surprises added by the Perl layer.
In order to use Tkx, you need to understand enough Tcl to be able to
read the documentation for Tcl/Tk and figure out how this maps to the
Tkx.  You will not need to write any Tcl code though, as all your GUI
work, including the creation of megawidgets can be done in Perl using
Tkx.

The benefit of this approach compared Nick Ing-Simmons's classic
[Perl/Tk](https://metacpan.org/pod/Tk)
module is that you can always use the latest features that Tcl/Tk
provides and that you can use Tcl's native megawidgets directly.
Perl/Tk has stagnated because of the huge effort needed to port
it to run with newer versions of Tk.  The downside of the Tkx approach
is that you will need to know a bit about Tcl and that you have to
install Tcl/Tk on both your development and deployment systems.
Another downside is that you will not be able to use any of the `Tk::`
add-ons or megawidgets already present on CPAN.

Tkx is the toolkit used to implement the GUI frontends of ActiveState's
PDK tools.

In order to install Tkx, you will need to have Tcl/Tk 8.4 or later,
and Perl 5.8 or later with the [Tcl.pm](https://metacpan.org/pod/Tcl)
module installed.  Installation otherwise follows the normal drill:

   perl Makefile.PL
   make
   make test
   make install

If you have questions about this code or want to report bugs send a
message to the tcltk@perl.org mailing list.  To subscribe to this
list, send an empty message to tcltk-subscribe@perl.org.

The official source repository for Tkx is
https://github.com/chrstphrchvz/tkx.  You can grab the latest sources
with:

   git clone https://github.com/chrstphrchvz/tkx.git

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

Copyright 2005 ActiveState.  All rights reserved.
