/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class PageExtractor {
    protected PDDocument sourceDocument;
    protected int startPage = 1;
    protected int endPage = 0;

    public PageExtractor(PDDocument sourceDocument) {
        this.sourceDocument = sourceDocument;
        this.endPage = sourceDocument.getNumberOfPages();
    }

    public PageExtractor(PDDocument sourceDocument, int startPage, int endPage) {
        this(sourceDocument);
        this.startPage = startPage;
        this.endPage = endPage;
    }

    public PDDocument extract() throws IOException {
        PDDocument extractedDocument = new PDDocument();
        extractedDocument.setDocumentInformation(this.sourceDocument.getDocumentInformation());
        extractedDocument.getDocumentCatalog().setViewerPreferences(this.sourceDocument.getDocumentCatalog().getViewerPreferences());
        List pages = this.sourceDocument.getDocumentCatalog().getAllPages();
        int pageCounter = 1;
        for (PDPage page : pages) {
            if (pageCounter >= this.startPage && pageCounter <= this.endPage) {
                PDPage imported = extractedDocument.importPage(page);
                imported.setCropBox(page.findCropBox());
                imported.setMediaBox(page.findMediaBox());
                imported.setResources(page.findResources());
                imported.setRotation(page.findRotation());
            }
            ++pageCounter;
        }
        return extractedDocument;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }
}

