/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.poi.hemf.record.HemfRecord;
import org.apache.poi.hemf.record.HemfRecordType;
import org.apache.poi.hemf.record.UnimplementedHemfRecord;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.RecordFormatException;

@Internal
public class HemfText {
    private static final Charset UTF16LE = Charset.forName("UTF-16LE");
    private static final int MAX_RECORD_LENGTH = 1000000;

    private static class EmrTextObject {
        long x;
        long y;
        int numChars;
        byte[] rawTextBytes;

        EmrTextObject(byte[] emrTextObjBytes, Charset charsetHint, int readSoFar) throws IOException {
            int offset = 0;
            this.x = LittleEndian.getUInt(emrTextObjBytes, offset);
            this.y = LittleEndian.getUInt(emrTextObjBytes, offset += 4);
            long numCharsLong = LittleEndian.getUInt(emrTextObjBytes, offset += 4);
            long offString = LittleEndian.getUInt(emrTextObjBytes, offset += 4);
            int start = (int)offString - (offset += 4) - readSoFar;
            if (numCharsLong == 0L) {
                this.rawTextBytes = new byte[0];
                this.numChars = 0;
                return;
            }
            if (numCharsLong > Integer.MAX_VALUE) {
                throw new RecordFormatException("Number of characters can't be > Integer.MAX_VALUE");
            }
            if (numCharsLong < 0L) {
                throw new RecordFormatException("Number of characters can't be < 0");
            }
            this.numChars = (int)numCharsLong;
            this.rawTextBytes = IOUtils.safelyAllocate(emrTextObjBytes.length - start, 1000000);
            System.arraycopy(emrTextObjBytes, start, this.rawTextBytes, 0, emrTextObjBytes.length - start);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getText(Charset charset) throws IOException {
            StringBuilder sb = new StringBuilder();
            InputStreamReader r = null;
            try {
                r = new InputStreamReader((InputStream)new ByteArrayInputStream(this.rawTextBytes), charset);
                for (int i = 0; i < this.numChars; ++i) {
                    sb.appendCodePoint(this.readCodePoint(r));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(r);
                throw throwable;
            }
            IOUtils.closeQuietly(r);
            return sb.toString();
        }

        private int readCodePoint(Reader r) throws IOException {
            int c1 = r.read();
            if (c1 == -1) {
                throw new EOFException("Tried to read beyond byte array");
            }
            if (!Character.isHighSurrogate((char)c1)) {
                return c1;
            }
            int c2 = r.read();
            if (c2 == -1) {
                throw new EOFException("Tried to read beyond byte array");
            }
            if (!Character.isLowSurrogate((char)c2)) {
                throw new RecordFormatException("Expected low surrogate after high surrogate");
            }
            return Character.toCodePoint((char)c1, (char)c2);
        }
    }

    public static class SetTextJustification
    extends UnimplementedHemfRecord {
    }

    public static class SetTextColor
    extends UnimplementedHemfRecord {
    }

    public static class SetTextAlign
    extends UnimplementedHemfRecord {
    }

    public static class PolyTextOutW
    extends UnimplementedHemfRecord {
    }

    public static class PolyTextOutA
    extends UnimplementedHemfRecord {
    }

    public static class ExtTextOutW
    extends ExtTextOutA {
        @Override
        public HemfRecordType getRecordType() {
            return HemfRecordType.exttextoutw;
        }

        @Override
        protected Charset getEncodingHint() {
            return UTF16LE;
        }

        public String getText() throws IOException {
            return this.getText(UTF16LE);
        }
    }

    public static class ExtTextOutA
    implements HemfRecord {
        private long left;
        private long top;
        private long right;
        private long bottom;
        private long graphicsMode;
        private long exScale;
        private long eyScale;
        EmrTextObject textObject;

        @Override
        public HemfRecordType getRecordType() {
            return HemfRecordType.exttextouta;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordId, long recordSize) throws IOException {
            this.left = leis.readInt();
            this.top = leis.readInt();
            this.right = leis.readInt();
            this.bottom = leis.readInt();
            this.graphicsMode = leis.readUInt();
            this.exScale = leis.readUInt();
            this.eyScale = leis.readUInt();
            int recordSizeInt = -1;
            if (recordSize >= Integer.MAX_VALUE) {
                throw new RecordFormatException("can't have text length > Integer.MAX_VALUE");
            }
            recordSizeInt = (int)recordSize;
            byte[] emrTextBytes = IOUtils.safelyAllocate(recordSizeInt - 28, 1000000);
            IOUtils.readFully(leis, emrTextBytes);
            this.textObject = new EmrTextObject(emrTextBytes, this.getEncodingHint(), 20);
            return recordSize;
        }

        protected Charset getEncodingHint() {
            return null;
        }

        public String getText(Charset charset) throws IOException {
            return this.textObject.getText(charset);
        }

        public long getX() {
            return this.textObject.x;
        }

        public long getY() {
            return this.textObject.y;
        }

        public long getLeft() {
            return this.left;
        }

        public long getTop() {
            return this.top;
        }

        public long getRight() {
            return this.right;
        }

        public long getBottom() {
            return this.bottom;
        }

        public long getGraphicsMode() {
            return this.graphicsMode;
        }

        public long getExScale() {
            return this.exScale;
        }

        public long getEyScale() {
            return this.eyScale;
        }
    }

    public static class ExtCreateFontIndirectW
    extends UnimplementedHemfRecord {
    }
}

