/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.sis.index.tree.NodeType;
import org.apache.sis.index.tree.QuadTree;
import org.apache.sis.index.tree.QuadTreeData;
import org.apache.sis.index.tree.QuadTreeNode;
import org.apache.sis.index.tree.Quadrant;

public final class QuadTreeWriter {
    private QuadTreeWriter() {
    }

    public static void writeTreeToFile(QuadTree quadTree, String string) {
        QuadTreeWriter.createIdxDir(string);
        QuadTreeWriter.writeTreeConfigsToFile(quadTree, string);
        QuadTreeWriter.writeNodeToFile(quadTree.getRoot(), string);
    }

    private static void createIdxDir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("[INFO] Creating qtree idx dir: [" + string + "]");
            new File(string).mkdirs();
        }
    }

    private static void writeTreeConfigsToFile(QuadTree quadTree, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + "tree_config.txt"));
            bufferedWriter.write("capacity;" + quadTree.getCapacity() + ";depth;" + quadTree.getDepth());
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writeNodeToFile(QuadTreeNode quadTreeNode, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + "node_" + quadTreeNode.getId() + ".txt"));
            if (quadTreeNode.getNodeType() == NodeType.GRAY) {
                if (quadTreeNode.getChild(Quadrant.NW) != null) {
                    bufferedWriter.write(QuadTreeWriter.getQuadTreeDataString(Quadrant.NW, quadTreeNode.getChild(Quadrant.NW)));
                    bufferedWriter.newLine();
                }
                if (quadTreeNode.getChild(Quadrant.NE) != null) {
                    bufferedWriter.write(QuadTreeWriter.getQuadTreeDataString(Quadrant.NE, quadTreeNode.getChild(Quadrant.NE)));
                    bufferedWriter.newLine();
                }
                if (quadTreeNode.getChild(Quadrant.SW) != null) {
                    bufferedWriter.write(QuadTreeWriter.getQuadTreeDataString(Quadrant.SW, quadTreeNode.getChild(Quadrant.SW)));
                    bufferedWriter.newLine();
                }
                if (quadTreeNode.getChild(Quadrant.SE) != null) {
                    bufferedWriter.write(QuadTreeWriter.getQuadTreeDataString(Quadrant.SE, quadTreeNode.getChild(Quadrant.SE)));
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (quadTreeNode.getNodeType() == NodeType.GRAY) {
            if (quadTreeNode.getChild(Quadrant.NW) != null && quadTreeNode.getChild(Quadrant.NW).getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeNodeToFile(quadTreeNode.getChild(Quadrant.NW), string);
            }
            if (quadTreeNode.getChild(Quadrant.NE) != null && quadTreeNode.getChild(Quadrant.NE).getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeNodeToFile(quadTreeNode.getChild(Quadrant.NE), string);
            }
            if (quadTreeNode.getChild(Quadrant.SW) != null && quadTreeNode.getChild(Quadrant.SW).getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeNodeToFile(quadTreeNode.getChild(Quadrant.SW), string);
            }
            if (quadTreeNode.getChild(Quadrant.SE) != null && quadTreeNode.getChild(Quadrant.SE).getNodeType() == NodeType.GRAY) {
                QuadTreeWriter.writeNodeToFile(quadTreeNode.getChild(Quadrant.SE), string);
            }
        }
    }

    private static String getQuadTreeDataString(Quadrant quadrant, QuadTreeNode quadTreeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(quadrant.index());
        stringBuffer.append(':');
        stringBuffer.append(quadTreeNode.getNodeType().toString());
        stringBuffer.append(':');
        stringBuffer.append(quadTreeNode.getId());
        stringBuffer.append(':');
        stringBuffer.append(quadTreeNode.getCapacity());
        stringBuffer.append(':');
        QuadTreeData[] quadTreeDataArray = quadTreeNode.getData();
        for (int i = 0; i < quadTreeNode.getCount(); ++i) {
            stringBuffer.append(quadTreeDataArray[i].getLatLon().y);
            stringBuffer.append(';');
            stringBuffer.append(quadTreeDataArray[i].getLatLon().x);
            stringBuffer.append(';');
            stringBuffer.append(quadTreeDataArray[i].getFileName());
            stringBuffer.append(':');
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }
}

