/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.xml.names.CatalogElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.ThreddsXmlParserIssue;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.DatasetElementParser;
import thredds.catalog2.xml.parser.stax.PropertyElementParser;
import thredds.catalog2.xml.parser.stax.ServiceElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;
import ucar.nc2.units.DateType;

class CatalogElementParser
extends AbstractElementParser {
    private final String docBaseUriString;
    private final PropertyElementParser.Factory propertyElemParserFactory;
    private final ServiceElementParser.Factory serviceElemParserFactory;
    private final DatasetElementParser.Factory datasetElemParserFactory;
    CatalogBuilder selfBuilder;

    private CatalogElementParser(QName elementName, String docBaseUriString, XMLEventReader reader, ThreddsBuilderFactory builderFactory) {
        super(elementName, reader, builderFactory);
        this.docBaseUriString = docBaseUriString;
        this.propertyElemParserFactory = new PropertyElementParser.Factory();
        this.serviceElemParserFactory = new ServiceElementParser.Factory();
        this.datasetElemParserFactory = new DatasetElementParser.Factory();
    }

    @Override
    CatalogBuilder getSelfBuilder() {
        return this.selfBuilder;
    }

    @Override
    void parseStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        Attribute nameAtt = startElement.getAttributeByName(CatalogElementNames.CatalogElement_Name);
        String nameString = nameAtt != null ? nameAtt.getValue() : null;
        Attribute versionAtt = startElement.getAttributeByName(CatalogElementNames.CatalogElement_Version);
        String versionString = versionAtt != null ? versionAtt.getValue() : null;
        Attribute expiresAtt = startElement.getAttributeByName(CatalogElementNames.CatalogElement_Expires);
        String expiresString = expiresAtt != null ? expiresAtt.getValue() : null;
        DateType expires = null;
        try {
            expires = expiresString != null ? new DateType(expiresString, null, null) : null;
        }
        catch (ParseException e) {
            String msg = "Failed to parse catalog expires date [" + expiresString + "].";
            ThreddsXmlParserIssue issue = StaxThreddsXmlParserUtils.createIssueForException(msg, this.reader, e);
            this.log.warn("parseStartElement(): " + issue.getMessage(), e);
            throw new ThreddsXmlParserException(issue);
        }
        Attribute lastModifiedAtt = startElement.getAttributeByName(CatalogElementNames.CatalogElement_LastModified);
        String lastModifiedString = lastModifiedAtt != null ? lastModifiedAtt.getValue() : null;
        DateType lastModified = null;
        try {
            lastModified = lastModifiedString != null ? new DateType(lastModifiedString, null, null) : null;
        }
        catch (ParseException e) {
            String msg = "Failed to parse catalog lastModified date [" + lastModifiedString + "].";
            ThreddsXmlParserIssue issue = StaxThreddsXmlParserUtils.createIssueForException(msg, this.reader, e);
            this.log.warn("parseStartElement(): " + issue.getMessage(), e);
            throw new ThreddsXmlParserException(issue);
        }
        URI docBaseUri = null;
        try {
            docBaseUri = new URI(this.docBaseUriString);
        }
        catch (URISyntaxException e) {
            String msg = "Bad catalog base URI [" + this.docBaseUriString + "].";
            ThreddsXmlParserIssue issue = StaxThreddsXmlParserUtils.createIssueForException(msg, this.reader, e);
            this.log.warn("parseStartElement(): " + issue.getMessage(), e);
            throw new ThreddsXmlParserException(issue);
        }
        this.selfBuilder = this.builderFactory.newCatalogBuilder(nameString, docBaseUri, versionString, expires, lastModified);
    }

    @Override
    void handleChildStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (this.serviceElemParserFactory.isEventMyStartElement(startElement)) {
            ServiceElementParser serviceElemParser = this.serviceElemParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
            serviceElemParser.parse();
        } else if (this.propertyElemParserFactory.isEventMyStartElement(startElement)) {
            PropertyElementParser parser = this.propertyElemParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
            parser.parse();
        } else if (this.datasetElemParserFactory.isEventMyStartElement(startElement)) {
            DatasetElementParser parser = this.datasetElemParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder, null);
            parser.parse();
        } else {
            StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
        }
    }

    @Override
    void postProcessingAfterEndElement() throws ThreddsXmlParserException {
    }

    static class Factory {
        private QName elementName = CatalogElementNames.CatalogElement;

        Factory() {
        }

        boolean isEventMyStartElement(XMLEvent event) {
            return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
        }

        CatalogElementParser getNewParser(String docBaseUriString, XMLEventReader reader, ThreddsBuilderFactory builderFactory) {
            return new CatalogElementParser(this.elementName, docBaseUriString, reader, builderFactory);
        }
    }
}

