/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.syntaxgraph.feature;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.AddressFunction;
import org.maltparser.core.feature.value.AddressValue;
import org.maltparser.core.io.dataformat.DataFormatInstance;
import org.maltparser.core.symbol.nullvalue.NullValues;
import org.maltparser.core.syntaxgraph.SyntaxGraphException;
import org.maltparser.core.syntaxgraph.feature.ColumnFeature;
import org.maltparser.core.syntaxgraph.node.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InputColumnFeature
extends ColumnFeature {
    protected AddressFunction addressFunction;
    protected DataFormatInstance dataFormatInstance;

    public InputColumnFeature(DataFormatInstance dataFormatInstance) throws MaltChainedException {
        this.setDataFormatInstance(dataFormatInstance);
    }

    @Override
    public void initialize(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 2) {
            throw new SyntaxGraphException("Could not initialize InputColumnFeature: number of arguments are not correct. ");
        }
        if (!(arguments[0] instanceof String)) {
            throw new SyntaxGraphException("Could not initialize InputColumnFeature: the first argument is not a string. ");
        }
        if (!(arguments[1] instanceof AddressFunction)) {
            throw new SyntaxGraphException("Could not initialize InputColumnFeature: the second argument is not an address function. ");
        }
        this.setColumn(this.dataFormatInstance.getColumnDescriptionByName((String)arguments[0]));
        this.setAddressFunction((AddressFunction)arguments[1]);
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class[] paramTypes = new Class[]{String.class, AddressFunction.class};
        return paramTypes;
    }

    @Override
    public void update() throws MaltChainedException {
        AddressValue a = this.addressFunction.getAddressValue();
        if (a.getAddress() == null) {
            this.featureValue.setCode(this.column.getSymbolTable().getNullValueCode(NullValues.NullValueId.NO_NODE));
            this.featureValue.setSymbol(this.column.getSymbolTable().getNullValueSymbol(NullValues.NullValueId.NO_NODE));
            this.featureValue.setKnown(true);
            this.featureValue.setNullValue(true);
        } else {
            DependencyNode node = (DependencyNode)a.getAddress();
            if (!node.isRoot()) {
                this.featureValue.setCode(node.getLabelCode(this.column.getSymbolTable()));
                this.featureValue.setSymbol(this.column.getSymbolTable().getSymbolCodeToString(node.getLabelCode(this.column.getSymbolTable())));
                this.featureValue.setKnown(this.column.getSymbolTable().getKnown(node.getLabelCode(this.column.getSymbolTable())));
                this.featureValue.setNullValue(false);
            } else {
                this.featureValue.setCode(this.column.getSymbolTable().getNullValueCode(NullValues.NullValueId.ROOT_NODE));
                this.featureValue.setSymbol(this.column.getSymbolTable().getNullValueSymbol(NullValues.NullValueId.ROOT_NODE));
                this.featureValue.setKnown(true);
                this.featureValue.setNullValue(true);
            }
        }
    }

    public AddressFunction getAddressFunction() {
        return this.addressFunction;
    }

    public void setAddressFunction(AddressFunction addressFunction) {
        this.addressFunction = addressFunction;
    }

    public DataFormatInstance getDataFormatInstance() {
        return this.dataFormatInstance;
    }

    public void setDataFormatInstance(DataFormatInstance dataFormatInstance) {
        this.dataFormatInstance = dataFormatInstance;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public int hashCode() {
        return 217 + (null == this.toString() ? 0 : this.toString().hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InputColumn(");
        sb.append(super.toString());
        sb.append(", ");
        sb.append(this.addressFunction.toString());
        sb.append(")");
        return sb.toString();
    }
}

