# Generated by default/object.tt
package Paws::MediaTailor::Transition;
  use Moose;
  has RelativePosition => (is => 'ro', isa => 'Str', required => 1);
  has RelativeProgram => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::Transition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::Transition object:

  $service_obj->Method(Att1 => { RelativePosition => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::Transition object:

  $result = $service_obj->Method(...);
  $result->Att1->RelativePosition

=head1 DESCRIPTION

Program transition configuration.

=head1 ATTRIBUTES


=head2 B<REQUIRED> RelativePosition => Str

The position where this program will be inserted relative to the
RelativeProgram. Possible values are: AFTER_PROGRAM, and
BEFORE_PROGRAM.


=head2 RelativeProgram => Str

The name of the program that this program will be inserted next to, as
defined by RelativePosition.


=head2 B<REQUIRED> Type => Str

When the program should be played. RELATIVE means that programs will be
played back-to-back.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

