use strict;
use warnings;
use Test::More;
use Digest::BLAKE qw(blake_384 blake_384_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::BLAKE->new(384)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            blake_384_hex($data), $digest,
            "blake_384_hex: $len bits of $msg"
        );
        ok(
            blake_384($data) eq pack('H*', $digest),
            "blake_384: $len bits of $msg"
        );
    }

    my $md = Digest::BLAKE->new(384)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|c6cbd89c926ab525c242e6621f2f5fa73aa4afe3d9e24aed727faaadd6af38b620bdb623dd2b4788b1c8086984af8706
00|1ffde9711b419d7c97dc142e7704d2ae61163f8a818c47938b978d6113949d8e7819b9699d497a3b289b8bb4415ffae7
C0|195d771c302bb1ca0c9ac55a782cbe877bc0bc28016f735de68d7cf5fc1d0a99cc69a32cb0174fd2a97d5fcf46aafded
C0|883b186d9372a04d585eb1eef1cd32ff8a7c061d5e396f05fd9d3d9d6033de757bfc3adf30b06d7fb02a875a2ac0db70
80|91140c47ba7ef06fe6810acef4be65ad772576291778c6b5588b08fd48beeae4e70c3ac4abb9636a637e9a6359a19053
48|f03566b78ead38d98f787c08f117817702d24d3bc8c663551393a1f2e6a079855434414789b34dd360df198eb00e67a2
50|68eeca6e6550ece0662882bd36605eeabea74230171225b708c1a375c90e4a59fec2eff42eba07441dc1f48d39665bd6
98|70bb604b0893b22e2f4e2fc0e9cfd725648c9ff217df8eee219a7a1cab3039158ff1ae3c8b2106165f00e3dac9301adb
CC|a77e65c0c03ecb831dbcdd50a3c2bce300d55eac002a9c197095518d8514c0b578e3ecb7415291f99ede91d49197dd05
9800|fdf53e189982aead4849b6fba84b9e84a7f4c38a580840344e4017819f30901ca333b12954ea811049e023f073a69ae2
9D40|0afc73af8a4f8645cfb30ceab03c256cabf8088d5452c66a766159428de6050484f39b31cb4eebbcb2a06a8a7b0e4626
AA80|7939c08121bcbdd2d87069a3f8feedc3e1eeaa7a140574afd126441f4ed9e32b783ca02f33bb454aa6d05494d4c9028d
9830|a9045405bb39e7f6f89398160208d61f2f4ccbd5c688a6b67aa6eef78d00ef1ee8c6779b781b8603eaf585d475cd86d5
5030|bcbc3cff50f0bd0f03c9dcba0296f7bd7a9e111361335cdd8cb47cc02fe6bcff01d3244c6b7141b77b4cbfc88d6cd320
4D24|9bc5c48e85de4ea136072a53b31d964668175c378a424af4503a454637cd55fa091b2e1a005a6f308f18f5f2b90900a3
CBDE|4f1eea4e836e12d8521bce58831481e80fec26d40fbef756e571c9cf1e1072008a2475fbdda6b1dc6ff09238f2675329
41FB|e80a87362c9d39e2074ac135e2514b0cdf0001bfd8c35888d7ca8bbc4e918a157386524d41579e7fcd9c3c9a4f7a991a
4FF400|28a0158d802b4e6ca90dbd9558140dada402b3fa3f556fc06ab9cd0e645a32eb1793d5ba321e8e6fcbaef6403ba5d4c3
FD0440|cf58d202fc28371bca34f2698569a87d06633777c457312341ce3651259041feefd2fcabe1618ad24d4707292a2f2c63
424D00|b0f5ab250b2f65cb9a6b200f6bc39ba74db8a5282fdd9e8d1bf87c733da89005fac37f40dcdb9b095a70a018392c3018
3FDEE0|ffd7f9bf50dcca42c961bbc4fff717ab586e01968d606407ec610aa3d2462987af054c694474c7b5878dd7af5124c1dc
335768|1f288d53346f74a9618c47f5a77a9e41aece4005037e3b6b908f6d0b4d8faaf148cc18ac1632b3362e1a78369edfc6f6
051E7C|d5dbcb933c5cba8c1b355b6152a947051a71ea0a9ad295ab308afa39fdce8a07e9e0192a187df0ff9e089718534a7c46
717F8C|c6c62993fb330dd106932569300a97ab54837fe5927adcd0a418fa24e01148d80de54ddc63dc58705c62be1ea4b3ee32
1F877C|d67cfa1b09c8c050094ea018bb5ecd3ce0c02835325467a8fa79701f0ad6bbd4a34947bbaa2fc5f9379985ccd6a1dc0e
EB35CF80|dfba2a0077e56cacb0df1be549dfe06c9828e1eef91b77d83acc0300c0c67db0e2594a4bd552c80f4a0d98fae44a860c
B406C480|a20846d26c780b03d4d0fe15757d664111aaedc435af784ae85e1a1b25ca56c476b86351edc1ad3825667b86328678d3
CEE88040|ee885ca24e330d26bde1b3ea640fd0af5ab1840697bd12d015fc515d219cdd2c13bb3429f374727ee632a1555fef1ca3
C584DB70|243a3c6ad6fb97298c04200273cbe829c636daab73ea7abaaf1caff193e9dc9b7399ed859a46a6daba98ee9fd810cf00
53587BC8|01c6579dd37e707e33ec4a0a768499f28be4e80ba4952e645faa07f09d507dec9e81ab2cf34c0318a34a0ac4af621655
69A305B0|081633892d928cd7debc78ce70b0a82f8595cf32e1998b0298490b8799b26f76ed428d13ca4da02e504efda5a3379dca
C9375ECE|24a2d2af040b31fc238abfb935fb0f699eaf97291b75d5a7eaaf542e19c7e486554c166962943b762f2818172bbcdee5
C1ECFDFC|7a57c41d850b7ab51c6075aba299ff649fdaf08a4c37088ece73b21304b1072c21930cc34ac6b0fc5f27b95f4f389b26
8D73E8A280|e1480a83839ab8747935690f1922e0f05e8f67239f7dced9cfd39a1678ee10febb4f7580bd803c66ec5584ef102a12db
06F2522080|f386f8bdd36de67d43aeb976b2d57a9499b3796c1c37e6c7b133bf2545d7efcd21be6935425a5dfaa627ceec834400b6
3EF6C36F20|311c0aafbb8e6729641d9bb12d0434614f5be6e0d3d27933e1469b0c662430de7153b2aab9c4085758099e6064d2f883
0127A1D340|9933fe64ef4de19c78695186286831534f30721b82d031b9f938fb19b4c2cab1d4ac53f63f96a60cf172702f9305854e
6A6AB6C210|094b79964b193bf655f91f76f4d3589eab2a902587f730ec76251b98d9de4db846d81c29dba5eb20ede52db447f429a7
AF3175E160|e05997f725613d05ec2a3edab5b9af53de9eeaef986ad4ed1f83c6c4211bb0b1a6058d8eaed94d52299e2e32225e2545
B66609ED86|c0b0e332a81821d4dd06a72ef108fae9060f2c826b3905db037ad75db15efac9c04d0f284aae722e407b41f132a75980
21F134AC57|324155f4f5e346bfe0b08e9642bebe86505795be186146d30242273ebebb3d51e076b1105ab647c130e6efc0b75072a7
3DC2AADFFC80|4202b2a7fd50f9f64268a5cecaa979e68fb5e5b4f16050baa0eee6254640a243f8f775c44f26c0d950498c8f1bbb34cb
9202736D2240|18987d9b924db295acb2645618b772fa7d451ef841f207d525c2c501e472fafb44b3078537515ed39475743c7d2d04c2
F219BD629820|b059cd3e9e615574d0f2bbe11522ed7c2243f070272880a5f58bd147985a24afbdf8be2cf139792b482b97bfc94d6788
F3511EE2C4B0|028c6ea676b4ab01cbdf0918a90e507429ca7b926763dc26ced6f7a851923b91fd4ac6054cc7432139af954c3abe5a94
3ECAB6BF7720|5f46d3abe50df2b402567f95468862ecfc91508019c85a190a3c3eb2f6a77e794835697987dc4bce0bd3ef2afb89a026
CD62F688F498|444921bbc8e0dceb33e0b4660f2e09fc8a0d8254ae03327af448408b1dc9229c95253c3873f09a522f428899d23d6846
C2CBAA33A9F8|b4a57910d5ef0113585fbe7f3a5ebd7a3e3ddc4e66bd42a8baed7c59134d3cdc36c70a4a39fa11449ff8adfe4da66cb8
C6F50BB74E29|5ddb50068ca430bffae7e5a8bbcb2c59171743cce027c0ea937fa2b511848192af2aca98ead30b0850b4d2d1542decdb
79F1B4CCC62A00|7c80a8320015dfc5143d1c6d60a4b51c6943208005aa5176300ecdfa728d5bb53c9817b33c934eca94332716458572dc
