/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.nexrad2;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import ucar.nc2.iosp.nexrad2.Level2VolumeScan;
import ucar.nc2.util.TableParser;

public class NexradStationDB {
    private static boolean showStations = false;
    private static Map<String, Station> stationTableHash = null;
    private static Map<String, Station> stationTableHash1 = null;

    public static synchronized void init() throws IOException {
        if (stationTableHash == null) {
            NexradStationDB.readStationTableXML();
        }
    }

    public static Station get(String id) {
        return stationTableHash.get(id);
    }

    public static Station getByIdNumber(String idn) {
        return stationTableHash1.get(idn);
    }

    private static void readStationTableXML() throws IOException {
        Document doc;
        stationTableHash = new HashMap<String, Station>();
        stationTableHash1 = new HashMap<String, Station>();
        ClassLoader cl = Level2VolumeScan.class.getClassLoader();
        InputStream is = cl.getResourceAsStream("resources/nj22/tables/nexradstns.xml");
        SAXBuilder saxBuilder = new SAXBuilder();
        try {
            doc = saxBuilder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element root = doc.getRootElement();
        List children = root.getChildren("station");
        for (int i = 0; i < children.size(); ++i) {
            Element sElem = (Element)children.get(i);
            String idn = sElem.getAttributeValue("idn");
            String id = sElem.getAttributeValue("id");
            String name = sElem.getAttributeValue("name");
            String st = sElem.getAttributeValue("st");
            String co = sElem.getAttributeValue("co");
            String lat = sElem.getAttributeValue("lat");
            String lon = sElem.getAttributeValue("lon");
            String elev = sElem.getAttributeValue("elev");
            Station s = new Station();
            s.id = "K" + id;
            s.name = name + "," + st + "," + co;
            s.lat = NexradStationDB.parseDegree(lat);
            s.lon = NexradStationDB.parseDegree(lon);
            s.elev = Double.parseDouble(elev);
            stationTableHash.put(s.id, s);
            stationTableHash1.put(idn, s);
            if (!showStations) continue;
            System.out.println(" station= " + s);
        }
    }

    private static double parseDegree(String s) {
        StringTokenizer stoke = new StringTokenizer(s, ":");
        String degS = stoke.nextToken();
        String minS = stoke.nextToken();
        String secS = stoke.nextToken();
        try {
            double deg = Double.parseDouble(degS);
            double min = Double.parseDouble(minS);
            double sec = Double.parseDouble(secS);
            if (deg < 0.0) {
                return deg - min / 60.0 - sec / 3600.0;
            }
            return deg + min / 60.0 + sec / 3600.0;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private static void readStationTable() throws IOException {
        stationTableHash = new HashMap<String, Station>();
        ClassLoader cl = Level2VolumeScan.class.getClassLoader();
        InputStream is = cl.getResourceAsStream("resources/nj22/tables/nexrad.tbl");
        List<TableParser.Record> recs = TableParser.readTable(is, "3,15,46, 54,60d,67d,73d", 50000);
        for (TableParser.Record record : recs) {
            Station s = new Station();
            s.id = "K" + record.get(0);
            s.name = record.get(2) + " " + record.get(3);
            s.lat = (Double)record.get(4) * 0.01;
            s.lon = (Double)record.get(5) * 0.01;
            s.elev = (Double)record.get(6);
            stationTableHash.put(s.id, s);
            if (!showStations) continue;
            System.out.println(" station= " + s);
        }
    }

    public static class Station {
        public String id;
        public String name;
        public double lat;
        public double lon;
        public double elev;

        public String toString() {
            return this.id + " <" + this.name + ">   " + this.lat + " " + this.lon + " " + this.elev;
        }
    }
}

