/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect;

import com.google.common.base.Optional;
import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.LanguageDetectorImpl;
import com.optimaize.langdetect.NgramFrequencyData;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractor;
import com.optimaize.langdetect.profiles.LanguageProfile;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageDetectorBuilder {
    private static final double ALPHA_DEFAULT = 0.5;
    @NotNull
    private final NgramExtractor ngramExtractor;
    private double alpha = 0.5;
    private Optional<Long> seed = Optional.absent();
    private int shortTextAlgorithm = 50;
    private double prefixFactor = 1.0;
    private double suffixFactor = 1.0;
    private double probabilityThreshold = 0.1;
    private double minimalConfidence = 0.9999;
    @Nullable
    private Map<LdLocale, Double> langWeightingMap;
    @NotNull
    private final Set<LanguageProfile> languageProfiles = new HashSet<LanguageProfile>();
    @NotNull
    private final Set<LdLocale> langsAdded = new HashSet<LdLocale>();

    public static LanguageDetectorBuilder create(@NotNull NgramExtractor ngramExtractor) {
        return new LanguageDetectorBuilder(ngramExtractor);
    }

    private LanguageDetectorBuilder(@NotNull NgramExtractor ngramExtractor) {
        this.ngramExtractor = ngramExtractor;
    }

    public LanguageDetectorBuilder alpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("alpha must be between 0 and 1, but was: " + alpha);
        }
        this.alpha = alpha;
        return this;
    }

    public LanguageDetectorBuilder seed(long seed) {
        return this.seed(Optional.of(seed));
    }

    public LanguageDetectorBuilder seed(@NotNull Optional<Long> seed) {
        this.seed = seed;
        return this;
    }

    public LanguageDetectorBuilder shortTextAlgorithm(int shortTextAlgorithm) {
        this.shortTextAlgorithm = shortTextAlgorithm;
        return this;
    }

    public LanguageDetectorBuilder affixFactor(double affixFactor) {
        this.prefixFactor(affixFactor);
        this.suffixFactor(affixFactor);
        return this;
    }

    public LanguageDetectorBuilder prefixFactor(double prefixFactor) {
        this.prefixFactor = prefixFactor;
        return this;
    }

    public LanguageDetectorBuilder suffixFactor(double suffixFactor) {
        this.suffixFactor = suffixFactor;
        return this;
    }

    public LanguageDetectorBuilder probabilityThreshold(double probabilityThreshold) {
        this.probabilityThreshold = probabilityThreshold;
        return this;
    }

    public LanguageDetectorBuilder minimalConfidence(double minimalConfidence) {
        this.minimalConfidence = minimalConfidence;
        return this;
    }

    public LanguageDetectorBuilder languagePriorities(@Nullable Map<LdLocale, Double> langWeightingMap) {
        this.langWeightingMap = langWeightingMap;
        return this;
    }

    public LanguageDetectorBuilder withProfile(LanguageProfile languageProfile) throws IllegalStateException {
        if (this.langsAdded.contains(languageProfile.getLocale())) {
            throw new IllegalStateException("A language profile for language " + languageProfile.getLocale() + " was added already!");
        }
        for (Integer gramLength : this.ngramExtractor.getGramLengths()) {
            if (languageProfile.getGramLengths().contains(gramLength)) continue;
            throw new IllegalArgumentException("The NgramExtractor is set to handle " + gramLength + "-grams but the given language profile for " + languageProfile.getLocale() + " does not support this!");
        }
        this.langsAdded.add(languageProfile.getLocale());
        this.languageProfiles.add(languageProfile);
        return this;
    }

    public LanguageDetectorBuilder withProfiles(Iterable<LanguageProfile> languageProfiles) throws IllegalStateException {
        for (LanguageProfile languageProfile : languageProfiles) {
            this.withProfile(languageProfile);
        }
        return this;
    }

    public LanguageDetector build() throws IllegalStateException {
        if (this.languageProfiles.isEmpty()) {
            throw new IllegalStateException();
        }
        return new LanguageDetectorImpl(NgramFrequencyData.create(this.languageProfiles, this.ngramExtractor.getGramLengths()), this.alpha, this.seed, this.shortTextAlgorithm, this.prefixFactor, this.suffixFactor, this.probabilityThreshold, this.minimalConfidence, this.langWeightingMap, this.ngramExtractor);
    }
}

