/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.writer.stax;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.Property;
import thredds.catalog2.Service;
import thredds.catalog2.xml.names.CatalogNamespace;
import thredds.catalog2.xml.names.ServiceElementNames;
import thredds.catalog2.xml.writer.ThreddsXmlWriterException;
import thredds.catalog2.xml.writer.stax.AbstractElementWriter;
import thredds.catalog2.xml.writer.stax.PropertyElementWriter;
import thredds.catalog2.xml.writer.stax.StaxWriter;

public class ServiceElementWriter
implements AbstractElementWriter {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void writeElement(Service service, XMLStreamWriter writer, int nestLevel) throws ThreddsXmlWriterException {
        String indentString = StaxWriter.getIndentString(nestLevel);
        try {
            boolean isEmptyElement;
            if (nestLevel == 0) {
                writer.writeStartDocument();
                writer.writeCharacters("\n");
            } else {
                writer.writeCharacters(indentString);
            }
            boolean bl = isEmptyElement = service.getProperties().isEmpty() && service.getServices().isEmpty();
            if (isEmptyElement) {
                writer.writeEmptyElement(ServiceElementNames.ServiceElement.getLocalPart());
            } else {
                writer.writeStartElement(ServiceElementNames.ServiceElement.getLocalPart());
            }
            if (nestLevel == 0) {
                writer.writeNamespace(CatalogNamespace.CATALOG_1_0.getStandardPrefix(), CatalogNamespace.CATALOG_1_0.getNamespaceUri());
                writer.writeNamespace(CatalogNamespace.XLINK.getStandardPrefix(), CatalogNamespace.XLINK.getNamespaceUri());
            }
            writer.writeAttribute(ServiceElementNames.ServiceElement_Name.getLocalPart(), service.getName());
            writer.writeAttribute(ServiceElementNames.ServiceElement_ServiceType.getLocalPart(), service.getType().toString());
            writer.writeAttribute(ServiceElementNames.ServiceElement_Base.getLocalPart(), service.getBaseUri().toString());
            if (service.getSuffix() != null && service.getSuffix().length() != 0) {
                writer.writeAttribute(ServiceElementNames.ServiceElement_Suffix.getLocalPart(), service.getSuffix());
            }
            if (service.getDescription() != null && service.getDescription().length() != 0) {
                writer.writeAttribute(ServiceElementNames.ServiceElement_Description.getLocalPart(), service.getDescription());
            }
            writer.writeCharacters("\n");
            for (Property curProperty : service.getProperties()) {
                new PropertyElementWriter().writeElement(curProperty, writer, nestLevel + 1);
            }
            for (Service curService : service.getServices()) {
                new ServiceElementWriter().writeElement(curService, writer, nestLevel + 1);
            }
            if (!isEmptyElement) {
                writer.writeCharacters(indentString);
                writer.writeEndElement();
                writer.writeCharacters("\n");
            }
            if (nestLevel == 0) {
                writer.writeEndDocument();
            }
            writer.flush();
            if (nestLevel == 0) {
                writer.close();
            }
        }
        catch (XMLStreamException e) {
            this.log.error("writeElement(): Failed while writing to XMLStreamWriter: " + e.getMessage());
            throw new ThreddsXmlWriterException("Failed while writing to XMLStreamWriter: " + e.getMessage(), e);
        }
    }
}

