
######################################################################
## $Id: DataRowView.pm 3668 2006-03-11 20:51:13Z spadkins $
######################################################################

package App::Widget::DataRowView;
$VERSION = (q$Revision: 3668 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App;
use App::Widget;
@ISA = ( "App::Widget" );

use strict;

=head1 NAME

App::Widget::DataRowView - A simple label

=head1 SYNOPSIS

   $name = "label";

   # official way
   use App;
   $context = App->context();
   $w = $context->widget($name);

   # internal way
   use App::Widget::DataRowView;
   $w = App::Widget::DataRowView->new($name);

=cut

######################################################################
# CONSTANTS
######################################################################

######################################################################
# ATTRIBUTES
######################################################################

# INPUTS FROM THE ENVIRONMENT

=head1 DESCRIPTION

This class implements a base class for a complex view of a row.
the attributes of

 $self->{row}
 $self->{columns}

are assumed to exist.

=cut

######################################################################
# INITIALIZATION
######################################################################

# no special initialization

######################################################################
# EVENTS
######################################################################

# no events

######################################################################
# OUTPUT METHODS
######################################################################

sub html {
    my $self = shift;
    my $html = "<span style=\"white-space: normal\">";
    my $columns = $self->{columns} || die "columns not defined";
    my $row = $self->{row} || die "row not defined";
    my $first = 1;
    for (my $i = 0; $i <= $#$columns; $i++) {
        if (defined $row->[$i] && $row->[$i] ne "") {
            $html .= ", " if (!$first);
            $first = 0;
            $html .= "<b>$columns->[$i]</b>:&nbsp;$row->[$i]";
        }
    }
    $html .= "</span>";
    return($html);
}

1;

