# Generated by default/object.tt
package Paws::SageMaker::AgentVersion;
  use Moose;
  has AgentCount => (is => 'ro', isa => 'Int', required => 1);
  has Version => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::AgentVersion

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::AgentVersion object:

  $service_obj->Method(Att1 => { AgentCount => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::AgentVersion object:

  $result = $service_obj->Method(...);
  $result->Att1->AgentCount

=head1 DESCRIPTION

Edge Manager agent version.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AgentCount => Int

The number of Edge Manager agents.


=head2 B<REQUIRED> Version => Str

Version of the agent.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

