#line 1 "inc/ExtUtils/MM.pm - /System/Library/Perl/5.8.6/ExtUtils/MM.pm"
package ExtUtils::MM;

use strict;
use Config;
use vars qw(@ISA $VERSION);
$VERSION = 0.04;

require ExtUtils::Liblist;
require ExtUtils::MakeMaker;

@ISA = qw(ExtUtils::Liblist ExtUtils::MakeMaker);

#line 37

{
    # Convenient alias.
    package MM;
    use vars qw(@ISA);
    @ISA = qw(ExtUtils::MM);
    sub DESTROY {}
}

my %Is = ();
$Is{VMS}    = 1 if $^O eq 'VMS';
$Is{OS2}    = 1 if $^O eq 'os2';
$Is{MacOS}  = 1 if $^O eq 'MacOS';
if( $^O eq 'MSWin32' ) {
    Win32::IsWin95() ? $Is{Win95} = 1 : $Is{Win32} = 1;
}
$Is{UWIN}   = 1 if $^O eq 'uwin';
$Is{Cygwin} = 1 if $^O eq 'cygwin';
$Is{NW5}    = 1 if $Config{osname} eq 'NetWare';  # intentional
$Is{BeOS}   = 1 if $^O =~ /beos/i;    # XXX should this be that loose?
$Is{DOS}    = 1 if $^O eq 'dos';

$Is{Unix}   = 1 if !keys %Is;

if( $Is{NW5} ) {
    $^O = 'NetWare';
    delete $Is{Win32};
}

_assert( keys %Is == 1 );
my($OS) = keys %Is;


my $class = "ExtUtils::MM_$OS";
eval "require $class" unless $INC{"ExtUtils/MM_$OS.pm"};
die $@ if $@;
unshift @ISA, $class;


sub _assert {
    my $sanity = shift;
    die sprintf "Assert failed at %s line %d\n", (caller)[1,2] unless $sanity;
    return;
}
