package WebService::FOAAS::Codegen;

use 5.014000;
use strict;
use warnings;

use HTTP::Tiny;
use JSON::MaybeXS qw/decode_json/;

our $VERSION = '0.002';

sub run {
	my $ht = HTTP::Tiny->new;
	my $result = $ht->get('https://foaas.com/operations');
	die $result->{reason} unless $result->{success};

	my @export;

	print <<"EOF";
### Start of code generated by WebService::FOAAS::Codegen->run

\=head1 AVAILABLE METHODS

\=over
EOF

	my @ops = map { $_->{url} =~ y/-/_/r } @{decode_json $result->{content}};
	for my $op (@ops) {
		my (undef, $name, @args) = split '/', $op;
		my $nargs = @args;
		push @export, "foaas_$name";
		print <<"EOF"

\=item foaas_$name @{[join ', ', map { y/:/$/r } @args]}

\=cut

sub foaas_$name {
	die "Expected $nargs arguments" unless \@_ == $nargs || \@_ == @{[$nargs + 1]};
	request '$name', \@_;
}

BEGIN { \*$name = \\&foaas_$name }
EOF
	}

	my @export_ok = (@export, map { substr $_, 6 } @export);
	print <<"EOF"

BEGIN {
	our \@EXPORT   = qw/@export/;
	our \@EXPORT_OK = qw/@export_ok/;
}

\=back

\=cut

### End of code generated by WebService::FOAAS::Codegen->run
EOF
}

1;
__END__
