# Generated by default/object.tt
package Paws::AppRunner::AutoScalingConfiguration;
  use Moose;
  has AutoScalingConfigurationArn => (is => 'ro', isa => 'Str');
  has AutoScalingConfigurationName => (is => 'ro', isa => 'Str');
  has AutoScalingConfigurationRevision => (is => 'ro', isa => 'Int');
  has CreatedAt => (is => 'ro', isa => 'Str');
  has DeletedAt => (is => 'ro', isa => 'Str');
  has Latest => (is => 'ro', isa => 'Bool');
  has MaxConcurrency => (is => 'ro', isa => 'Int');
  has MaxSize => (is => 'ro', isa => 'Int');
  has MinSize => (is => 'ro', isa => 'Int');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppRunner::AutoScalingConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppRunner::AutoScalingConfiguration object:

  $service_obj->Method(Att1 => { AutoScalingConfigurationArn => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppRunner::AutoScalingConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AutoScalingConfigurationArn

=head1 DESCRIPTION

Describes an AWS App Runner automatic scaling configuration resource.
Multiple revisions of a configuration have the same
C<AutoScalingConfigurationName> and different
C<AutoScalingConfigurationRevision> values.

A higher C<MinSize> increases the spread of your App Runner service
over more Availability Zones in the AWS Region. The tradeoff is a
higher minimal cost.

A lower C<MaxSize> controls your cost. The tradeoff is lower
responsiveness during peak demand.

=head1 ATTRIBUTES


=head2 AutoScalingConfigurationArn => Str

The Amazon Resource Name (ARN) of this auto scaling configuration.


=head2 AutoScalingConfigurationName => Str

The customer-provided auto scaling configuration name. It can be used
in multiple revisions of a configuration.


=head2 AutoScalingConfigurationRevision => Int

The revision of this auto scaling configuration. It's unique among all
the active configurations (C<"Status": "ACTIVE">) that share the same
C<AutoScalingConfigurationName>.


=head2 CreatedAt => Str

The time when the auto scaling configuration was created. It's in Unix
time stamp format.


=head2 DeletedAt => Str

The time when the auto scaling configuration was deleted. It's in Unix
time stamp format.


=head2 Latest => Bool

It's set to C<true> for the configuration with the highest C<Revision>
among all configurations that share the same C<Name>. It's set to
C<false> otherwise.


=head2 MaxConcurrency => Int

The maximum number of concurrent requests that an instance processes.
If the number of concurrent requests exceeds this limit, App Runner
scales the service up.


=head2 MaxSize => Int

The maximum number of instances that a service scales up to. At most
C<MaxSize> instances actively serve traffic for your service.


=head2 MinSize => Int

The minimum number of instances that App Runner provisions for a
service. The service always has at least C<MinSize> provisioned
instances. Some of them actively serve traffic. The rest of them
(provisioned and inactive instances) are a cost-effective compute
capacity reserve and are ready to be quickly activated. You pay for
memory usage of all the provisioned instances. You pay for CPU usage of
only the active subset.

App Runner temporarily doubles the number of provisioned instances
during deployments, to maintain the same capacity for both old and new
code.


=head2 Status => Str

The current state of the auto scaling configuration. If the status of a
configuration revision is C<INACTIVE>, it was deleted and can't be
used. Inactive configuration revisions are permanently removed some
time after they are deleted.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppRunner>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

