# $Id: turn.t 564 2025-02-13 21:33:15Z whynot $
# Copyright 2013, 2022 Eric Pozharski <whynot@pozharski.name>
# Copyright 2025 Eric Pozharski <wayside.ultimate@tuta.io>
# GNU GPLv3
# AS-IS, NO-WARRANTY, HOPE-TO-BE-USEFUL

use strict;
use warnings;

package main;
use version 0.77; our $VERSION = version->declare( v2.3.3 );

use t::TestSuite qw| :diag :wraps |;
use Test::More;

use Acme::FSM;
use List::Util qw| sum |;

our( $bb, $rc, $stderr );
my %st = ( );
my %opts   = ( diag_level => -t STDOUT ? 10 : 1 );
my $method = q|turn|;

my @data =
([ '', [qw| init |], { }                                             ],
 [         q|no args, no fst|,
  [qw|                pass |],
  [                         ],
  [                0, undef ],
  qr.(?m)^\Q[turn]: no args .                                        ],
 [                       '',
  [qw|              init |],
  { KNOPPIX =>      undef,
    Kiwi    => q|BackBox|,
    Tuquito => [        ],
    DEFT    =>  sub { 1 } },                                         ],
 [             q|entry isa missing|,
  [qw|                      pass |],
  [qw|                     Linvo |],
  [                      4, undef ],
  qr.(?m)\Q(Linvo): no such {fst} .                                  ],
 [                    q|entry isa undef|,
  [qw|                           fail |],
  [qw|                        KNOPPIX |],
  qr.\Q{KNOPPIX}(): entry !isa defined .                             ],
 [           q|entry isa scalar|,
  [qw|                   fail |],
  [qw|                   Kiwi |],
  qr.\Q{Kiwi}(): entry isa (), .                                     ],
 [                  q|entry isa (ARRAY)|,
  [qw|                           fail |],
  [qw|                        Tuquito |],
  qr.\Q{Tuquito}(): entry isa (ARRAY), .                             ],
 [
  q|entry isa (CODE)|,
  [qw| fail |],
  [qw| DEFT |],
  qr.\Q{DEFT}(): entry isa (CODE), .                                 ],
 [                                                                '',
  [qw|                                                       init |],
  { KNOPPIX  => {                                                },
    Kiwi     => {                                 tturn => undef },
    Tuquito  => {                                 fturn => undef },
    Linvo    => {                 tturn => undef, fturn => undef },
    Plamo    => {                                 eturn => undef },
    Gentoo   => {                                 uturn => undef },
    Emmabunt => { tturn => undef, fturn => undef, turns => undef } } ],
 [                           q|empty entry|,
  [qw|                              pass |],
  [qw|                           KNOPPIX |],
  [                              7, undef ],
  qr.(?m)\Q{KNOPPIX}: none supported turn .                          ],
 [   q|lone {tturn}|,
  [qw| pass quiet |],
  [qw|       Kiwi |],
  [          7, '' ]                                                 ],
 [   q|lone {fturn}|,
  [qw| pass quiet |],
  [qw|    Tuquito |],
  [          7, '' ]                                                 ],
 [
  q|{tturn} plus {fturn} pair|,
  [qw|           pass quiet |],
  [qw|                Linvo |],
  [                    7, '' ]                                       ],
 [                        q|lone {eturn}|,
  [qw|                            pass |],
  [qw|                           Plamo |],
  [                            7, undef ],
  qr.(?m)\Q{Plamo}: none supported turn .                            ],
 [                         q|lone {uturn}|,
  [qw|                             pass |],
  [qw|                           Gentoo |],
  [                             7, undef ],
  qr.(?m)\Q{Gentoo}: none supported turn .                           ],
 [ q|{tturn} plus {fturn} plus {turns} tripple|,
  [qw|                            pass quiet |],
  [qw|                              Emmabunt |],
  [                                     7, '' ]                      ],
 [                                    '',
  [qw|                           init |],
  { KNOPPIX => { turns =>      undef },
    Kiwi    => { turns => q|BackBox| },
    Tuquito => { turns =>  sub { 1 } },
    DEFT    => { turns =>         { }} }                             ],
 [                      q|{turns} isa undef|,
  [qw|                               fail |],
  [qw|                            KNOPPIX |],
  qr.\Q{KNOPPIX}(turns): turn !isa defined .                         ],
 [             q|{turns} isa scalar|,
  [qw|                       fail |],
  [qw|                       Kiwi |],
  qr.\Q{Kiwi}(turns): turn isa (), .                                 ],
 [                    q|{turns} isa (CODE)|,
  [qw|                              fail |],
  [qw|                           Tuquito |],
  qr.\Q{Tuquito}(turns): turn isa (CODE), .                          ],
 [ q|{turns} isa (HASH)|,
  [qw|     pass quiet |],
  [qw|           DEFT |],
  [         4, q|HASH| ]                                             ],
 [ '', [qw| init |], { STOP => { }, BREAK => { }}                    ],
 [ q|{STOP} has no turns|,
  [qw|      pass quiet |],
  [qw|            STOP |],
  [          2, q|HASH| ]                                            ],
 [ q|{BREAK} has no turns|,
  [qw|       pass quiet |],
  [qw|            BREAK |],
  [           2, q|HASH| ]                                           ],
 [                                                        '',
  [qw|                                               init |],
  { STOP => { eturn => undef }, BREAK => { eturn => undef }}         ],
 [ q|{STOP} has {eturn}|,
  [qw|     pass quiet |],
  [qw|           STOP |],
  [         2, q|HASH| ]                                             ],
 [ q|{BREAK} has {eturn}|,
  [qw|      pass quiet |],
  [qw|           BREAK |],
  [          2, q|HASH| ]                                            ],
 [                                                        '',
  [qw|                                               init |],
  { STOP => { tturn => undef }, BREAK => { tturn => undef }}         ],
 [ q|{STOP} has {tturn}|,
  [qw|     pass quiet |],
  [qw|           STOP |],
  [         2, q|HASH| ]                                             ],
 [ q|{BREAK} has {tturn}|,
  [qw|      pass quiet |],
  [qw|           BREAK |],
  [          2, q|HASH| ]                                            ],
 [                                                        '',
  [qw|                                               init |],
  { STOP => { fturn => undef }, BREAK => { fturn => undef }}         ],
 [ q|{STOP} has {fturn}|,
  [qw|     pass quiet |],
  [qw|           STOP |],
  [         2, q|HASH| ]                                             ],
 [ q|{BREAK} has {fturn}|,
  [qw|      pass quiet |],
  [qw|           BREAK |],
  [          2, q|HASH| ]                                            ],
 [                                                        '',
  [qw|                                               init |],
  { STOP => { turns => undef }, BREAK => { turns => undef }}         ],
 [ q|{STOP} has {turns}|,
  [qw|     pass quiet |],
  [qw|           STOP |],
  [         2, q|HASH| ]                                             ],
 [ q|{BREAK} has {turns}|,
  [qw|      pass quiet |],
  [qw|           BREAK |],
  [          2, q|HASH| ]                                            ],
 [                                                           '',
  [qw|                                                  init |],
  { KNOPPIX  =>
    { eturn => undef,
      uturn => undef,
      tturn => undef,
      fturn => undef                                          },
    Kiwi     =>
    { eturn =>   q|BackBox|,
      uturn =>    q|aLinux|,
      tturn => q|EasyPeasy|,
      fturn =>  q|CAELinux|                                   },
    Tuquito  =>
    { eturn => sub { },
      uturn => sub { },
      tturn => sub { },
      fturn => sub { }                                        },
    DEFT     => { turns =>
    { Linvo => undef, Plamo => q|BRLix|, Gentoo => sub { } }} }      ],
 [                      q|{eturn} isa undef|,
  [qw|                               fail |],
  [qw|                      KNOPPIX eturn |],
  qr.\Q{KNOPPIX}(eturn): turn !isa defined .                         ],
 [                    q|{uturn} isa undef|,
  [qw|                             fail |],
  [qw|                    KNOPPIX uturn |],
  qr.\Q{KNOPPIX}(uturn): turn !isa defined.                          ],
 [                     q|{tturn} isa undef|,
  [qw|                              fail |],
  [qw|                     KNOPPIX tturn |],
  qr.\Q{KNOPPIX}(tturn): turn !isa defined.                          ],
 [                     q|{fturn} isa undef|,
  [qw|                              fail |],
  [qw|                     KNOPPIX fturn |],
  qr.\Q{KNOPPIX}(fturn): turn !isa defined.                          ],
 [               q|turn in {turns} isa undef|,
  [qw|                                fail |],
  [qw|                     DEFT turn%Linvo |],
  qr.\Q{DEFT}(turn%Linvo): turn !isa defined.                        ],
 [             q|{eturn} isa scalar|,
  [qw|                       fail |],
  [qw|                 Kiwi eturn |],
  qr.\Q{Kiwi}(eturn): turn isa (), .                                 ],
 [             q|{uturn} isa scalar|,
  [qw|                       fail |],
  [qw|                 Kiwi uturn |],
  qr.\Q{Kiwi}(uturn): turn isa (), .                                 ],
 [             q|{tturn} isa scalar|,
  [qw|                       fail |],
  [qw|                 Kiwi tturn |],
  qr.\Q{Kiwi}(tturn): turn isa (), .                                 ],
 [             q|{fturn} isa scalar|,
  [qw|                       fail |],
  [qw|                 Kiwi fturn |],
  qr.\Q{Kiwi}(fturn): turn isa (), .                                 ],
 [          q|turn in {turns} isa scalar|,
  [qw|                            fail |],
  [qw|                 DEFT turn%Plamo |],
  qr.\Q{DEFT}(turn%Plamo): turn isa (), .                            ],
 [                    q|{eturn} isa (CODE)|,
  [qw|                              fail |],
  [qw|                     Tuquito eturn |],
  qr.\Q{Tuquito}(eturn): turn isa (CODE), .                          ],
 [                    q|{uturn} isa (CODE)|,
  [qw|                              fail |],
  [qw|                     Tuquito uturn |],
  qr.\Q{Tuquito}(uturn): turn isa (CODE), .                          ],
 [                    q|{tturn} isa (CODE)|,
  [qw|                              fail |],
  [qw|                     Tuquito tturn |],
  qr.\Q{Tuquito}(tturn): turn isa (CODE), .                          ],
 [                    q|{fturn} isa (CODE)|,
  [qw|                              fail |],
  [qw|                     Tuquito fturn |],
  qr.\Q{Tuquito}(fturn): turn isa (CODE), .                          ],
 [               q|turn in {turns} isa (CODE)|,
  [qw|                                 fail |],
  [qw|                     DEFT turn%Gentoo |],
  qr.\Q{DEFT}(turn%Gentoo): turn isa (CODE), .                       ],
 [                                                              '',
  [qw|                                                     init |],
  { KNOPPIX  =>
    {    eturn => [ ], uturn => [ ], tturn => [ ], fturn => [ ]},
    Kiwi     =>
    { eturn => [ undef ],
      uturn => [ undef ],
      tturn => [ undef ],
      fturn => [ undef ]                                       },
    Tuquito  =>
    { eturn => [   q|BackBox| ],
      uturn => [    q|aLinux| ],
      tturn => [ q|EasyPeasy| ],
      fturn => [  q|CAELinux| ]                                },
    DEFT     => { turns =>
    { Linvo => [ ], Plamo => [ undef ], Gentoo => [ q|BRLix| ]}} }   ],
 [                      q|{eturn} isa empty|,
  [qw|                               fail |],
  [qw|                      KNOPPIX eturn |],
  qr.\Q{KNOPPIX}(eturn): state !isa defined.                         ],
 [                      q|{uturn} isa empty|,
  [qw|                               fail |],
  [qw|                      KNOPPIX uturn |],
  qr.\Q{KNOPPIX}(uturn): state !isa defined.                         ],
 [                      q|{tturn} isa empty|,
  [qw|                               fail |],
  [qw|                      KNOPPIX tturn |],
  qr.\Q{KNOPPIX}(tturn): state !isa defined.                         ],
 [                      q|{fturn} isa empty|,
  [qw|                               fail |],
  [qw|                      KNOPPIX fturn |],
  qr.\Q{KNOPPIX}(fturn): state !isa defined.                         ],
 [                q|turn in {turns} isa empty|,
  [qw|                                 fail |],
  [qw|                      DEFT turn%Linvo |],
  qr.\Q{DEFT}(turn%Linvo): state !isa defined.                       ],
 [             q|{eturn} state isa undef|,
  [qw|                            fail |],
  [qw|                      Kiwi eturn |],
  qr.\Q{Kiwi}(eturn): state !isa defined.                            ],
 [             q|{uturn} state isa undef|,
  [qw|                            fail |],
  [qw|                      Kiwi uturn |],
  qr.\Q{Kiwi}(uturn): state !isa defined.                            ],
 [             q|{tturn} state isa undef|,
  [qw|                            fail |],
  [qw|                      Kiwi tturn |],
  qr.\Q{Kiwi}(tturn): state !isa defined.                            ],
 [             q|{fturn} state isa undef|,
  [qw|                            fail |],
  [qw|                      Kiwi fturn |],
  qr.\Q{Kiwi}(fturn): state !isa defined.                            ],
 [          q|turn of {turns} state isa undef|,
  [qw|                                 fail |],
  [qw|                      DEFT turn%Plamo |],
  qr.\Q{DEFT}(turn%Plamo): state !isa defined.                       ],
 [q|{eturn} state isa noise, action isa missing|,
  [qw|                                   fail |],
  [qw|                          Tuquito eturn |],
     qr.\Q{Tuquito}(eturn): action !isa defined.                     ],
 [q|{uturn} state isa noise, action isa missing|,
  [qw|                                   fail |],
  [qw|                          Tuquito uturn |],
     qr.\Q{Tuquito}(uturn): action !isa defined.                     ],
 [q|{tturn} state isa noise, action isa missing|,
  [qw|                                   fail |],
  [qw|                          Tuquito tturn |],
     qr.\Q{Tuquito}(tturn): action !isa defined.                     ],
 [q|{fturn} state isa noise, action isa missing|,
  [qw|                                   fail |],
  [qw|                          Tuquito fturn |],
     qr.\Q{Tuquito}(fturn): action !isa defined.                     ],
 [q|turn of {turns} state isa noise, action isa missing|,
  [qw|                                           fail |],
  [qw|                               DEFT turn%Gentoo |],
          qr.\Q{DEFT}(turn%Gentoo): action !isa defined.             ],
 [                                          '',
  [qw|                                 init |],
  { KNOPPIX =>
    { eturn => [ q|BackBox|,   undef ],
      uturn => [ q|aLinux|,    undef ],
      tturn => [ q|EasyPeasy|, undef ],
      fturn => [ q|CAELinux|,  undef ]     },
    Kiwi =>
    { eturn => [qw| BRLix      Super_OS |],
      uturn => [qw| CCux          Qubes |],
      tturn => [qw| SuliX        Endian |],
      fturn => [qw| Caixa_M_gica Macpup |] },
    Tuquito => { turns =>
    { DEFT  => [ q|Emmabunt_s|, undef ],
      Linvo => [qw| Gentoo     Plamo |] }  } }                       ],
 [             q|{eturn} action !isa defined|,
  [qw|                                fail |],
  [qw|                       KNOPPIX eturn |],
  qr.\Q{KNOPPIX}(eturn): action !isa defined.                        ],
 [             q|{uturn} action !isa defined|,
  [qw|                                fail |],
  [qw|                       KNOPPIX uturn |],
  qr.\Q{KNOPPIX}(uturn): action !isa defined.                        ],
 [             q|{tturn} action !isa defined|,
  [qw|                                fail |],
  [qw|                       KNOPPIX tturn |],
  qr.\Q{KNOPPIX}(tturn): action !isa defined.                        ],
 [             q|{fturn} action !isa defined|,
  [qw|                                fail |],
  [qw|                       KNOPPIX fturn |],
  qr.\Q{KNOPPIX}(fturn): action !isa defined.                        ],
 [         q|turn of {turns} action !isa defined|,
  [qw|                                    fail |],
  [qw|                       Tuquito turn%DEFT |],
  qr.\Q{Tuquito}(turn%DEFT): action !isa defined.                    ],
 [          q|correct {eturn}|,
  [qw|           pass quiet |],
  [qw|           Kiwi eturn |],
  [ 3, [qw| BRLix Super_OS |]]                                       ],
 [      q|correct {uturn}|,
  [qw|       pass quiet |],
  [qw|       Kiwi uturn |],
  [ 3, [qw| CCux Qubes |]]                                           ],
 [        q|correct {tturn}|,
  [qw|         pass quiet |],
  [qw|         Kiwi tturn |],
  [ 3, [qw| SuliX Endian |]]                                         ],
 [               q|correct {fturn}|,
  [qw|                pass quiet |],
  [qw|                Kiwi fturn |],
  [ 3, [qw| Caixa_M_gica Macpup |]]                                  ],
 [ q|correct turn of {turns}|,
  [qw|          pass quiet |],
  [qw|  Tuquito turn%Linvo |],
  [ 3,  [qw| Gentoo Plamo |]]                                        ],
 [                                                 '',
  [qw|                                        init |],
  { KNOPPIX    =>
    { eturn => [qw| BackBox     aLinux |, undef ],
      uturn => [qw| EasyPeasy CAELinux |, undef ],
      tturn => [qw| BRLix     Super_OS |, undef ],
      fturn => [qw| CCux         Qubes |, undef ] },
    Kiwi       => { turns =>
    { Tuquito => [qw| SuliX     Endian |, undef ]}} }                ],
 [      q|{eturn} with trailing undef|,
  [qw|                   pass quiet |],
  [qw|                KNOPPIX eturn |],
  [ 2, [qw| BackBox aLinux |, undef ]]                               ],
 [
            q|{uturn} with trailing undef|,
  [qw|                       pass quiet |],
  [qw|                    KNOPPIX uturn |],
  [ 2, [qw| EasyPeasy CAELinux |, undef ]]                           ],
 [      q|{tturn} with trailing undef|,
  [qw|                   pass quiet |],
  [qw|                KNOPPIX tturn |],
  [ 2, [qw| BRLix Super_OS |, undef ]]                               ],
 [  q|{fturn} with trailing undef|,
  [qw|               pass quiet |],
  [qw|            KNOPPIX fturn |],
  [ 2, [qw| CCux Qubes |, undef ]]                                   ],
 [ q|correct turn of {turns} with trailing undef|,
  [qw|                              pass quiet |],
  [qw|                       Kiwi turn%Tuquito |],
  [ 2,              [qw| SuliX Endian |, undef ]]                    ],
 [                                                  '',
  [qw|                                         init |],
  { KNOPPIX  =>
    { eturn => [qw| BackBox  aLinux  EasyPeasy |],
      uturn => [qw| CAELinux   BRLix  Super_OS |],
      tturn => [qw| CCux      Qubes      SuliX |],
      fturn => [qw| Endian Caixa_M_gica Macpup |]  },
  Kiwi       => { turns =>
  { Tuquito => [qw| Emmabunt_s  Gentoo   Plamo |] }} }               ],
 [       q|{eturn} trailing extra noise|,
  [qw|                     pass quiet |],
  [qw|                  KNOPPIX eturn |],
  [ 2, [qw| BackBox aLinux EasyPeasy |]]                             ],
 [      q|{uturn} trailing extra noise|,
  [qw|                    pass quiet |],
  [qw|                 KNOPPIX uturn |],
  [ 2, [qw| CAELinux BRLix Super_OS |]]                              ],
 [q|{tturn} trailing extra noise|,
  [qw|              pass quiet |],
  [qw|           KNOPPIX tturn |],
  [ 2,  [qw| CCux Qubes SuliX |]]                                    ],
 [         q|{fturn} trailing extra noise|,
  [qw|                       pass quiet |],
  [qw|                    KNOPPIX fturn |],
  [ 2, [qw| Endian Caixa_M_gica Macpup |]]                           ],
 [ q|turn of {eturn} trailing extra noise|,
  [qw|                       pass quiet |],
  [qw|                Kiwi turn%Tuquito |],
  [ 2,    [qw| Emmabunt_s Gentoo Plamo |]]                           ],
 [                                         '',
  [qw|                                init |],
  { START =>
    { eturn => [ q|BackBox|,   undef ],
      uturn => [ q|aLinux|,    undef ],
      tturn => [ q|EasyPeasy|, undef ],
      fturn => [ q|CAELinux|,  undef ]    },
    STOP =>
    { eturn => [ q|BRLix|,    undef ],
      uturn => [ q|Super_OS|, undef ],
      tturn => [ q|CCux|,     undef ],
      fturn => [ q|Qubes|,    undef ]     },
    CONTINUE =>
    { eturn => [ q|SuliX|,        undef ],
      uturn => [ q|Endian|,       undef ],
      tturn => [ q|Caixa_M_gica|, undef ],
      fturn => [ q|Macpup|,       undef ] },
    BREAK =>
    { eturn => [ q|Emmabunt_s|, undef ],
      uturn => [ q|Gentoo|,     undef ],
      tturn => [ q|Plamo|,      undef ],
      fturn => [ q|Linvo|,      undef ]   } }                        ],
 [ q|{START}{eturn} action isa undef|,
  [qw|                  pass quiet |],
  [qw|                 START eturn |],
  [ 4,            [ q|BackBox|, '' ]]                                ],
 [ q|{START}{uturn} action isa undef|,
  [qw|                  pass quiet |],
  [qw|                 START uturn |],
  [ 4,             [ q|aLinux|, '' ]]                                ],
 [ q|{START}{tturn} action isa undef|,
  [qw|                  pass quiet |],
  [qw|                 START tturn |],
  [ 4,          [ q|EasyPeasy|, '' ]]                                ],
 [ q|{START}{fturn} action isa undef|,
  [qw|                  pass quiet |],
  [qw|                 START fturn |],
  [ 4,           [ q|CAELinux|, '' ]]                                ],
 [        q|{STOP}{eturn} action isa undef|,
  [qw|                              fail |],
  [qw|                        STOP eturn |],
  qr.\Q{STOP}(eturn): action !isa defined .                          ],
 [        q|{STOP}{uturn} action isa undef|,
  [qw|                              fail |],
  [qw|                        STOP uturn |],
  qr.\Q{STOP}(uturn): action !isa defined .                          ],
 [        q|{STOP}{tturn} action isa undef|,
  [qw|                              fail |],
  [qw|                        STOP tturn |],
  qr.\Q{STOP}(tturn): action !isa defined .                          ],
 [        q|{STOP}{fturn} action isa undef|,
  [qw|                              fail |],
  [qw|                        STOP fturn |],
  qr.\Q{STOP}(fturn): action !isa defined .                          ],
 [ q|{CONTINUE}{eturn} action isa undef|,
  [qw|                     pass quiet |],
  [qw|                 CONTINUE eturn |],
  [ 4,                 [ q|SuliX|, '' ]]                             ],
 [ q|{CONTINUE}{uturn} action isa undef|,
  [qw|                     pass quiet |],
  [qw|                 CONTINUE uturn |],
  [ 4,                [ q|Endian|, '' ]]                             ],
 [ q|{CONTINUE}{tturn} action isa undef|,
  [qw|                     pass quiet |],
  [qw|                 CONTINUE tturn |],
  [ 4,          [ q|Caixa_M_gica|, '' ]]                             ],
 [ q|{CONTINUE}{fturn} action isa undef|,
  [qw|                     pass quiet |],
  [qw|                 CONTINUE fturn |],
  [ 4,                [ q|Macpup|, '' ]]                             ],
 [        q|{BREAK}{eturn} action isa undef|,
  [qw|                               fail |],
  [qw|                        BREAK eturn |],
  qr.\Q{BREAK}(eturn): action !isa defined .                         ],
 [        q|{BREAK}{uturn} action isa undef|,
  [qw|                               fail |],
  [qw|                        BREAK uturn |],
  qr.\Q{BREAK}(uturn): action !isa defined .                         ],
 [        q|{BREAK}{tturn} action isa undef|,
  [qw|                               fail |],
  [qw|                        BREAK tturn |],
  qr.\Q{BREAK}(tturn): action !isa defined .                         ],
 [        q|{BREAK}{fturn} action isa undef|,
  [qw|                               fail |],
  [qw|                        BREAK fturn |],
  qr.\Q{BREAK}(fturn): action !isa defined .                         ],
 [                                                               '',
  [qw|                                                      init |],
  { START    => { turns => { KNOPPIX => [ q|BackBox|,   undef ]}},
    STOP     => { turns => { Kiwi    => [ q|aLinux|,    undef ]}},
    CONTINUE => { turns => { Tuquito => [ q|EasyPeasy|, undef ]}},
    BREAK    => { turns => { DEFT    => [ q|CAELinux|,  undef ]}} }  ],
 [ q|{START}{turns} action isa undef|,
  [qw|                  pass quiet |],
  [qw|          START turn%KNOPPIX |],
  [ 4,            [ q|BackBox|, '' ]]                                ],
 [            q|{STOP}{turns} action isa undef|,
  [qw|                                  fail |],
  [qw|                        STOP turn%Kiwi |],
  qr.\Q{STOP}(turn%Kiwi): action !isa defined .                      ],
 [ q|{CONTINUE}{turns} action isa undef|,
  [qw|                     pass quiet |],
  [qw|          CONTINUE turn%Tuquito |],
  [ 4,             [ q|EasyPeasy|, '' ]]                             ],
 [            q|{BREAK}{turns} action isa undef|,
  [qw|                                   fail |],
  [qw|                        BREAK turn%DEFT |],
  qr.\Q{BREAK}(turn%DEFT): action !isa defined .                     ] );

plan tests => sum map                  {
    grep( $_ eq q|init|,  @$_ ) ? 0 :
    grep( $_ eq q|fail|,  @$_ ) ? 1 :
    grep( $_ eq q|quiet|, @$_ ) ? 1 : 2 }
                  map {         $_->[1] } @data;

foreach my $unit ( @data )                                           {
    if( grep $_ eq q|init|, @{$unit->[1]}    )                      {
        %st = %{$unit->[2]};
        AFSMTS_class_wrap { %opts }, \%st                            }
    elsif( grep $_ eq q|pass|, @{$unit->[1]} )                      {
        AFSMTS_method_wrap $method, @{$unit->[2]};
        is_deeply [ scalar keys %{$bb->{_}{fst}}, $rc ], $unit->[3],
          qq|$unit->[0], queried|;
        like $stderr, $unit->[4], qq|$unit->[0], noted|                 unless
          grep $_ eq q|quiet|, @{$unit->[1]}                         }
    elsif( grep $_ eq q|fail|, @{$unit->[1]} )                      {
        AFSMTS_method_wrap $method, @{$unit->[2]};
        like $@, $unit->[3], AFSMTS_croakson qq|$unit->[0], queried| }}

# vim: set filetype=perl
