# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230614174403;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"819684", "山鹿",
"81885", "小松島",
"815995", "阿児",
"817675", "七尾",
"818795", "三本松",
"819205", "厳原",
"818367", "宇部",
"81832", "下関",
"815993", "鳥羽",
"812998", "潮来",
"812838", "佐野",
"811858", "能代",
"812648", "長野",
"811546", "釧路",
"811377", "八雲",
"818292", "広島",
"81260", "阿南町",
"818793", "三本松",
"819938", "加世田",
"817673", "羽咋",
"814775", "船橋",
"817238", "寝屋川",
"81178", "八戸",
"818680", "岡山",
"817903", "福崎",
"818244", "三次",
"812618", "大町",
"815586", "下田",
"818262", "加計",
"818678", "新見",
"81478", "佐原",
"81987", "日南",
"812968", "笠間",
"8112394", "夕張",
"8186999", "岡山瀬戸",
"8188092", "窪川",
"812566", "三条",
"818397", "小郡",
"817905", "福崎",
"81467", "藤沢",
"814226", "武蔵野三鷹",
"81167", "富良野",
"815954", "上野",
"815988", "三瀬谷",
"817940", "加古川",
"81834", "徳山",
"818462", "竹原",
"81572", "多治見",
"811526", "網走",
"811549", "釧路",
"81892", "久万",
"815393", "浜松",
"811977", "北上",
"812787", "沼田",
"817707", "小浜",
"812677", "佐久",
"818562", "益田",
"815767", "下呂",
"818544", "木次",
"815395", "浜松",
"81545", "富士",
"817482", "八日市",
"812383", "米沢",
"819807", "沖縄宮古",
"818592", "米子",
"812574", "柏崎",
"8188095", "土佐清水",
"818514", "海士",
"812550", "安塚",
"814229", "武蔵野三鷹",
"812569", "巻",
"818837", "阿波池田",
"818206", "柳井",
"814756", "東金",
"812385", "米沢",
"815363", "新城",
"81555", "吉田",
"815589", "修善寺大仁",
"811756", "野辺地",
"812474", "石川",
"811866", "鷹巣",
"811582", "紋別",
"811987", "遠野",
"819666", "水俣",
"81562", "尾張横須賀",
"818876", "土佐山田",
"8183768", "下関",
"8126177", "長野",
"814707", "大原",
"811538", "根室標津",
"812558", "新井",
"811656", "美深",
"812584", "長岡",
"812373", "村山",
"817472", "五条",
"81940", "宗像",
"8112391", "夕張",
"819946", "鹿屋",
"81853", "出雲",
"812375", "村山",
"815564", "鰍沢青柳",
"812484", "白河",
"811936", "宮古",
"812956", "常陸大宮",
"81950", "平戸",
"8198298", "日向",
"818943", "八幡浜",
"818879", "室戸",
"81270", "伊勢崎",
"818693", "邑久",
"819674", "熊本一の宮",
"818842", "阿南",
"815743", "美濃加茂",
"81583", "岐阜",
"81564", "岡崎",
"812748", "富岡",
"817685", "輪島",
"81823", "呉",
"818695", "岡山瀬戸",
"811874", "角館",
"818952", "宇和島",
"818945", "八幡浜",
"814798", "八日市場",
"811869", "大館",
"817683", "輪島",
"815752", "関",
"81778", "武生",
"815745", "美濃加茂",
"8125488", "津川",
"819784", "豊後高田",
"818557", "川本",
"812640", "長野",
"812830", "宇都宮",
"811238", "栗山",
"811939", "宮古",
"81177", "青森",
"81298", "土浦",
"811336", "石狩",
"812551", "上越",
"812975", "水海道",
"8182942", "広島",
"817230", "寝屋川",
"81988", "那覇",
"818665", "高梁",
"818688", "美作",
"818654", "鴨方",
"81468", "横須賀",
"819577", "島原",
"819949", "大根占",
"81596", "伊勢",
"817948", "三木",
"818894", "須崎",
"812872", "大田原",
"814282", "青梅",
"818663", "総社",
"819972", "種子島",
"815978", "熊野",
"81561", "瀬戸",
"815734", "恵那",
"812973", "水海道",
"81559", "沼津",
"8198292", "延岡",
"814796", "八日市場",
"818847", "牟岐",
"818543", "安来",
"811236", "千歳",
"8125482", "村上",
"818957", "御荘",
"817916", "竜野",
"818552", "浜田",
"815757", "郡上八幡",
"818545", "木次",
"815394", "浜松",
"812746", "富岡",
"81549", "静岡",
"81546", "静岡",
"81833", "下松",
"817946", "三木",
"812575", "十日町",
"812473", "石川",
"81930", "行橋",
"812560", "糸魚川",
"81740", "今津",
"814220", "国分寺",
"812559", "安塚",
"811539", "根室標津",
"8186993", "備前",
"8199343", "鹿児島",
"812573", "柏崎",
"819572", "諫早",
"814287", "青梅",
"812877", "黒磯",
"812384", "米沢",
"819977", "瀬戸内",
"818686", "津山",
"812475", "石川",
"819668", "水俣",
"819685", "玉名",
"8125485", "津川",
"811587", "中湧別",
"81886", "徳島",
"815994", "阿児",
"811982", "花巻",
"817674", "羽咋",
"818794", "三本松",
"818878", "嶺北",
"819204", "郷ノ浦",
"81487", "浦和",
"81228", "築館",
"819683", "山鹿",
"811868", "鷹巣",
"8198295", "日向",
"814702", "館山",
"818689", "岡山",
"818245", "三次",
"819546", "鹿島",
"815953", "上野",
"811938", "宮古",
"811658", "上川",
"815979", "熊野",
"811536", "厚岸",
"812556", "糸魚川",
"817904", "福崎",
"818243", "東広島",
"81280", "古河",
"815955", "上野",
"817949", "加古川",
"819948", "志布志",
"814240", "国分寺",
"81893", "大洲",
"818467", "木江",
"811873", "角館",
"81852", "松江",
"819675", "熊本一の宮",
"811541", "弟子屈",
"819783", "豊後高田",
"817684", "輪島",
"811972", "水沢",
"812782", "沼田",
"81977", "別府",
"817702", "敦賀",
"819673", "熊本一の宮",
"818694", "岡山",
"811875", "角館",
"812672", "小諸",
"811528", "美幌",
"818944", "八幡浜",
"81488", "浦和",
"81227", "仙台",
"815762", "下呂",
"818567", "津和野",
"81188", "秋田",
"812839", "佐野",
"81581", "高富",
"812649", "長野",
"815744", "美濃加茂",
"819785", "豊後高田",
"812999", "潮来",
"817487", "水口",
"818208", "久賀",
"818893", "佐川",
"819802", "南大東",
"818597", "根雨",
"814758", "東金",
"818679", "新見",
"815733", "恵那",
"812974", "水海道",
"812619", "大町",
"81563", "西尾",
"81584", "大垣",
"818664", "高梁",
"817239", "寝屋川",
"818832", "鴨島",
"818655", "鴨方",
"819940", "志布志",
"818895", "須崎",
"81875", "観音寺",
"81420", "所沢",
"815735", "恵那",
"812996", "潮来",
"811548", "弟子屈",
"812646", "長野",
"812836", "佐野",
"811856", "能代",
"819438", "田主丸",
"819936", "加世田",
"818362", "宇部",
"811372", "鹿部",
"811946", "久慈",
"8112396", "栗山",
"818297", "廿日市",
"8153963", "天竜",
"815563", "鰍沢青柳",
"812585", "長岡",
"812568", "巻",
"814228", "武蔵野三鷹",
"818267", "千代田",
"815986", "松阪",
"81535", "浜松",
"812483", "白河",
"812374", "村山",
"812583", "長岡",
"812616", "大町",
"815588", "修善寺大仁",
"815565", "鰍沢青柳",
"8188098", "土佐清水",
"81582", "岐阜",
"812485", "白河",
"81822", "広島",
"818676", "久世",
"81567", "津島",
"812913", "鉾田",
"811954", "二戸",
"812934", "高萩",
"819912", "中之島",
"812894", "宇都宮",
"818804", "土佐中村",
"818872", "室戸",
"819662", "人吉",
"81276", "太田",
"81764", "富山",
"812780", "前橋",
"81926", "福岡",
"818973", "新居浜",
"81471", "柏",
"81898", "今治",
"818975", "新居浜",
"811862", "鹿角",
"81578", "神岡",
"811586", "中湧別",
"812654", "飯田",
"811634", "浜頓別",
"812695", "中野",
"81474", "船橋",
"811932", "釜石",
"819953", "大口",
"812557", "新井",
"811537", "中標津",
"814708", "大原",
"811643", "石狩深川",
"812853", "小山",
"81174", "蟹田",
"817715", "亀岡",
"819942", "大根占",
"81425", "立川",
"819955", "加治木",
"81929", "福岡",
"819964", "川内",
"812879", "烏山",
"814289", "青梅",
"812693", "中野",
"817734", "福知山",
"819979", "徳之島",
"817713", "亀岡",
"811652", "士別",
"812855", "小山",
"811645", "留萌",
"817476", "下市",
"8161", "大阪",
"819547", "鹿島",
"81125", "滝川",
"81253", "新潟",
"815756", "郡上八幡",
"811589", "興部",
"818375", "美祢",
"812747", "富岡",
"818956", "宇和島",
"817917", "竜野",
"817725", "宮津",
"818360", "小郡",
"811363", "倶知安",
"818558", "川本",
"8186698", "倉敷",
"818846", "丹生谷",
"814797", "八日市場",
"818584", "倉吉",
"81739", "田辺",
"818373", "長門",
"811237", "栗山",
"81949", "直方",
"817494", "彦根",
"811365", "倶知安",
"81243", "二本松",
"817723", "宮津",
"811354", "余市",
"81762", "金沢",
"814701", "鴨川",
"811395", "江差",
"819976", "名瀬",
"818687", "美作",
"817455", "大和高田",
"819823", "延岡",
"81946", "甘木",
"817464", "吉野",
"8186998", "岡山瀬戸",
"812876", "黒磯",
"814286", "相模原",
"81956", "佐世保",
"811393", "松前",
"815977", "熊野",
"8147955", "八日市場",
"8112390", "夕張",
"819578", "島原",
"81172", "弘前",
"817453", "大和高田",
"8182943", "広島",
"817947", "三木",
"811332", "当別",
"819825", "日向",
"819595", "有川",
"812414", "柳津",
"811947", "久慈",
"8198299", "日向",
"811453", "早来",
"818296", "広島",
"819432", "八女",
"819724", "佐伯",
"818368", "宇部",
"818385", "萩",
"8164", "大阪",
"811564", "上士幌",
"811542", "釧路",
"811555", "帯広",
"818474", "府中",
"8165", "大阪",
"818383", "萩",
"811464", "静内",
"819937", "加世田",
"811455", "鵡川",
"819593", "大瀬戸",
"811553", "帯広",
"81436", "市原",
"8125489", "津川",
"812997", "潮来",
"811378", "今金",
"811857", "能代",
"812647", "長野",
"812837", "佐野",
"818677", "新見",
"81935", "北九州",
"817354", "新宮",
"81162", "稚内",
"81439", "木更津",
"817365", "和歌山橋本",
"8178", "神戸",
"8188093", "窪川",
"812967", "笠間",
"812562", "三条",
"81462", "厚木",
"812544", "新発田",
"812617", "大町",
"814222", "武蔵野三鷹",
"81234", "酒田",
"815987", "三瀬谷",
"817363", "和歌山橋本",
"818398", "小郡",
"81292", "水戸",
"815582", "下田",
"818266", "千代田",
"819554", "伊万里",
"817995", "洲本",
"81725", "和泉",
"81568", "春日井",
"812788", "前橋",
"811978", "北上",
"811734", "五所川原",
"81196", "盛岡",
"815768", "下呂",
"81774", "宇治",
"819744", "三重",
"81266", "諏訪",
"812244", "白石",
"817993", "洲本",
"81577", "高山",
"812678", "佐久",
"818466", "木江",
"818299", "広島",
"811522", "斜里",
"819733", "日田",
"817613", "小松",
"81984", "小林",
"81963", "熊本",
"811752", "むつ",
"814700", "鴨川",
"819232", "前原",
"818838", "阿波池田",
"812233", "岩沼",
"819808", "八重山",
"818202", "柳井",
"817963", "豊岡",
"81294", "常陸太田",
"814752", "茂原",
"8162", "大阪",
"812793", "渋川",
"81199", "盛岡",
"812235", "仙台",
"818391", "小郡",
"81183", "湯沢",
"817615", "小松",
"819735", "日田",
"812795", "渋川",
"817486", "水口",
"81464", "厚木",
"818596", "米子",
"817965", "豊岡",
"817954", "西脇",
"815766", "下呂",
"817493", "彦根",
"818374", "長門",
"818583", "倉吉",
"8163", "大阪",
"818369", "宇部",
"817706", "小浜",
"81222", "仙台",
"812676", "佐久",
"817724", "宮津",
"811353", "余市",
"818568", "津和野",
"818585", "倉吉",
"811976", "北上",
"817495", "長浜",
"812786", "沼田",
"81857", "鳥取",
"811364", "倶知安",
"811527", "美幌",
"811757", "野辺地",
"811394", "松前",
"818207", "久賀",
"817454", "大和高田",
"817465", "吉野",
"817488", "水口",
"814757", "東金",
"818598", "根雨",
"818836", "脇町",
"819806", "沖縄宮古",
"81244", "原町",
"8182920", "廿日市",
"817463", "吉野",
"819824", "延岡",
"811942", "岩泉",
"812935", "水戸",
"811955", "二戸",
"819437", "田主丸",
"812895", "宇都宮",
"818805", "土佐中村",
"81473", "市川",
"812653", "飯田",
"812789", "前橋",
"81429", "所沢",
"811376", "八雲",
"811547", "白糠",
"81925", "福岡",
"818803", "土佐中村",
"818298", "廿日市",
"812893", "宇都宮",
"819932", "指宿",
"818366", "宇部",
"812933", "高萩",
"811953", "二戸",
"812914", "鉾田",
"812679", "佐久",
"818974", "新居浜",
"812992", "石岡",
"815769", "荘川",
"8112397", "栗山",
"811852", "男鹿",
"812832", "佐野",
"812642", "木曾福島",
"8169", "大阪",
"811635", "浜頓別",
"812655", "飯田",
"812694", "中野",
"818672", "福渡",
"819963", "川内",
"81587", "一宮",
"812962", "下館",
"81827", "岩国",
"819809", "八重山",
"812567", "巻",
"81242", "会津若松",
"812612", "大町",
"818268", "千代田",
"814227", "武蔵野三鷹",
"817714", "亀岡",
"817733", "福知山",
"81763", "福野",
"815982", "松阪",
"814994", "三宅",
"819954", "加治木",
"81426", "八王子",
"819965", "川内",
"814280", "立川",
"81252", "新潟",
"8153962", "天竜",
"817735", "福知山",
"811644", "留萌",
"812854", "小山",
"81126", "岩見沢",
"815587", "修善寺大仁",
"81495", "本庄",
"817994", "洲本",
"818848", "牟岐",
"812243", "白石",
"818556", "江津",
"81726", "茨木",
"819743", "三重",
"81964", "松橋",
"8125483", "村上",
"81983", "高鍋",
"812742", "藤岡",
"811735", "五所川原",
"817912", "相生",
"811733", "五所川原",
"815758", "郡上八幡",
"81184", "本荘",
"814792", "銚子",
"811232", "千歳",
"812245", "大河原",
"818290", "広島",
"81463", "平塚",
"81484", "川口",
"8198293", "延岡",
"818958", "御荘",
"81828", "広島",
"814709", "鴨川",
"818682", "津山",
"8186992", "備前",
"817953", "西脇",
"819576", "島原",
"812234", "仙台",
"815972", "尾鷲",
"817614", "小松",
"819978", "徳之島",
"819734", "日田",
"81286", "宇都宮",
"8188099", "土佐清水",
"812794", "渋川",
"814288", "青梅",
"812878", "烏山",
"817964", "豊岡",
"811337", "石狩",
"817942", "加古川",
"817955", "三田",
"81729", "八尾",
"812415", "柳津",
"819594", "有川",
"81182", "横手",
"819725", "佐伯",
"811463", "浦河",
"81848", "尾道",
"818384", "萩",
"818877", "嶺北",
"819667", "水俣",
"811588", "興部",
"81482", "川口",
"818475", "府中",
"811554", "帯広",
"811986", "遠野",
"811465", "静内",
"81233", "新庄",
"819723", "佐伯",
"81962", "熊本",
"812413", "喜多方",
"811454", "鵡川",
"818473", "甲山",
"81939", "北九州",
"811563", "本別",
"811867", "鷹巣",
"818559", "川本",
"817355", "新宮",
"812957", "大子",
"811937", "宮古",
"81936", "北九州",
"817364", "和歌山橋本",
"819553", "伊万里",
"811532", "根室",
"812552", "上越",
"812545", "村上",
"8186995", "岡山瀬戸",
"8199345", "鹿児島",
"819947", "志布志",
"817353", "新宮",
"81550", "御殿場",
"814281", "相模原",
"813", "東京",
"814706", "大原",
"812543", "新発田",
"818490", "尾道",
"819542", "武雄",
"819555", "唐津",
"818595", "米子",
"817966", "八鹿",
"815362", "新城",
"817468", "上北山",
"81544", "富士宮",
"812796", "渋川",
"817485", "八日市",
"818657", "笠岡",
"817616", "小松",
"81937", "北九州",
"812236", "仙台",
"818493", "尾道",
"8188091", "窪川",
"817483", "八日市",
"812382", "米沢",
"818593", "米子",
"819574", "諫早",
"815737", "中津川",
"81554", "大月",
"819599", "大瀬戸",
"819677", "矢部",
"81835", "防府",
"818563", "益田",
"81551", "韮崎",
"811559", "帯広",
"818463", "竹原",
"8183766", "下関",
"811877", "大曲",
"815392", "浜松",
"817498", "長浜",
"818565", "益田",
"818588", "郡家",
"817996", "津名",
"818554", "浜田",
"819787", "国東",
"8186697", "倉敷",
"818265", "安芸吉田",
"814704", "館山",
"814772", "市川",
"812587", "長岡",
"81552", "甲府",
"8125486", "津川",
"812239", "仙台",
"818263", "加計",
"81542", "静岡",
"817902", "福崎",
"817738", "舞鶴",
"8198296", "日向",
"817950", "三田",
"812799", "長野原",
"817366", "岩出",
"819968", "出水",
"817969", "浜坂",
"812487", "須賀川",
"81863", "玉野",
"815992", "鳥羽",
"818293", "廿日市",
"81727", "池田",
"818808", "土佐清水",
"811456", "門別富川",
"812898", "鹿沼",
"817672", "羽咋",
"811984", "花巻",
"818792", "三本松",
"812938", "水戸",
"811958", "岩手",
"811638", "利尻礼文",
"812658", "伊那",
"811556", "帯広",
"81480", "久喜",
"8186552", "倉敷",
"8199347", "鹿児島",
"8186997", "岡山瀬戸",
"819596", "福江",
"818295", "廿日市",
"812577", "六日町",
"819826", "日向",
"814283", "青梅",
"812873", "大田原",
"8112392", "夕張",
"8153974", "天竜",
"819804", "名護",
"818662", "高梁",
"818834", "鴨島",
"812972", "水海道",
"819973", "種子島",
"81586", "一宮",
"817958", "丹波柏原",
"81998", "鹿児島",
"812875", "大田原",
"814285", "相模原",
"817456", "大和高田",
"81427", "相模原",
"81288", "今市",
"811396", "江差",
"8188094", "窪川",
"819975", "名瀬",
"812477", "三春",
"812859", "小山",
"812890", "宇都宮",
"811366", "寿都",
"812930", "水戸",
"818953", "宇和島",
"811738", "鰺ケ沢",
"81565", "豊田",
"811974", "水沢",
"817682", "輪島",
"815753", "関",
"812784", "沼田",
"81728", "寝屋川",
"818845", "丹生谷",
"814298", "飯能",
"818955", "宇和島",
"818942", "八幡浜",
"817726", "峰山",
"81220", "迫",
"818692", "邑久",
"817704", "敦賀",
"81593", "四日市",
"812674", "小諸",
"818843", "阿南",
"812248", "大河原",
"815764", "下呂",
"818547", "掛合",
"815755", "関",
"818376", "美祢",
"815742", "美濃加茂",
"817475", "下市",
"818247", "庄原",
"812856", "真岡",
"811646", "羽幌",
"8182941", "広島",
"817459", "大和榛原",
"81938", "北九州",
"814996", "八丈島",
"81250", "新津",
"819956", "加治木",
"819558", "唐津",
"8147950", "八日市場",
"8112395", "栗山",
"817716", "園部",
"81240", "磐城富岡",
"81849", "福山",
"817473", "五条",
"812372", "村山",
"815957", "上野",
"812696", "飯山",
"818478", "東城",
"811585", "遠軽",
"818976", "新居浜",
"819687", "玉名",
"814291", "飯能",
"81157", "北見",
"818364", "宇部",
"819728", "臼杵",
"81533", "豊橋",
"812418", "会津山口",
"811374", "森",
"811583", "紋別",
"81899", "松山",
"817718", "園部",
"818242", "東広島",
"818264", "安芸吉田",
"819556", "唐津",
"814705", "館山",
"81864", "倉敷",
"812698", "飯山",
"81460", "小田原",
"814703", "館山",
"812858", "真岡",
"811648", "焼尻",
"812230", "仙台",
"812377", "寒河江",
"812546", "村上",
"817356", "串本",
"817960", "八鹿",
"81798", "西宮",
"815952", "上野",
"814998", "小笠原",
"817959", "三田",
"81928", "福岡",
"819682", "山鹿",
"811466", "えりも",
"8198291", "延岡",
"811566", "十勝清水",
"8125481", "村上",
"818476", "府中",
"818978", "伯方",
"811983", "花巻",
"81896", "伊予三島",
"812416", "田島",
"818294", "廿日市",
"819726", "臼杵",
"818594", "米子",
"819573", "諫早",
"812572", "柏崎",
"817956", "三田",
"817484", "八日市",
"81948", "飯塚",
"817458", "大和榛原",
"81738", "御坊",
"818667", "井原",
"811398", "熊石",
"812549", "津川",
"818512", "西郷",
"812977", "竜ケ崎",
"8112398", "栗山",
"819828", "高千穂",
"81862", "岡山",
"819575", "諫早",
"81839", "山口",
"812472", "石川",
"81958", "長崎",
"81543", "静岡",
"812419", "田島",
"817728", "峰山",
"818464", "竹原",
"817687", "能都",
"812246", "大河原",
"818553", "浜田",
"818378", "下関",
"8188096", "土佐清水",
"818479", "東城",
"819746", "竹田",
"812911", "鉾田",
"818947", "宇和",
"818697", "備前",
"81553", "山梨",
"811736", "五所川原",
"818564", "益田",
"818555", "江津",
"815747", "美濃白川",
"818542", "安来",
"81947", "田川",
"817474", "五条",
"81737", "湯浅",
"81592", "津",
"814777", "船橋",
"817736", "舞鶴",
"812582", "長岡",
"8153960", "天竜",
"81534", "浜松",
"817368", "岩出",
"819966", "出水",
"815562", "鰍沢青柳",
"817907", "播磨山崎",
"812482", "白河",
"811558", "広尾",
"8198294", "延岡",
"811584", "遠軽",
"815997", "阿児",
"812656", "伊那",
"811636", "北見枝幸",
"81845", "因島",
"818365", "宇部",
"818388", "田万川",
"8152", "名古屋",
"818797", "土庄",
"817677", "七尾",
"819598", "福江",
"811375", "八雲",
"81438", "木更津",
"812896", "鹿沼",
"81138", "函館",
"81531", "田原",
"818806", "宿毛",
"8125484", "村上",
"811956", "岩手",
"812936", "水戸",
"818363", "宇部",
"815367", "設楽",
"819805", "名護",
"818835", "脇町",
"818652", "倉敷",
"81585", "揖斐川",
"81825", "広島",
"819803", "名護",
"818892", "佐川",
"817968", "浜坂",
"81594", "桑名",
"812874", "大田原",
"814284", "立川",
"812387", "長井",
"819969", "中甑",
"817466", "十津川",
"812798", "長野原",
"81569", "半田",
"819738", "玖珠",
"81532", "豊橋",
"819974", "屋久島",
"817618", "加賀",
"81797", "西宮",
"815732", "恵那",
"818833", "鴨島",
"812238", "仙台",
"812673", "小諸",
"81277", "桐生",
"81591", "津",
"812939", "水戸",
"819672", "熊本一の宮",
"817703", "敦賀",
"812899", "鹿沼",
"811356", "岩内",
"81927", "福岡",
"811975", "水沢",
"811551", "十勝池田",
"8124196", "柳津",
"817496", "長浜",
"81566", "刈谷",
"812785", "沼田",
"815763", "下呂",
"818844", "阿南",
"817998", "津名",
"818586", "倉吉",
"818954", "宇和島",
"817705", "小浜",
"812675", "佐久",
"815397", "浜松",
"8147957", "八日市場",
"81268", "上田",
"815765", "下呂",
"812783", "沼田",
"811973", "水沢",
"815754", "関",
"819782", "豊後高田",
"812659", "伊那",
"811639", "利尻礼文",
"811392", "木古内",
"812580", "十日町",
"812578", "六日町",
"811333", "当別",
"817452", "大和高田",
"81548", "榛原",
"812478", "三春",
"818666", "井原",
"8112393", "夕張",
"812976", "竜ケ崎",
"817957", "丹波柏原",
"819822", "延岡",
"81246", "いわき",
"811737", "鰺ケ沢",
"814297", "飯能",
"818372", "長門",
"81249", "郡山",
"815746", "美濃加茂",
"818946", "宇和",
"817722", "宮津",
"8128798", "大田原",
"818696", "備前",
"812247", "大河原",
"817686", "能都",
"818548", "石見大田",
"819747", "竹田",
"811362", "倶知安",
"81144", "苫小牧",
"81259", "佐渡",
"81229", "古川",
"811935", "釜石",
"812955", "常陸大宮",
"812571", "六日町",
"8166", "大阪",
"817357", "串本",
"812964", "下館",
"819943", "鹿屋",
"812692", "中野",
"81979", "中津",
"818674", "久世",
"812979", "竜ケ崎",
"81273", "高崎",
"812614", "大町",
"811653", "士別",
"818248", "庄原",
"817712", "亀岡",
"818669", "総社",
"81923", "福岡",
"812547", "村上",
"812376", "寒河江",
"819945", "鹿屋",
"814992", "伊豆大島",
"815984", "松阪",
"819952", "大口",
"81424", "武蔵野三鷹",
"815958", "亀山",
"811933", "釜石",
"81124", "芦別",
"819557", "唐津",
"811655", "名寄",
"811642", "石狩深川",
"812852", "小山",
"818875", "土佐山田",
"812417", "会津山口",
"811944", "岩泉",
"819727", "臼杵",
"81888", "高知",
"811567", "十勝清水",
"818477", "東城",
"819665", "人吉",
"819688", "玉名",
"81142", "伊達",
"81765", "魚津",
"811863", "鹿角",
"81793", "姫路",
"819913", "硫黄島",
"819934", "指宿",
"818873", "安芸",
"818949", "宇和",
"811865", "大館",
"811854", "男鹿",
"812834", "宇都宮",
"812644", "木曾福島",
"819663", "人吉",
"81226", "気仙沼",
"818972", "新居浜",
"812994", "石岡",
"81493", "東松山",
"818684", "津山",
"818240", "東広島",
"81985", "宮崎",
"81489", "草加",
"814755", "東金",
"812386", "長井",
"818205", "柳井",
"81284", "足利",
"81263", "松本",
"815738", "中津川",
"811753", "むつ",
"81932", "北九州",
"815974", "尾鷲",
"817612", "小松",
"819732", "日田",
"81742", "奈良",
"812232", "岩沼",
"81721", "富田林",
"819233", "前原",
"817962", "豊岡",
"8167", "大阪",
"817944", "加古川",
"818203", "柳井",
"815366", "設楽",
"812792", "渋川",
"81969", "天草",
"814753", "茂原",
"81465", "小田原",
"815396", "浜松",
"812744", "藤岡",
"81281", "宇都宮",
"81724", "岸和田貝塚",
"817992", "洲本",
"815999", "津",
"819678", "矢部",
"817914", "相生",
"811523", "斜里",
"811234", "千歳",
"8183767", "下関",
"817497", "長浜",
"819788", "国東",
"818587", "郡家",
"81775", "大津",
"814794", "銚子",
"81486", "浦和",
"811525", "網走",
"811878", "大曲",
"811357", "岩内",
"81282", "栃木",
"812570", "小出",
"81934", "北九州",
"8188090", "窪川",
"817362", "和歌山橋本",
"81744", "大和高田",
"8125487", "津川",
"81547", "島田",
"81992", "鹿児島",
"814225", "武蔵野三鷹",
"812588", "長岡",
"812565", "三条",
"815583", "下田",
"817906", "播磨山崎",
"811534", "中標津",
"812554", "上越",
"8199331", "鹿児島",
"81557", "伊東",
"8198297", "日向",
"812488", "須賀川",
"81235", "鶴岡",
"819967", "出水",
"812389", "米沢",
"819544", "武雄",
"81433", "千葉",
"815585", "下田",
"812563", "三条",
"814223", "武蔵野三鷹",
"817737", "舞鶴",
"814776", "船橋",
"812897", "鹿沼",
"818382", "萩",
"818807", "宿毛",
"811957", "岩手",
"812937", "水戸",
"819592", "大瀬戸",
"819435", "八女",
"811545", "釧路",
"811552", "帯広",
"8186553", "倉敷",
"819433", "八女",
"811452", "早来",
"81722", "堺",
"817676", "七尾",
"818796", "土庄",
"8186996", "岡山瀬戸",
"811637", "北見枝幸",
"812657", "伊那",
"815996", "阿児",
"815399", "天竜",
"811543", "釧路",
"811934", "釜石",
"812965", "下館",
"815983", "松阪",
"817367", "岩出",
"81952", "佐賀",
"81476", "成田",
"812486", "須賀川",
"818675", "久世",
"812615", "大町",
"815566", "身延",
"81176", "十和田",
"818660", "岡山瀬戸",
"8186994", "岡山瀬戸",
"8112399", "栗山",
"818673", "福渡",
"81877", "丸亀",
"8175", "京都",
"819944", "鹿屋",
"815985", "松阪",
"812963", "下館",
"819962", "川内",
"817908", "播磨山崎",
"817732", "福知山",
"81942", "久留米",
"811654", "名寄",
"812613", "大町",
"812586", "長岡",
"812892", "宇都宮",
"818802", "窪川",
"818387", "田万川",
"819208", "対馬佐賀",
"818874", "安芸",
"811945", "久慈",
"819597", "福江",
"8168", "大阪",
"812932", "高萩",
"811952", "二戸",
"819679", "高森",
"818798", "土庄",
"817678", "七尾",
"819933", "指宿",
"815998", "阿児",
"812993", "石岡",
"81924", "福岡",
"811557", "十勝池田",
"81766", "高岡",
"819664", "人吉",
"812643", "木曾福島",
"811853", "男鹿",
"812833", "宇都宮",
"819935", "加世田",
"81423", "国分寺",
"811943", "岩泉",
"811457", "門別富川",
"818690", "岡山",
"81179", "三戸",
"81975", "大分",
"811864", "大館",
"812835", "佐野",
"811855", "能代",
"812645", "木曾福島",
"819789", "杵築",
"812652", "飯田",
"811632", "天塩",
"81225", "石巻",
"812995", "石岡",
"8111", "札幌",
"812589", "長岡",
"815736", "中津川",
"81792", "姫路",
"81537", "掛川",
"814771", "市川",
"818896", "須崎",
"81944", "瀬高",
"815368", "設楽",
"81734", "和歌山",
"819737", "玖珠",
"818656", "笠岡",
"817617", "加賀",
"812237", "仙台",
"8153961", "天竜",
"817967", "八鹿",
"812388", "長井",
"81245", "福島",
"81143", "室蘭",
"812489", "須賀川",
"812797", "渋川",
"817997", "津名",
"819786", "杵築",
"8124197", "柳津",
"811876", "大曲",
"817492", "彦根",
"815398", "浜松",
"818582", "倉吉",
"819676", "高森",
"81922", "福岡",
"81272", "前橋",
"811352", "余市",
"817352", "新宮",
"81538", "磐田",
"812697", "飯山",
"815956", "上野",
"812579", "小出",
"814224", "武蔵野三鷹",
"817717", "園部",
"812564", "三条",
"819543", "武雄",
"812555", "糸魚川",
"811535", "厚岸",
"812542", "新発田",
"819957", "加治木",
"81236", "山形",
"812553", "上越",
"818246", "三次",
"811533", "根室",
"815584", "下田",
"819552", "伊万里",
"812378", "寒河江",
"811647", "羽幌",
"812857", "真岡",
"81262", "長野",
"812412", "喜多方",
"81933", "北九州",
"819434", "八女",
"819722", "佐伯",
"81743", "奈良",
"811562", "本別",
"811544", "釧路",
"818472", "甲山",
"811462", "浦河",
"81134", "小樽",
"812917", "水戸",
"81492", "川越",
"81192", "大船渡",
"8186691", "倉敷",
"818549", "石見大田",
"818977", "伯方",
"81434", "千葉",
"819686", "玉名",
"81723", "堺",
"811397", "奥尻",
"818668", "井原",
"818685", "津山",
"812476", "三春",
"818249", "東広島",
"81986", "都城",
"811754", "むつ",
"814770", "市川",
"815973", "尾鷲",
"812978", "竜ケ崎",
"81779", "大野",
"814754", "茂原",
"817943", "加古川",
"818204", "柳井",
"817457", "大和高田",
"81166", "旭川",
"81878", "高松",
"818683", "津山",
"815959", "亀山",
"81191", "一関",
"819827", "高千穂",
"817945", "加古川",
"812576", "十日町",
"817952", "西脇",
"81466", "藤沢",
"81965", "八代",
"814793", "銚子",
"812745", "藤岡",
"817688", "能都",
"8145", "横浜",
"8125480", "村上",
"811732", "五所川原",
"81494", "秩父",
"818377", "下関",
"811233", "千歳",
"818546", "掛合",
"817727", "峰山",
"817915", "相生",
"8188097", "土佐清水",
"81432", "千葉",
"811235", "夕張",
"812242", "白石",
"81776", "福井",
"815748", "美濃白川",
"812743", "藤岡",
"8153977", "天竜",
"814795", "銚子",
"819742", "三重",
"8198290", "延岡",
"81989", "那覇",
"811524", "網走",
"818948", "宇和",
"8144", "川崎",
"81485", "熊谷",
"811367", "寿都",
"818698", "備前",};
$areanames{en} = {"814794", "Choshi\,\ Chiba",
"818587", "Koge\,\ Tottori",
"81775", "Otsu\,\ Shiga",
"819788", "Kunisaki\,\ Oita",
"8183767", "Shimonoseki\,\ Yamaguchi",
"8126178", "Omachi\,\ Nagano",
"817497", "Nagahama\,\ Shiga",
"81234", "Sakata\,\ Yamagata",
"811234", "Chitose\,\ Hokkaido",
"8153968", "Hamamatsu\,\ Shizuoka",
"819554", "Imari\,\ Saga",
"811357", "Iwanai\,\ Hokkaido",
"815582", "Shimoda\,\ Shizuoka",
"811878", "Omagari\,\ Akita",
"81292", "Mito\,\ Ibaraki",
"818398", "Ogori\,\ Yamaguchi",
"811525", "Abashiri\,\ Hokkaido",
"81486", "Urawa\,\ Saitama",
"8153973", "Hamamatsu\,\ Shizuoka",
"815999", "Tsu\,\ Mie",
"812967", "Kasama\,\ Ibaraki",
"8178", "Kobe\,\ Hyogo",
"81439", "Kisarazu\,\ Chiba",
"817992", "Sumoto\,\ Hyogo",
"81162", "Wakkanai\,\ Hokkaido",
"81935", "Kitakyushu\,\ Fukuoka",
"817354", "Shingu\,\ Fukuoka",
"81281", "Utsunomiya\,\ Tochigi",
"812744", "Fujioka\,\ Gunma",
"818677", "Niimi\,\ Okayama",
"811523", "Shari\,\ Hokkaido",
"812544", "Shibata\,\ Niigata",
"81462", "Atsugi\,\ Kanagawa",
"817914", "Aioi\,\ Hyogo",
"812562", "Sanjo\,\ Niigata",
"81721", "Tondabayashi\,\ Osaka",
"819233", "Maebaru\,\ Fukuoka",
"811455", "Mukawa\,\ Hokkaido",
"819593", "Oseto\,\ Nagasaki",
"812232", "Iwanuma\,\ Miyagi",
"819937", "Kaseda\,\ Kagoshima",
"811464", "Shizunai\,\ Hokkaido",
"819732", "Hita\,\ Oita",
"81742", "Nara\,\ Nara",
"817612", "Komatsu\,\ Ishikawa",
"811753", "Mutsu\,\ Aomori",
"818383", "Hagi\,\ Yamaguchi",
"815974", "Owase\,\ Mie",
"81932", "Kitakyushu\,\ Fukuoka",
"81263", "Matsumoto\,\ Nagano",
"81284", "Ashikaga\,\ Tochigi",
"8165", "Osaka\,\ Osaka",
"815738", "Nakatsugawa\,\ Gifu",
"812647", "Nagano\,\ Nagano",
"812837", "Sano\,\ Tochigi",
"811857", "Noshiro\,\ Akita",
"81465", "Odawara\,\ Kanagawa",
"81969", "Amakusa\,\ Kumamoto",
"814753", "Mobara\,\ Chiba",
"811378", "Imakane\,\ Hokkaido",
"812792", "Shibukawa\,\ Gunma",
"815366", "Shitara\,\ Aichi",
"812997", "Itako\,\ Ibaraki",
"8125489", "Tsugawa\,\ Niigata",
"818203", "Yanai\,\ Yamaguchi",
"817944", "Kakogawa\,\ Hyogo",
"8167", "Osaka\,\ Osaka",
"817962", "Toyooka\,\ Hyogo",
"81436", "Ichihara\,\ Chiba",
"811553", "Obihiro\,\ Hokkaido",
"818368", "Ube\,\ Yamaguchi",
"818385", "Hagi\,\ Yamaguchi",
"81489", "Soka\,\ Saitama",
"81985", "Miyazaki\,\ Miyazaki",
"819724", "Saiki\,\ Oita",
"819432", "Yame\,\ Fukuoka",
"818684", "Tsuyama\,\ Okayama",
"818240", "Higashi\-ku\,\ Hiroshima",
"818296", "Hiroshima\,\ Hiroshima",
"8198299", "Hyuga\,\ Miyazaki",
"81493", "Higashimatsuyama\,\ Saitama",
"811947", "Kuji\,\ Iwate",
"811453", "Hayakita\,\ Hokkaido",
"812414", "Yanaizu\,\ Fukushima",
"811555", "Obihiro\,\ Hokkaido",
"818474", "Fuchu\,\ Hiroshima",
"811542", "Kushiro\,\ Hokkaido",
"818205", "Yanai\,\ Yamaguchi",
"811564", "Kamishihoro\,\ Hokkaido",
"812386", "Nagai\,\ Yamagata",
"8164", "Osaka\,\ Osaka",
"814755", "Togane\,\ Chiba",
"819735", "Hita\,\ Oita",
"817615", "Komatsu\,\ Ishikawa",
"81183", "Yuzawa\,\ Akita",
"818796", "Tonosho\,\ Kagawa",
"817676", "Nanao\,\ Ishikawa",
"81722", "Sakai\,\ Osaka",
"818391", "Ogori\,\ Yamaguchi",
"811452", "Hayakita\,\ Hokkaido",
"812235", "Sendai\,\ Miyagi",
"81199", "Morioka\,\ Iwate",
"819433", "Yame\,\ Fukuoka",
"817954", "Nishiwaki\,\ Hyogo",
"811543", "Kushiro\,\ Hokkaido",
"817965", "Toyooka\,\ Hyogo",
"818596", "Yonago\,\ Tottori",
"815996", "Ago\,\ Mie",
"812657", "Ina\,\ Nagano",
"81464", "Atsugi\,\ Kanagawa",
"812795", "Shibukawa\,\ Gunma",
"8186996", "Seto\,\ Okayama",
"817486", "Minakuchi\,\ Shiga",
"819435", "Yame\,\ Fukuoka",
"812233", "Iwanuma\,\ Miyagi",
"819592", "Oseto\,\ Nagasaki",
"819232", "Maebaru\,\ Fukuoka",
"811957", "Iwate\,\ Iwate",
"812937", "Mito\,\ Ibaraki",
"814700", "Kamogawa\,\ Chiba",
"818807", "Sukumo\,\ Kochi",
"818382", "Hagi\,\ Yamaguchi",
"811752", "Mutsu\,\ Aomori",
"817613", "Komatsu\,\ Ishikawa",
"81984", "Kobayashi\,\ Miyazaki",
"81963", "Kumamoto\,\ Kumamoto",
"812897", "Kanuma\,\ Tochigi",
"819733", "Hita\,\ Oita",
"8162", "Osaka\,\ Osaka",
"8186553", "Kurashiki\,\ Okayama",
"812793", "Shibukawa\,\ Gunma",
"814752", "Mobara\,\ Chiba",
"811552", "Obihiro\,\ Hokkaido",
"81294", "Hitachiota\,\ Ibaraki",
"817963", "Toyooka\,\ Hyogo",
"811545", "Kushiro\,\ Hokkaido",
"818202", "Yanai\,\ Yamaguchi",
"819808", "Yaeyama\ District\,\ Okinawa",
"812389", "Yonezawa\,\ Yamagata",
"819967", "Izumi\,\ Kagoshima",
"817993", "Sumoto\,\ Hyogo",
"812244", "Shiroishi\,\ Miyagi",
"812488", "Sukagawa\,\ Fukushima",
"81235", "Tsuruoka\,\ Yamagata",
"815768", "Gero\,\ Gifu",
"81774", "Uji\,\ Kyoto",
"8198297", "Hyuga\,\ Miyazaki",
"81266", "Suwa\,\ Nagano",
"819744", "Mie\,\ Oita",
"81557", "Ito\,\ Shizuoka",
"8199331", "Kagoshima\,\ Kagoshima",
"8153970", "Hamamatsu\,\ Shizuoka",
"818299", "Hiroshima\,\ Hiroshima",
"811522", "Shari\,\ Hokkaido",
"814776", "Funabashi\,\ Chiba",
"817737", "Maizuru\,\ Kyoto",
"812563", "Sanjo\,\ Niigata",
"819544", "Takeo\,\ Saga",
"81433", "Chiba\,\ Chiba",
"815585", "Shimoda\,\ Shizuoka",
"818466", "Mima\,\ Tokushima",
"81577", "Takayama\,\ Gifu",
"812678", "Saku\,\ Nagano",
"811734", "Goshogawara\,\ Aomori",
"811978", "Kitakami\,\ Iwate",
"81568", "Kasugai\,\ Aichi",
"812788", "Maebashi\,\ Gunma",
"81744", "Yamatotakada\,\ Nara",
"817995", "Sumoto\,\ Hyogo",
"81934", "Kitakyushu\,\ Fukuoka",
"81725", "Izumi\,\ Osaka",
"81282", "Tochigi\,\ Tochigi",
"812554", "Joetsu\,\ Niigata",
"811534", "Nakashibetsu\,\ Hokkaido",
"815583", "Shimoda\,\ Shizuoka",
"81196", "Morioka\,\ Iwate",
"812588", "Nagaoka\,\ Niigata",
"812565", "Sanjo\,\ Niigata",
"81992", "Kagoshima\,\ Kagoshima",
"8125487", "Tsugawa\,\ Niigata",
"81547", "Shimada\,\ Shizuoka",
"812693", "Nakano\,\ Nagano",
"819747", "Taketa\,\ Oita",
"819964", "Satsumasendai\,\ Kagoshima",
"812879", "Nasukarasuyama\,\ Tochigi",
"814289", "Ome\,\ Tokyo",
"819955", "Kajiki\,\ Kagoshima",
"817686", "Noto\,\ Ishikawa",
"81929", "Fukuoka\,\ Fukuoka",
"81425", "Tachikawa\,\ Tokyo",
"812247", "Ogawara\,\ Miyagi",
"819547", "Kashima\,\ Saga",
"81125", "Takikawa\,\ Hokkaido",
"81259", "Sado\,\ Niigata",
"81144", "Tomakomai\,\ Hokkaido",
"817476", "Shimonoseki\,\ Yamaguchi",
"811362", "Kutchan\,\ Hokkaido",
"8161", "Osaka\,\ Osaka",
"812855", "Oyama\,\ Tochigi",
"811645", "Rumoi\,\ Hokkaido",
"811652", "Shibetsu\,\ Hokkaido",
"817734", "Fukuchiyama\,\ Kyoto",
"819979", "Tokunoshima\,\ Kagoshima",
"817713", "Kameoka\,\ Kyoto",
"818372", "Nagato\,\ Yamaguchi",
"815746", "Minokamo\,\ Gifu",
"81249", "Koriyama\,\ Fukushima",
"819953", "Okuchi\,\ Kagoshima",
"814297", "Hanno\,\ Saitama",
"8126176", "Omachi\,\ Nagano",
"811932", "Kamaishi\,\ Iwate",
"81474", "Funabashi\,\ Chiba",
"812695", "Nakano\,\ Nagano",
"817715", "Kameoka\,\ Kyoto",
"81174", "Kanita\,\ Aomori",
"818696", "Bizen\,\ Okayama",
"812853", "Oyama\,\ Tochigi",
"8128798", "Otawara\,\ Tochigi",
"811537", "Nakashibetsu\,\ Hokkaido",
"818946", "Uwajima\,\ Ehime",
"817722", "Miyazu\,\ Kyoto",
"8153966", "Hamamatsu\,\ Shizuoka",
"81898", "Imabari\,\ Ehime",
"818666", "Ibara\,\ Okayama",
"8112393", "Yubari\,\ Hokkaido",
"81471", "Kashiwa\,\ Chiba",
"812478", "Miharu\,\ Fukushima",
"812654", "Iida\,\ Nagano",
"811634", "Hamatonbetsu\,\ Hokkaido",
"811586", "Nakayubetsu\,\ Hokkaido",
"81578", "Kamioka\,\ Akita",
"811862", "Kazuno\,\ Akita",
"81246", "Iwaki\,\ Fukushima",
"819822", "Nobeoka\,\ Miyazaki",
"818975", "Niihama\,\ Ehime",
"818872", "Muroto\,\ Kochi",
"812894", "Utsunomiya\,\ Tochigi",
"812580", "Tokamachi\,\ Niigata",
"812934", "Takahagi\,\ Ibaraki",
"812913", "Hokota\,\ Ibaraki",
"811954", "Ninohe\,\ Iwate",
"811392", "Kikonai\,\ Hokkaido",
"81567", "Tsushima\,\ Aichi",
"818973", "Niihama\,\ Ehime",
"812780", "Maebashi\,\ Gunma",
"81548", "Haibara\,\ Shizuoka",
"81926", "Fukuoka\,\ Fukuoka",
"817452", "Yamatotakada\,\ Nara",
"811333", "Tobetsu\,\ Hokkaido",
"81276", "Ota\,\ Gunma",
"81764", "Toyama\,\ Toyama",
"812578", "Muika\,\ Niigata",
"819662", "Hitoyoshi\,\ Kumamoto",
"8112390", "Yubari\,\ Hokkaido",
"8147955", "Yokaichiba\,\ Chiba",
"818949", "Uwajima\,\ Ehime",
"815977", "Kumano\,\ Mie",
"818873", "Aki\,\ Kochi",
"81956", "Sasebo\,\ Nagasaki",
"811393", "Matsumae\,\ Hokkaido",
"81793", "Himeji\,\ Hyogo",
"819934", "Ibusuki\,\ Kagoshima",
"817453", "Yamatotakada\,\ Nara",
"819825", "Hyuga\,\ Miyazaki",
"8182943", "Hiroshima\,\ Hiroshima",
"817947", "Miki\,\ Hyogo",
"811332", "Tobetsu\,\ Hokkaido",
"812994", "Ishioka\,\ Ibaraki",
"81172", "Hirosaki\,\ Aomori",
"81226", "Kesennuma\,\ Miyagi",
"818972", "Niihama\,\ Ehime",
"819663", "Hitoyoshi\,\ Kumamoto",
"811854", "Oga\,\ Akita",
"812834", "Utsunomiya\,\ Tochigi",
"811865", "Odate\,\ Akita",
"819578", "Shimabara\,\ Nagasaki",
"818687", "Mimasaka\,\ Okayama",
"819727", "Usuki\,\ Oita",
"819976", "Naze\,\ Kagoshima",
"811395", "Esashi\,\ Hokkaido",
"811944", "Iwaizumi\,\ Iwate",
"814701", "Kamogawa\,\ Chiba",
"812876", "Kuroiso\,\ Tochigi",
"811863", "Kazuno\,\ Akita",
"814286", "Sagamihara\,\ Kanagawa",
"81765", "Uozu\,\ Toyama",
"8186998", "Seto\,\ Okayama",
"81142", "Date\,\ Hokkaido",
"819665", "Hitoyoshi\,\ Kumamoto",
"819688", "Tamana\,\ Kumamoto",
"81946", "Amagi\,\ Fukuoka",
"818477", "Tojo\,\ Hiroshima",
"817464", "Yoshino\,\ Nara",
"817455", "Yamatotakada\,\ Nara",
"819823", "Nobeoka\,\ Miyazaki",
"81888", "Kochi\,\ Kochi",
"811933", "Kamaishi\,\ Iwate",
"815958", "Kameyama\,\ Mie",
"81949", "Nogata\,\ Fukuoka",
"817494", "Hikone\,\ Shiga",
"811237", "Kuriyama\,\ Hokkaido",
"819952", "Okuchi\,\ Kagoshima",
"819945", "Kanoya\,\ Kagoshima",
"815984", "Matsusaka\,\ Mie",
"81739", "Tanabe\,\ Wakayama",
"818373", "Nagato\,\ Yamaguchi",
"818584", "Kurayoshi\,\ Tottori",
"814797", "Yokaichiba\,\ Chiba",
"8186698", "Kurashiki\,\ Okayama",
"818558", "Kawamoto\,\ Shimane",
"812852", "Oyama\,\ Tochigi",
"811655", "Nayoro\,\ Hokkaido",
"81762", "Kanazawa\,\ Ishikawa",
"81124", "Ashibetsu\,\ Hokkaido",
"819557", "Karatsu\,\ Saga",
"817723", "Miyazu\,\ Kyoto",
"811354", "Yoichi\,\ Hokkaido",
"811365", "Kutchan\,\ Hokkaido",
"81243", "Nihonmatsu\,\ Fukushima",
"812747", "Tomioka\,\ Gunma",
"818674", "Kuse\,\ Okayama",
"81979", "Nakatsu\,\ Oita",
"812692", "Nakano\,\ Nagano",
"818375", "Mine\,\ Yamaguchi",
"819943", "Kanoya\,\ Kagoshima",
"812964", "Shimodate\,\ Ibaraki",
"811589", "Okoppe\,\ Hokkaido",
"81253", "Niigata\,\ Niigata",
"8166", "Osaka\,\ Osaka",
"817357", "Kushimoto\,\ Wakayama",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"811935", "Kamaishi\,\ Iwate",
"812571", "Muika\,\ Niigata",
"812376", "Sagae\,\ Yamagata",
"811363", "Kutchan\,\ Hokkaido",
"81923", "Fukuoka\,\ Fukuoka",
"818360", "Ogori\,\ Yamaguchi",
"812547", "Murakami\,\ Niigata",
"817725", "Miyazu\,\ Kyoto",
"818669", "Soja\,\ Okayama",
"818956", "Uwajima\,\ Ehime",
"818248", "Shobara\,\ Hiroshima",
"817712", "Kameoka\,\ Kyoto",
"812614", "Omachi\,\ Nagano",
"811653", "Shibetsu\,\ Hokkaido",
"81273", "Takasaki\,\ Gunma",
"81286", "Utsunomiya\,\ Tochigi",
"819734", "Hita\,\ Oita",
"817614", "Komatsu\,\ Ishikawa",
"819978", "Tokunoshima\,\ Kagoshima",
"815972", "Owase\,\ Mie",
"81492", "Kawagoe\,\ Saitama",
"812917", "Mito\,\ Ibaraki",
"812234", "Sendai\,\ Miyagi",
"81134", "Otaru\,\ Hokkaido",
"811462", "Urakawa\,\ Hokkaido",
"819686", "Tamana\,\ Kumamoto",
"81729", "Yao\,\ Osaka",
"817955", "Sanda\,\ Hyogo",
"811337", "Ishikari\,\ Hokkaido",
"817942", "Kakogawa\,\ Hyogo",
"81434", "Chiba\,\ Chiba",
"817964", "Toyooka\,\ Hyogo",
"818977", "Hakata\,\ Ehime",
"814288", "Ome\,\ Tokyo",
"812878", "Nasukarasuyama\,\ Tochigi",
"8186691", "Kurashiki\,\ Okayama",
"81192", "Ofunato\,\ Iwate",
"812794", "Shibukawa\,\ Gunma",
"8188099", "Tosashimizu\,\ Kochi",
"819722", "Saiki\,\ Oita",
"819434", "Yame\,\ Fukuoka",
"8186992", "Bizen\,\ Okayama",
"8153979", "Hamamatsu\,\ Shizuoka",
"81743", "Nara\,\ Nara",
"818682", "Tsuyama\,\ Okayama",
"812412", "Kitakata\,\ Fukushima",
"81933", "Kitakyushu\,\ Fukuoka",
"81262", "Nagano\,\ Nagano",
"814709", "Kamogawa\,\ Chiba",
"81828", "Hiroshima\,\ Hiroshima",
"819576", "Shimabara\,\ Nagasaki",
"811544", "Kushiro\,\ Hokkaido",
"811562", "Honbetsu\,\ Hokkaido",
"817953", "Nishiwaki\,\ Hyogo",
"81236", "Yamagata\,\ Yamagata",
"812245", "Ogawara\,\ Miyagi",
"811232", "Chitose\,\ Hokkaido",
"819957", "Kajiki\,\ Kagoshima",
"814792", "Choshi\,\ Chiba",
"81184", "Yurihonjo\,\ Akita",
"811733", "Goshogawara\,\ Aomori",
"818958", "Misho\,\ Ehime",
"812857", "Mooka\,\ Tochigi",
"8198293", "Nobeoka\,\ Miyazaki",
"811647", "Haboro\,\ Hokkaido",
"81484", "Kawaguchi\,\ Saitama",
"81463", "Hiratsuka\,\ Kanagawa",
"812378", "Sagae\,\ Yamagata",
"819552", "Imari\,\ Saga",
"815584", "Shimoda\,\ Shizuoka",
"818290", "Hiroshima\,\ Hiroshima",
"812553", "Joetsu\,\ Niigata",
"818246", "Miyoshi\,\ Hiroshima",
"811533", "Nemuro\,\ Hokkaido",
"811735", "Goshogawara\,\ Aomori",
"812742", "Fujioka\,\ Gunma",
"81983", "Takanabe\,\ Miyazaki",
"8125483", "Murakami\,\ Niigata",
"812697", "Iiyama\,\ Nagano",
"819743", "Mie\,\ Oita",
"81726", "Ibaraki\,\ Osaka",
"818556", "Gotsu\,\ Shimane",
"812243", "Shiroishi\,\ Miyagi",
"81538", "Iwata\,\ Shizuoka",
"817994", "Sumoto\,\ Hyogo",
"817352", "Shingu\,\ Fukuoka",
"81495", "Honjo\,\ Saitama",
"812542", "Shibata\,\ Niigata",
"812555", "Itoigawa\,\ Niigata",
"811535", "Akkeshi\,\ Hokkaido",
"819543", "Takeo\,\ Saga",
"817912", "Aioi\,\ Hyogo",
"812564", "Sanjo\,\ Niigata",
"817717", "Sonobe\,\ Kyoto",
"814795", "Choshi\,\ Chiba",
"819742", "Mie\,\ Oita",
"813", "Tokyo",
"812743", "Fujioka\,\ Gunma",
"814281", "Sagamihara\,\ Kanagawa",
"81550", "Gotenba\,\ Shizuoka",
"81776", "Fukui\,\ Fukui",
"817353", "Shingu\,\ Fukuoka",
"819947", "Shibushi\,\ Kagoshima",
"8199345", "Kagoshima\,\ Kagoshima",
"812242", "Shiroishi\,\ Miyagi",
"8186995", "Seto\,\ Okayama",
"811235", "Yubari\,\ Hokkaido",
"819555", "Karatsu\,\ Saga",
"818698", "Bizen\,\ Okayama",
"818490", "Onomichi\,\ Hiroshima",
"819542", "Takeo\,\ Saga",
"811367", "Suttsu\,\ Hokkaido",
"812543", "Shibata\,\ Niigata",
"8144", "Kawasaki\,\ Kanagawa",
"81485", "Kumagaya\,\ Saitama",
"818948", "Uwajima\,\ Ehime",
"81989", "Naha\,\ Okinawa",
"811524", "Abashiri\,\ Hokkaido",
"8198290", "Nobeoka\,\ Miyazaki",
"818546", "Kakeya\,\ Shimane",
"811233", "Chitose\,\ Hokkaido",
"81936", "Kitakyushu\,\ Fukuoka",
"818377", "Shimonoseki\,\ Yamaguchi",
"811937", "Miyako\,\ Iwate",
"812957", "Daigo\,\ Ibaraki",
"81494", "Chichibu\,\ Saitama",
"817355", "Shingu\,\ Fukuoka",
"811732", "Goshogawara\,\ Aomori",
"8125480", "Murakami\,\ Niigata",
"8145", "Yokohama\,\ Kanagawa",
"817688", "Noto\,\ Ishikawa",
"812745", "Fujioka\,\ Gunma",
"81965", "Yatsushiro\,\ Kumamoto",
"814793", "Choshi\,\ Chiba",
"81432", "Chiba\,\ Chiba",
"812545", "Murakami\,\ Niigata",
"812552", "Joetsu\,\ Niigata",
"8188097", "Tosashimizu\,\ Kochi",
"811532", "Nemuro\,\ Hokkaido",
"817915", "Aioi\,\ Hyogo",
"819553", "Imari\,\ Saga",
"811454", "Mukawa\,\ Hokkaido",
"812413", "Kitakata\,\ Fukushima",
"818683", "Tsuyama\,\ Okayama",
"81962", "Kumamoto\,\ Kumamoto",
"811465", "Shizunai\,\ Hokkaido",
"81878", "Takamatsu\,\ Kagawa",
"81233", "Shinjo\,\ Yamagata",
"819723", "Saiki\,\ Oita",
"8126174", "Omachi\,\ Nagano",
"81166", "Asahikawa\,\ Hokkaido",
"811986", "Tono\,\ Iwate",
"8153964", "Hamamatsu\,\ Shizuoka",
"818559", "Kawamoto\,\ Shimane",
"811867", "Takanosu\,\ Akita",
"81466", "Fujisawa\,\ Kanagawa",
"817952", "Nishiwaki\,\ Hyogo",
"81939", "Kitakyushu\,\ Fukuoka",
"819827", "Takachiho\,\ Miyazaki",
"817945", "Kakogawa\,\ Hyogo",
"811563", "Honbetsu\,\ Hokkaido",
"812576", "Tokamachi\,\ Niigata",
"81191", "Ichinoseki\,\ Iwate",
"815959", "Kameyama\,\ Mie",
"81986", "Miyakonojo\,\ Miyazaki",
"818384", "Hagi\,\ Yamaguchi",
"811754", "Mutsu\,\ Aomori",
"814770", "Ichikawa\,\ Chiba",
"815973", "Owase\,\ Mie",
"818249", "Higashi\-ku\,\ Hiroshima",
"81848", "Onomichi\,\ Hiroshima",
"819725", "Saiki\,\ Oita",
"811463", "Urakawa\,\ Hokkaido",
"812476", "Miharu\,\ Fukushima",
"818668", "Ibara\,\ Okayama",
"818685", "Tsuyama\,\ Okayama",
"812415", "Yanaizu\,\ Fukushima",
"81182", "Yokote\,\ Akita",
"811397", "Okushiri\,\ Hokkaido",
"81723", "Sakai\,\ Osaka",
"818475", "Fuchu\,\ Hiroshima",
"811554", "Obihiro\,\ Hokkaido",
"81482", "Kawaguchi\,\ Saitama",
"818204", "Yanai\,\ Yamaguchi",
"811588", "Okoppe\,\ Hokkaido",
"817943", "Kakogawa\,\ Hyogo",
"817457", "Yamatotakada\,\ Nara",
"814754", "Mobara\,\ Chiba",
"819667", "Minamata\,\ Kumamoto",
"81779", "Ono\,\ Gifu",
"818836", "Mima\,\ Tokushima",
"81179", "Sannohe\,\ Aomori",
"818690", "Okayama\,\ Okayama",
"811943", "Iwaizumi\,\ Iwate",
"81423", "Kokubunji\,\ Tokyo",
"819935", "Kaseda\,\ Kagoshima",
"819824", "Nobeoka\,\ Miyazaki",
"812995", "Ishioka\,\ Ibaraki",
"81225", "Ishinomaki\,\ Miyagi",
"8182920", "Hatsukaichi\,\ Hiroshima",
"817463", "Yoshino\,\ Nara",
"81244", "Hobara\,\ Fukushima",
"819789", "Kitsuki\,\ Oita",
"811632", "Teshio\,\ Hokkaido",
"812652", "Iida\,\ Nagano",
"812835", "Sano\,\ Tochigi",
"811855", "Noshiro\,\ Akita",
"81975", "Oita\,\ Oita",
"811864", "Odate\,\ Akita",
"817678", "Nanao\,\ Ishikawa",
"819933", "Ibusuki\,\ Kagoshima",
"819679", "Takamori\,\ Kumamoto",
"818798", "Tonosho\,\ Kagawa",
"8168", "Osaka\,\ Osaka",
"812932", "Takahagi\,\ Ibaraki",
"811952", "Ninohe\,\ Iwate",
"811945", "Kuji\,\ Iwate",
"811394", "Matsumae\,\ Hokkaido",
"819597", "Fukue\,\ Nagasaki",
"818387", "Tamagawa\,\ Yamaguchi",
"811757", "Noheji\,\ Aomori",
"818874", "Aki\,\ Kochi",
"812892", "Utsunomiya\,\ Tochigi",
"8153965", "Hamamatsu\,\ Shizuoka",
"811853", "Oga\,\ Akita",
"812833", "Utsunomiya\,\ Tochigi",
"8126175", "Omachi\,\ Nagano",
"81766", "Takaoka\,\ Toyama",
"814757", "Togane\,\ Chiba",
"819664", "Hitoyoshi\,\ Kumamoto",
"81924", "Fukuoka\,\ Fukuoka",
"817465", "Yoshino\,\ Nara",
"817488", "Minakuchi\,\ Shiga",
"812993", "Ishioka\,\ Ibaraki",
"815998", "Ago\,\ Mie",
"817454", "Yamatotakada\,\ Nara",
"819962", "Satsumasendai\,\ Kagoshima",
"817495", "Nagahama\,\ Shiga",
"812786", "Numata\,\ Gunma",
"812963", "Shimodate\,\ Ibaraki",
"811976", "Kitakami\,\ Iwate",
"815985", "Matsusaka\,\ Mie",
"819944", "Kanoya\,\ Kagoshima",
"818568", "Tsuwano\,\ Shimane",
"8175", "Kyoto\,\ Kyoto",
"818585", "Kurayoshi\,\ Tottori",
"81877", "Marugame\,\ Kagawa",
"811527", "Bihoro\,\ Hokkaido",
"812586", "Nagaoka\,\ Niigata",
"811654", "Nayoro\,\ Hokkaido",
"812613", "Omachi\,\ Nagano",
"817732", "Fukuchiyama\,\ Kyoto",
"81942", "Kurume\,\ Fukuoka",
"81857", "Tottori\,\ Tottori",
"811364", "Kutchan\,\ Hokkaido",
"818675", "Kuse\,\ Okayama",
"812486", "Sukagawa\,\ Fukushima",
"81476", "Narita\,\ Chiba",
"8163", "Osaka\,\ Osaka",
"818583", "Kurayoshi\,\ Tottori",
"81952", "Saga\,\ Saga",
"815983", "Matsusaka\,\ Mie",
"818374", "Nagato\,\ Yamaguchi",
"817367", "Iwade\,\ Wakayama",
"812965", "Shimodate\,\ Ibaraki",
"817493", "Hikone\,\ Shiga",
"815766", "Gero\,\ Gifu",
"811934", "Kamaishi\,\ Iwate",
"8112399", "Kuriyama\,\ Hokkaido",
"8186994", "Seto\,\ Okayama",
"817724", "Miyazu\,\ Kyoto",
"811353", "Yoichi\,\ Hokkaido",
"81222", "Sendai\,\ Miyagi",
"812676", "Saku\,\ Nagano",
"81176", "Towada\,\ Aomori",
"818660", "Seto\,\ Okayama",
"817706", "Obama\,\ Fukui",
"818369", "Ube\,\ Yamaguchi",
"812615", "Omachi\,\ Nagano",
"815566", "Minobu\,\ Yamanashi",
"818582", "Kurayoshi\,\ Tottori",
"81252", "Niigata\,\ Niigata",
"814280", "Tachikawa\,\ Tokyo",
"815398", "Hamamatsu\,\ Shizuoka",
"819965", "Satsumasendai\,\ Kagoshima",
"817492", "Hikone\,\ Shiga",
"81426", "Hachioji\,\ Tokyo",
"819954", "Kajiki\,\ Kagoshima",
"815982", "Matsusaka\,\ Mie",
"811352", "Yoichi\,\ Hokkaido",
"81126", "Iwamizawa\,\ Hokkaido",
"81272", "Maebashi\,\ Gunma",
"812854", "Oyama\,\ Tochigi",
"811644", "Rumoi\,\ Hokkaido",
"819676", "Takamori\,\ Kumamoto",
"81922", "Fukuoka\,\ Fukuoka",
"8126172", "Omachi\,\ Nagano",
"817735", "Fukuchiyama\,\ Kyoto",
"819786", "Kitsuki\,\ Oita",
"819809", "Yaeyama\ District\,\ Okinawa",
"812962", "Shimodate\,\ Ibaraki",
"81827", "Iwakuni\,\ Yamaguchi",
"817997", "Tsuna\,\ Hyogo",
"819963", "Satsumasendai\,\ Kagoshima",
"81587", "Ichinomiya\,\ Aichi",
"812694", "Nakano\,\ Nagano",
"81763", "Fukuno\,\ Toyama",
"811876", "Omagari\,\ Akita",
"817714", "Kameoka\,\ Kyoto",
"817733", "Fukuchiyama\,\ Kyoto",
"812612", "Omachi\,\ Nagano",
"8124197", "Yanaizu\,\ Fukushima",
"81242", "Aizuwakamatsu\,\ Fukushima",
"812679", "Saku\,\ Nagano",
"811953", "Ninohe\,\ Iwate",
"812914", "Hokota\,\ Ibaraki",
"812933", "Takahagi\,\ Ibaraki",
"818366", "Ube\,\ Yamaguchi",
"819932", "Ibusuki\,\ Kagoshima",
"812237", "Sendai\,\ Miyagi",
"817617", "Kaga\,\ Ishikawa",
"818656", "Kasaoka\,\ Okayama",
"812893", "Utsunomiya\,\ Tochigi",
"819737", "Kusu\,\ Oita",
"818298", "Hatsukaichi\,\ Hiroshima",
"812655", "Iida\,\ Nagano",
"811635", "Hamatonbetsu\,\ Hokkaido",
"812832", "Sano\,\ Tochigi",
"811852", "Oga\,\ Akita",
"8169", "Osaka\,\ Osaka",
"815769", "Shokawa\,\ Gifu",
"8112397", "Kuriyama\,\ Hokkaido",
"812797", "Shibukawa\,\ Gunma",
"812489", "Sukagawa\,\ Fukushima",
"812992", "Ishioka\,\ Ibaraki",
"8126171", "Omachi\,\ Nagano",
"812388", "Nagai\,\ Yamagata",
"81143", "Muroran\,\ Hokkaido",
"81245", "Fukushima\,\ Fukushima",
"818974", "Niihama\,\ Ehime",
"814771", "Ichikawa\,\ Chiba",
"81473", "Ichikawa\,\ Chiba",
"812895", "Utsunomiya\,\ Tochigi",
"81792", "Himeji\,\ Hyogo",
"81537", "Kakegawa\,\ Shizuoka",
"812589", "Nagaoka\,\ Niigata",
"815736", "Nakatsugawa\,\ Gifu",
"819437", "Tanushimaru\,\ Fukuoka",
"8111", "Sapporo\,\ Hokkaido",
"811955", "Ninohe\,\ Iwate",
"812935", "Mito\,\ Ibaraki",
"811942", "Iwaizumi\,\ Iwate",
"811547", "Shiranuka\,\ Hokkaido",
"815368", "Shitara\,\ Aichi",
"81925", "Fukuoka\,\ Fukuoka",
"81734", "Wakayama\,\ Wakayama",
"81429", "Tokorozawa\,\ Saitama",
"811376", "Yakumo\,\ Hokkaido",
"81944", "Setaka\,\ Fukuoka",
"812789", "Maebashi\,\ Gunma",
"818896", "Susaki\,\ Kochi",
"812653", "Iida\,\ Nagano",
"812674", "Komoro\,\ Nagano",
"81593", "Yokkaichi\,\ Mie",
"818692", "Oku\,\ Okayama",
"817704", "Tsuruga\,\ Fukui",
"812375", "Murayama\,\ Yamagata",
"818942", "Yawatahama\,\ Ehime",
"81853", "Izumo\,\ Shimane",
"818955", "Uwajima\,\ Ehime",
"818376", "Mine\,\ Yamaguchi",
"815742", "Minokamo\,\ Gifu",
"818547", "Kakeya\,\ Shimane",
"815755", "Sekigahara\,\ Gifu",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"811936", "Miyako\,\ Iwate",
"81950", "Hirado\,\ Nagasaki",
"815764", "Gero\,\ Gifu",
"812484", "Shirakawa\,\ Fukushima",
"812248", "Ogawara\,\ Miyagi",
"818843", "Anan\,\ Tokushima",
"818953", "Uwajima\,\ Ehime",
"812930", "Mito\,\ Ibaraki",
"8112391", "Yubari\,\ Hokkaido",
"81940", "Munakata\,\ Fukuoka",
"811366", "Suttsu\,\ Hokkaido",
"812373", "Murayama\,\ Yamagata",
"812584", "Nagaoka\,\ Niigata",
"812890", "Utsunomiya\,\ Tochigi",
"811656", "Bifuka\,\ Hokkaido",
"8183768", "Shimonoseki\,\ Yamaguchi",
"814298", "Hanno\,\ Saitama",
"81728", "Neyagawa\,\ Osaka",
"8153967", "Hamamatsu\,\ Shizuoka",
"812784", "Numata\,\ Gunma",
"811974", "Mizusawa\,\ Iwate",
"815753", "Sekigahara\,\ Gifu",
"817682", "Wajima\,\ Ishikawa",
"819946", "Kanoya\,\ Kagoshima",
"81565", "Toyota\,\ Aichi",
"817456", "Yamatotakada\,\ Nara",
"812875", "Otawara\,\ Tochigi",
"814285", "Sagamihara\,\ Kanagawa",
"81998", "Kagoshima\,\ Kagoshima",
"819666", "Minamata\,\ Kumamoto",
"812859", "Oyama\,\ Tochigi",
"812477", "Miharu\,\ Fukushima",
"819975", "Naze\,\ Kagoshima",
"811396", "Esashi\,\ Hokkaido",
"81427", "Sagamihara\,\ Kanagawa",
"81288", "Imabari\,\ Ehime",
"819804", "Nago\,\ Okinawa",
"8112392", "Yubari\,\ Hokkaido",
"811582", "Monbetsu\,\ Hokkaido",
"811866", "Takanosu\,\ Akita",
"814283", "Ome\,\ Tokyo",
"812873", "Otawara\,\ Tochigi",
"812577", "Muika\,\ Niigata",
"819826", "Hyuga\,\ Miyazaki",
"81586", "Ichinomiya\,\ Aichi",
"818834", "Kamojima\,\ Tokushima",
"818662", "Takahashi\,\ Okayama",
"811987", "Tono\,\ Iwate",
"814282", "Ome\,\ Tokyo",
"812872", "Otawara\,\ Tochigi",
"81596", "Ise\,\ Mie",
"817948", "Miki\,\ Hyogo",
"811583", "Monbetsu\,\ Hokkaido",
"818894", "Susaki\,\ Kochi",
"81468", "Yokosuka\,\ Kanagawa",
"8126179", "Omachi\,\ Nagano",
"819577", "Shimabara\,\ Nagasaki",
"811374", "Mori\,\ Hokkaido",
"815734", "Ena\,\ Gifu",
"81561", "Seto\,\ Aichi",
"815978", "Kumano\,\ Mie",
"8153969", "Hamamatsu\,\ Shizuoka",
"818663", "Soja\,\ Okayama",
"811336", "Ishikari\,\ Hokkaido",
"819687", "Tamana\,\ Kumamoto",
"814291", "Hanno\,\ Saitama",
"818976", "Niihama\,\ Ehime",
"81298", "Tsuchiura\,\ Ibaraki",
"811585", "Engaru\,\ Hokkaido",
"811939", "Miyako\,\ Iwate",
"818478", "Tojo\,\ Hiroshima",
"81177", "Aomori\,\ Aomori",
"818654", "Kamogata\,\ Okayama",
"818665", "Takahashi\,\ Okayama",
"81533", "Toyohashi\,\ Aichi",
"818688", "Mimasaka\,\ Okayama",
"819728", "Usuki\,\ Oita",
"81157", "Kitami\,\ Hokkaido",
"817230", "Neyagawa\,\ Osaka",
"81988", "Naha\,\ Okinawa",
"818364", "Ube\,\ Yamaguchi",
"8182942", "Hiroshima\,\ Hiroshima",
"812551", "Joetsu\,\ Niigata",
"81849", "Fukuyama\,\ Hiroshima",
"812372", "Murayama\,\ Yamagata",
"818945", "Yawatahama\,\ Ehime",
"818952", "Uwajima\,\ Ehime",
"817716", "Sonobe\,\ Kyoto",
"811874", "Kakunodate\,\ Akita",
"818695", "Seto\,\ Okayama",
"8112395", "Kuriyama\,\ Hokkaido",
"819558", "Karatsu\,\ Saga",
"8147950", "Yokaichiba\,\ Chiba",
"811238", "Kuriyama\,\ Hokkaido",
"812830", "Utsunomiya\,\ Tochigi",
"812696", "Iiyama\,\ Nagano",
"812640", "Nagano\,\ Nagano",
"81778", "Takefu\,\ Fukui",
"818557", "Kawamoto\,\ Shimane",
"819784", "Bungotakada\,\ Oita",
"8125488", "Tsugawa\,\ Niigata",
"815745", "Minokamo\,\ Gifu",
"817683", "Wajima\,\ Ishikawa",
"815752", "Sekigahara\,\ Gifu",
"814798", "Yokaichiba\,\ Chiba",
"811869", "Odate\,\ Akita",
"812856", "Mooka\,\ Tochigi",
"811646", "Haboro\,\ Hokkaido",
"818693", "Oku\,\ Okayama",
"81270", "Isesaki\,\ Gunma",
"818879", "Muroto\,\ Kochi",
"818943", "Yawatahama\,\ Ehime",
"817475", "Shimonoseki\,\ Yamaguchi",
"8198298", "Hyuga\,\ Miyazaki",
"818247", "Shobara\,\ Hiroshima",
"81823", "Kure\,\ Hiroshima",
"81583", "Gifu\,\ Gifu",
"81564", "Okazaki\,\ Aichi",
"81250", "Niitsu\,\ Niigata",
"819956", "Kajiki\,\ Kagoshima",
"817685", "Wajima\,\ Ishikawa",
"812748", "Tomioka\,\ Gunma",
"815743", "Minokamo\,\ Gifu",
"818842", "Anan\,\ Tokushima",
"81938", "Kitakyushu\,\ Fukuoka",
"8182941", "Hiroshima\,\ Hiroshima",
"8183766", "Shimonoseki\,\ Yamaguchi",
"811877", "Omagari\,\ Akita",
"81467", "Fujisawa\,\ Kanagawa",
"817905", "Fukusaki\,\ Hyogo",
"818463", "Takehara\,\ Hiroshima",
"812566", "Sanjo\,\ Niigata",
"818397", "Ogori\,\ Yamaguchi",
"819787", "Kunisaki\,\ Oita",
"818554", "Hamada\,\ Shimane",
"817996", "Tsuna\,\ Hyogo",
"817940", "Kakogawa\,\ Hyogo",
"818565", "Masuda\,\ Shimane",
"818588", "Koge\,\ Tottori",
"817498", "Nagahama\,\ Shiga",
"81167", "Furano\,\ Hokkaido",
"815392", "Hamamatsu\,\ Shizuoka",
"812618", "Omachi\,\ Nagano",
"815586", "Shimoda\,\ Shizuoka",
"818262", "Kake\,\ Hiroshima",
"818680", "Okayama\,\ Okayama",
"81178", "Hachinohe\,\ Aomori",
"81835", "Hofu\,\ Yamaguchi",
"818244", "Miyoshi\,\ Hiroshima",
"817903", "Fukusaki\,\ Hyogo",
"814775", "Funabashi\,\ Chiba",
"819599", "Oseto\,\ Nagasaki",
"817238", "Neyagawa\,\ Osaka",
"8186999", "Seto\,\ Okayama",
"8112394", "Yubari\,\ Hokkaido",
"81551", "Nirasaki\,\ Yamanashi",
"8153972", "Hamamatsu\,\ Shizuoka",
"811559", "Obihiro\,\ Hokkaido",
"812968", "Kasama\,\ Ibaraki",
"81987", "Nichinan\,\ Miyazaki",
"818563", "Masuda\,\ Shimane",
"81478", "Sawara\,\ Chiba",
"818678", "Niimi\,\ Okayama",
"818593", "Yonago\,\ Tottori",
"819574", "Isahaya\,\ Nagasaki",
"811377", "Yakumo\,\ Hokkaido",
"811546", "Kushiro\,\ Hokkaido",
"812838", "Sano\,\ Tochigi",
"812648", "Nagano\,\ Nagano",
"811858", "Noshiro\,\ Akita",
"812382", "Yonezawa\,\ Yamagata",
"817483", "Yokaichi\,\ Shiga",
"812998", "Itako\,\ Ibaraki",
"815993", "Toba\,\ Mie",
"81832", "Shimonoseki\,\ Yamaguchi",
"819938", "Kaseda\,\ Kagoshima",
"817673", "Hakui\,\ Ishikawa",
"81554", "Otsuki\,\ Yamanashi",
"81260", "Anan\,\ Nagano",
"815737", "Nakatsugawa\,\ Gifu",
"818292", "Hiroshima\,\ Hiroshima",
"815995", "Ago\,\ Mie",
"81885", "Komatsushima\,\ Tokushima",
"81544", "Fujinomiya\,\ Shizuoka",
"817468", "Kamikitayama\,\ Nara",
"812796", "Shibukawa\,\ Gunma",
"817485", "Yokaichi\,\ Shiga",
"815362", "Shinshiro\,\ Aichi",
"819684", "Yamaga\,\ Kumamoto",
"818595", "Yonago\,\ Tottori",
"8153971", "Hamamatsu\,\ Shizuoka",
"818493", "Onomichi\,\ Hiroshima",
"812236", "Sendai\,\ Miyagi",
"81937", "Kitakyushu\,\ Fukuoka",
"818367", "Ube\,\ Yamaguchi",
"818657", "Kasaoka\,\ Okayama",
"817616", "Komatsu\,\ Ishikawa",
"817675", "Nanao\,\ Ishikawa",
"815363", "Shinshiro\,\ Aichi",
"81480", "Kuki\,\ Saitama",
"812385", "Yonezawa\,\ Yamagata",
"814756", "Togane\,\ Chiba",
"811556", "Obihiro\,\ Hokkaido",
"818206", "Yanai\,\ Yamaguchi",
"812658", "Ina\,\ Nagano",
"812474", "Ishikawa\,\ Fukushima",
"818295", "Hatsukaichi\,\ Hiroshima",
"8186997", "Seto\,\ Okayama",
"819596", "Fukue\,\ Nagasaki",
"8199347", "Kagoshima\,\ Kagoshima",
"811756", "Noheji\,\ Aomori",
"8186552", "Kurashiki\,\ Okayama",
"81555", "Fujiyoshida\,\ Yamanashi",
"8153975", "Hamamatsu\,\ Shizuoka",
"8188095", "Tosashimizu\,\ Kochi",
"812574", "Kashiwazaki\,\ Niigata",
"818592", "Yonago\,\ Tottori",
"815992", "Toba\,\ Mie",
"817482", "Yokaichi\,\ Shiga",
"812383", "Yonezawa\,\ Yamagata",
"81545", "Fuji\,\ Shizuoka",
"81863", "Tamano\,\ Okayama",
"811958", "Iwate\,\ Iwate",
"812938", "Mito\,\ Ibaraki",
"817672", "Hakui\,\ Ishikawa",
"811984", "Hanamaki\,\ Iwate",
"812898", "Kanuma\,\ Tochigi",
"818293", "Hatsukaichi\,\ Hiroshima",
"812550", "Yasuzuka\,\ Niigata",
"818808", "Tosashimizu\,\ Kochi",
"81727", "Ikeda\,\ Osaka",
"818514", "Ama\,\ Shimane",
"8198296", "Hyuga\,\ Miyazaki",
"817738", "Maizuru\,\ Kyoto",
"817902", "Fukusaki\,\ Hyogo",
"818263", "Kake\,\ Hiroshima",
"81542", "Shizuoka\,\ Shizuoka",
"812677", "Saku\,\ Nagano",
"812239", "Sendai\,\ Miyagi",
"817707", "Obama\,\ Fukui",
"812487", "Sukagawa\,\ Fukushima",
"817969", "Hamasaka\,\ Hyogo",
"815395", "Hamamatsu\,\ Shizuoka",
"819968", "Izumi\,\ Kagoshima",
"818544", "Kisuki\,\ Shimane",
"817366", "Iwade\,\ Wakayama",
"812799", "Naganohara\,\ Gunma",
"815767", "Gero\,\ Gifu",
"817950", "Sanda\,\ Hyogo",
"818562", "Masuda\,\ Shimane",
"812587", "Nagaoka\,\ Niigata",
"811526", "Abashiri\,\ Hokkaido",
"814772", "Ichikawa\,\ Chiba",
"81572", "Tajimi\,\ Gifu",
"814704", "Tateyama\,\ Chiba",
"818462", "Takehara\,\ Hiroshima",
"8186697", "Kurashiki\,\ Okayama",
"81834", "Tokuyama\,\ Yamaguchi",
"812787", "Numata\,\ Gunma",
"81552", "Kofu\,\ Yamanashi",
"811977", "Kitakami\,\ Iwate",
"8125486", "Tsugawa\,\ Niigata",
"81892", "Kumakogen\,\ Ehime",
"815393", "Hamamatsu\,\ Shizuoka",
"811549", "Kushiro\,\ Hokkaido",
"81438", "Kisarazu\,\ Chiba",
"818895", "Susaki\,\ Kochi",
"819940", "Shibushi\,\ Kagoshima",
"811375", "Yakumo\,\ Hokkaido",
"815735", "Ena\,\ Gifu",
"818363", "Ube\,\ Yamaguchi",
"811956", "Iwate\,\ Iwate",
"81420", "Tokorozawa\,\ Saitama",
"812936", "Mito\,\ Ibaraki",
"8125484", "Murakami\,\ Niigata",
"81531", "Tahara\,\ Aichi",
"818806", "Sukumo\,\ Kochi",
"81875", "Kan\'onji\,\ Kagawa",
"812896", "Kanuma\,\ Tochigi",
"81138", "Hakodate\,\ Hokkaido",
"818679", "Niimi\,\ Okayama",
"814758", "Togane\,\ Chiba",
"812656", "Ina\,\ Nagano",
"819802", "Minamidaito\,\ Okinawa",
"811584", "Engaru\,\ Hokkaido",
"818893", "Sakawa\,\ Kochi",
"815997", "Ago\,\ Mie",
"817487", "Minakuchi\,\ Shiga",
"811558", "Hiroo\,\ Hokkaido",
"8198294", "Nobeoka\,\ Miyazaki",
"818655", "Kamogata\,\ Okayama",
"819598", "Fukue\,\ Nagasaki",
"817239", "Neyagawa\,\ Osaka",
"818832", "Kamojima\,\ Tokushima",
"818664", "Takahashi\,\ Okayama",
"817677", "Nanao\,\ Ishikawa",
"818797", "Tonosho\,\ Kagawa",
"8152", "Nagoya\,\ Aichi",
"818365", "Ube\,\ Yamaguchi",
"81845", "Innoshima\,\ Hiroshima",
"81584", "Ogaki\,\ Gifu",
"81563", "Nishio\,\ Aichi",
"812619", "Omachi\,\ Nagano",
"818388", "Tamagawa\,\ Yamaguchi",
"815733", "Ena\,\ Gifu",
"81488", "Urawa\,\ Saitama",
"81227", "Sendai\,\ Miyagi",
"811528", "Bihoro\,\ Hokkaido",
"818944", "Yawatahama\,\ Ehime",
"812672", "Komoro\,\ Nagano",
"811875", "Kakunodate\,\ Akita",
"817702", "Tsuruga\,\ Fukui",
"818694", "Okayama\,\ Okayama",
"81977", "Beppu\,\ Oita",
"812999", "Itako\,\ Ibaraki",
"812482", "Shirakawa\,\ Fukushima",
"819785", "Bungotakada\,\ Oita",
"815744", "Minokamo\,\ Gifu",
"812649", "Nagano\,\ Nagano",
"812839", "Sano\,\ Tochigi",
"81188", "Akita\,\ Akita",
"818567", "Tsuwano\,\ Shimane",
"815762", "Gero\,\ Gifu",
"812582", "Nagaoka\,\ Niigata",
"817736", "Maizuru\,\ Kyoto",
"811873", "Kakunodate\,\ Akita",
"81852", "Matsue\,\ Shimane",
"814777", "Funabashi\,\ Chiba",
"81737", "Yuasa\,\ Wakayama",
"81592", "Tsu\,\ Mie",
"81947", "Tagawa\,\ Fukuoka",
"818467", "Mima\,\ Tokushima",
"819966", "Izumi\,\ Kagoshima",
"812782", "Numata\,\ Gunma",
"817684", "Wajima\,\ Ishikawa",
"811972", "Mizusawa\,\ Iwate",
"811541", "Teshikaga\,\ Hokkaido",
"819783", "Bungotakada\,\ Oita",
"8126170", "Omachi\,\ Nagano",
"81534", "Hamamatsu\,\ Shizuoka",
"817368", "Iwade\,\ Wakayama",
"812675", "Saku\,\ Nagano",
"817705", "Obama\,\ Fukui",
"812616", "Omachi\,\ Nagano",
"812583", "Nagaoka\,\ Niigata",
"812374", "Murayama\,\ Yamagata",
"818954", "Uwajima\,\ Ehime",
"819782", "Bungotakada\,\ Oita",
"812659", "Ina\,\ Nagano",
"811973", "Mizusawa\,\ Iwate",
"815754", "Sekigahara\,\ Gifu",
"812783", "Numata\,\ Gunma",
"81268", "Ueda\,\ Nagano",
"815765", "Gero\,\ Gifu",
"8147957", "Yokaichiba\,\ Chiba",
"818676", "Kuse\,\ Okayama",
"81822", "Hiroshima\,\ Hiroshima",
"812485", "Shirakawa\,\ Fukushima",
"8188098", "Tosashimizu\,\ Kochi",
"81582", "Gifu\,\ Gifu",
"81927", "Fukuoka\,\ Fukuoka",
"811356", "Iwanai\,\ Hokkaido",
"8153978", "Hamamatsu\,\ Shizuoka",
"812899", "Kanuma\,\ Tochigi",
"812585", "Nagaoka\,\ Niigata",
"817703", "Tsuruga\,\ Fukui",
"81277", "Kiryu\,\ Gunma",
"81591", "Tsu\,\ Mie",
"812939", "Mito\,\ Ibaraki",
"812673", "Komoro\,\ Nagano",
"818586", "Kurayoshi\,\ Tottori",
"818844", "Anan\,\ Tokushima",
"817998", "Tsuna\,\ Hyogo",
"8126173", "Omachi\,\ Nagano",
"812483", "Shirakawa\,\ Fukushima",
"81535", "Hamamatsu\,\ Shizuoka",
"815763", "Gero\,\ Gifu",
"817496", "Nagahama\,\ Shiga",
"81566", "Kariya\,\ Aichi",
"812785", "Numata\,\ Gunma",
"8124196", "Yanaizu\,\ Fukushima",
"811975", "Mizusawa\,\ Iwate",
"815986", "Matsusaka\,\ Mie",
"812798", "Naganohara\,\ Gunma",
"817466", "Totsukawa\,\ Nara",
"811372", "Shikabe\,\ Hokkaido",
"81569", "Handa\,\ Aichi",
"812874", "Otawara\,\ Tochigi",
"814284", "Tachikawa\,\ Tokyo",
"812387", "Nagai\,\ Yamagata",
"81594", "Kuwana\,\ Mie",
"817968", "Hamasaka\,\ Hyogo",
"818892", "Sakawa\,\ Kochi",
"819803", "Nago\,\ Okinawa",
"812238", "Sendai\,\ Miyagi",
"818833", "Kamojima\,\ Tokushima",
"818297", "Hatsukaichi\,\ Hiroshima",
"815732", "Ena\,\ Gifu",
"819974", "Yakushima\,\ Kagoshima",
"81532", "Toyohashi\,\ Aichi",
"81797", "Nishinomiya\,\ Hyogo",
"817618", "Kaga\,\ Ishikawa",
"819738", "Kusu\,\ Oita",
"811946", "Kuji\,\ Iwate",
"8112396", "Kuriyama\,\ Hokkaido",
"819805", "Nago\,\ Okinawa",
"812836", "Sano\,\ Tochigi",
"812646", "Nagano\,\ Nagano",
"811856", "Noshiro\,\ Akita",
"815367", "Shitara\,\ Aichi",
"811548", "Teshikaga\,\ Hokkaido",
"812996", "Itako\,\ Ibaraki",
"81825", "Hiroshima\,\ Hiroshima",
"818362", "Ube\,\ Yamaguchi",
"819936", "Kaseda\,\ Kagoshima",
"81585", "Ibigawa\,\ Gifu",
"818652", "Kurashiki\,\ Okayama",
"818835", "Mima\,\ Tokushima",
"819438", "Tanushimaru\,\ Fukuoka",
"818978", "Hakata\,\ Ehime",
"814287", "Ome\,\ Tokyo",
"812877", "Kuroiso\,\ Tochigi",
"812384", "Yonezawa\,\ Yamagata",
"818476", "Fuchu\,\ Hiroshima",
"819572", "Isahaya\,\ Nagasaki",
"8125481", "Murakami\,\ Niigata",
"8199343", "Kagoshima\,\ Kagoshima",
"812573", "Kashiwazaki\,\ Niigata",
"8186993", "Bizen\,\ Okayama",
"819726", "Usuki\,\ Oita",
"812475", "Ishikawa\,\ Fukushima",
"818294", "Hatsukaichi\,\ Hiroshima",
"818686", "Tsuyama\,\ Okayama",
"812416", "Tajima\,\ Fukushima",
"819977", "Setouchi\,\ Kagoshima",
"81896", "Iyomishima\,\ Ehime",
"811983", "Hanamaki\,\ Iwate",
"819682", "Yamaga\,\ Kumamoto",
"817946", "Miki\,\ Hyogo",
"812575", "Tokamachi\,\ Niigata",
"81833", "Kudamatsu\,\ Yamaguchi",
"81928", "Fukuoka\,\ Fukuoka",
"81546", "Shizuoka\,\ Shizuoka",
"812559", "Yasuzuka\,\ Niigata",
"814220", "Kokubunji\,\ Tokyo",
"812560", "Itoigawa\,\ Niigata",
"81740", "Imazu\,\ Shiga",
"81930", "Yukuhashi\,\ Fukuoka",
"8198291", "Nobeoka\,\ Miyazaki",
"811466", "Erimo\,\ Hokkaido",
"812473", "Ishikawa\,\ Fukushima",
"812546", "Murakami\,\ Niigata",
"812230", "Sendai\,\ Miyagi",
"812377", "Sagae\,\ Yamagata",
"818957", "Misho\,\ Ehime",
"812858", "Mooka\,\ Tochigi",
"814703", "Tateyama\,\ Chiba",
"8125482", "Murakami\,\ Niigata",
"81460", "Odawara\,\ Kanagawa",
"814998", "Ogasawara\,\ Tokyo",
"817959", "Sanda\,\ Hyogo",
"81549", "Shizuoka\,\ Shizuoka",
"812746", "Tomioka\,\ Gunma",
"81798", "Nishinomiya\,\ Hyogo",
"815394", "Hamamatsu\,\ Shizuoka",
"818545", "Kisuki\,\ Shimane",
"818552", "Hamada\,\ Shimane",
"817356", "Kushimoto\,\ Wakayama",
"81559", "Numazu\,\ Shizuoka",
"814705", "Tateyama\,\ Chiba",
"81864", "Kurashiki\,\ Okayama",
"819556", "Karatsu\,\ Saga",
"817718", "Sonobe\,\ Kyoto",
"818242", "Higashi\-ku\,\ Hiroshima",
"81899", "Matsuyama\,\ Ehime",
"812698", "Iiyama\,\ Nagano",
"818543", "Yasugi\,\ Shimane",
"811236", "Chitose\,\ Hokkaido",
"814796", "Yokaichiba\,\ Chiba",
"8198292", "Nobeoka\,\ Miyazaki",
"818697", "Bizen\,\ Okayama",
"812556", "Itoigawa\,\ Niigata",
"818243", "Higashi\-ku\,\ Hiroshima",
"817904", "Fukusaki\,\ Hyogo",
"811536", "Akkeshi\,\ Hokkaido",
"815979", "Kumano\,\ Mie",
"811658", "Kamikawa\,\ Hokkaido",
"8153976", "Hamamatsu\,\ Shizuoka",
"812911", "Hokota\,\ Ibaraki",
"818947", "Uwajima\,\ Ehime",
"81893", "Ozu\,\ Ehime",
"818542", "Yasugi\,\ Shimane",
"818555", "Gotsu\,\ Shimane",
"814240", "Kokubunji\,\ Tokyo",
"818564", "Masuda\,\ Shimane",
"819948", "Shibushi\,\ Kagoshima",
"811736", "Goshogawara\,\ Aomori",
"817949", "Kakogawa\,\ Hyogo",
"81553", "Yamanashi\,\ Yamanashi",
"81280", "Koga\,\ Ibaraki",
"819546", "Kashima\,\ Saga",
"818245", "Miyoshi\,\ Hiroshima",
"818464", "Takehara\,\ Hiroshima",
"818689", "Okayama\,\ Okayama",
"81543", "Shizuoka\,\ Shizuoka",
"812419", "Tajima\,\ Fukushima",
"814702", "Tateyama\,\ Chiba",
"811938", "Miyako\,\ Iwate",
"819746", "Taketa\,\ Oita",
"818479", "Tojo\,\ Hiroshima",
"8188096", "Tosashimizu\,\ Kochi",
"818378", "Shimonoseki\,\ Yamaguchi",
"818553", "Hamada\,\ Shimane",
"812246", "Ogawara\,\ Miyagi",
"817687", "Noto\,\ Ishikawa",
"811868", "Takanosu\,\ Akita",
"819575", "Isahaya\,\ Nagasaki",
"819683", "Yamaga\,\ Kumamoto",
"81862", "Okayama\,\ Okayama",
"81487", "Urawa\,\ Saitama",
"819828", "Takachiho\,\ Miyazaki",
"8198295", "Hyuga\,\ Miyazaki",
"81958", "Nagasaki\,\ Nagasaki",
"81839", "Yamaguchi\,\ Yamaguchi",
"812472", "Ishikawa\,\ Fukushima",
"81886", "Tokushima\,\ Tokushima",
"811587", "Nakayubetsu\,\ Hokkaido",
"81738", "Gobo\,\ Wakayama",
"815994", "Ago\,\ Mie",
"817484", "Yokaichi\,\ Shiga",
"8125485", "Tsugawa\,\ Niigata",
"81948", "Iizuka\,\ Fukuoka",
"819668", "Minamata\,\ Kumamoto",
"817956", "Sanda\,\ Hyogo",
"819685", "Tamana\,\ Kumamoto",
"812572", "Kashiwazaki\,\ Niigata",
"818594", "Yonago\,\ Tottori",
"819573", "Isahaya\,\ Nagasaki",
"8112398", "Kuriyama\,\ Hokkaido",
"818512", "Nishigo\,\ Fukushima",
"812549", "Tsugawa\,\ Niigata",
"811398", "Kumaishi\,\ Hokkaido",
"811982", "Hanamaki\,\ Iwate",
"818667", "Ibara\,\ Okayama",
"817674", "Hakui\,\ Ishikawa",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;