/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.logging.Logger;
import org.openqa.selenium.Keys;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.ButtonReleaseAction;
import org.openqa.selenium.interactions.ClickAction;
import org.openqa.selenium.interactions.ClickAndHoldAction;
import org.openqa.selenium.interactions.CompositeAction;
import org.openqa.selenium.interactions.ContextClickAction;
import org.openqa.selenium.interactions.DoubleClickAction;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.IsInteraction;
import org.openqa.selenium.interactions.KeyDownAction;
import org.openqa.selenium.interactions.KeyInput;
import org.openqa.selenium.interactions.KeyUpAction;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.MoveMouseAction;
import org.openqa.selenium.interactions.MoveToOffsetAction;
import org.openqa.selenium.interactions.Pause;
import org.openqa.selenium.interactions.PauseAction;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.SendKeysAction;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.interactions.internal.MouseAction;

public class Actions {
    private static final Logger LOG = Logger.getLogger(Actions.class.getName());
    private final WebDriver driver;
    private final Map<InputSource, Sequence> sequences = new HashMap<InputSource, Sequence>();
    private final PointerInput defaultMouse = new PointerInput(PointerInput.Kind.MOUSE, "default mouse");
    private final KeyInput defaultKeyboard = new KeyInput("default keyboard");
    private final Keyboard jsonKeyboard;
    private final Mouse jsonMouse;
    protected CompositeAction action = new CompositeAction();

    public Actions(WebDriver driver) {
        this.driver = Objects.requireNonNull(driver);
        if (driver instanceof HasInputDevices) {
            HasInputDevices deviceOwner = (HasInputDevices)((Object)driver);
            this.jsonKeyboard = deviceOwner.getKeyboard();
            this.jsonMouse = deviceOwner.getMouse();
        } else {
            this.jsonKeyboard = null;
            this.jsonMouse = null;
        }
    }

    @Deprecated
    public Actions(Keyboard keyboard, Mouse mouse) {
        this.driver = null;
        this.jsonKeyboard = keyboard;
        this.jsonMouse = mouse;
    }

    @Deprecated
    public Actions(Keyboard keyboard) {
        this.driver = null;
        this.jsonKeyboard = keyboard;
        this.jsonMouse = null;
    }

    public Actions keyDown(CharSequence key) {
        if (this.isBuildingActions()) {
            this.action.addAction(new KeyDownAction(this.jsonKeyboard, this.jsonMouse, this.asKeys(key)));
        }
        return this.addKeyAction(key, codePoint -> this.tick(this.defaultKeyboard.createKeyDown(codePoint)));
    }

    public Actions keyDown(WebElement target, CharSequence key) {
        if (this.isBuildingActions()) {
            this.action.addAction(new KeyDownAction(this.jsonKeyboard, this.jsonMouse, (Locatable)((Object)target), this.asKeys(key)));
        }
        return this.focusInTicks(target).addKeyAction(key, codepoint -> this.tick(this.defaultKeyboard.createKeyDown(codepoint)));
    }

    public Actions keyUp(CharSequence key) {
        if (this.isBuildingActions()) {
            this.action.addAction(new KeyUpAction(this.jsonKeyboard, this.jsonMouse, this.asKeys(key)));
        }
        return this.addKeyAction(key, codePoint -> this.tick(this.defaultKeyboard.createKeyUp(codePoint)));
    }

    public Actions keyUp(WebElement target, CharSequence key) {
        if (this.isBuildingActions()) {
            this.action.addAction(new KeyUpAction(this.jsonKeyboard, this.jsonMouse, (Locatable)((Object)target), this.asKeys(key)));
        }
        return this.focusInTicks(target).addKeyAction(key, codePoint -> this.tick(this.defaultKeyboard.createKeyUp(codePoint)));
    }

    public Actions sendKeys(CharSequence ... keys) {
        if (this.isBuildingActions()) {
            this.action.addAction(new SendKeysAction(this.jsonKeyboard, this.jsonMouse, null, keys));
        }
        return this.sendKeysInTicks(keys);
    }

    public Actions sendKeys(WebElement target, CharSequence ... keys) {
        if (this.isBuildingActions()) {
            this.action.addAction(new SendKeysAction(this.jsonKeyboard, this.jsonMouse, (Locatable)((Object)target), keys));
        }
        return this.focusInTicks(target).sendKeysInTicks(keys);
    }

    private Keys asKeys(CharSequence key) {
        if (!(key instanceof Keys)) {
            throw new IllegalArgumentException("keyDown argument must be an instanceof Keys: " + key);
        }
        return (Keys)key;
    }

    private Actions sendKeysInTicks(CharSequence ... keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Keys should be a not null CharSequence");
        }
        for (CharSequence key : keys) {
            key.codePoints().forEach(codePoint -> {
                this.tick(this.defaultKeyboard.createKeyDown(codePoint));
                this.tick(this.defaultKeyboard.createKeyUp(codePoint));
            });
        }
        return this;
    }

    private Actions addKeyAction(CharSequence key, IntConsumer consumer) {
        if (key.codePoints().count() != 1L) {
            throw new IllegalStateException(String.format("Only one code point is allowed at a time: %s", key));
        }
        key.codePoints().forEach(consumer);
        return this;
    }

    public Actions clickAndHold(WebElement target) {
        if (this.isBuildingActions()) {
            this.action.addAction(new ClickAndHoldAction(this.jsonMouse, (Locatable)((Object)target)));
        }
        return this.moveInTicks(target, 0, 0).tick(this.defaultMouse.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Actions clickAndHold() {
        if (this.isBuildingActions()) {
            this.action.addAction(new ClickAndHoldAction(this.jsonMouse, null));
        }
        return this.tick(this.defaultMouse.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Actions release(WebElement target) {
        if (this.isBuildingActions()) {
            this.action.addAction(new ButtonReleaseAction(this.jsonMouse, (Locatable)((Object)target)));
        }
        return this.moveInTicks(target, 0, 0).tick(this.defaultMouse.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Actions release() {
        if (this.isBuildingActions()) {
            this.action.addAction(new ButtonReleaseAction(this.jsonMouse, null));
        }
        return this.tick(this.defaultMouse.createPointerUp(MouseAction.Button.LEFT.asArg()));
    }

    public Actions click(WebElement target) {
        if (this.isBuildingActions()) {
            this.action.addAction(new ClickAction(this.jsonMouse, (Locatable)((Object)target)));
        }
        return this.moveInTicks(target, 0, 0).clickInTicks(PointerInput.MouseButton.LEFT);
    }

    public Actions click() {
        if (this.isBuildingActions()) {
            this.action.addAction(new ClickAction(this.jsonMouse, null));
        }
        return this.clickInTicks(PointerInput.MouseButton.LEFT);
    }

    private Actions clickInTicks(PointerInput.MouseButton button) {
        this.tick(this.defaultMouse.createPointerDown(button.asArg()));
        this.tick(this.defaultMouse.createPointerUp(button.asArg()));
        return this;
    }

    private Actions focusInTicks(WebElement target) {
        return this.moveInTicks(target, 0, 0).clickInTicks(PointerInput.MouseButton.LEFT);
    }

    public Actions doubleClick(WebElement target) {
        if (this.isBuildingActions()) {
            this.action.addAction(new DoubleClickAction(this.jsonMouse, (Locatable)((Object)target)));
        }
        return this.moveInTicks(target, 0, 0).clickInTicks(PointerInput.MouseButton.LEFT).clickInTicks(PointerInput.MouseButton.LEFT);
    }

    public Actions doubleClick() {
        if (this.isBuildingActions()) {
            this.action.addAction(new DoubleClickAction(this.jsonMouse, null));
        }
        return this.clickInTicks(PointerInput.MouseButton.LEFT).clickInTicks(PointerInput.MouseButton.LEFT);
    }

    public Actions moveToElement(WebElement target) {
        if (this.isBuildingActions()) {
            this.action.addAction(new MoveMouseAction(this.jsonMouse, (Locatable)((Object)target)));
        }
        return this.moveInTicks(target, 0, 0);
    }

    public Actions moveToElement(WebElement target, int xOffset, int yOffset) {
        if (this.isBuildingActions()) {
            this.action.addAction(new MoveToOffsetAction(this.jsonMouse, (Locatable)((Object)target), xOffset, yOffset));
        }
        LOG.info("When using the W3C Action commands, offsets are from the center of element");
        return this.moveInTicks(target, xOffset, yOffset);
    }

    private Actions moveInTicks(WebElement target, int xOffset, int yOffset) {
        return this.tick(this.defaultMouse.createPointerMove(Duration.ofMillis(100L), PointerInput.Origin.fromElement(target), xOffset, yOffset));
    }

    public Actions moveByOffset(int xOffset, int yOffset) {
        if (this.isBuildingActions()) {
            this.action.addAction(new MoveToOffsetAction(this.jsonMouse, null, xOffset, yOffset));
        }
        return this.tick(this.defaultMouse.createPointerMove(Duration.ofMillis(200L), PointerInput.Origin.pointer(), xOffset, yOffset));
    }

    public Actions contextClick(WebElement target) {
        if (this.isBuildingActions()) {
            this.action.addAction(new ContextClickAction(this.jsonMouse, (Locatable)((Object)target)));
        }
        return this.moveInTicks(target, 0, 0).clickInTicks(PointerInput.MouseButton.RIGHT);
    }

    public Actions contextClick() {
        if (this.isBuildingActions()) {
            this.action.addAction(new ContextClickAction(this.jsonMouse, null));
        }
        return this.clickInTicks(PointerInput.MouseButton.RIGHT);
    }

    public Actions dragAndDrop(WebElement source, WebElement target) {
        if (this.isBuildingActions()) {
            this.action.addAction(new ClickAndHoldAction(this.jsonMouse, (Locatable)((Object)source)));
            this.action.addAction(new MoveMouseAction(this.jsonMouse, (Locatable)((Object)target)));
            this.action.addAction(new ButtonReleaseAction(this.jsonMouse, (Locatable)((Object)target)));
        }
        return this.moveInTicks(source, 0, 0).tick(this.defaultMouse.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).moveInTicks(target, 0, 0).tick(this.defaultMouse.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Actions dragAndDropBy(WebElement source, int xOffset, int yOffset) {
        if (this.isBuildingActions()) {
            this.action.addAction(new ClickAndHoldAction(this.jsonMouse, (Locatable)((Object)source)));
            this.action.addAction(new MoveToOffsetAction(this.jsonMouse, null, xOffset, yOffset));
            this.action.addAction(new ButtonReleaseAction(this.jsonMouse, null));
        }
        return this.moveInTicks(source, 0, 0).tick(this.defaultMouse.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).tick(this.defaultMouse.createPointerMove(Duration.ofMillis(250L), PointerInput.Origin.pointer(), xOffset, yOffset)).tick(this.defaultMouse.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Actions pause(long pause) {
        if (this.isBuildingActions()) {
            this.action.addAction(new PauseAction(pause));
        }
        return this.tick(new Pause(this.defaultMouse, Duration.ofMillis(pause)));
    }

    public Actions pause(Duration duration) {
        Objects.requireNonNull(duration, "Duration of pause not set");
        if (this.isBuildingActions()) {
            this.action.addAction(new PauseAction(duration.toMillis()));
        }
        return this.tick(new Pause(this.defaultMouse, duration));
    }

    public Actions tick(Interaction ... actions) {
        HashSet<InputSource> seenSources = new HashSet<InputSource>();
        for (Interaction action : actions) {
            boolean freshlyAdded = seenSources.add(action.getSource());
            if (freshlyAdded) continue;
            throw new IllegalStateException(String.format("You may only add one action per input source per tick: %s", Arrays.asList(actions)));
        }
        for (Interaction action : actions) {
            Sequence sequence = this.getSequence(action.getSource());
            sequence.addAction(action);
        }
        HashSet<InputSource> unseen = new HashSet<InputSource>(this.sequences.keySet());
        unseen.removeAll(seenSources);
        for (InputSource source : unseen) {
            this.getSequence(source).addAction(new Pause(source, Duration.ZERO));
        }
        return this;
    }

    public Actions tick(Action action) {
        if (!(action instanceof IsInteraction)) {
            throw new IllegalStateException("Expected action to implement IsInteraction");
        }
        for (Interaction interaction : ((IsInteraction)((Object)action)).asInteractions(this.defaultMouse, this.defaultKeyboard)) {
            this.tick(interaction);
        }
        if (this.isBuildingActions()) {
            this.action.addAction(action);
        }
        return this;
    }

    public Action build() {
        BuiltAction toReturn = new BuiltAction(this.driver, new LinkedHashMap<InputSource, Sequence>(this.sequences), this.action);
        this.action = new CompositeAction();
        this.sequences.clear();
        return toReturn;
    }

    public void perform() {
        this.build().perform();
    }

    private Sequence getSequence(InputSource source) {
        Sequence sequence = this.sequences.get(source);
        if (sequence != null) {
            return sequence;
        }
        int longest = 0;
        for (Sequence examining : this.sequences.values()) {
            longest = Math.max(longest, examining.size());
        }
        sequence = new Sequence(source, longest);
        this.sequences.put(source, sequence);
        return sequence;
    }

    private boolean isBuildingActions() {
        return this.jsonMouse != null || this.jsonKeyboard != null;
    }

    private static class BuiltAction
    implements Action {
        private final WebDriver driver;
        private final Map<InputSource, Sequence> sequences;
        private final Action fallBack;

        private BuiltAction(WebDriver driver, Map<InputSource, Sequence> sequences, Action fallBack) {
            this.driver = driver;
            this.sequences = sequences;
            this.fallBack = fallBack;
        }

        @Override
        public void perform() {
            if (this.driver == null) {
                this.fallBack.perform();
                return;
            }
            try {
                ((Interactive)((Object)this.driver)).perform(this.sequences.values());
            }
            catch (ClassCastException | UnsupportedCommandException e) {
                this.fallBack.perform();
            }
        }
    }
}

