/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlCommand;
import net.sourceforge.plantuml.graphic.HtmlCommandFactory;
import net.sourceforge.plantuml.graphic.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Splitter {
    static final String endFontPattern = "\\</font\\>|\\</color\\>|\\</size\\>|\\</text\\>";
    static final String endSupSub = "\\</sup\\>|\\</sub\\>";
    public static final String fontPattern = "\\<font(\\s+size[%s]*=[%s]*[%g]?\\d+[%g]?|[%s]+color[%s]*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>";
    public static final String fontColorPattern2 = "\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>";
    public static final String fontSizePattern2 = "\\<size[\\s:]+(\\d+)[%s]*\\>";
    static final String fontSup = "\\<sup\\>";
    static final String fontSub = "\\<sub\\>";
    static final String imgPattern = "\\<img\\s+(src[%s]*=[%s]*[%q%g]?[^\\s%g>]+[%q%g]?[%s]*|vspace\\s*=\\s*[%q%g]?\\d+[%q%g]?\\s*|valign[%s]*=[%s]*[%q%g]?(top|middle|bottom)[%q%g]?[%s]*)+\\>";
    public static final String imgPatternNoSrcColon = "\\<img[\\s:]+([^>]+)/?\\>";
    public static final String fontFamilyPattern = "\\<font[\\s:]+([^>]+)/?\\>";
    public static final String svgAttributePattern = "\\<text[\\s:]+([^>]+)/?\\>";
    public static final String spritePattern = "\\<\\$[\\p{L}0-9_]+\\>";
    public static final String spritePattern2 = "\\<\\$([\\p{L}0-9_]+)\\>";
    static final String htmlTag;
    static final String linkPattern = "\\[\\[([^\\[\\]]+)\\]\\]";
    private static final Pattern tagOrText;
    private final List<String> splitted = new ArrayList<String>();

    public Splitter(String string) {
        Matcher matcher = tagOrText.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(0);
            string2 = StringUtils.showComparatorCharacters(string2);
            this.splitted.add(string2);
        }
    }

    List<String> getSplittedInternal() {
        return this.splitted;
    }

    public List<HtmlCommand> getHtmlCommands(boolean bl) {
        HtmlCommandFactory htmlCommandFactory = new HtmlCommandFactory();
        ArrayList<HtmlCommand> arrayList = new ArrayList<HtmlCommand>();
        for (String string : this.getSplittedInternal()) {
            HtmlCommand htmlCommand = htmlCommandFactory.getHtmlCommand(string);
            if (bl && htmlCommand instanceof Text) {
                arrayList.addAll(this.splitText((Text)htmlCommand));
                continue;
            }
            arrayList.add(htmlCommand);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Collection<Text> splitText(Text text) {
        String string = text.getText();
        ArrayList<Text> arrayList = new ArrayList<Text>();
        while (true) {
            int n;
            if ((n = string.indexOf(Text.NEWLINE.getText())) == -1) {
                arrayList.add(new Text(string));
                return arrayList;
            }
            if (n > 0) {
                arrayList.add(new Text(string.substring(0, n)));
            }
            arrayList.add(Text.NEWLINE);
            string = string.substring(n + 2);
        }
    }

    static {
        StringBuilder stringBuilder = new StringBuilder("(?i)");
        for (FontStyle fontStyle : EnumSet.allOf(FontStyle.class)) {
            if (fontStyle == FontStyle.PLAIN) continue;
            stringBuilder.append(fontStyle.getActivationPattern());
            stringBuilder.append('|');
            stringBuilder.append(fontStyle.getDeactivationPattern());
            stringBuilder.append('|');
        }
        stringBuilder.append(fontPattern);
        stringBuilder.append('|');
        stringBuilder.append(fontColorPattern2);
        stringBuilder.append('|');
        stringBuilder.append(fontSizePattern2);
        stringBuilder.append('|');
        stringBuilder.append(fontSup);
        stringBuilder.append('|');
        stringBuilder.append(fontSub);
        stringBuilder.append('|');
        stringBuilder.append(endFontPattern);
        stringBuilder.append('|');
        stringBuilder.append(endSupSub);
        stringBuilder.append('|');
        stringBuilder.append(imgPattern);
        stringBuilder.append('|');
        stringBuilder.append(imgPatternNoSrcColon);
        stringBuilder.append('|');
        stringBuilder.append(fontFamilyPattern);
        stringBuilder.append('|');
        stringBuilder.append(spritePattern);
        stringBuilder.append('|');
        stringBuilder.append(linkPattern);
        stringBuilder.append('|');
        stringBuilder.append(svgAttributePattern);
        htmlTag = stringBuilder.toString();
        tagOrText = MyPattern.cmpile(htmlTag + "|.+?(?=" + htmlTag + ")|.+$", 2);
    }
}

