#!/usr/bin/perl

use strict;
use warnings;
use 5.010;
use DBIx::SchemaChecksum;

my $sc = DBIx::SchemaChecksum->new_with_options();

my $pre_checksum = $sc->checksum;
say "Base checksum: $pre_checksum" if $sc->verbose;

$sc->build_update_path( );
$sc->apply_sql_snippets($pre_checksum);

__END__

=head1 NAME

schema_update.pl - Update a schema based on checksums and sql snippets


=head1 SYNOPSIS

    schema_update.pl --dsn dbi:Pg:dbname=your_db;host=db.example.org  --sqlsnippetdir path/to/sql/snippets

=head1 DESCRIPTION

Please see C<perldoc DBIx::SchemaChecksum> for more information.

=head1 OPTIONS

See L<DBIx::SchemaChecksum> section C<Attributes generated by Moose>

=head1 AUTHOR

Thomas Klausner, C<< <domm at cpan.org> >>

=head1 COPYRIGHT & LICENSE

Copyright 2008 Thomas Klausner, revdev.at, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

