# Generated by default/object.tt
package Paws::Glue::BackfillError;
  use Moose;
  has Code => (is => 'ro', isa => 'Str');
  has Partitions => (is => 'ro', isa => 'ArrayRef[Paws::Glue::PartitionValueList]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::BackfillError

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::BackfillError object:

  $service_obj->Method(Att1 => { Code => $value, ..., Partitions => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::BackfillError object:

  $result = $service_obj->Method(...);
  $result->Att1->Code

=head1 DESCRIPTION

A list of errors that can occur when registering partition indexes for
an existing table.

These errors give the details about why an index registration failed
and provide a limited number of partitions in the response, so that you
can fix the partitions at fault and try registering the index again.
The most common set of errors that can occur are categorized as
follows:

=over

=item *

EncryptedPartitionError: The partitions are encrypted.

=item *

InvalidPartitionTypeDataError: The partition value doesn't match the
data type for that partition column.

=item *

MissingPartitionValueError: The partitions are encrypted.

=item *

UnsupportedPartitionCharacterError: Characters inside the partition
value are not supported. For example: U+0000 , U+0001, U+0002.

=item *

InternalError: Any error which does not belong to other error codes.

=back


=head1 ATTRIBUTES


=head2 Code => Str

The error code for an error that occurred when registering partition
indexes for an existing table.


=head2 Partitions => ArrayRef[L<Paws::Glue::PartitionValueList>]

A list of a limited number of partitions in the response.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

