#include "ntt_consts.h"
#include "params.h"

#define PADDING 0

const int16_t PQCLEAN_FALCONPADDED1024_AARCH64_qmvq[8] = {FALCON_Q, FALCON_QINV,
                                                          FALCON_MONT, FALCON_NINV_MONT,
                                                          FALCON_V, 0,
                                                          FALCON_MONT_BR, FALCON_NINV_MONT_BR
                                                         };

const int16_t PQCLEAN_FALCONPADDED1024_AARCH64_ntt_br[] = {
    PADDING,    -1479,    -5146,     4043,    -1305,      722,     5736,    -4134,
    3542,    -4821,     2639,     2319,    -1170,     -955,     -790,     1260,
    4388,     4632,    -5755,     2426,      334,     1428,     1696,  PADDING,
    2401,     2401,     2401,     2401,    -5101,    -5101,    -5101,    -5101,
    390,      390,      390,      390,    -3833,    -3833,    -3833,    -3833,
    354,      354,      354,      354,    -2912,    -2912,    -2912,    -2912,
    5012,     5012,     5012,     5012,     2859,     2859,     2859,     2859,
    442,      442,      442,      442,    -1067,    -1067,    -1067,    -1067,
    773,      773,      773,      773,     3778,     3778,     3778,     3778,
    4861,     4861,     4861,     4861,     5698,     5698,     5698,     5698,
    -2481,    -2481,    -2481,    -2481,    -1045,    -1045,    -1045,    -1045,
    49,     1263,     5915,     1483,    -2500,    -1489,    -1583,    -5942,
    1512,      350,    -1815,     5383,     5369,    -2057,    -3202,     4493,
    -2738,    -5868,    -5735,     2655,    -3009,     1693,      174,      723,
    -1975,    -3757,      347,     2925,    -3315,     -426,     1858,     4754,
    7,      845,     3154,     3285,      216,    -5526,      767,    -2213,
    3120,    -6086,    -3941,     3536,     3229,    -1706,     1282,     2021,
    3944,     5604,     2171,    -1265,    -2945,     2633,    -3232,     4855,
    -2941,    -5662,     3837,     3221,     4050,      844,     -980,     4590,
    1936,     3723,     5054,    -4360,       50,      769,    -3805,     4153,
    -6105,     5646,     3753,     5370,     4730,     3929,    -3572,    -2832,
    4099,    -5530,    -3480,     3007,     5349,     1406,     -293,    -3769,
    -567,     5289,     2595,     4273,    -5207,     5202,     -682,    -5082,
    -3504,    -2625,     -949,    -3201,     3014,     5086,    -1326,     2013,
    -3289,      729,     3241,     2881,     3284,    -5092,    -2089,  PADDING,
    1017,     1017,     1017,     1017,     1632,     1632,     1632,     1632,
    27,       27,       27,       27,    -3763,    -3763,    -3763,    -3763,
    1537,     1537,     1537,     1537,     4714,     4714,     4714,     4714,
    -2678,    -2678,    -2678,    -2678,     5019,     5019,     5019,     5019,
    -4885,    -4885,    -4885,    -4885,    -5084,    -5084,    -5084,    -5084,
    -3066,    -3066,    -3066,    -3066,    -1440,    -1440,    -1440,    -1440,
    242,      242,      242,      242,    -4143,    -4143,    -4143,    -4143,
    3704,     3704,     3704,     3704,     -545,     -545,     -545,     -545,
    3030,     4115,     2361,    -1843,     2908,      218,     3434,    -3529,
    3963,      576,     6142,    -2447,     1954,    -2051,    -2882,    -1805,
    3991,    -3969,    -2767,      156,     2281,     5876,    -2031,     5333,
    3772,      418,     5908,     -453,     5429,    -4774,    -4737,     1293,
    -3469,    -4443,     4693,    -2293,     1802,     5103,    -4411,     1223,
    -1280,      -24,     -904,    -5547,      881,     1015,     5461,     2637,
    4684,    -5135,    -4987,     3670,      578,     -450,    -4661,    -2622,
    5618,     5789,     5043,     3090,     3065,    -5703,    -5900,    -4719,
    6138,    -3418,     2338,     -417,     1555,    -1891,    -1590,    -2334,
    614,    -1371,    -2485,    -5039,     -365,    -1927,    -2946,    -4510,
    3360,       63,     2373,     3808,     5368,     1944,     -510,    -5386,
    -1658,     3502,      826,     1398,     1506,     4483,      910,     -751,
    -2545,     -563,    -2975,     4846,    -2747,    -3135,     3712,    -3694,
    -5179,    -1759,    -3707,     3382,     -355,    -2548,    -4231,  PADDING,
    1002,     1002,     1002,     1002,     5088,     5088,     5088,     5088,
    -4976,    -4976,    -4976,    -4976,    -3780,    -3780,    -3780,    -3780,
    -2437,    -2437,    -2437,    -2437,     6022,     6022,     6022,     6022,
    -2566,    -2566,    -2566,    -2566,    -6039,    -6039,    -6039,    -6039,
    5011,     5011,     5011,     5011,    -4284,    -4284,    -4284,    -4284,
    -1607,    -1607,    -1607,    -1607,     -875,     -875,     -875,     -875,
    3646,     3646,     3646,     3646,     2987,     2987,     2987,     2987,
    -2187,    -2187,    -2187,    -2187,    -2422,    -2422,    -2422,    -2422,
    295,     6099,     5766,      652,    -4016,     4077,    -3762,    -2919,
    325,    -1404,    -1146,     -948,     5990,     1159,    -3728,    -4049,
    3329,     4298,     -168,     2692,     5961,    -5106,    -1962,     1594,
    -6122,    -2555,    -5184,    -1200,     1360,     3956,    -6119,     5297,
    4518,     1160,     2730,    -2253,     2478,     4194,    -1783,    -4565,
    -5170,     -865,      189,    -1763,    -1530,    -3869,     5832,    -1734,
    -5275,    -1251,     2035,    -1882,    -4770,     5287,    -5673,    -5406,
    4834,    -2828,    -4113,     3840,     3451,    -1241,    -5781,    -2643,
    3094,     4820,     5411,     1868,    -2840,     3019,    -5078,     4974,
    2672,     1279,     3116,     2209,     1694,    -4423,     1350,    -3815,
    -1790,    -5410,     1040,    -6125,      944,    -3669,    -3020,    -4665,
    2712,     4352,       72,    -1842,    -4094,     4378,    -3045,     1095,
    3621,    -3006,    -2744,     4805,    -3553,    -1062,    -2294,     3637,
    3459,      145,    -5542,    -2731,    -3932,    -4890,    -5911,  PADDING,
    -1065,    -1065,    -1065,    -1065,     -404,     -404,     -404,     -404,
    1168,     1168,     1168,     1168,    -1207,    -1207,    -1207,    -1207,
    493,      493,      493,      493,    -5444,    -5444,    -5444,    -5444,
    -4337,    -4337,    -4337,    -4337,     1378,     1378,     1378,     1378,
    2143,     2143,     2143,     2143,    -4645,    -4645,    -4645,    -4645,
    5277,     5277,     5277,     5277,     3248,     3248,     3248,     3248,
    -4096,    -4096,    -4096,    -4096,     2381,     2381,     2381,     2381,
    -435,     -435,     -435,     -435,     1912,     1912,     1912,     1912,
    -4079,    -1058,      922,      441,     1958,     4322,     1112,     2078,
    4046,      709,    -3150,     1319,     4240,    -3570,    -6065,     -835,
    2459,      683,     3656,      -64,    -1566,     5782,    -2948,    -2503,
    -3123,    -1747,    -3054,    -5486,    -4433,    -5919,     3834,    -5257,
    2873,     -791,    -1120,      -21,      874,      170,     2307,     -648,
    -1030,     3821,     4649,     2929,     1573,     3793,     -502,     2602,
    1849,    -3268,    -4301,      457,     -879,      982,     4218,    -3454,
    -4504,      530,     3578,    -3466,    -2046,    -2957,     3317,      139,
    2827,     2434,    -2535,    -5808,    -2301,    -5650,     4289,     -150,
    -466,     1681,     5969,     6026,    -3846,    -6063,     5118,    -1901,
    5776,     3795,    -4523,       -8,    -2593,    -2276,     4390,    -3758,
    778,     2626,     4697,     1701,     2940,    -1481,    -2532,     3332,
    -1646,     5728,    -4591,     3091,      -81,    -4320,    -1000,    -2842,
    480,     1022,        9,    -2468,      339,     5791,      544,  PADDING,
    2166,     2166,     2166,     2166,     -113,     -113,     -113,     -113,
    -160,     -160,     -160,     -160,       -3,       -3,       -3,       -3,
    3636,     3636,     3636,     3636,     5291,     5291,     5291,     5291,
    -1426,    -1426,    -1426,    -1426,     1663,     1663,     1663,     1663,
    3915,     3915,     3915,     3915,    -4919,    -4919,    -4919,    -4919,
    3149,     3149,     3149,     3149,     4437,     4437,     4437,     4437,
    4938,     4938,     4938,     4938,     2704,     2704,     2704,     2704,
    -4654,    -4654,    -4654,    -4654,    -1777,    -1777,    -1777,    -1777,
    -5241,    -2920,    -4169,    -3127,    -5468,     1010,    -3482,      787,
    5057,     4698,     4780,    -3445,     -192,     1321,     4912,    -2049,
    677,    -5874,    -6055,    -3336,     1323,    -2766,      -52,     3174,
    1579,     -431,    -2505,     5906,     3957,    -2839,      151,    -2127,
    343,     4538,    -5211,     1208,    -1705,     -416,      716,     2164,
    5412,    -3278,     3515,     1218,    -1536,     2429,     1373,      717,
    -3368,     4238,    -4222,     -540,     3163,     6127,     1389,     4404,
    3359,     5209,     3678,    -1928,     1826,     4489,     1136,     3708,
    -3448,    -1908,     1866,    -4727,     2450,      814,    -2110,    -5416,
    -4209,    -5993,     -438,     5061,    -1721,    -4103,    -2982,    -3589,
    4227,     -612,     1526,     -125,     4032,    -4840,    -2068,     -346,
    -3205,     1092,     4265,      464,     2926,    -3171,     3449,    -3238,
    1212,     5023,     5828,    -2963,    -4896,    -3051,     2366,    -1673,
    4278,    -5331,    -4989,    -4177,    -3584,     1381,    -2525,  PADDING,
    3364,     3364,     3364,     3364,     4057,     4057,     4057,     4057,
    -2847,    -2847,    -2847,    -2847,     2174,     2174,     2174,     2174,
    -5042,    -5042,    -5042,    -5042,     4053,     4053,     4053,     4053,
    5195,     5195,     5195,     5195,    -4895,    -4895,    -4895,    -4895,
    1689,     1689,     1689,     1689,    -3271,    -3271,    -3271,    -3271,
    -4414,    -4414,    -4414,    -4414,     4372,     4372,     4372,     4372,
    -2305,    -2305,    -2305,    -2305,     2645,     2645,     2645,     2645,
    -2780,    -2780,    -2780,    -2780,     1484,     1484,     1484,     1484,
    -58,     -241,     3532,    -1003,     1956,    -5009,     -885,    -6008,
    3477,    -5681,      142,    -1105,    -2844,     3438,     -975,     4212,
    -3029,    -5594,     4782,     5886,    -4213,      504,     2302,     -605,
    -421,    -4080,     3602,     6068,    -3600,     3263,     6077,    -4624,
    2065,     3495,    -3534,    -1756,     2275,     4267,     5063,    -1518,
    -1275,    -1176,     4860,    -1445,    -5987,      579,    -2769,    -5966,
    -3975,    -5835,     1417,    -4505,     3744,     2528,     5102,    -5588,
    4924,     1014,     1327,     3942,     2717,     3200,     5836,     2260,
    5826,     4564,     3961,     4145,     2461,     5653,    -4176,    -3765,
    5508,    -5734,     1125,    -1131,    -5596,     3889,     3114,      212,
    4883,     3087,     5676,     2257,     4963,    -3056,     -412,    -5845,
    4781,     -448,     3607,    -5232,       60,    -1535,    -4566,       68,
    3195,    -3328,    -5777,    -1177,    -4255,    -1635,    -2768,     -953,
    -3748,      827,     5767,     2476,      118,     2197,    -5067,  PADDING,
    -3247,    -3247,    -3247,    -3247,    -3978,    -3978,    -3978,    -3978,
    -2370,    -2370,    -2370,    -2370,     5332,     5332,     5332,     5332,
    1630,     1630,     1630,     1630,     5407,     5407,     5407,     5407,
    -1153,    -1153,    -1153,    -1153,    -2249,    -2249,    -2249,    -2249,
    -2686,    -2686,    -2686,    -2686,    -2969,    -2969,    -2969,    -2969,
    2865,     2865,     2865,     2865,     3510,     3510,     3510,     3510,
    -2126,    -2126,    -2126,    -2126,     3186,     3186,     3186,     3186,
    -2884,    -2884,    -2884,    -2884,    -4048,    -4048,    -4048,    -4048,
    -4467,    -4789,    -5537,     4749,     4449,    -5456,     -147,    -3789,
    6118,    -3818,     1190,    -2683,     3860,     5445,    -4536,    -1050,
    5079,    -3262,     2169,     -522,    -4324,     4916,    -4075,     5315,
    -1278,    -2344,     1973,    -5574,    -3514,    -1041,     5925,    -1018,
    180,    -4605,    -1409,      204,    -1468,    -3407,    -1344,    -2483,
    4739,    -5518,    -3028,     -364,    -1236,    -5246,     3121,     1057,
    -406,      146,     1403,     6094,     -239,      994,     4670,     5464,
    3375,    -3393,    -4913,     3825,    -2947,      636,     -622,     5672,
    4138,     2689,    -5219,     5509,    -3981,      463,    -3042,    -2054,
    -4251,     1226,     5216,    -2360,    -3017,     4475,     4705,    -2600,
    -1687,     5268,     1804,    -5189,    -2900,     4554,     -512,     4906,
    -2291,     4335,     3528,    -4235,    -3982,     5609,    -1737,     4499,
    5860,    -4978,     1351,     -140,    -1853,    -4611,     -726,     3949,
    -3296,     4452,     2396,    -4354,      130,     2837,    -5374,  PADDING,
    -2399,    -2399,    -2399,    -2399,    -5191,    -5191,    -5191,    -5191,
    -3000,    -3000,    -3000,    -3000,     3016,     3016,     3016,     3016,
    -5559,    -5559,    -5559,    -5559,    -2178,    -2178,    -2178,    -2178,
    3985,     3985,     3985,     3985,     3531,     3531,     3531,     3531,
    -3400,    -3400,    -3400,    -3400,    -3136,    -3136,    -3136,    -3136,
    671,      671,      671,      671,      243,      243,      243,      243,
    420,      420,      420,      420,     1544,     1544,     1544,     1544,
    4905,     4905,     4905,     4905,      476,      476,      476,      476,
    654,     3565,     1702,     1987,    -5529,     5206,     3199,      -56,
    6136,    -5862,    -5415,    -3643,     4948,    -6137,      400,    -1728,
    5339,     5446,     3710,     6093,      468,    -3988,      316,     -382,
    -2033,    -3998,     3879,     1922,    -1359,    -5435,      973,    -1254,
    5598,    -1892,    -5724,    -1029,     5959,    -3959,     2442,     5115,
    -1314,     2894,    -5690,    -3947,     3343,     1522,      -20,     4608,
    4578,     -375,    -1836,    -2185,     6085,    -1038,    -2231,     2800,
    506,     1392,     3276,     2212,    -1942,     2575,     2776,    -5478,
    3344,    -3624,    -1325,    -1945,    -2148,     5797,     1248,     4939,
    1744,    -3654,    -2455,      338,    -4119,    -2151,     5002,     5163,
    377,     1620,     -425,     -392,    -4167,     -923,    -6092,      193,
    1255,     5784,    -3338,    -2674,    -3408,     1165,    -1178,     3511,
}; // 1024->1416

const int16_t PQCLEAN_FALCONPADDED1024_AARCH64_ntt_qinv_br[] = {
    PADDING,    -3943,   -13721,    10780,    -3479,     1925,    15294,   -11023,
    9444,   -12854,     7036,     6183,    -3119,    -2546,    -2106,     3359,
    11700,    12350,   -15345,     6468,      890,     3807,     4522,  PADDING,
    6402,     6402,     6402,     6402,   -13601,   -13601,   -13601,   -13601,
    1039,     1039,     1039,     1039,   -10220,   -10220,   -10220,   -10220,
    943,      943,      943,      943,    -7764,    -7764,    -7764,    -7764,
    13364,    13364,    13364,    13364,     7623,     7623,     7623,     7623,
    1178,     1178,     1178,     1178,    -2845,    -2845,    -2845,    -2845,
    2061,     2061,     2061,     2061,    10073,    10073,    10073,    10073,
    12961,    12961,    12961,    12961,    15193,    15193,    15193,    15193,
    -6615,    -6615,    -6615,    -6615,    -2786,    -2786,    -2786,    -2786,
    130,     3367,    15772,     3954,    -6666,    -3970,    -4220,   -15844,
    4031,      933,    -4839,    14353,    14316,    -5484,    -8537,    11980,
    -7300,   -15646,   -15292,     7079,    -8023,     4514,      463,     1927,
    -5266,   -10017,      925,     7799,    -8839,    -1135,     4954,    12676,
    18,     2253,     8409,     8759,      575,   -14734,     2045,    -5900,
    8319,   -16228,   -10508,     9428,     8609,    -4548,     3418,     5388,
    10516,    14942,     5788,    -3373,    -7852,     7020,    -8617,    12945,
    -7842,   -15097,    10231,     8588,    10799,     2250,    -2613,    12239,
    5162,     9927,    13476,   -11625,      133,     2050,   -10145,    11073,
    -16278,    15054,    10007,    14318,    12612,    10476,    -9524,    -7551,
    10929,   -14745,    -9279,     8018,    14262,     3749,     -781,   -10049,
    -1511,    14102,     6919,    11393,   -13884,    13870,    -1818,   -13550,
    -9343,    -6999,    -2530,    -8535,     8036,    13561,    -3535,     5367,
    -8769,     1943,     8641,     7682,     8756,   -13577,    -5570,  PADDING,
    2711,     2711,     2711,     2711,     4351,     4351,     4351,     4351,
    71,       71,       71,       71,   -10033,   -10033,   -10033,   -10033,
    4098,     4098,     4098,     4098,    12569,    12569,    12569,    12569,
    -7140,    -7140,    -7140,    -7140,    13382,    13382,    13382,    13382,
    -13025,   -13025,   -13025,   -13025,   -13556,   -13556,   -13556,   -13556,
    -8175,    -8175,    -8175,    -8175,    -3839,    -3839,    -3839,    -3839,
    645,      645,      645,      645,   -11047,   -11047,   -11047,   -11047,
    9876,     9876,     9876,     9876,    -1453,    -1453,    -1453,    -1453,
    8079,    10972,     6295,    -4914,     7754,      581,     9156,    -9409,
    10567,     1535,    16377,    -6524,     5210,    -5468,    -7684,    -4812,
    10641,   -10583,    -7378,      415,     6082,    15668,    -5415,    14220,
    10057,     1114,    15753,    -1207,    14476,   -12729,   -12630,     3447,
    -9249,   -11847,    12513,    -6114,     4804,    13606,   -11761,     3261,
    -3413,      -63,    -2410,   -14790,     2349,     2706,    14561,     7031,
    12489,   -13692,   -13297,     9785,     1541,    -1199,   -12428,    -6991,
    14980,    15436,    13446,     8239,     8172,   -15206,   -15732,   -12582,
    16366,    -9113,     6234,    -1111,     4146,    -5042,    -4239,    -6223,
    1637,    -3655,    -6626,   -13436,     -973,    -5138,    -7855,   -12025,
    8959,      167,     6327,    10153,    14313,     5183,    -1359,   -14361,
    -4420,     9337,     2202,     3727,     4015,    11953,     2426,    -2002,
    -6786,    -1501,    -7932,    12921,    -7324,    -8359,     9897,    -9849,
    -13809,    -4690,    -9884,     9017,     -946,    -6794,   -11281,  PADDING,
    2671,     2671,     2671,     2671,    13566,    13566,    13566,    13566,
    -13268,   -13268,   -13268,   -13268,   -10079,   -10079,   -10079,   -10079,
    -6498,    -6498,    -6498,    -6498,    16057,    16057,    16057,    16057,
    -6842,    -6842,    -6842,    -6842,   -16102,   -16102,   -16102,   -16102,
    13361,    13361,    13361,    13361,   -11423,   -11423,   -11423,   -11423,
    -4284,    -4284,    -4284,    -4284,    -2333,    -2333,    -2333,    -2333,
    9721,     9721,     9721,     9721,     7964,     7964,     7964,     7964,
    -5831,    -5831,    -5831,    -5831,    -6458,    -6458,    -6458,    -6458,
    786,    16262,    15374,     1738,   -10708,    10871,   -10031,    -7783,
    866,    -3743,    -3055,    -2527,    15972,     3090,    -9940,   -10796,
    8876,    11460,     -447,     7178,    15894,   -13614,    -5231,     4250,
    -16324,    -6812,   -13822,    -3199,     3626,    10548,   -16316,    14124,
    12047,     3093,     7279,    -6007,     6607,    11183,    -4754,   -12172,
    -13785,    -2306,      503,    -4700,    -4079,   -10316,    15550,    -4623,
    -14065,    -3335,     5426,    -5018,   -12718,    14097,   -15126,   -14414,
    12889,    -7540,   -10967,    10239,     9201,    -3309,   -15414,    -7047,
    8249,    12852,    14428,     4980,    -7572,     8050,   -13540,    13262,
    7124,     3410,     8308,     5890,     4516,   -11793,     3599,   -10172,
    -4772,   -14425,     2773,   -16332,     2517,    -9783,    -8052,   -12438,
    7231,    11604,      191,    -4911,   -10916,    11673,    -8119,     2919,
    9655,    -8015,    -7316,    12812,    -9473,    -2831,    -6116,     9697,
    9223,      386,   -14777,    -7282,   -10484,   -13038,   -15761,  PADDING,
    -2839,    -2839,    -2839,    -2839,    -1077,    -1077,    -1077,    -1077,
    3114,     3114,     3114,     3114,    -3218,    -3218,    -3218,    -3218,
    1314,     1314,     1314,     1314,   -14516,   -14516,   -14516,   -14516,
    -11564,   -11564,   -11564,   -11564,     3674,     3674,     3674,     3674,
    5714,     5714,     5714,     5714,   -12385,   -12385,   -12385,   -12385,
    14070,    14070,    14070,    14070,     8660,     8660,     8660,     8660,
    -10921,   -10921,   -10921,   -10921,     6348,     6348,     6348,     6348,
    -1159,    -1159,    -1159,    -1159,     5098,     5098,     5098,     5098,
    -10876,    -2821,     2458,     1175,     5220,    11524,     2965,     5540,
    10788,     1890,    -8399,     3517,    11305,    -9519,   -16172,    -2226,
    6556,     1821,     9748,     -170,    -4175,    15417,    -7860,    -6674,
    -8327,    -4658,    -8143,   -14628,   -11820,   -15782,    10223,   -14017,
    7660,    -2109,    -2986,      -55,     2330,      453,     6151,    -1727,
    -2746,    10188,    12396,     7810,     4194,    10113,    -1338,     6938,
    4930,    -8713,   -11468,     1218,    -2343,     2618,    11247,    -9209,
    -12009,     1413,     9540,    -9241,    -5455,    -7884,     8844,      370,
    7538,     6490,    -6759,   -15486,    -6135,   -15065,    11436,     -399,
    -1242,     4482,    15916,    16068,   -10255,   -16166,    13646,    -5068,
    15401,    10119,   -12060,      -21,    -6914,    -6068,    11705,   -10020,
    2074,     7002,    12524,     4535,     7839,    -3949,    -6751,     8884,
    -4388,    15273,   -12241,     8241,     -215,   -11519,    -2666,    -7578,
    1279,     2725,       23,    -6580,      903,    15441,     1450,  PADDING,
    5775,     5775,     5775,     5775,     -301,     -301,     -301,     -301,
    -426,     -426,     -426,     -426,       -7,       -7,       -7,       -7,
    9695,     9695,     9695,     9695,    14108,    14108,    14108,    14108,
    -3802,    -3802,    -3802,    -3802,     4434,     4434,     4434,     4434,
    10439,    10439,    10439,    10439,   -13116,   -13116,   -13116,   -13116,
    8396,     8396,     8396,     8396,    11831,    11831,    11831,    11831,
    13166,    13166,    13166,    13166,     7210,     7210,     7210,     7210,
    -12409,   -12409,   -12409,   -12409,    -4738,    -4738,    -4738,    -4738,
    -13974,    -7786,   -11116,    -8337,   -14580,     2693,    -9284,     2098,
    13484,    12526,    12745,    -9185,     -511,     3522,    13097,    -5463,
    1805,   -15662,   -16145,    -8895,     3527,    -7375,     -138,     8463,
    4210,    -1149,    -6679,    15748,    10551,    -7570,      402,    -5671,
    914,    12100,   -13894,     3221,    -4546,    -1109,     1909,     5770,
    14430,    -8740,     9372,     3247,    -4095,     6476,     3661,     1911,
    -8980,    11300,   -11257,    -1439,     8433,    16337,     3703,    11743,
    8956,    13889,     9807,    -5140,     4868,    11969,     3029,     9887,
    -9193,    -5087,     4975,   -12604,     6532,     2170,    -5626,   -14441,
    -11223,   -15980,    -1167,    13494,    -4588,   -10940,    -7951,    -9569,
    11271,    -1631,     4069,     -333,    10751,   -12905,    -5514,     -922,
    -8545,     2911,    11372,     1237,     7802,    -8455,     9196,    -8633,
    3231,    13393,    15540,    -7900,   -13054,    -8135,     6308,    -4460,
    11407,   -14214,   -13302,   -11137,    -9556,     3682,    -6732,  PADDING,
    8969,     8969,     8969,     8969,    10817,    10817,    10817,    10817,
    -7591,    -7591,    -7591,    -7591,     5796,     5796,     5796,     5796,
    -13444,   -13444,   -13444,   -13444,    10807,    10807,    10807,    10807,
    13852,    13852,    13852,    13852,   -13052,   -13052,   -13052,   -13052,
    4503,     4503,     4503,     4503,    -8721,    -8721,    -8721,    -8721,
    -11769,   -11769,   -11769,   -11769,    11657,    11657,    11657,    11657,
    -6146,    -6146,    -6146,    -6146,     7052,     7052,     7052,     7052,
    -7412,    -7412,    -7412,    -7412,     3957,     3957,     3957,     3957,
    -154,     -642,     9417,    -2674,     5215,   -13356,    -2359,   -16020,
    9271,   -15148,      378,    -2946,    -7583,     9167,    -2599,    11231,
    -8076,   -14916,    12750,    15694,   -11233,     1343,     6138,    -1613,
    -1122,   -10879,     9604,    16180,    -9599,     8700,    16204,   -12329,
    5506,     9319,    -9423,    -4682,     6066,    11377,    13500,    -4047,
    -3399,    -3135,    12958,    -3853,   -15964,     1543,    -7383,   -15908,
    -10599,   -15558,     3778,   -12012,     9983,     6740,    13604,   -14900,
    13129,     2703,     3538,    10511,     7244,     8532,    15561,     6026,
    15534,    12169,    10561,    11052,     6562,    15073,   -11135,   -10039,
    14686,   -15289,     2999,    -3015,   -14921,    10369,     8303,      565,
    13020,     8231,    15134,     6018,    13233,    -8148,    -1098,   -15585,
    12748,    -1194,     9617,   -13950,      159,    -4093,   -12175,      181,
    8519,    -8873,   -15404,    -3138,   -11345,    -4359,    -7380,    -2541,
    -9993,     2205,    15377,     6602,      314,     5858,   -13510,  PADDING,
    -8657,    -8657,    -8657,    -8657,   -10607,   -10607,   -10607,   -10607,
    -6319,    -6319,    -6319,    -6319,    14217,    14217,    14217,    14217,
    4346,     4346,     4346,     4346,    14417,    14417,    14417,    14417,
    -3074,    -3074,    -3074,    -3074,    -5996,    -5996,    -5996,    -5996,
    -7162,    -7162,    -7162,    -7162,    -7916,    -7916,    -7916,    -7916,
    7639,     7639,     7639,     7639,     9359,     9359,     9359,     9359,
    -5668,    -5668,    -5668,    -5668,     8495,     8495,     8495,     8495,
    -7690,    -7690,    -7690,    -7690,   -10793,   -10793,   -10793,   -10793,
    -11911,   -12769,   -14764,    12662,    11863,   -14548,     -391,   -10103,
    16313,   -10180,     3173,    -7154,    10292,    14518,   -12095,    -2799,
    13542,    -8697,     5783,    -1391,   -11529,    13108,   -10865,    14172,
    -3407,    -6250,     5260,   -14862,    -9369,    -2775,    15798,    -2714,
    479,   -12279,    -3757,      543,    -3914,    -9084,    -3583,    -6620,
    12636,   -14713,    -8074,     -970,    -3295,   -13988,     8321,     2818,
    -1082,      389,     3741,    16249,     -637,     2650,    12452,    14569,
    8999,    -9047,   -13100,    10199,    -7858,     1695,    -1658,    15124,
    11033,     7170,   -13916,    14689,   -10615,     1234,    -8111,    -5476,
    -11335,     3269,    13908,    -6292,    -8044,    11932,    12545,    -6932,
    -4498,    14046,     4810,   -13836,    -7732,    12143,    -1365,    13081,
    -6108,    11559,     9407,   -11292,   -10617,    14956,    -4631,    11996,
    15625,   -13273,     3602,     -373,    -4940,   -12294,    -1935,    10529,
    -8788,    11871,     6388,   -11609,      346,     7564,   -14329,  PADDING,
    -6396,    -6396,    -6396,    -6396,   -13841,   -13841,   -13841,   -13841,
    -7999,    -7999,    -7999,    -7999,     8042,     8042,     8042,     8042,
    -14822,   -14822,   -14822,   -14822,    -5807,    -5807,    -5807,    -5807,
    10625,    10625,    10625,    10625,     9415,     9415,     9415,     9415,
    -9065,    -9065,    -9065,    -9065,    -8361,    -8361,    -8361,    -8361,
    1789,     1789,     1789,     1789,      647,      647,      647,      647,
    1119,     1119,     1119,     1119,     4116,     4116,     4116,     4116,
    13078,    13078,    13078,    13078,     1269,     1269,     1269,     1269,
    1743,     9505,     4538,     5298,   -14742,    13881,     8529,     -149,
    16361,   -15630,   -14438,    -9713,    13193,   -16364,     1066,    -4607,
    14236,    14521,     9892,    16246,     1247,   -10633,      842,    -1018,
    -5420,   -10660,    10343,     5124,    -3623,   -14492,     2594,    -3343,
    14926,    -5044,   -15262,    -2743,    15889,   -10556,     6511,    13638,
    -3503,     7716,   -15172,   -10524,     8913,     4058,      -53,    12287,
    12207,     -999,    -4895,    -5826,    16225,    -2767,    -5948,     7466,
    1349,     3711,     8735,     5898,    -5178,     6866,     7402,   -14606,
    8916,    -9663,    -3533,    -5186,    -5727,    15457,     3327,    13169,
    4650,    -9743,    -6546,      901,   -10983,    -5735,    13337,    13766,
    1005,     4319,    -1133,    -1045,   -11111,    -2461,   -16244,      514,
    3346,    15422,    -8900,    -7130,    -9087,     3106,    -3141,     9361,
}; // 1416

const int16_t PQCLEAN_FALCONPADDED1024_AARCH64_invntt_br[] = {
    -3511,     1178,    -1165,     3408,     2674,     3338,    -5784,    -1255,
    -193,     6092,      923,     4167,      392,      425,    -1620,     -377,
    -5163,    -5002,     2151,     4119,     -338,     2455,     3654,    -1744,
    -4939,    -1248,    -5797,     2148,     1945,     1325,     3624,    -3344,
    5478,    -2776,    -2575,     1942,    -2212,    -3276,    -1392,     -506,
    -2800,     2231,     1038,    -6085,     2185,     1836,      375,    -4578,
    -4608,       20,    -1522,    -3343,     3947,     5690,    -2894,     1314,
    -5115,    -2442,     3959,    -5959,     1029,     5724,     1892,    -5598,
    1254,     -973,     5435,     1359,    -1922,    -3879,     3998,     2033,
    382,     -316,     3988,     -468,    -6093,    -3710,    -5446,    -5339,
    1728,     -400,     6137,    -4948,     3643,     5415,     5862,    -6136,
    56,    -3199,    -5206,     5529,    -1987,    -1702,    -3565,     -654,
    -476,     -476,     -476,     -476,    -4905,    -4905,    -4905,    -4905,
    -1544,    -1544,    -1544,    -1544,     -420,     -420,     -420,     -420,
    -243,     -243,     -243,     -243,     -671,     -671,     -671,     -671,
    3136,     3136,     3136,     3136,     3400,     3400,     3400,     3400,
    -3531,    -3531,    -3531,    -3531,    -3985,    -3985,    -3985,    -3985,
    2178,     2178,     2178,     2178,     5559,     5559,     5559,     5559,
    -3016,    -3016,    -3016,    -3016,     3000,     3000,     3000,     3000,
    5191,     5191,     5191,     5191,     2399,     2399,     2399,     2399,
    5374,    -2837,     -130,     4354,    -2396,    -4452,     3296,    -3949,
    726,     4611,     1853,      140,    -1351,     4978,    -5860,  PADDING,
    -4499,     1737,    -5609,     3982,     4235,    -3528,    -4335,     2291,
    -4906,      512,    -4554,     2900,     5189,    -1804,    -5268,     1687,
    2600,    -4705,    -4475,     3017,     2360,    -5216,    -1226,     4251,
    2054,     3042,     -463,     3981,    -5509,     5219,    -2689,    -4138,
    -5672,      622,     -636,     2947,    -3825,     4913,     3393,    -3375,
    -5464,    -4670,     -994,      239,    -6094,    -1403,     -146,      406,
    -1057,    -3121,     5246,     1236,      364,     3028,     5518,    -4739,
    2483,     1344,     3407,     1468,     -204,     1409,     4605,     -180,
    1018,    -5925,     1041,     3514,     5574,    -1973,     2344,     1278,
    -5315,     4075,    -4916,     4324,      522,    -2169,     3262,    -5079,
    1050,     4536,    -5445,    -3860,     2683,    -1190,     3818,    -6118,
    3789,      147,     5456,    -4449,    -4749,     5537,     4789,     4467,
    4048,     4048,     4048,     4048,     2884,     2884,     2884,     2884,
    -3186,    -3186,    -3186,    -3186,     2126,     2126,     2126,     2126,
    -3510,    -3510,    -3510,    -3510,    -2865,    -2865,    -2865,    -2865,
    2969,     2969,     2969,     2969,     2686,     2686,     2686,     2686,
    2249,     2249,     2249,     2249,     1153,     1153,     1153,     1153,
    -5407,    -5407,    -5407,    -5407,    -1630,    -1630,    -1630,    -1630,
    -5332,    -5332,    -5332,    -5332,     2370,     2370,     2370,     2370,
    3978,     3978,     3978,     3978,     3247,     3247,     3247,     3247,
    5067,    -2197,     -118,    -2476,    -5767,     -827,     3748,      953,
    2768,     1635,     4255,     1177,     5777,     3328,    -3195,  PADDING,
    -68,     4566,     1535,      -60,     5232,    -3607,      448,    -4781,
    5845,      412,     3056,    -4963,    -2257,    -5676,    -3087,    -4883,
    -212,    -3114,    -3889,     5596,     1131,    -1125,     5734,    -5508,
    3765,     4176,    -5653,    -2461,    -4145,    -3961,    -4564,    -5826,
    -2260,    -5836,    -3200,    -2717,    -3942,    -1327,    -1014,    -4924,
    5588,    -5102,    -2528,    -3744,     4505,    -1417,     5835,     3975,
    5966,     2769,     -579,     5987,     1445,    -4860,     1176,     1275,
    1518,    -5063,    -4267,    -2275,     1756,     3534,    -3495,    -2065,
    4624,    -6077,    -3263,     3600,    -6068,    -3602,     4080,      421,
    605,    -2302,     -504,     4213,    -5886,    -4782,     5594,     3029,
    -4212,      975,    -3438,     2844,     1105,     -142,     5681,    -3477,
    6008,      885,     5009,    -1956,     1003,    -3532,      241,       58,
    -1484,    -1484,    -1484,    -1484,     2780,     2780,     2780,     2780,
    -2645,    -2645,    -2645,    -2645,     2305,     2305,     2305,     2305,
    -4372,    -4372,    -4372,    -4372,     4414,     4414,     4414,     4414,
    3271,     3271,     3271,     3271,    -1689,    -1689,    -1689,    -1689,
    4895,     4895,     4895,     4895,    -5195,    -5195,    -5195,    -5195,
    -4053,    -4053,    -4053,    -4053,     5042,     5042,     5042,     5042,
    -2174,    -2174,    -2174,    -2174,     2847,     2847,     2847,     2847,
    -4057,    -4057,    -4057,    -4057,    -3364,    -3364,    -3364,    -3364,
    2525,    -1381,     3584,     4177,     4989,     5331,    -4278,     1673,
    -2366,     3051,     4896,     2963,    -5828,    -5023,    -1212,  PADDING,
    3238,    -3449,     3171,    -2926,     -464,    -4265,    -1092,     3205,
    346,     2068,     4840,    -4032,      125,    -1526,      612,    -4227,
    3589,     2982,     4103,     1721,    -5061,      438,     5993,     4209,
    5416,     2110,     -814,    -2450,     4727,    -1866,     1908,     3448,
    -3708,    -1136,    -4489,    -1826,     1928,    -3678,    -5209,    -3359,
    -4404,    -1389,    -6127,    -3163,      540,     4222,    -4238,     3368,
    -717,    -1373,    -2429,     1536,    -1218,    -3515,     3278,    -5412,
    -2164,     -716,      416,     1705,    -1208,     5211,    -4538,     -343,
    2127,     -151,     2839,    -3957,    -5906,     2505,      431,    -1579,
    -3174,       52,     2766,    -1323,     3336,     6055,     5874,     -677,
    2049,    -4912,    -1321,      192,     3445,    -4780,    -4698,    -5057,
    -787,     3482,    -1010,     5468,     3127,     4169,     2920,     5241,
    1777,     1777,     1777,     1777,     4654,     4654,     4654,     4654,
    -2704,    -2704,    -2704,    -2704,    -4938,    -4938,    -4938,    -4938,
    -4437,    -4437,    -4437,    -4437,    -3149,    -3149,    -3149,    -3149,
    4919,     4919,     4919,     4919,    -3915,    -3915,    -3915,    -3915,
    -1663,    -1663,    -1663,    -1663,     1426,     1426,     1426,     1426,
    -5291,    -5291,    -5291,    -5291,    -3636,    -3636,    -3636,    -3636,
    3,        3,        3,        3,      160,      160,      160,      160,
    113,      113,      113,      113,    -2166,    -2166,    -2166,    -2166,
    -544,    -5791,     -339,     2468,       -9,    -1022,     -480,     2842,
    1000,     4320,       81,    -3091,     4591,    -5728,     1646,  PADDING,
    -3332,     2532,     1481,    -2940,    -1701,    -4697,    -2626,     -778,
    3758,    -4390,     2276,     2593,        8,     4523,    -3795,    -5776,
    1901,    -5118,     6063,     3846,    -6026,    -5969,    -1681,      466,
    150,    -4289,     5650,     2301,     5808,     2535,    -2434,    -2827,
    -139,    -3317,     2957,     2046,     3466,    -3578,     -530,     4504,
    3454,    -4218,     -982,      879,     -457,     4301,     3268,    -1849,
    -2602,      502,    -3793,    -1573,    -2929,    -4649,    -3821,     1030,
    648,    -2307,     -170,     -874,       21,     1120,      791,    -2873,
    5257,    -3834,     5919,     4433,     5486,     3054,     1747,     3123,
    2503,     2948,    -5782,     1566,       64,    -3656,     -683,    -2459,
    835,     6065,     3570,    -4240,    -1319,     3150,     -709,    -4046,
    -2078,    -1112,    -4322,    -1958,     -441,     -922,     1058,     4079,
    -1912,    -1912,    -1912,    -1912,      435,      435,      435,      435,
    -2381,    -2381,    -2381,    -2381,     4096,     4096,     4096,     4096,
    -3248,    -3248,    -3248,    -3248,    -5277,    -5277,    -5277,    -5277,
    4645,     4645,     4645,     4645,    -2143,    -2143,    -2143,    -2143,
    -1378,    -1378,    -1378,    -1378,     4337,     4337,     4337,     4337,
    5444,     5444,     5444,     5444,     -493,     -493,     -493,     -493,
    1207,     1207,     1207,     1207,    -1168,    -1168,    -1168,    -1168,
    404,      404,      404,      404,     1065,     1065,     1065,     1065,
    5911,     4890,     3932,     2731,     5542,     -145,    -3459,    -3637,
    2294,     1062,     3553,    -4805,     2744,     3006,    -3621,  PADDING,
    -1095,     3045,    -4378,     4094,     1842,      -72,    -4352,    -2712,
    4665,     3020,     3669,     -944,     6125,    -1040,     5410,     1790,
    3815,    -1350,     4423,    -1694,    -2209,    -3116,    -1279,    -2672,
    -4974,     5078,    -3019,     2840,    -1868,    -5411,    -4820,    -3094,
    2643,     5781,     1241,    -3451,    -3840,     4113,     2828,    -4834,
    5406,     5673,    -5287,     4770,     1882,    -2035,     1251,     5275,
    1734,    -5832,     3869,     1530,     1763,     -189,      865,     5170,
    4565,     1783,    -4194,    -2478,     2253,    -2730,    -1160,    -4518,
    -5297,     6119,    -3956,    -1360,     1200,     5184,     2555,     6122,
    -1594,     1962,     5106,    -5961,    -2692,      168,    -4298,    -3329,
    4049,     3728,    -1159,    -5990,      948,     1146,     1404,     -325,
    2919,     3762,    -4077,     4016,     -652,    -5766,    -6099,     -295,
    2422,     2422,     2422,     2422,     2187,     2187,     2187,     2187,
    -2987,    -2987,    -2987,    -2987,    -3646,    -3646,    -3646,    -3646,
    875,      875,      875,      875,     1607,     1607,     1607,     1607,
    4284,     4284,     4284,     4284,    -5011,    -5011,    -5011,    -5011,
    6039,     6039,     6039,     6039,     2566,     2566,     2566,     2566,
    -6022,    -6022,    -6022,    -6022,     2437,     2437,     2437,     2437,
    3780,     3780,     3780,     3780,     4976,     4976,     4976,     4976,
    -5088,    -5088,    -5088,    -5088,    -1002,    -1002,    -1002,    -1002,
    4231,     2548,      355,    -3382,     3707,     1759,     5179,     3694,
    -3712,     3135,     2747,    -4846,     2975,      563,     2545,  PADDING,
    751,     -910,    -4483,    -1506,    -1398,     -826,    -3502,     1658,
    5386,      510,    -1944,    -5368,    -3808,    -2373,      -63,    -3360,
    4510,     2946,     1927,      365,     5039,     2485,     1371,     -614,
    2334,     1590,     1891,    -1555,      417,    -2338,     3418,    -6138,
    4719,     5900,     5703,    -3065,    -3090,    -5043,    -5789,    -5618,
    2622,     4661,      450,     -578,    -3670,     4987,     5135,    -4684,
    -2637,    -5461,    -1015,     -881,     5547,      904,       24,     1280,
    -1223,     4411,    -5103,    -1802,     2293,    -4693,     4443,     3469,
    -1293,     4737,     4774,    -5429,      453,    -5908,     -418,    -3772,
    -5333,     2031,    -5876,    -2281,     -156,     2767,     3969,    -3991,
    1805,     2882,     2051,    -1954,     2447,    -6142,     -576,    -3963,
    3529,    -3434,     -218,    -2908,     1843,    -2361,    -4115,    -3030,
    545,      545,      545,      545,    -3704,    -3704,    -3704,    -3704,
    4143,     4143,     4143,     4143,     -242,     -242,     -242,     -242,
    1440,     1440,     1440,     1440,     3066,     3066,     3066,     3066,
    5084,     5084,     5084,     5084,     4885,     4885,     4885,     4885,
    -5019,    -5019,    -5019,    -5019,     2678,     2678,     2678,     2678,
    -4714,    -4714,    -4714,    -4714,    -1537,    -1537,    -1537,    -1537,
    3763,     3763,     3763,     3763,      -27,      -27,      -27,      -27,
    -1632,    -1632,    -1632,    -1632,    -1017,    -1017,    -1017,    -1017,
    2089,     5092,    -3284,    -2881,    -3241,     -729,     3289,    -2013,
    1326,    -5086,    -3014,     3201,      949,     2625,     3504,  PADDING,
    5082,      682,    -5202,     5207,    -4273,    -2595,    -5289,      567,
    3769,      293,    -1406,    -5349,    -3007,     3480,     5530,    -4099,
    2832,     3572,    -3929,    -4730,    -5370,    -3753,    -5646,     6105,
    -4153,     3805,     -769,      -50,     4360,    -5054,    -3723,    -1936,
    -4590,      980,     -844,    -4050,    -3221,    -3837,     5662,     2941,
    -4855,     3232,    -2633,     2945,     1265,    -2171,    -5604,    -3944,
    -2021,    -1282,     1706,    -3229,    -3536,     3941,     6086,    -3120,
    2213,     -767,     5526,     -216,    -3285,    -3154,     -845,       -7,
    -4754,    -1858,      426,     3315,    -2925,     -347,     3757,     1975,
    -723,     -174,    -1693,     3009,    -2655,     5735,     5868,     2738,
    -4493,     3202,     2057,    -5369,    -5383,     1815,     -350,    -1512,
    5942,     1583,     1489,     2500,    -1483,    -5915,    -1263,      -49,
    1045,     1045,     1045,     1045,     2481,     2481,     2481,     2481,
    -5698,    -5698,    -5698,    -5698,    -4861,    -4861,    -4861,    -4861,
    -3778,    -3778,    -3778,    -3778,     -773,     -773,     -773,     -773,
    1067,     1067,     1067,     1067,     -442,     -442,     -442,     -442,
    -2859,    -2859,    -2859,    -2859,    -5012,    -5012,    -5012,    -5012,
    2912,     2912,     2912,     2912,     -354,     -354,     -354,     -354,
    3833,     3833,     3833,     3833,     -390,     -390,     -390,     -390,
    5101,     5101,     5101,     5101,    -2401,    -2401,    -2401,    -2401,
    -1696,    -1428,     -334,    -2426,     5755,    -4632,    -4388,    -1260,
    790,      955,     1170,    -2319,    -2639,     4821,    -3542,  PADDING,
    4134,    -5736,     -722,     1305,    -4043,     5146,     1479,  PADDING, // dup
    4134,    -5736,     -722,     1305,    -4043,     5146,     6830,    12277, // ninv=1
}; // 1424

const int16_t PQCLEAN_FALCONPADDED1024_AARCH64_invntt_qinv_br[] = {
    -9361,     3141,    -3106,     9087,     7130,     8900,   -15422,    -3346,
    -514,    16244,     2461,    11111,     1045,     1133,    -4319,    -1005,
    -13766,   -13337,     5735,    10983,     -901,     6546,     9743,    -4650,
    -13169,    -3327,   -15457,     5727,     5186,     3533,     9663,    -8916,
    14606,    -7402,    -6866,     5178,    -5898,    -8735,    -3711,    -1349,
    -7466,     5948,     2767,   -16225,     5826,     4895,      999,   -12207,
    -12287,       53,    -4058,    -8913,    10524,    15172,    -7716,     3503,
    -13638,    -6511,    10556,   -15889,     2743,    15262,     5044,   -14926,
    3343,    -2594,    14492,     3623,    -5124,   -10343,    10660,     5420,
    1018,     -842,    10633,    -1247,   -16246,    -9892,   -14521,   -14236,
    4607,    -1066,    16364,   -13193,     9713,    14438,    15630,   -16361,
    149,    -8529,   -13881,    14742,    -5298,    -4538,    -9505,    -1743,
    -1269,    -1269,    -1269,    -1269,   -13078,   -13078,   -13078,   -13078,
    -4116,    -4116,    -4116,    -4116,    -1119,    -1119,    -1119,    -1119,
    -647,     -647,     -647,     -647,    -1789,    -1789,    -1789,    -1789,
    8361,     8361,     8361,     8361,     9065,     9065,     9065,     9065,
    -9415,    -9415,    -9415,    -9415,   -10625,   -10625,   -10625,   -10625,
    5807,     5807,     5807,     5807,    14822,    14822,    14822,    14822,
    -8042,    -8042,    -8042,    -8042,     7999,     7999,     7999,     7999,
    13841,    13841,    13841,    13841,     6396,     6396,     6396,     6396,
    14329,    -7564,     -346,    11609,    -6388,   -11871,     8788,   -10529,
    1935,    12294,     4940,      373,    -3602,    13273,   -15625,  PADDING,
    -11996,     4631,   -14956,    10617,    11292,    -9407,   -11559,     6108,
    -13081,     1365,   -12143,     7732,    13836,    -4810,   -14046,     4498,
    6932,   -12545,   -11932,     8044,     6292,   -13908,    -3269,    11335,
    5476,     8111,    -1234,    10615,   -14689,    13916,    -7170,   -11033,
    -15124,     1658,    -1695,     7858,   -10199,    13100,     9047,    -8999,
    -14569,   -12452,    -2650,      637,   -16249,    -3741,     -389,     1082,
    -2818,    -8321,    13988,     3295,      970,     8074,    14713,   -12636,
    6620,     3583,     9084,     3914,     -543,     3757,    12279,     -479,
    2714,   -15798,     2775,     9369,    14862,    -5260,     6250,     3407,
    -14172,    10865,   -13108,    11529,     1391,    -5783,     8697,   -13542,
    2799,    12095,   -14518,   -10292,     7154,    -3173,    10180,   -16313,
    10103,      391,    14548,   -11863,   -12662,    14764,    12769,    11911,
    10793,    10793,    10793,    10793,     7690,     7690,     7690,     7690,
    -8495,    -8495,    -8495,    -8495,     5668,     5668,     5668,     5668,
    -9359,    -9359,    -9359,    -9359,    -7639,    -7639,    -7639,    -7639,
    7916,     7916,     7916,     7916,     7162,     7162,     7162,     7162,
    5996,     5996,     5996,     5996,     3074,     3074,     3074,     3074,
    -14417,   -14417,   -14417,   -14417,    -4346,    -4346,    -4346,    -4346,
    -14217,   -14217,   -14217,   -14217,     6319,     6319,     6319,     6319,
    10607,    10607,    10607,    10607,     8657,     8657,     8657,     8657,
    13510,    -5858,     -314,    -6602,   -15377,    -2205,     9993,     2541,
    7380,     4359,    11345,     3138,    15404,     8873,    -8519,  PADDING,
    -181,    12175,     4093,     -159,    13950,    -9617,     1194,   -12748,
    15585,     1098,     8148,   -13233,    -6018,   -15134,    -8231,   -13020,
    -565,    -8303,   -10369,    14921,     3015,    -2999,    15289,   -14686,
    10039,    11135,   -15073,    -6562,   -11052,   -10561,   -12169,   -15534,
    -6026,   -15561,    -8532,    -7244,   -10511,    -3538,    -2703,   -13129,
    14900,   -13604,    -6740,    -9983,    12012,    -3778,    15558,    10599,
    15908,     7383,    -1543,    15964,     3853,   -12958,     3135,     3399,
    4047,   -13500,   -11377,    -6066,     4682,     9423,    -9319,    -5506,
    12329,   -16204,    -8700,     9599,   -16180,    -9604,    10879,     1122,
    1613,    -6138,    -1343,    11233,   -15694,   -12750,    14916,     8076,
    -11231,     2599,    -9167,     7583,     2946,     -378,    15148,    -9271,
    16020,     2359,    13356,    -5215,     2674,    -9417,      642,      154,
    -3957,    -3957,    -3957,    -3957,     7412,     7412,     7412,     7412,
    -7052,    -7052,    -7052,    -7052,     6146,     6146,     6146,     6146,
    -11657,   -11657,   -11657,   -11657,    11769,    11769,    11769,    11769,
    8721,     8721,     8721,     8721,    -4503,    -4503,    -4503,    -4503,
    13052,    13052,    13052,    13052,   -13852,   -13852,   -13852,   -13852,
    -10807,   -10807,   -10807,   -10807,    13444,    13444,    13444,    13444,
    -5796,    -5796,    -5796,    -5796,     7591,     7591,     7591,     7591,
    -10817,   -10817,   -10817,   -10817,    -8969,    -8969,    -8969,    -8969,
    6732,    -3682,     9556,    11137,    13302,    14214,   -11407,     4460,
    -6308,     8135,    13054,     7900,   -15540,   -13393,    -3231,  PADDING,
    8633,    -9196,     8455,    -7802,    -1237,   -11372,    -2911,     8545,
    922,     5514,    12905,   -10751,      333,    -4069,     1631,   -11271,
    9569,     7951,    10940,     4588,   -13494,     1167,    15980,    11223,
    14441,     5626,    -2170,    -6532,    12604,    -4975,     5087,     9193,
    -9887,    -3029,   -11969,    -4868,     5140,    -9807,   -13889,    -8956,
    -11743,    -3703,   -16337,    -8433,     1439,    11257,   -11300,     8980,
    -1911,    -3661,    -6476,     4095,    -3247,    -9372,     8740,   -14430,
    -5770,    -1909,     1109,     4546,    -3221,    13894,   -12100,     -914,
    5671,     -402,     7570,   -10551,   -15748,     6679,     1149,    -4210,
    -8463,      138,     7375,    -3527,     8895,    16145,    15662,    -1805,
    5463,   -13097,    -3522,      511,     9185,   -12745,   -12526,   -13484,
    -2098,     9284,    -2693,    14580,     8337,    11116,     7786,    13974,
    4738,     4738,     4738,     4738,    12409,    12409,    12409,    12409,
    -7210,    -7210,    -7210,    -7210,   -13166,   -13166,   -13166,   -13166,
    -11831,   -11831,   -11831,   -11831,    -8396,    -8396,    -8396,    -8396,
    13116,    13116,    13116,    13116,   -10439,   -10439,   -10439,   -10439,
    -4434,    -4434,    -4434,    -4434,     3802,     3802,     3802,     3802,
    -14108,   -14108,   -14108,   -14108,    -9695,    -9695,    -9695,    -9695,
    7,        7,        7,        7,      426,      426,      426,      426,
    301,      301,      301,      301,    -5775,    -5775,    -5775,    -5775,
    -1450,   -15441,     -903,     6580,      -23,    -2725,    -1279,     7578,
    2666,    11519,      215,    -8241,    12241,   -15273,     4388,  PADDING,
    -8884,     6751,     3949,    -7839,    -4535,   -12524,    -7002,    -2074,
    10020,   -11705,     6068,     6914,       21,    12060,   -10119,   -15401,
    5068,   -13646,    16166,    10255,   -16068,   -15916,    -4482,     1242,
    399,   -11436,    15065,     6135,    15486,     6759,    -6490,    -7538,
    -370,    -8844,     7884,     5455,     9241,    -9540,    -1413,    12009,
    9209,   -11247,    -2618,     2343,    -1218,    11468,     8713,    -4930,
    -6938,     1338,   -10113,    -4194,    -7810,   -12396,   -10188,     2746,
    1727,    -6151,     -453,    -2330,       55,     2986,     2109,    -7660,
    14017,   -10223,    15782,    11820,    14628,     8143,     4658,     8327,
    6674,     7860,   -15417,     4175,      170,    -9748,    -1821,    -6556,
    2226,    16172,     9519,   -11305,    -3517,     8399,    -1890,   -10788,
    -5540,    -2965,   -11524,    -5220,    -1175,    -2458,     2821,    10876,
    -5098,    -5098,    -5098,    -5098,     1159,     1159,     1159,     1159,
    -6348,    -6348,    -6348,    -6348,    10921,    10921,    10921,    10921,
    -8660,    -8660,    -8660,    -8660,   -14070,   -14070,   -14070,   -14070,
    12385,    12385,    12385,    12385,    -5714,    -5714,    -5714,    -5714,
    -3674,    -3674,    -3674,    -3674,    11564,    11564,    11564,    11564,
    14516,    14516,    14516,    14516,    -1314,    -1314,    -1314,    -1314,
    3218,     3218,     3218,     3218,    -3114,    -3114,    -3114,    -3114,
    1077,     1077,     1077,     1077,     2839,     2839,     2839,     2839,
    15761,    13038,    10484,     7282,    14777,     -386,    -9223,    -9697,
    6116,     2831,     9473,   -12812,     7316,     8015,    -9655,  PADDING,
    -2919,     8119,   -11673,    10916,     4911,     -191,   -11604,    -7231,
    12438,     8052,     9783,    -2517,    16332,    -2773,    14425,     4772,
    10172,    -3599,    11793,    -4516,    -5890,    -8308,    -3410,    -7124,
    -13262,    13540,    -8050,     7572,    -4980,   -14428,   -12852,    -8249,
    7047,    15414,     3309,    -9201,   -10239,    10967,     7540,   -12889,
    14414,    15126,   -14097,    12718,     5018,    -5426,     3335,    14065,
    4623,   -15550,    10316,     4079,     4700,     -503,     2306,    13785,
    12172,     4754,   -11183,    -6607,     6007,    -7279,    -3093,   -12047,
    -14124,    16316,   -10548,    -3626,     3199,    13822,     6812,    16324,
    -4250,     5231,    13614,   -15894,    -7178,      447,   -11460,    -8876,
    10796,     9940,    -3090,   -15972,     2527,     3055,     3743,     -866,
    7783,    10031,   -10871,    10708,    -1738,   -15374,   -16262,     -786,
    6458,     6458,     6458,     6458,     5831,     5831,     5831,     5831,
    -7964,    -7964,    -7964,    -7964,    -9721,    -9721,    -9721,    -9721,
    2333,     2333,     2333,     2333,     4284,     4284,     4284,     4284,
    11423,    11423,    11423,    11423,   -13361,   -13361,   -13361,   -13361,
    16102,    16102,    16102,    16102,     6842,     6842,     6842,     6842,
    -16057,   -16057,   -16057,   -16057,     6498,     6498,     6498,     6498,
    10079,    10079,    10079,    10079,    13268,    13268,    13268,    13268,
    -13566,   -13566,   -13566,   -13566,    -2671,    -2671,    -2671,    -2671,
    11281,     6794,      946,    -9017,     9884,     4690,    13809,     9849,
    -9897,     8359,     7324,   -12921,     7932,     1501,     6786,  PADDING,
    2002,    -2426,   -11953,    -4015,    -3727,    -2202,    -9337,     4420,
    14361,     1359,    -5183,   -14313,   -10153,    -6327,     -167,    -8959,
    12025,     7855,     5138,      973,    13436,     6626,     3655,    -1637,
    6223,     4239,     5042,    -4146,     1111,    -6234,     9113,   -16366,
    12582,    15732,    15206,    -8172,    -8239,   -13446,   -15436,   -14980,
    6991,    12428,     1199,    -1541,    -9785,    13297,    13692,   -12489,
    -7031,   -14561,    -2706,    -2349,    14790,     2410,       63,     3413,
    -3261,    11761,   -13606,    -4804,     6114,   -12513,    11847,     9249,
    -3447,    12630,    12729,   -14476,     1207,   -15753,    -1114,   -10057,
    -14220,     5415,   -15668,    -6082,     -415,     7378,    10583,   -10641,
    4812,     7684,     5468,    -5210,     6524,   -16377,    -1535,   -10567,
    9409,    -9156,     -581,    -7754,     4914,    -6295,   -10972,    -8079,
    1453,     1453,     1453,     1453,    -9876,    -9876,    -9876,    -9876,
    11047,    11047,    11047,    11047,     -645,     -645,     -645,     -645,
    3839,     3839,     3839,     3839,     8175,     8175,     8175,     8175,
    13556,    13556,    13556,    13556,    13025,    13025,    13025,    13025,
    -13382,   -13382,   -13382,   -13382,     7140,     7140,     7140,     7140,
    -12569,   -12569,   -12569,   -12569,    -4098,    -4098,    -4098,    -4098,
    10033,    10033,    10033,    10033,      -71,      -71,      -71,      -71,
    -4351,    -4351,    -4351,    -4351,    -2711,    -2711,    -2711,    -2711,
    5570,    13577,    -8756,    -7682,    -8641,    -1943,     8769,    -5367,
    3535,   -13561,    -8036,     8535,     2530,     6999,     9343,  PADDING,
    13550,     1818,   -13870,    13884,   -11393,    -6919,   -14102,     1511,
    10049,      781,    -3749,   -14262,    -8018,     9279,    14745,   -10929,
    7551,     9524,   -10476,   -12612,   -14318,   -10007,   -15054,    16278,
    -11073,    10145,    -2050,     -133,    11625,   -13476,    -9927,    -5162,
    -12239,     2613,    -2250,   -10799,    -8588,   -10231,    15097,     7842,
    -12945,     8617,    -7020,     7852,     3373,    -5788,   -14942,   -10516,
    -5388,    -3418,     4548,    -8609,    -9428,    10508,    16228,    -8319,
    5900,    -2045,    14734,     -575,    -8759,    -8409,    -2253,      -18,
    -12676,    -4954,     1135,     8839,    -7799,     -925,    10017,     5266,
    -1927,     -463,    -4514,     8023,    -7079,    15292,    15646,     7300,
    -11980,     8537,     5484,   -14316,   -14353,     4839,     -933,    -4031,
    15844,     4220,     3970,     6666,    -3954,   -15772,    -3367,     -130,
    2786,     2786,     2786,     2786,     6615,     6615,     6615,     6615,
    -15193,   -15193,   -15193,   -15193,   -12961,   -12961,   -12961,   -12961,
    -10073,   -10073,   -10073,   -10073,    -2061,    -2061,    -2061,    -2061,
    2845,     2845,     2845,     2845,    -1178,    -1178,    -1178,    -1178,
    -7623,    -7623,    -7623,    -7623,   -13364,   -13364,   -13364,   -13364,
    7764,     7764,     7764,     7764,     -943,     -943,     -943,     -943,
    10220,    10220,    10220,    10220,    -1039,    -1039,    -1039,    -1039,
    13601,    13601,    13601,    13601,    -6402,    -6402,    -6402,    -6402,
    -4522,    -3807,     -890,    -6468,    15345,   -12350,   -11700,    -3359,
    2106,     2546,     3119,    -6183,    -7036,    12854,    -9444,  PADDING,
    11023,   -15294,    -1925,     3479,   -10780,    13721,     3943,  PADDING, // dup
    11023,   -15294,    -1925,     3479,   -10780,    13721,     18211,   32736, // ninv=1
}; // 1424
