#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

Pernyataan Umum tentang Hak-Hak Asasi Manusia
Mukadimah
Menimbang bahwa pengakuan atas martabat alamiah dan hak-hak yang sama dan mutlak dari semua anggota keluarga manusia adalah dasar kemerdekaan, keadilan dan perdamaian di dunia,

Menimbang bahwa mengabaikan dan memandang rendah hak-hak asasi manusia telah mengakibatkan perbuatan-perbuatan bengis yang menimbulkan rasa kemarahan hati nurani umat manusia, dan terbentuknya suatu dunia tempat manusia akan mengecap kenikmatan kebebasan berbicara dan beragama serta kebebasan dari ketakutan dan kekurangan telah dinyatakan sebagai cita-cita tertinggi dari rakyat biasa,

Menimbang bahwa hak-hak asasi manusia perlu dilindungi oleh peraturan hukum supaya orang tidak akan terpaksa memilih pemberontakan sebagai usaha terakhir guna menentang kelaliman dan penindasan,

Menimbang bahwa pembangunan hubungan persahabatan antara negara-negara perlu digalakkan,

Menimbang bahwa bangsa-bangsa dari Perserikatan Bangsa-Bangsa sekali lagi telah menyatakan di dalam Piagam Perserikatan Bangsa-Bangsa kepercayaan mereka akan hak-hak dasar dari manusia, akan martabat dan nilai seseorang manusia dan akan hak-hak yang sama dari pria maupun wanita, dan telah bertekad untuk menggalakkan kemajuan sosial dan taraf hidup yang lebih baik di dalam kemerdekaan yang lebih luas,

Menimbang bahwa Negara-Negara Anggota telah berjanji untuk mencapai kemajuan dalam penghargaan dan penghormatan umum terhadap hak-hak asasi manusia dan kebebasan-kebebasan asasi, dengan bekerjasama dengan Perserikatan Bangsa-Bangsa,
Menimbang bahwa pengertian umum tentang hak-hak dan kebebasan-kebebasan tersebut sangat penting untuk pelaksanaan yang sungguh-sungguh dari janji ini, maka,

Majelis Umum dengan ini memproklamasikan

Pernyataan Umum tentang Hak-Hak Asasi Manusia

sebagai satu standar umum keberhasilan untuk semua bangsa dan semua negara, dengan tujuan agar setiap orang dan setiap badan dalam masyarakat dengan senantiasa mengingat Pernyataan ini, akan berusaha dengan jalan mengajar dan mendidik untuk menggalakkan penghargaan terhadap hak-hak dan kebebasan-kebebasan tersebut, dan dengan jalan tindakan-tindakan progresif yang bersifat nasional maupun internasional, menjamin pengakuan dan penghormatannya secara universal dan efektif, baik oleh bangsa-bangsa dari Negara-Negara Anggota sendiri maupun oleh bangsa-bangsa dari daerah-daerah yang berada di bawah kekuasaan hukum mereka.

Pasal 1
Semua orang dilahirkan merdeka dan mempunyai martabat dan hak-hak yang sama. Mereka dikaruniai akal dan hati nurani dan hendaknya bergaul satu sama lain dalam semangat persaudaraan.

Pasal 2
Setiap orang berhak atas semua hak dan kebebasan-kebebasan yang tercantum di dalam Pernyataan ini tanpa perkecualian apapun, seperti ras, warna kulit, jenis kelamin, bahasa, agama, politik atau pendapat yang berlainan, asal mula kebangsaan atau kemasyarakatan, hak milik, kelahiran ataupun kedudukan lain.

Di samping itu, tidak diperbolehkan melakukan perbedaan atas dasar kedudukan politik, hukum atau kedudukan internasional dari negara atau daerah dari mana seseorang berasal, baik dari negara yang merdeka, yang berbentuk wilayah-wilayah perwalian, jajahan atau yang berada di bawah batasan kedaulatan yang lain.

Pasal 3
Setiap orang berhak atas penghidupan, kebebasan dan keselamatan individu.

Pasal 4
Tidak seorang pun boleh diperbudak atau diperhambakan, perbudakan dan perdagangan budak dalam bentuk apapun mesti dilarang.

Pasal 5
Tidak seorang pun boleh disiksa atau diperlakukan secara kejam, memperoleh perlakuan atau dihukum secara tidak manusiawi atau direndahkan martabatnya.

Pasal 6
Setiap orang berhak atas pengakuan di depan hukum sebagai pribadi di mana saja ia berada.

Pasal 7
Semua orang sama di depan hukum dan berhak atas perlindungan hukum yang sama tanpa diskriminasi. Semua berhak atas perlindungan yang sama terhadap setiap bentuk diskriminasi yang bertentangan dengan Pernyataan ini dan terhadap segala hasutan yang mengarah pada diskriminasi semacam itu.

Pasal 8
Setiap orang berhak atas bantuan yang efektif dari pengadilan nasional yang kompeten untuk tindakan pelanggaran hak-hak dasar yang diberikan kepadanya oleh undang-undang dasar atau hukum.

Pasal 9
Tak seorang pun boleh ditangkap, ditahan atau dibuang dengan sewenang-wenang.

Pasal 10
Setiap orang, dalam persamaan yang penuh, berhak atas pengadilan yang adil dan terbuka oleh pengadilan yang bebas dan tidak memihak, dalam menetapkan hak dan kewajiban-kewajibannya serta dalam setiap tuntutan pidana yang dijatuhkan kepadanya.

Pasal 11
1. Setiap orang yang dituntut karena disangka melakukan suatu pelanggaran hukum dianggap tidak bersalah, sampai dibuktikan kesalahannya menurut hukum dalam suatu pengadilan yang terbuka, di mana dia memperoleh semua jaminan yang diperlukan untuk pembelaannya.

2. Tidak seorang pun boleh dipersalahkan melakukan pelanggaran hukum karena perbuatan atau kelalaian yang tidak merupakan suatu pelanggaran hukum menurut undang-undang nasional atau internasional, ketika perbuatan tersebut dilakukan. Juga tidak diperkenankan menjatuhkan hukuman lebih berat daripada hukuman yang seharusnya dikenakan ketika pelanggaran hukum itu dilakukan.

Pasal 12
Tidak seorang pun dapat diganggu dengan sewenang-wenang urusan pribadinya, keluarganya, rumah-tangganya atau hubungan surat-menyuratnya, juga tak diperkenankan pelanggaran atas kehormatannya dan nama baiknya. Setiap orang berhak mendapat perlindungan hukum terhadap gangguan atau pelanggaran seperti itu.

Pasal 13
1. Setiap orang berhak atas kebebasan bergerak dan berdiam di dalam batas-batas setiap negara.

2. Setiap orang berhak meninggalkan sesuatu negeri, termasuk negerinya sendiri, dan berhak kembali ke negerinya.

Pasal 14
1. Setiap orang berhak mencari dan menikmati suaka di negeri lain untuk melindungi diri dari pengejaran.

2. Hak ini tidak berlaku untuk kasus pengejaran yang benar-benar timbul karena kejahatan-kejahatan yang tak berhubungan dengan politik, atau karena perbuatan-perbuatan yang bertentangan dengan tujuan dan dasar Perserikatan Bangsa-Bangsa.

Pasal 15
1. Setiap orang berhak atas sesuatu kewarga-negaraan.

2. Tidak seorang pun dengan semena-mena dapat dicabut kewarga-negaraannya atau ditolak haknya untuk mengganti kewarga-negaraan.

Pasal 16
1. Pria dan wanita yang sudah dewasa, dengan tidak dibatasi kebangsaan, kewarga-negaraan atau agama, berhak untuk nikah dan untuk membentuk keluarga. Mereka mempunyai hak yang sama dalam soal perkawinan, di dalam masa perkawinan dan pada saat perceraian.
2. Perkawinan hanya dapat dilaksanakan berdasarkan pilihan bebas dan persetujuan penuh oleh kedua mempelai.

3. Keluarga adalah kesatuan alamiah dan fundamental dari masyarakat dan berhak mendapat perlindungan dari masyarakat dan Negara.

Pasal 17
1. Setiap orang berhak memiliki harta, baik sendiri maupun bersama-sama dengan orang lain.

2. Tak seorang pun boleh dirampas hartanya dengan semena-mena.

Pasal 18
Setiap orang berhak atas kebebasan pikiran, hati nurani dan agama; dalam hal ini termasuk kebebasan berganti agama atau kepercayaan, dan kebebasan untuk menyatakan agama atau kepercayaan dengan cara mengajarkannya, mempraktekkannya, melaksanakan ibadahnya dan mentaatinya, baik sendiri maupun bersama-sama dengan orang lain, di muka umum maupun sendiri.

Pasal 19
Setiap orang berhak atas kebebasan mempunyai dan mengeluarkan pendapat; dalam hak ini termasuk kebebasan memiliki pendapat tanpa gangguan, dan untuk mencari, menerima dan menyampaikan informasi dan buah pikiran melalui media apa saja dan dengan tidak memandang batas-batas (wilayah).

Pasal 20
1. Setiap orang mempunyai hak atas kebebasan berkumpul dan berserikat secara damai.

2. Tidak seorang pun boleh dipaksa untuk memasuki sesuatu perkumpulan.

Pasal 21
1. Setiap orang berhak turut serta dalam pemerintahan negerinya, secara langsung atau melalui wakil-wakil yang dipilih dengan bebas.

2. Setiap orang berhak atas kesempatan yang sama untuk diangkat dalam jabatan pemerintahan negerinya.

3. Kehendak rakyat harus menjadi dasar kekuasaan pemerintah; kehendak ini harus dinyatakan dalam pemilihan umum yang dilaksanakan secara berkala dan jujur dan yang dilakukan menurut hak pilih yang bersifat umum dan yang tidak membeda-bedakan, dan dengan pemungutan suara yang rahasia ataupun menurut cara-cara lain yang menjamin kebebasan memberikan suara.

Pasal 22
Setiap orang, sebagai anggota masyarakat, berhak atas jaminan sosial dan berhak melaksanakan dengan perantaraan usaha-usaha nasional dan kerjasama internasional, dan sesuai dengan organisasi serta sumber-sumber kekayaan dari setiap Negara, hak-hak ekonomi, sosial dan kebudayaan yang sangat diperlukan untuk martabat dan pertumbuhan bebas pribadinya.

Pasal 23
1. Setiap orang berhak atas pekerjaan, berhak dengan bebas memilih pekerjaan, berhak atas syarat-syarat perburuhan yang adil serta baik, dan berhak atas perlindungan dari pengangguran.

2. Setiap orang, tanpa diskriminasi, berhak atas pengupahan yang sama untuk pekerjaan yang sama.

3. Setiap orang yang melakukan pekerjaan berhak atas pengupahan yang adil dan baik yang menjamin kehidupannya dan keluarganya, suatu kehidupan yang pantas untuk manusia yang bermartabat, dan jika perlu ditambah dengan perlindungan sosial lainnya.

4. Setiap orang berhak mendirikan dan memasuki serikat-serikat pekerja untuk melindungi kepentingannya.

Pasal 24
Setiap orang berhak atas istirahat dan liburan, termasuk pembatasan-pembatasan jam kerja yang layak dan hari libur berkala, dengan menerima upah.

Pasal 25
1. Setiap orang berhak atas taraf hidup yang menjamin kesehatan dan kesejahteraan untuk dirinya dan keluarganya, termasuk pangan, pakaian, perumahan dan perawatan kesehatannya serta pelayanan sosial yang diperlukan, dan berhak atas jaminan pada saat menganggur, menderita sakit, cacat, menjadi janda, mencapai usia lanjut atau mengalami kekurangan mata pencarian yang lain karena keadaan yang berada di luar kekuasaannya.

2. Para ibu dan anak-anak berhak mendapat perawatan dan bantuan istimewa. Semua anak, baik yang dilahirkan di dalam maupun di luar perkawinan, harus mendapat perlindungan sosial yang sama.

Pasal 26
1. Setiap orang berhak mendapat pendidikan. Pendidikan harus gratis, setidak-tidaknya untuk tingkat sekolah rendah dan pendidikan dasar. Pendidikan rendah harus diwajibkan. Pendidikan teknik dan jurusan secara umum harus terbuka bagi semua orang, dan pengajaran tinggi harus secara adil dapat diakses oleh semua orang, berdasarkan kepantasan.

2. Pendidikan harus ditujukan ke arah perkembangan pribadi yang seluas-luasnya serta memperkokoh rasa penghargaan terhadap hak-hak manusia dan kebebasan asasi. Pendidikan harus menggalakkan saling pengertian, toleransi dan persahabatan di antara semua bangsa, kelompok ras maupun agama, serta harus memajukan kegiatan Perserikatan Bangsa-Bangsa dalam memelihara perdamaian.

3. Orang-tua mempunyai hak utama untuk memilih jenis pendidikan yang akan diberikan kepada anak-anak mereka.

Pasal 27
1. Setiap orang berhak untuk turut serta dengan bebas dalam kehidupan kebudayaan masyarakat, untuk mengecap kenikmatan kesenian dan berbagi dalam kemajuan ilmu pengetahuan dan manfaatnya.

2. Setiap orang berhak untuk memperoleh perlindungan atas kepentingan-kepentingan moril dan material yang diperoleh sebagai hasil dari sesuatu produksi ilmiah, kesusasteraan atau kesenian yang diciptakannya.

Pasal 28
Setiap orang berhak atas suatu tatanan sosial dan internasional di mana hak-hak dan kebebasan-kebebasan yang termaktub di dalam Pernyataan ini dapat dilaksanakan sepenuhnya.

Pasal 29
1. Setiap orang mempunyai kewajiban terhadap masyarakat tempat satu-satunya di mana ia memperoleh kesempatan untuk mengembangkan pribadinya dengan penuh dan leluasa.

2. Dalam menjalankan hak-hak dan kebebasan-kebebasannya, setiap orang harus tunduk hanya pada pembatasan-pembatasan yang ditetapkan oleh undang-undang dengan maksud semata-mata untuk menjamin pengakuan serta penghormatan yang layak terhadap hak-hak dan kebebasan-kebebasan orang lain, dan untuk memenuhi syarat-syarat yang adil dalam hal kesusilaan, ketertiban dan kesejahteraan umum dalam suatu masyarakat yang demokratis.

3. Hak-hak dan kebebasan-kebebasan ini dengan jalan bagaimana pun sekali-kali tidak boleh dilaksanakan bertentangan dengan tujuan dan dasar Perserikatan Bangsa-Bangsa.

Pasal 30
Tidak satu pun di dalam Pernyataan ini boleh ditafsirkan memberikan sesuatu Negara, kelompok ataupun seseorang, hak untuk terlibat di dalam kegiatan apa pun atau melakukan perbuatan yang bertujuan untuk merusak hak-hak dan kebebasan-kebebasan yang mana pun yang termaktub di dalam Pernyataan ini.



TEXT

#is(Text::Guess::Language->guess($text),'id','is id');

done_testing;
