use warnings;
use strict;
use utf8;
use FindBin '$Bin';
use Test::More;
my $builder = Test::More->builder;
binmode $builder->output,         ":utf8";
binmode $builder->failure_output, ":utf8";
binmode $builder->todo_output,    ":utf8";
binmode STDOUT, ":encoding(utf8)";
binmode STDERR, ":encoding(utf8)";
use HTML::Make;
my $warning;
$SIG{__WARN__} = sub {$warning = "@_"};
my $b = HTML::Make->new ('b', href => 'http://www.example.org');
ok ($warning, "got warning");
my $bout = $b->text ();
unlike ($bout, qr!href!, "did not add href to b element");
$warning = undef;
my $a = HTML::Make->new ('a', href => 'http://www.example.com');
ok (! $warning, "no warning with a element");
my $aout = $a->text ();
like ($aout, qr!href!, "Got href on a element");
done_testing ();
