/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.util.Format;

public class Stereographic
extends ProjectionImpl {
    private double latts;
    private double latt;
    private double lont;
    private double scale;
    private double sinlatt;
    private double coslatt;
    private double central_meridian;
    private boolean isNorth = false;
    private boolean isPolar = false;
    private double falseEasting;
    private double falseNorthing;
    private LatLonPointImpl origin;

    @Override
    public ProjectionImpl constructCopy() {
        return new Stereographic(this.getTangentLat(), this.getTangentLon(), this.getScale(), this.getFalseEasting(), this.getFalseNorthing());
    }

    public Stereographic() {
        this(90.0, -105.0, 1.0);
    }

    public Stereographic(double latt, double lont, double scale) {
        this(latt, lont, scale, 0.0, 0.0);
    }

    public Stereographic(double latt, double lont, double scale, double false_easting, double false_northing) {
        this.latt = Math.toRadians(latt);
        this.lont = Math.toRadians(lont);
        this.scale = scale * EARTH_RADIUS;
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.precalculate();
        this.origin = new LatLonPointImpl(latt, lont);
        this.addParameter("grid_mapping_name", "stereographic");
        this.addParameter("longitude_of_projection_origin", lont);
        this.addParameter("latitude_of_projection_origin", latt);
        this.addParameter("scale_factor_at_projection_origin", scale);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
    }

    public Stereographic(double lat_ts_deg, double latt_deg, double lont_deg, boolean north) {
        this.latts = Math.toRadians(lat_ts_deg);
        this.latt = Math.toRadians(latt_deg);
        this.lont = Math.toRadians(lont_deg);
        this.isPolar = true;
        this.isNorth = north;
        this.precalculate();
        this.origin = new LatLonPointImpl(latt_deg, lont_deg);
        double scaleFactor = lat_ts_deg == 90.0 || lat_ts_deg == -90.0 ? 1.0 : this.getScaleFactor(this.latts, north);
        this.scale = scaleFactor * EARTH_RADIUS;
        this.addParameter("grid_mapping_name", "polar_stereographic");
        this.addParameter("longitude_of_projection_origin", lont_deg);
        this.addParameter("latitude_of_projection_origin", latt_deg);
        this.addParameter("scale_factor_at_projection_origin", scaleFactor);
    }

    private double getScaleFactor(double lat_ts, boolean north) {
        double e = 0.081819191;
        double tf = 1.0;
        double mf = 1.0;
        double k0 = 1.0;
        double root = (1.0 + e * Math.sin(lat_ts)) / (1.0 - e * Math.sin(lat_ts));
        double power = e / 2.0;
        tf = north ? Math.tan(0.7853981633974483 - lat_ts / 2.0) * Math.pow(root, power) : Math.tan(0.7853981633974483 + lat_ts / 2.0) / Math.pow(root, power);
        mf = Math.cos(lat_ts) / Math.sqrt(1.0 - e * e * Math.pow(Math.sin(lat_ts), 2.0));
        k0 = mf * Math.sqrt(Math.pow(1.0 + e, 1.0 + e) * Math.pow(1.0 - e, 1.0 - e)) / (2.0 * tf);
        return Double.isNaN(k0) ? 1.0 : k0;
    }

    public static Stereographic factory(double latt, double lont, double latTrue) {
        double scale = (1.0 + Math.sin(Math.toRadians(latTrue))) / 2.0;
        return new Stereographic(latt, lont, scale);
    }

    private void precalculate() {
        this.sinlatt = Math.sin(this.latt);
        this.coslatt = Math.cos(this.latt);
    }

    public double getScale() {
        return this.scale / EARTH_RADIUS;
    }

    public void setScale(double scale) {
        this.scale = EARTH_RADIUS * scale;
    }

    public double getNaturalOriginLat() {
        return Math.toDegrees(this.latts);
    }

    public double getTangentLon() {
        return this.origin.getLongitude();
    }

    public void setTangentLon(double lon) {
        this.origin.setLongitude(lon);
        this.lont = Math.toRadians(lon);
    }

    public double getTangentLat() {
        return this.origin.getLatitude();
    }

    public void setTangentLat(double lat) {
        this.origin.setLatitude(lat);
        this.latt = Math.toRadians(lat);
        this.precalculate();
    }

    public double getCentralMeridian() {
        return this.central_meridian;
    }

    public void setCentralMeridian(double cm) {
        this.central_meridian = cm;
    }

    public boolean isNorth() {
        return this.isNorth;
    }

    public boolean isPolar() {
        return this.isPolar;
    }

    @Override
    public String paramsToString() {
        return " tangent " + this.origin.toString() + " scale: " + Format.d(this.getScale(), 6);
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    @Override
    public Object clone() {
        Stereographic cl = (Stereographic)super.clone();
        cl.origin = new LatLonPointImpl(this.getTangentLat(), this.getTangentLon());
        return cl;
    }

    @Override
    public boolean equals(Object proj) {
        if (!(proj instanceof Stereographic)) {
            return false;
        }
        Stereographic oo = (Stereographic)proj;
        return this.getScale() == oo.getScale() && this.getTangentLat() == oo.getTangentLat() && this.getTangentLon() == oo.getTangentLon() && this.defaultMapArea.equals(oo.defaultMapArea);
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double lat = Math.toRadians(fromLat);
        double lon = Math.toRadians(fromLon);
        if (Math.abs(lat + this.latt) <= 1.0E-6) {
            lat = -this.latt * 0.999999;
        }
        double sdlon = Math.sin(lon - this.lont);
        double cdlon = Math.cos(lon - this.lont);
        double sinlat = Math.sin(lat);
        double coslat = Math.cos(lat);
        double k = 2.0 * this.scale / (1.0 + this.sinlatt * sinlat + this.coslatt * coslat * cdlon);
        double toX = k * coslat * sdlon;
        double toY = k * (this.coslatt * sinlat - this.sinlatt * coslat * cdlon);
        result.setLocation(toX + this.falseEasting, toY + this.falseNorthing);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX() - this.falseEasting;
        double fromY = world.getY() - this.falseNorthing;
        double rho = Math.sqrt(fromX * fromX + fromY * fromY);
        double c = 2.0 * Math.atan2(rho, 2.0 * this.scale);
        double sinc = Math.sin(c);
        double cosc = Math.cos(c);
        double phi = Math.abs(rho) < 1.0E-6 ? this.latt : Math.asin(cosc * this.sinlatt + fromY * sinc * this.coslatt / rho);
        double toLat = Math.toDegrees(phi);
        double lam = Math.abs(fromX) < 1.0E-6 && Math.abs(fromY) < 1.0E-6 ? this.lont : (Math.abs(this.coslatt) < 1.0E-6 ? this.lont + Math.atan2(fromX, this.latt > 0.0 ? -fromY : fromY) : this.lont + Math.atan2(fromX * sinc, rho * this.coslatt * cosc - fromY * sinc * this.sinlatt));
        double toLon = Math.toDegrees(lam);
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[] resultXA = to[0];
        float[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            double lat = Math.toRadians(fromLat);
            double lon = Math.toRadians(fromLon);
            if (Math.abs(lat + this.latt) <= 1.0E-6) {
                lat = -this.latt * 0.999999;
            }
            double sdlon = Math.sin(lon - this.lont);
            double cdlon = Math.cos(lon - this.lont);
            double sinlat = Math.sin(lat);
            double coslat = Math.cos(lat);
            double k = 2.0 * this.scale / (1.0 + this.sinlatt * sinlat + this.coslatt * coslat * cdlon);
            double toX = k * coslat * sdlon;
            double toY = k * (this.coslatt * sinlat - this.sinlatt * coslat * cdlon);
            resultXA[i] = (float)(toX + this.falseEasting);
            resultYA[i] = (float)(toY + this.falseNorthing);
        }
        return to;
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        int cnt = from[0].length;
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[] toLatA = to[0];
        float[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = (double)fromXA[i] - this.falseEasting;
            double fromY = (double)fromYA[i] - this.falseNorthing;
            double rho = Math.sqrt(fromX * fromX + fromY * fromY);
            double c = 2.0 * Math.atan2(rho, 2.0 * this.scale);
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            double phi = Math.abs(rho) < 1.0E-6 ? this.latt : Math.asin(cosc * this.sinlatt + fromY * sinc * this.coslatt / rho);
            double toLat = Math.toDegrees(phi);
            double lam = Math.abs(fromX) < 1.0E-6 && Math.abs(fromY) < 1.0E-6 ? this.lont : (Math.abs(this.coslatt) < 1.0E-6 ? this.lont + Math.atan2(fromX, this.latt > 0.0 ? -fromY : fromY) : this.lont + Math.atan2(fromX * sinc, rho * this.coslatt * cosc - fromY * sinc * this.sinlatt));
            double toLon = Math.toDegrees(lam);
            toLatA[i] = (float)toLat;
            toLonA[i] = (float)toLon;
        }
        return to;
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[] resultXA = to[0];
        double[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            double lat = Math.toRadians(fromLat);
            double lon = Math.toRadians(fromLon);
            if (Math.abs(lat + this.latt) <= 1.0E-6) {
                lat = -this.latt * 0.999999;
            }
            double sdlon = Math.sin(lon - this.lont);
            double cdlon = Math.cos(lon - this.lont);
            double sinlat = Math.sin(lat);
            double coslat = Math.cos(lat);
            double k = 2.0 * this.scale / (1.0 + this.sinlatt * sinlat + this.coslatt * coslat * cdlon);
            double toX = k * coslat * sdlon;
            double toY = k * (this.coslatt * sinlat - this.sinlatt * coslat * cdlon);
            resultXA[i] = toX + this.falseEasting;
            resultYA[i] = toY + this.falseNorthing;
        }
        return to;
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        int cnt = from[0].length;
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[] toLatA = to[0];
        double[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = fromXA[i] - this.falseEasting;
            double fromY = fromYA[i] - this.falseNorthing;
            double rho = Math.sqrt(fromX * fromX + fromY * fromY);
            double c = 2.0 * Math.atan2(rho, 2.0 * this.scale);
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            double phi = Math.abs(rho) < 1.0E-6 ? this.latt : Math.asin(cosc * this.sinlatt + fromY * sinc * this.coslatt / rho);
            double toLat = Math.toDegrees(phi);
            double lam = Math.abs(fromX) < 1.0E-6 && Math.abs(fromY) < 1.0E-6 ? this.lont : (Math.abs(this.coslatt) < 1.0E-6 ? this.lont + Math.atan2(fromX, this.latt > 0.0 ? -fromY : fromY) : this.lont + Math.atan2(fromX * sinc, rho * this.coslatt * cosc - fromY * sinc * this.sinlatt));
            double toLon = Math.toDegrees(lam);
            toLatA[i] = toLat;
            toLonA[i] = toLon;
        }
        return to;
    }
}

