/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.TypeDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;

public final class DataTypeDescriptor
implements TypeDescriptor,
Formatable {
    private TypeDescriptorImpl typeDescriptor;
    private TypeId typeId;

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int n) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, true);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int n, int n2) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, true, n2);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int n, boolean bl) {
        TypeId typeId = TypeId.getBuiltInTypeId(n);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, bl);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int n, boolean bl, int n2) {
        TypeId typeId = TypeId.getBuiltInTypeId(n);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, bl, n2);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(String string) {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(string), true);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(String string, int n) {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(string), true, n);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String string) {
        return DataTypeDescriptor.getSQLDataTypeDescriptor(string, true);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String string, boolean bl) {
        TypeId typeId = TypeId.getSQLTypeForJavaType(string);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, bl);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String string, int n, int n2, boolean bl, int n3) {
        TypeId typeId = TypeId.getSQLTypeForJavaType(string);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, n, n2, bl, n3);
    }

    public DataTypeDescriptor() {
    }

    public DataTypeDescriptor(TypeId typeId, int n, int n2, boolean bl, int n3) {
        this.typeId = typeId;
        this.typeDescriptor = new TypeDescriptorImpl(typeId.getBaseTypeId(), n, n2, bl, n3);
    }

    public DataTypeDescriptor(TypeId typeId, boolean bl, int n) {
        this.typeId = typeId;
        this.typeDescriptor = new TypeDescriptorImpl(typeId.getBaseTypeId(), bl, n);
    }

    public DataTypeDescriptor(TypeId typeId, boolean bl) {
        this.typeId = typeId;
        this.typeDescriptor = new TypeDescriptorImpl(typeId.getBaseTypeId(), typeId.getMaximumPrecision(), typeId.getMaximumScale(), bl, typeId.getMaximumMaximumWidth());
    }

    public DataTypeDescriptor(DataTypeDescriptor dataTypeDescriptor, boolean bl) {
        this.typeId = dataTypeDescriptor.typeId;
        this.typeDescriptor = new TypeDescriptorImpl(dataTypeDescriptor.typeDescriptor, dataTypeDescriptor.getPrecision(), dataTypeDescriptor.getScale(), bl, dataTypeDescriptor.getMaximumWidth());
    }

    public DataTypeDescriptor(DataTypeDescriptor dataTypeDescriptor, int n, int n2, boolean bl, int n3) {
        this.typeId = dataTypeDescriptor.typeId;
        this.typeDescriptor = new TypeDescriptorImpl(dataTypeDescriptor.typeDescriptor, n, n2, bl, n3);
    }

    public DataTypeDescriptor(DataTypeDescriptor dataTypeDescriptor, boolean bl, int n) {
        this.typeId = dataTypeDescriptor.typeId;
        this.typeDescriptor = new TypeDescriptorImpl(dataTypeDescriptor.typeDescriptor, bl, n);
    }

    public DataTypeDescriptor(TypeDescriptorImpl typeDescriptorImpl, TypeId typeId) {
        this.typeDescriptor = typeDescriptorImpl;
        this.typeId = typeId;
    }

    public DataValueDescriptor normalize(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        if (dataValueDescriptor.isNull()) {
            if (!this.isNullable()) {
                throw StandardException.newException("23502", "");
            }
            if (dataValueDescriptor2 == null) {
                dataValueDescriptor2 = this.getNull();
            } else {
                dataValueDescriptor2.setToNull();
            }
        } else {
            if (dataValueDescriptor2 == null) {
                dataValueDescriptor2 = this.getNull();
            }
            int n = this.getJDBCTypeId();
            dataValueDescriptor2.normalize(this, dataValueDescriptor);
            if ((n == -1 || n == -4) && dataValueDescriptor.getClass() == dataValueDescriptor2.getClass()) {
                return dataValueDescriptor;
            }
        }
        return dataValueDescriptor2;
    }

    public DataTypeDescriptor getDominantType(DataTypeDescriptor dataTypeDescriptor, ClassFactory classFactory) throws StandardException {
        int n;
        DataTypeDescriptor dataTypeDescriptor2 = null;
        DataTypeDescriptor dataTypeDescriptor3 = null;
        int n2 = this.getPrecision();
        int n3 = this.getScale();
        TypeId typeId = this.getTypeId();
        TypeId typeId2 = dataTypeDescriptor.getTypeId();
        boolean bl = this.isNullable() || dataTypeDescriptor.isNullable();
        int n4 = n = this.getMaximumWidth() > dataTypeDescriptor.getMaximumWidth() ? this.getMaximumWidth() : dataTypeDescriptor.getMaximumWidth();
        if (typeId.systemBuiltIn() && typeId2.systemBuiltIn()) {
            TypeId typeId3;
            TypeId typeId4;
            if (typeId.typePrecedence() > typeId2.typePrecedence()) {
                dataTypeDescriptor2 = this;
                dataTypeDescriptor3 = dataTypeDescriptor;
                typeId4 = typeId;
                typeId3 = typeId2;
            } else {
                dataTypeDescriptor2 = dataTypeDescriptor;
                dataTypeDescriptor3 = this;
                typeId4 = typeId2;
                typeId3 = typeId;
            }
            if (typeId4.isRealTypeId() && !typeId3.isRealTypeId() && typeId3.isNumericTypeId()) {
                dataTypeDescriptor2 = DataTypeDescriptor.getBuiltInDataTypeDescriptor(8);
                typeId4 = TypeId.getBuiltInTypeId(8);
            }
            if (typeId4.isDecimalTypeId() && !typeId3.isStringTypeId()) {
                n2 = typeId4.getPrecision(this, dataTypeDescriptor);
                if (n2 > 31) {
                    n2 = 31;
                }
                n = (n3 = typeId4.getScale(this, dataTypeDescriptor)) > 0 ? n2 + 3 : n2 + 1;
            } else if (typeId.typePrecedence() != typeId2.typePrecedence()) {
                int n5;
                int n6;
                n2 = dataTypeDescriptor2.getPrecision();
                n3 = dataTypeDescriptor2.getScale();
                if (typeId3.isStringTypeId() && typeId4.isBitTypeId() && !typeId4.isLongConcatableTypeId()) {
                    if (typeId3.isLongConcatableTypeId()) {
                        n = n > 0x7FFFFFF ? Integer.MAX_VALUE : (n *= 16);
                    } else {
                        n6 = dataTypeDescriptor3.getMaximumWidth();
                        n5 = n6 > 0x7FFFFFF ? Integer.MAX_VALUE : 16 * n6;
                        int n7 = n = n >= n5 ? n : n5;
                    }
                }
                if (typeId3.isStringTypeId() && !typeId3.isLongConcatableTypeId() && typeId4.isDecimalTypeId()) {
                    n5 = dataTypeDescriptor3.getMaximumWidth();
                    n6 = n5 > 0x3FFFFFFE ? 0x7FFFFFFC : n5 * 2;
                    if (n2 < n6) {
                        n2 = n6;
                    }
                    if (n3 < n5) {
                        n3 = n5;
                    }
                    n = n2 + 3;
                }
            }
        } else {
            ClassInspector classInspector = classFactory.getClassInspector();
            TypeId typeId5 = typeId;
            TypeId typeId6 = typeId2;
            dataTypeDescriptor2 = classInspector.assignableTo(typeId5.getCorrespondingJavaTypeName(), typeId6.getCorrespondingJavaTypeName()) ? dataTypeDescriptor : this;
            n2 = dataTypeDescriptor2.getPrecision();
            n3 = dataTypeDescriptor2.getScale();
        }
        dataTypeDescriptor2 = new DataTypeDescriptor(dataTypeDescriptor2, n2, n3, bl, n);
        return dataTypeDescriptor2;
    }

    public boolean isExactTypeAndLengthMatch(DataTypeDescriptor dataTypeDescriptor) {
        TypeId typeId;
        if (this.getMaximumWidth() != dataTypeDescriptor.getMaximumWidth()) {
            return false;
        }
        if (this.getScale() != dataTypeDescriptor.getScale()) {
            return false;
        }
        if (this.getPrecision() != dataTypeDescriptor.getPrecision()) {
            return false;
        }
        TypeId typeId2 = this.getTypeId();
        return typeId2.equals(typeId = dataTypeDescriptor.getTypeId());
    }

    public int getMaximumWidth() {
        return this.typeDescriptor.getMaximumWidth();
    }

    public int getMaximumWidthInBytes() {
        return this.typeDescriptor.getMaximumWidthInBytes();
    }

    public TypeId getTypeId() {
        return this.typeId;
    }

    public DataValueDescriptor getNull() {
        return this.typeId.getNull();
    }

    public String getTypeName() {
        return this.typeId.getSQLTypeName();
    }

    public int getJDBCTypeId() {
        return this.typeId.getJDBCTypeId();
    }

    public int getPrecision() {
        return this.typeDescriptor.getPrecision();
    }

    public int getScale() {
        return this.typeDescriptor.getScale();
    }

    public boolean isNullable() {
        return this.typeDescriptor.isNullable();
    }

    public void setNullability(boolean bl) {
        this.typeDescriptor.setNullability(bl);
    }

    public boolean equals(Object object) {
        return this.typeDescriptor.equals(object);
    }

    public String getSQLstring() {
        return this.typeId.toParsableString(this);
    }

    public TypeDescriptorImpl getCatalogType() {
        return this.typeDescriptor;
    }

    public double estimatedMemoryUsage() {
        switch (this.typeId.getTypeFormatId()) {
            case 232: {
                return 10000.0;
            }
            case 27: {
                return (double)this.getMaximumWidth() / 8.0 + 0.5;
            }
            case 4: {
                return 4.0;
            }
            case 5: 
            case 13: 
            case 369: 
            case 370: {
                return 2.0 * (double)this.getMaximumWidth();
            }
            case 230: 
            case 362: {
                return 10000.0;
            }
            case 197: {
                return (double)this.getPrecision() * 0.415 + 1.5;
            }
            case 6: {
                return 8.0;
            }
            case 7: {
                return 4.0;
            }
            case 11: {
                return 8.0;
            }
            case 8: {
                return 4.0;
            }
            case 10: {
                return 2.0;
            }
            case 195: {
                return 1.0;
            }
            case 9: {
                return 12.0;
            }
            case 267: {
                if (this.typeId.userType()) {
                    return 256.0;
                }
            }
            case 35: 
            case 36: 
            case 40: {
                return 12.0;
            }
        }
        return 0.0;
    }

    public static boolean isJDBCTypeEquivalent(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (DataTypeDescriptor.isNumericType(n)) {
            if (DataTypeDescriptor.isNumericType(n2)) {
                return true;
            }
            return DataTypeDescriptor.isCharacterType(n2);
        }
        if (DataTypeDescriptor.isCharacterType(n)) {
            if (DataTypeDescriptor.isCharacterType(n2)) {
                return true;
            }
            if (DataTypeDescriptor.isNumericType(n2)) {
                return true;
            }
            switch (n2) {
                case 91: 
                case 92: 
                case 93: {
                    return true;
                }
            }
            return false;
        }
        if (DataTypeDescriptor.isBinaryType(n)) {
            return DataTypeDescriptor.isBinaryType(n2);
        }
        if (n == 91 || n == 92) {
            if (DataTypeDescriptor.isCharacterType(n2)) {
                return true;
            }
            return n2 == 93;
        }
        if (n == 93) {
            if (DataTypeDescriptor.isCharacterType(n2)) {
                return true;
            }
            return n2 == 91;
        }
        return false;
    }

    public static boolean isNumericType(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private static boolean isCharacterType(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static boolean isBinaryType(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.typeDescriptor.toString();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.typeId = (TypeId)objectInput.readObject();
        this.typeDescriptor = (TypeDescriptorImpl)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.typeId);
        objectOutput.writeObject(this.typeDescriptor);
    }

    public int getTypeFormatId() {
        return 259;
    }
}

