# Generated by default/object.tt
package Paws::SSM::OpsMetadata;
  use Moose;
  has CreationDate => (is => 'ro', isa => 'Str');
  has LastModifiedDate => (is => 'ro', isa => 'Str');
  has LastModifiedUser => (is => 'ro', isa => 'Str');
  has OpsMetadataArn => (is => 'ro', isa => 'Str');
  has ResourceId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSM::OpsMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSM::OpsMetadata object:

  $service_obj->Method(Att1 => { CreationDate => $value, ..., ResourceId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSM::OpsMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationDate

=head1 DESCRIPTION

Operational metadata for an application in Application Manager.

=head1 ATTRIBUTES


=head2 CreationDate => Str

The date the OpsMetadata objects was created.


=head2 LastModifiedDate => Str

The date the OpsMetadata object was last updated.


=head2 LastModifiedUser => Str

The user name who last updated the OpsMetadata object.


=head2 OpsMetadataArn => Str

The Amazon Resource Name (ARN) of the OpsMetadata Object or blob.


=head2 ResourceId => Str

The ID of the Application Manager application.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

