package WebService::Mattermost::V4::API::Resource::Role::View::ChannelMember;

# ABSTRACT: Links a resource to the channel member view.

use Moo::Role;
use Types::Standard 'Str';

################################################################################

has view_name => (is => 'ro', isa => Str, default => 'ChannelMember');

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::Role::View::ChannelMember - Links a resource to the channel member view.

=head1 VERSION

version 0.29

=head1 DESCRIPTION

Set a resource as using the L<WebService::Mattermost::V4::API::Object::ChannelMember>
view.

=head1 ATTRIBUTES

=over 4

=item C<view_name>

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
