package Evo::GA::BitGenome;

### genome with 0 or 1 genes

sub new {
	my ($class) = @_;

	my $self = { genes => (), };

	$class = ref($class) || $class;

	bless $self, $class;
}

sub mutate {
	my ($self, $idx) = @_;

	if ($self->{genes}[$idx] == 0) {
		$self->{genes}[$idx] = 1;
	} else {
		$self->{genes}[$idx] = 0;
	}	
}

sub crossover {
	my ($self, $idx1, $idx2, $genome) = @_;

	for (my $i = $idx1; $i < $idx2; $i++) {
		$self->{genes}[$i] = $genome->{genes}[$i] & $self->{genes}[$i]; ### FIXME
	}
}

sub add_to {
	my ($self, $gene) = @_;

	push (@{$self->{genes}}, $gene);
}

### estimate fitness function
sub fitness_simple {
	my ($self) = @_;
	my $sum = 0;

	for (my $i = 0; $i < scalar $self->{genes}; $i++) {
		$sum += $self->{genes}[$i];
	}

	return ($sum / scalar $self->{genes});	
}

sub norm {
	my ($self) = @_;

	my $dotp = 0;

	for (my $i = 0; $i < scalar $self->{genes}; $i++) {
		$dotp += $self->{genes}[$i] * $self->{genes}[$i];
	}
	
	return $dotp;
}

1;
