package Acme::CPANModules::Import::CPANRatings::User::perlancar;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-10-29'; # DATE
our $DIST = 'Acme-CPANModules-Import-CPANRatings-User-perlancar'; # DIST
our $VERSION = '0.002'; # VERSION

our $LIST = {description=>"This list is generated by scraping CPANRatings (cpanratings.perl.org) user page.",entries=>[{description=>"\nI'm not sure this really &quot;befits a ::Tiny distribution&quot; just because it's a thin wrapper of something. Please read: <a href=\"http://blogs.perl.org/users/dan_muey/2014/08/please-dont-use-tiny-unless-it-meets-the-tiny-criteria-thanks.html\" rel=\"nofollow\">blogs.perl.org/users/dan_muey/2014/08...</a> or the Tiny mandate e.g.  in <a href=\"https://metacpan.org/pod/Time::Tiny#The-Tiny-Mandate\" rel=\"nofollow\">metacpan.org/pod/Time::Tiny#The-Tiny-...</a>\n",module=>"LWP::JSON::Tiny",rating=>undef},{description=>"\nAfter the last template change of the website which is one year ago, &quot;Was this review helpful&quot; links no longer works. <a href=\"https://github.com/perlorg/perlweb/issues/232\" rel=\"nofollow\">github.com/perlorg/perlweb/issues/232</a>\r<br>\n\n",module=>"Acme::CPANRatings",rating=>2},{description=>"\nNo longer works. Sigh, looks like there is currently NO working generic currency converter module on CPAN anymore. Every converter module is either: 1) dead; 2) specific for some currencies only.\r<br>\n\n",module=>"Finance::Currency::Convert::WebserviceX",rating=>2},{description=>"\nUses hard-coded rates in the source code. Does not seem to work anymore: convert() returns zero even after updateRates().\n",module=>"Finance::Currency::Convert",rating=>2},{description=>"\nOf limited use because of the site's restrictive license. UPDATE: And it no longer works.\n",module=>"Finance::Currency::Convert::XE",rating=>2},{description=>"\nNo longer works (not a surprise since this module has not been updated since almost 13 years ago).\n",module=>"Finance::Currency::Convert::Yahoo",rating=>2},{description=>"\nUses simple regex instead of properly parses Perl source code (PPI, Compiler::Lexer) so potentially lots of false positives. Better use existing solutions like Perl::PrereqScanner or Perl::PrereqScanner::Lite, which already come with their own CLI's.\n",module=>"App::used",rating=>undef},{description=>"\nCurrently the only &quot;real&quot; module to create FTP servers in Perl. My suggestion would be to separate the Perl API documentation vs using the ftpd*.pl script, as the Net::FTPServer documentation currently mixes the two.\n",module=>"Net::FTPServer",rating=>undef},{description=>"\nEarly release, so not polished yet, but... cool! Thanks, Gabor. We need more CLI games!\r<br>\n\n",module=>"Games::Sudoku::CLI",rating=>10},{description=>"\nThe coolest thing since PPI. Now every time someone still says that one can't parse HTML or balanced parentheses using regex, you can just point him to this module to shut him up (although, if he had said that one *shouldn't*...).\r<br><br>Also now you can say that Perl is a simple language that is easy to learn. Why? Well, it's so simple you can parse the whole syntax with a single regex.\r<br><br>\n",module=>"PPR",rating=>10},{description=>"\nUse MySQL-specific SQL dialect &quot;SHOW TABLES&quot; so comparing e.g. two SQLite database is an instant fail, even though there is DBIx::Compare::SQLite. Instead of the common convention like DBIx::Compare-&gt;new(...), uses db_comparison-&gt;new(...), sqlite_comparison-&gt;new(...), etc.\n",module=>"DBIx::Compare",rating=>4},{description=>"\nHey, Perl::Critic has not been reviewed for quite a while...\r<br><br>Finally take the plunge (again) to include Perl::Critic in my development work, this time adding critic test in the Dist::Zilla release process. Already caught a couple of stupid bugs otherwise uncaught by perl's -w. Aside from that, will help you become more consistent and a better (Perl) programmer. Invaluable! \n",module=>"Perl::Critic",rating=>10},{description=>"\nRating Data::Undump::PPI, which currently lives inside Config-Perl:\r<br><br>Of course this is a nice proof of concept, but for &quot;real world&quot; usage, look at Data::Undump which is about 2000x faster :)\n",module=>"Config::Perl",rating=>undef},{description=>"\nRequires perl 5.20 for no particular reason. Claims to be replacement of smart match but only covers string comparison. Just use List::Util's first() which is more flexible and part of the core Perl distribution, or match::smart which covers more cases.\n",module=>"Array::Contains",rating=>2},{description=>"\nMostly unnecessary because this is just a glorified form of a widely known Perl idiom. Requires perl 5.20 for no particular reason. Re-sorts the list which is 99% not what user wants. Just use List::Util's uniq() which is faster and part of core distribution.\n",module=>"Array::Unique",rating=>2},{description=>"\nHas some problems, e.g. it uses InstallTool phase so it conflicts with DZP:StaticInstall when wanting to produce a static install distro. Use alternatives like the simpler DZP:Pod2Readme or the more complex DZP:ReadmeAnyFromPod.\r<br>\n\n",module=>"Dist::Zilla::Plugin::ReadmeFromPod",rating=>2},{description=>"\nGreat for debugging. Just whip up some code in dist.ini to e.g. dump &amp; print some stuffs, etc.\n",module=>"Dist::Zilla::Plugin::Hook",rating=>10},{description=>"\nInteresting features, but mooseware.\n",module=>"File::Tail::Dir",rating=>6},{description=>"\nHappily returns result when graph is cyclic (and thus proper topological sorting cannot be done). See also Data::Graph::Util for a simpler alternative.\r<br>\n\n",module=>"Algorithm::Dependency",rating=>6},{description=>"\n(Reviewing Sort::Topological, which is included in Data-Match distribution at the time of this review).\r<br><br>Hangs when given a dependency like: a =&gt; [&quot;a&quot;]. Happily returns result when graph is cyclic (and thus proper topological sorting cannot be done). See also Data::Graph::Util for alternative.\r<br>\n\n",module=>"Data::Match",rating=>4},{description=>"\nFile::Find lacks the &quot;making easy things easy&quot; part, so modules like this are great. A further step would be an option to omit \$wanted for even simpler cases, but that would probably break the interface. Another alternative is File::Finder, but it forces OO style.\r<br>\n\n",module=>"File::Find::Wanted",rating=>8},{description=>"\nSince this is essentially md5(dump(\$data)), why restrict yourself to hash? This works also for any kind of Perl data structure.\n",module=>"Hash::MD5",rating=>undef},{description=>"\nIsn't this basically ISO8601 (see DateTime::Format::ISO8601)?\n",module=>"DateTime::Format::Docker",rating=>undef},{description=>"\nTo get the ratings for a single distribution, this client library needs to download /csv/all_ratings.csv (~80KB at the time of this writing) first. This is not the fault of the client because the website indeed does not provide the necessary ratings data on the /dist/:DISTNAME page. The client library should perhaps cache the CSV response though. The implementation could also be simplified by using slimmer libraries for this simple scraping task. But other than that, does what it says on the tin.\n",module=>"WWW::CPANRatings",rating=>8},{description=>"\nNot as useful as the name implies. It requires you to download the CSV of all ratings first, which BTW does not seem to be advertised on the CPAN Ratings website. The CSV file only contains numeric ratings and does not include any reviews. So basically what this module does is just filter the CSV rows for a distribution's rating.\r<br><br>One might want to look at WWW::CPANRatings instead.\n",module=>"Parse::CPAN::Ratings",rating=>6},{description=>"\nThis pure-perl module creates a shallow copy of the object instead of directly removing blessing from the same object (which requires XS). Acme::Damn is the more direct counterpart of bless().\r<br>\n\n",module=>"Acme::Curse",rating=>undef},{description=>"\nUse Digest::SHA instead. In general, there is no reason in using Digest::SHA1 over Digest::SHA. The latter is a core Perl module, more updated, and implements the other algorithms while the former only implements SHA-1 which is now deprecated.\r<br><br>\n",module=>"Digest::SHA1",rating=>undef},{description=>"\nThe &quot;checksum&quot; (basically just adding 16-bit words) is too simplistic to be a real checksum or to be practically useful. Even MD5 or CRC32 is infinitely better.\r<br>\n\n",module=>"File::Checksum",rating=>undef},{description=>"\nStill works, partially, but in general out of date. For example, to get post the deprecated metaWeblog.getPost API method is still used instead of the newer wp.getPost call (which understandably is only introduced in WordPress 3.4, while this module is last updated with WordPress 2.8.4). And apparently wordpress.com doesn't return post_content anymore when you use metaWeblog.getPost.\r<br><br>Luckily, performing XMLRPC request directly is easy enough. Just use XMLRPC::Lite and peruse the Wordpress documentation here: <a href=\"https://codex.wordpress.org/XML-RPC_WordPress_API\" rel=\"nofollow\">codex.wordpress.org/XML-RPC_WordPress...</a> \n",module=>"WordPress::XMLRPC",rating=>undef},{description=>"\nMy new favorite Levenshtein distance module. It's as fast (if not faster) than Text::Levenshtein::XS and can provide a speed boost if you don't care about distances above a certain limit. Which I think in many cases is true.\n",module=>"Text::Levenshtein::Flexible",rating=>10},{description=>"\nGreat and all, but one drawback is that it currently destroys original file's formatting in serialize().\n",module=>"CPAN::Changes",rating=>undef},{description=>"\nAny module from ADAMK should be interesting, including this one. But please take a look at CPAN::Changes for the de facto standard nowadays.\n",module=>"Module::Changes::ADAMK",rating=>undef},{description=>"\nLike Module::Changes, this module also tries to use a more defined format for Changes. Sadly, it has not caught on. Please also take a look at CPAN::Changes which seems to be the de facto standard nowadays.\n",module=>"Module::Metadata::Changes",rating=>undef},{description=>"\nIn general I'm not opposed to the idea of this module. The included 'changes' script is also pretty cool (which I'm trying to recreate, for CPAN::Changes).\r<br><br>Just pointing out that I believe this module has not really &quot;caught on&quot; among the CPAN community. What has, is, CPAN::Changes which is followed by many authors and even employed on MetaCPAN.\r<br>\n\n",module=>"Module::Changes",rating=>undef},{description=>"\nSadly there is not a single perfect Archive::Tar::* module out there. Either a module offers incomplete API, (was) buggy, or it is crippled/limited in some way. Plus, the modules are mostly incompatible with one another. And that's why TIMTOWTDI.\r<br><br>For the task of just listing files in an archive, for example, it seems only Archive::Tar and Archive::Tar::Wrapper are usable. Archive::Tar::Wrapper is fast (because it utilizes external C-based tar utility) and does not load all contents of an archive into memory, but requires writing to temporary files and of course requires a tar utility so portability to non-Unix systems might be an issue.\n",module=>"Archive::Tar::Wrapper",rating=>undef},{description=>"\nSadly there is not a single perfect Archive::Tar::* module out there. Either a module offers incomplete API, (was) buggy, or it is crippled/limited in some way. Plus, the modules are mostly incompatible with one another. And that's why TIMTOWTDI.\r<br><br>For the task of just listing files in an archive, for example, it seems only Archive::Tar and Archive::Tar::Wrapper are usable. Archive::Tar is a core module, but relatively slow, and extracts all contents of an archive in memory so it's not workable for huge archives.\r<br>\n\n",module=>"Archive::Tar",rating=>undef},{description=>"\nOne can easily use this idiom instead:\r<br><br>\$picked = { map {(exists \$hash{\$_} ? (\$_=&gt;\$hash{\$_}):())} \@keys };\r<br><br>or:\r<br><br>\$picked = { map {\$_=&gt;\$hash{\$_}} grep {exists \$hash{\$_}} \@keys };\r<br><br>or (if you want non-existing picked keys to be created instead):\r<br><br>\$picked = { map {\$_ =&gt; \$hash{\$_}} \@keys };\r<br><br>but Hash::Util::Pick is implemented in XS and can be a few times faster than the above when the number of keys has reached thousands. So I guess this module has its uses.\n",module=>"Hash::Util::Pick",rating=>undef},{description=>"\nCons: more heavyweight (requires Moo), limited operations/methods, can only handle IPv4 and not IPv6. Pros: some operations are faster than competing modules, e.g. validation. See also: NetAddr::IP, Net::CIDR.\r<br>\n\n",module=>"NetObj::IPv4Address",rating=>undef},{description=>"\nAside from being Moo-based (which, makes it a bit more heavyweight and with more dependencies), doesn't yet offer anything extra or more methods compared to previously existing modules like NetAddr::MAC.\n",module=>"NetObj::MacAddress",rating=>4},{description=>"\nCool. Now you can create your own Camel Code with ease!\n",module=>"Acme::AsciiArtinator",rating=>10},{description=>"\nI'd say in terms of footprint and runtime performance, this module is average (it's not the most lightweight nor the fastest pure-perl object system, not to mention against XS ones). See my Bencher::Scenarios::Accessors for a comparison, e.g. <a href=\"https://metacpan.org/pod/Bencher::Scenario::Accessors::Get\" rel=\"nofollow\">metacpan.org/pod/Bencher::Scenario::A...</a> and <a href=\"https://metacpan.org/pod/Bencher::Scenario::Accessors::Set\" rel=\"nofollow\">metacpan.org/pod/Bencher::Scenario::A...</a> .\r<br><br>One drawback of using Mojo::Base and Object::Simple is its similar but slightly different and incompatible syntax with the Moo* family, so your code is not &quot;upgradable&quot; to Moo or Moose once you need more features. And often you'll end up wanting them, e.g. one day you'll probably read about the wonders of method modifiers (before, after, around), or roles, or wanting to have a lazy constructor, or triggers, and so on.\r<br><br>I'd recommend instead Mo. It's more lightweight than Object::Simple and you can do default value, builder, ro/rw, required, even coercion. But the features are modular and you only pay for what you use. And once you need more features later, you normally should be able to just replace 'use Mo' in your code with 'use Moo' or 'use Moose'.\r<br><br>Of course, this point is moot if you don't care about compatibility/upgradability to Moo*.\n",module=>"Object::Simple",rating=>6},{description=>"\nNice. API is more convenient to use than Test::Requires, especially if you use subtests.\r<br>\n\n",module=>"Test::Needs",rating=>10},{description=>"\nThere are a few use-cases where this would be useful (mostly, to access https websites in the absence of required perl library like LWP::Protocol::https), but it would be more useful to provide an API that is already familiar to Perl programmers. That's why MIYAGAWA created HTTP::Tinyish.\n",module=>"HTTP::Command::Wrapper",rating=>undef},{description=>"\nPoint for documentation (lots of examples and cookbook). But the recipes in the cookbook currently don't really entice me to use the module. Let's see:\r<br><br>1) batch file rename: it's much simpler to use 'rename' or 'perlmv' utility. Or, it's much shorter to just use plain perl like 'for (grep {-f} &lt;*&gt;) { rename \$_, s/\\.log\$/.txt/r }'.\r<br><br>2) recursively remove a directory tree: it's much shorter to just use 'File::Path::remove_tree()'.\r<br><br>3) increment a counter file: no locking (it's classic 1990's counter.cgi race condition all over again). Take a look at, for example, The Perl Cookbook chapter 7.11. Or I think one of Randal Schwartz's articles.\r<br><br>As an alternative, one can also take a look at Path::Tiny.\n",module=>"File::Util",rating=>undef},{description=>"\nA couple of comments:\r<br><br>* Some functions like min(), max(), etc need not be reinvented because they are already in core module List::Util. But I guess the author wants to be able to say min([1,2,3]) in addition to min(1,2,3).\r<br><br>* round() uses Number::Format, note that rounding number using this module is hundreds of times slower than using sprintf().\r<br><br>\n",module=>"Common::Routine",rating=>undef},{description=>"\nA couple of prior arts:\r<br><br>* all, <a href=\"https://metacpan.org/pod/all\" rel=\"nofollow\">metacpan.org/pod/all</a> (since 2003), nicer interface and offers &quot;use&quot;/compile-time interface, so it's more equivalent to the statements it wants to replace. The Submodules equivalent would be: BEGIN { for my \$i (Submodules-&gt;find(&quot;Blah&quot;)) { \$i-&gt;require } }.\r<br><br>* Module::Require, <a href=\"https://metacpan.org/pod/Module::Require\" rel=\"nofollow\">metacpan.org/pod/Module::Require</a> (since 2001), also nicer interface, more flexible, and more lightweight implementation.\r<br><br>I don't like Submodules' interface, it's too verbose and clunky. IMO, the interface should be a one-liner and without manual looping. \n",module=>"Submodules",rating=>undef},{description=>"\nI guess it depends on your data, but for random shortish strings (hundreds to thousands of them), I find that using raw joining is much faster to assemble the regex. And the resulting regex is also (much) faster to match. Please see Bencher::Scenario::RegexpAssemble if you're interested in the benchmark script.\n",module=>"Regexp::Assemble",rating=>undef},{description=>"\nThere is a prior art Tie::Simple (created in 2004) which works for scalar as well as the other types of ties that perl supports (array, hash, handle).\r<br>\n\n",module=>"Tie::Scalar::Callback",rating=>undef},{description=>"\nReview for 0.02: Performance-wise, still has some catching up to do against JSON::XS &amp; Cpanel::JSON::XS with regards to encoding arrays &amp; hashes.\r<br><br>UPDATE review for 0.19: Giving it 4 stars now. Speed has been improving and on-par/slightly better than the other JSON XS modules in some areas, while a bit worse in some other areas. Faster modules are always welcome.\n",module=>"JSON::Create",rating=>8},{description=>"\nConfirming previous reviewer, the module is a lot slower (~ 20-40x) than other alternatives like Array::Utils or List::MoreUtils when you want to perform basic set operations like union/intersect/diff/symmetric diff.\n",module=>"Set::Scalar",rating=>undef},{description=>"\nI can see the value of Exporter::Easy (although these days the saving in typing is not as big, with plain Exporter one can just say: use Exporter 'import'; our \@EXPORT = qw(a b c)).\r<br><br>However I fail to see the value of Exporter::Easiest. I'd rather use plain Perl than some DDL which cannot be checked statically or cannot be syntax-highlighted, just to save some []'s and ()'s (which I can get my editor to help me type them).\r<br><br>In short, I'd rather use plain Exporter than save a few keystrokes but add a non-core dependency.\n",module=>"Exporter::Easy",rating=>6},{description=>"\nDue to parallel processes and defaulting on no_test, can be several times faster than cpanminus (tried installing a module on a vanilla perlbrew instance with local CPAN mirror, which pulled +- 200 distributions, &quot;cpanm -n&quot; took 2m9s, while cpm took 38s.) I hope this gets developed further. Great job.\r<br>\n\n",module=>"App::cpm",rating=>10},{description=>"\nFrom the doc: &quot;This module generates one's Chinese zodiac. However, for those born in late January to early February, it may be wrong.&quot; Well, a module that might return wrong results is not very useful.\r<br>\n\n",module=>"Zodiac::Chinese",rating=>2},{description=>"\nI guess if you want to switch JSON implementation more easily with JSON, JSON::PP, and JSON::XS, it's better to use JSON::Tiny::Subclassable instead of JSON::Tiny, because the interface is more similar to JSON{::XS,::PP}, although it's not exactly the same. JT:Subclassable also supports pretty() which is often used when debugging. In short, I found JSON::Tiny::Subclassable is a better &quot;Tiny JSON&quot; module than JSON::Tiny.\n",module=>"JSON::MultiValueOrdered",rating=>10},{description=>"\nAh, the many JSON implementation modules out there... \r<br><br>I guess if you want to switch JSON implementation more easily with JSON, JSON::PP, and JSON::XS, it's better to use JSON::Tiny::Subclassable instead of JSON::Tiny, because the interface is more similar to JSON{::XS,::PP}, although it's not exactly the same.\r<br><br>\n",module=>"JSON::Tiny",rating=>undef},{description=>"\nProvides some more features compared to Carp::Always, like producing stack trace even when exception is ref/object, color &amp; dump function arguments (so you don't need a separate Carp::Always::Dump and Carp::Always::Color). Recommended.\r<br>\n\n",module=>"Devel::Confess",rating=>10},{description=>"\nThis module works well for string exceptions (e.g. die &quot;some message&quot;), but for ref/object exceptions (e.g. die [404,&quot;Not found&quot;] or die \$some_object) it will simply print/return the ref/object and thus no stack trace information is produced.\r<br><br>See also Devel::Confess, which can handle ref/object.\r<br><br>References: \r<br>\n<a href=\"http://blogs.perl.org/users/graham_knop/2013/09/carp-always-evenobjects.html\" rel=\"nofollow\">blogs.perl.org/users/graham_knop/2013...</a>\n",module=>"Carp::Always",rating=>undef},{description=>"\nOur prayer has been answered. experimental was added to perl core in 5.19.11\n",module=>"experimental",rating=>undef},{description=>"\nMostly unnecessary. The main premise of this module is that you don't need to inherit to use it. But you also can use Exporter (a core module, BTW) without inherinting it:\r<br><br>use Exporter qw(import);\r<br>\n\n",module=>"Exporter::Lite",rating=>undef},{description=>"\nThe idea is good, but a couple of things prevents me from using this interface.\r<br><br>First, the use of TryCatch (which brings the Moose ecosystem) makes the startup overhead too high for my taste (about 0.5s on my PC). Which is rather unfortunate because Date::Holidays itself does not use Moose.\r<br><br>Second, the interface assumes that a country has a single set of holidays, which is too restrictive in some cases. A more flexible/general interface would allow adding more calendars based not only on country but also religion, special community, organization, etc. And allow adding custom calendars.\r<br>\n\n",module=>"Date::Holidays",rating=>undef},{description=>"\n\@Kira S (I wish cpanratings adds a feature to comment on a review):\r<br><br>Comparing WWW::Mechanize with Furl is not really apples-to-apples, since Furl does not support parsing/following links or form processing. As the Furl POD itself suggests, Furl is positioned as a faster alternative to LWP, not WWW::Mechanize.\n",module=>"Furl",rating=>undef},{description=>"\nJust add this review to link to Ben Bullock's Lingua::EN::PluralToSingular if you need to go the other way (converting English noun from plural to singular).\r<br><br>BTW, I don't like the interface either, and wonder why the Env module needs to be involved. \r<br>\n\n",module=>"Lingua::EN::Inflect",rating=>undef},{description=>"\nNot perfect or exhaustive, but good enough and lightweight. With a dead-simple interface. Just the sort of libraries that are reusable almost everywhere. Thanks for this.\r<br><br>Also, this might not be immediately obvious since there's no mention on the See Also section: to go the other way (converting English noun from singular to plural) you can use Lingua::EN::Inflect.\n",module=>"Lingua::EN::PluralToSingular",rating=>10},{description=>"\nI haven't used or evaluated this module in detail, but if there is one advantage to using procedural/command syntax:\r<br><br>info blah;\r<br><br>as opposed to object syntax:\r<br><br>\$log-&gt;info(blah);\r<br><br>then this module clearly demonstrates it. Using Devel::Declare (or the Perl 5.14+ keyword API), the former can be easily rewritten as something like:\r<br><br>info &amp;&amp; blah;\r<br><br>or:\r<br><br>if (CONST_LOG_INFO) { info blah }\r<br><br>and during compilation, Perl can optimize the line away and we get zero run-time penalty when logging (level) is disabled.\r<br><br>(Actually, it's also possible for the object syntax to get rewritten, e.g. using source filter, but it's more cumbersome).\n",module=>"Log::Declare",rating=>undef},{description=>"\nNice alternative module for benchmarking with a different interface than Benchmark (marking portion of code to be benchmarked with start and stop).\r<br><br>For most Perl programmers familiar to the core module Benchmark, I recommend looking at Benchmark::Dumb first though. It has an interface like Benchmark (cmpthese() et all) but with some statistical confidence.\n",module=>"Benchmark::Timer",rating=>undef},{description=>"\nNice idea, but some performance concerns. If you want to use cgetargs (the compiled, faster version), you are restricted to the getargs() interface, which only features checking for required arguments and supplying default value. In which case you might as well use Params::Validate directly as it's several times (e.g. 3-4x) faster.\r<br><br>If you want to use the more featured xgetargs, there is currently no compiled version.\r<br><br>All in all, I think users should take a look at Params::Validate first. \n",module=>"Getargs::Long",rating=>undef},{description=>"\nNot as easy as the name might claim. First of all, why do users need to pass __LINE__ explicitly for every call??? Other logging modules will get this information automatically via caller(). \r<br><br>Levels are a bit confusing: why is debug split to 2 (or 3)? \r<br><br>Not as flexible as it should be because the design conflates some things together. For example, most levels output to STDERR but some level (VERBOSE) outputs to STDOUT instead. The output concern and levels should've been separated. Another example would be the DEBUGWAIT level, where level is DEBUG *and* execution is halted (wait on a keypress) on log. What if users want a lower level setting *but* want execution to be halted on log? The halt/keypress setting should've been separated from the level.\n",module=>"Debug::Easy",rating=>4},{description=>"\nWho'da thought that something as seemingly simple as &quot;slurping a file into a string&quot; would need several modules and false starts? Well, if you add encodings, Perl I/O layers, scalar/list context, DWIM-ness, ... it can get complex and buggy. I'm glad there are people taking care of this and making sure that a simple task stays simple and correct. \n",module=>"File::Slurper",rating=>10},{description=>"\nUse the newer File::Slurper instead, which has a clearer API (e.g. text vs binary, array/lines vs string) and encoding default. It's arguably &quot;saner&quot; than File::Slurp and File::Slurp::Tiny.\r<br>\n\n",module=>"File::Slurp",rating=>undef},{description=>"\nUse the newer File::Slurper instead, which has a clearer API (e.g. text vs binary, array/lines vs string) and encoding default. It's arguably &quot;saner&quot; than File::Slurp and File::Slurp::Tiny.\r<br>\n\n",module=>"File::Slurp::Tiny",rating=>undef},{description=>"\nA significantly faster alternative to Perl::PrereqScanner. It's *almost* a drop-in replacement, there might still be some bugs in missing detecting some modules, and you still have to do several add_extra_scanner() calls like \$scanner-&gt;add_extra_scanner('Moose') to match the behavior of Perl::PrereqScanner.\r<br><br>\n",module=>"Perl::PrereqScanner::Lite",rating=>10},{description=>"\nFirst file rotating module I found and tried. Works, but needs to be modernized a bit. Indirect object notation in doc should be replaced. Bool option takes &quot;yes&quot; or &quot;no&quot;, should perhaps be 1 or 0. Capitalization adjustment, perhaps.\r<br><br>\n",module=>"Logfile::Rotate",rating=>6},{description=>"\nAt the time of this review, I find two modules for reading a file backwards: File::Bidirectional (FBidi) and File::ReadBackwards (FRB).\r<br><br>Both modules have roughly the same footprint and minimal dependencies. Both provide OO as well as tie interface. Both respect the \$/ setting.\r<br><br>FRB pro's:\r<br>\n- FRB is 15-20% faster than FBidi when reading backwards;\r<br><br>FRB con's:\r<br>\n- does not offer the feature of reading forward as well, but of course this is not the goal of the module.\r<br><br>FBidi's POD contains information on benchmarks (it's roughly an order of magnitude slower than raw Perl's open+read/diamond operator, still the case in 2014). While FRB's POD contains information on how the thing works behind the scenes.\r<br><br>In summary, both modules are roughly the same. I'd prefer FRB unless in the rarer cases where I need bidirectional reading.\r<br>\n\n",module=>"File::ReadBackwards",rating=>8},{description=>"\nAt the time of this review, I find two modules for reading a file backwards: File::Bidirectional (FBidi) and File::ReadBackwards (FRB).\r<br><br>Both modules have roughly the same footprint and minimal dependencies. Both provide OO as well as tie interface. Both respect the \$/ setting.\r<br><br>FBidi pro's:\r<br>\n- has the unique feature of reading backward/forward and switch direction in the middle;\r<br><br>FBidi con's:\r<br>\n- FBidi is 15-20% slower than FBidi when reading backwards;\r<br>\n- reading forward is just as slow as backward, so if you only need to read forward, obviously there's no need to use this module;\r<br><br>FBidi's POD contains information on benchmarks (it's roughly an order of magnitude slower than raw Perl's open+read/diamond operator, still the case in 2014). While FRB's POD contains information on how the thing works behind the scenes.\r<br><br>In summary, both modules are roughly the same. I'd prefer FRB unless in the rarer cases where I need bidirectional reading.\r<br>\n\n",module=>"File::Bidirectional",rating=>8},{description=>"\nNice, but Signal::StackTrace should've output something carp-like in the first place.\n",module=>"Signal::StackTrace::CarpLike",rating=>undef},{description=>"\nI think this is basically logging under a fancy name and with a more cumbersome interface. Look at Log::Any instead.\n",module=>"Devel::Messenger",rating=>undef},{description=>"\nCute! I didn't know SIGALRM still works even though you're doing blocking I/O or calling other programs. But unfortunately it doesn't work if you sleep(), making this approach not as attractive.\r<br>\n\n",module=>"Term::Twiddle",rating=>undef},{description=>"\nThe move to Moo is very welcome, but I wish there were an alternative of CHI which is even more lightweight (starts in under 0.01s). CHI::Tiny, anyone?\n",module=>"CHI",rating=>undef},{description=>"\nBit of a shame that we currently don't have a working YouTube download script/module (WWW::YouTube::Download is last updated 2013 and has been broken for a long while). This module actually requires another *Python* script to do its job. I might as well skip this and go straight to the Python script.\r<br><br>UPDATE 2016-03-04: I guess it's been so for a few years, but this still needs to be said: For downloading YouTube videos, use youtube-dl (a far more popular Python project) and just forget the rest. Keeping up with YouTube changes is many times a full time job. Nothing else comes remotely close. \n",module=>"App::YTDL",rating=>undef},{description=>"\nThe part that makes this module convenient is that the functions return their original arguments. So when debugging (peppering dump statements), you don't have to change this:\r<br><br>return [&quot;some&quot;, \$expr];\r<br><br>to this (taking an example from another dumping module, Data::Dump):\r<br><br>my \$tmp = [&quot;some&quot;, \$expr]; dd \$tmp; return \$tmp;\r<br><br>but just this:\r<br><br>return YYY [&quot;some&quot;, \$expr];\r<br><br>This should be imitated by the other dumper functions.\n",module=>"XXX",rating=>10}],summary=>"List of modules mentioned by CPANRatings user perlancar"};

1;
# ABSTRACT: List of modules mentioned by CPANRatings user perlancar

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANModules::Import::CPANRatings::User::perlancar - List of modules mentioned by CPANRatings user perlancar

=head1 VERSION

This document describes version 0.002 of Acme::CPANModules::Import::CPANRatings::User::perlancar (from Perl distribution Acme-CPANModules-Import-CPANRatings-User-perlancar), released on 2023-10-29.

=head1 DESCRIPTION

This list is generated by scraping CPANRatings (cpanratings.perl.org) user page.

This list is generated by scraping CPANRatings (cpanratings.perl.org) user page.

=head1 ACME::CPANMODULES ENTRIES

=over

=item L<LWP::JSON::Tiny>

Author: L<SKINGTON|https://metacpan.org/author/SKINGTON>

I'm not sure this really &quot;befits a ::Tiny distribution&quot; just because it's a thin wrapper of something. Please read: <a href="http://blogs.perl.org/users/dan_muey/2014/08/please-dont-use-tiny-unless-it-meets-the-tiny-criteria-thanks.html" rel="nofollow">blogs.perl.org/users/dan_muey/2014/08...</a> or the Tiny mandate e.g.  in <a href="https://metacpan.org/pod/Time::Tiny#The-Tiny-Mandate" rel="nofollow">metacpan.org/pod/Time::Tiny#The-Tiny-...</a>


=item L<Acme::CPANRatings>

Author: L<PERLANCAR|https://metacpan.org/author/PERLANCAR>

After the last template change of the website which is one year ago, &quot;Was this review helpful&quot; links no longer works. <a href="https://github.com/perlorg/perlweb/issues/232" rel="nofollow">github.com/perlorg/perlweb/issues/232</a>
<br>


Rating: 2/10

=item L<Finance::Currency::Convert::WebserviceX>

Author: L<CLACO|https://metacpan.org/author/CLACO>

No longer works. Sigh, looks like there is currently NO working generic currency converter module on CPAN anymore. Every converter module is either: 1) dead; 2) specific for some currencies only.
<br>


Rating: 2/10

=item L<Finance::Currency::Convert>

Author: L<JANW|https://metacpan.org/author/JANW>

Uses hard-coded rates in the source code. Does not seem to work anymore: convert() returns zero even after updateRates().


Rating: 2/10

=item L<Finance::Currency::Convert::XE>

Author: L<RMCKAY|https://metacpan.org/author/RMCKAY>

Of limited use because of the site's restrictive license. UPDATE: And it no longer works.


Rating: 2/10

=item L<Finance::Currency::Convert::Yahoo>

Author: L<LGODDARD|https://metacpan.org/author/LGODDARD>

No longer works (not a surprise since this module has not been updated since almost 13 years ago).


Rating: 2/10

=item L<App::used>

Author: L<IVANWILLS|https://metacpan.org/author/IVANWILLS>

Uses simple regex instead of properly parses Perl source code (PPI, Compiler::Lexer) so potentially lots of false positives. Better use existing solutions like Perl::PrereqScanner or Perl::PrereqScanner::Lite, which already come with their own CLI's.


=item L<Net::FTPServer>

Author: L<RYOCHIN|https://metacpan.org/author/RYOCHIN>

Currently the only &quot;real&quot; module to create FTP servers in Perl. My suggestion would be to separate the Perl API documentation vs using the ftpd*.pl script, as the Net::FTPServer documentation currently mixes the two.


=item L<Games::Sudoku::CLI>

Author: L<SZABGAB|https://metacpan.org/author/SZABGAB>

Early release, so not polished yet, but... cool! Thanks, Gabor. We need more CLI games!
<br>


=item L<PPR>

Author: L<DCONWAY|https://metacpan.org/author/DCONWAY>

The coolest thing since PPI. Now every time someone still says that one can't parse HTML or balanced parentheses using regex, you can just point him to this module to shut him up (although, if he had said that one I<shouldn't>...).
<br><br>Also now you can say that Perl is a simple language that is easy to learn. Why? Well, it's so simple you can parse the whole syntax with a single regex.
<br><br>


=item L<DBIx::Compare>

Author: L<CJONES|https://metacpan.org/author/CJONES>

Use MySQL-specific SQL dialect &quot;SHOW TABLES&quot; so comparing e.g. two SQLite database is an instant fail, even though there is DBIx::Compare::SQLite. Instead of the common convention like DBIx::Compare-&gt;new(...), uses db_comparison-&gt;new(...), sqlite_comparison-&gt;new(...), etc.


Rating: 4/10

=item L<Perl::Critic>

Author: L<PETDANCE|https://metacpan.org/author/PETDANCE>

Hey, Perl::Critic has not been reviewed for quite a while...
<br><br>Finally take the plunge (again) to include Perl::Critic in my development work, this time adding critic test in the Dist::Zilla release process. Already caught a couple of stupid bugs otherwise uncaught by perl's -w. Aside from that, will help you become more consistent and a better (Perl) programmer. Invaluable! 


=item L<Config::Perl>

Author: L<HAUKEX|https://metacpan.org/author/HAUKEX>

Rating Data::Undump::PPI, which currently lives inside Config-Perl:
<br><br>Of course this is a nice proof of concept, but for &quot;real world&quot; usage, look at Data::Undump which is about 2000x faster :)


=item L<Array::Contains>

Author: L<CAVAC|https://metacpan.org/author/CAVAC>

Requires perl 5.20 for no particular reason. Claims to be replacement of smart match but only covers string comparison. Just use List::Util's first() which is more flexible and part of the core Perl distribution, or match::smart which covers more cases.


Rating: 2/10

=item L<Array::Unique>

Author: L<SZABGAB|https://metacpan.org/author/SZABGAB>

Mostly unnecessary because this is just a glorified form of a widely known Perl idiom. Requires perl 5.20 for no particular reason. Re-sorts the list which is 99% not what user wants. Just use List::Util's uniq() which is faster and part of core distribution.


Rating: 2/10

=item L<Dist::Zilla::Plugin::ReadmeFromPod>

Author: L<FAYLAND|https://metacpan.org/author/FAYLAND>

Has some problems, e.g. it uses InstallTool phase so it conflicts with DZP:StaticInstall when wanting to produce a static install distro. Use alternatives like the simpler DZP:Pod2Readme or the more complex DZP:ReadmeAnyFromPod.
<br>


Rating: 2/10

=item L<Dist::Zilla::Plugin::Hook>

Author: L<VDB|https://metacpan.org/author/VDB>

Great for debugging. Just whip up some code in dist.ini to e.g. dump &amp; print some stuffs, etc.


=item L<File::Tail::Dir>

Author: L<JJSCHUTZ|https://metacpan.org/author/JJSCHUTZ>

Interesting features, but mooseware.


Rating: 6/10

=item L<Algorithm::Dependency>

Author: L<ETHER|https://metacpan.org/author/ETHER>

Happily returns result when graph is cyclic (and thus proper topological sorting cannot be done). See also Data::Graph::Util for a simpler alternative.
<br>


Rating: 6/10

=item L<Data::Match>

Author: L<KSTEPHENS|https://metacpan.org/author/KSTEPHENS>

(Reviewing Sort::Topological, which is included in Data-Match distribution at the time of this review).
<br><br>Hangs when given a dependency like: a =&gt; [&quot;a&quot;]. Happily returns result when graph is cyclic (and thus proper topological sorting cannot be done). See also Data::Graph::Util for alternative.
<br>


Rating: 4/10

=item L<File::Find::Wanted>

Author: L<PETDANCE|https://metacpan.org/author/PETDANCE>

File::Find lacks the &quot;making easy things easy&quot; part, so modules like this are great. A further step would be an option to omit $wanted for even simpler cases, but that would probably break the interface. Another alternative is File::Finder, but it forces OO style.
<br>


Rating: 8/10

=item L<Hash::MD5>

Author: L<MZIESCHA|https://metacpan.org/author/MZIESCHA>

Since this is essentially md5(dump($data)), why restrict yourself to hash? This works also for any kind of Perl data structure.


=item L<DateTime::Format::Docker>

Author: L<MZIESCHA|https://metacpan.org/author/MZIESCHA>

Isn't this basically ISO8601 (see DateTime::Format::ISO8601)?


=item L<WWW::CPANRatings>

Author: L<CORNELIUS|https://metacpan.org/author/CORNELIUS>

To get the ratings for a single distribution, this client library needs to download /csv/all_ratings.csv (~80KB at the time of this writing) first. This is not the fault of the client because the website indeed does not provide the necessary ratings data on the /dist/:DISTNAME page. The client library should perhaps cache the CSV response though. The implementation could also be simplified by using slimmer libraries for this simple scraping task. But other than that, does what it says on the tin.


Rating: 8/10

=item L<Parse::CPAN::Ratings>

Author: L<LBROCARD|https://metacpan.org/author/LBROCARD>

Not as useful as the name implies. It requires you to download the CSV of all ratings first, which BTW does not seem to be advertised on the CPAN Ratings website. The CSV file only contains numeric ratings and does not include any reviews. So basically what this module does is just filter the CSV rows for a distribution's rating.
<br><br>One might want to look at WWW::CPANRatings instead.


Rating: 6/10

=item L<Acme::Curse>

Author: L<MORITZ|https://metacpan.org/author/MORITZ>

This pure-perl module creates a shallow copy of the object instead of directly removing blessing from the same object (which requires XS). Acme::Damn is the more direct counterpart of bless().
<br>


=item L<Digest::SHA1>

Author: L<GAAS|https://metacpan.org/author/GAAS>

Use Digest::SHA instead. In general, there is no reason in using Digest::SHA1 over Digest::SHA. The latter is a core Perl module, more updated, and implements the other algorithms while the former only implements SHA-1 which is now deprecated.
<br><br>


=item L<File::Checksum>

Author: L<KNORR|https://metacpan.org/author/KNORR>

The &quot;checksum&quot; (basically just adding 16-bit words) is too simplistic to be a real checksum or to be practically useful. Even MD5 or CRC32 is infinitely better.
<br>


=item L<WordPress::XMLRPC>

Author: L<IGIBBS|https://metacpan.org/author/IGIBBS>

Still works, partially, but in general out of date. For example, to get post the deprecated metaWeblog.getPost API method is still used instead of the newer wp.getPost call (which understandably is only introduced in WordPress 3.4, while this module is last updated with WordPress 2.8.4). And apparently wordpress.com doesn't return post_content anymore when you use metaWeblog.getPost.
<br><br>Luckily, performing XMLRPC request directly is easy enough. Just use XMLRPC::Lite and peruse the Wordpress documentation here: <a href="https://codex.wordpress.org/XML-RPC_WordPress_API" rel="nofollow">codex.wordpress.org/XML-RPC_WordPress...</a> 


=item L<Text::Levenshtein::Flexible>

Author: L<MBETHKE|https://metacpan.org/author/MBETHKE>

My new favorite Levenshtein distance module. It's as fast (if not faster) than Text::Levenshtein::XS and can provide a speed boost if you don't care about distances above a certain limit. Which I think in many cases is true.


=item L<CPAN::Changes>

Author: L<HAARG|https://metacpan.org/author/HAARG>

Great and all, but one drawback is that it currently destroys original file's formatting in serialize().


=item L<Module::Changes::ADAMK>

Author: L<ADAMK|https://metacpan.org/author/ADAMK>

Any module from ADAMK should be interesting, including this one. But please take a look at CPAN::Changes for the de facto standard nowadays.


=item L<Module::Metadata::Changes>

Author: L<RSAVAGE|https://metacpan.org/author/RSAVAGE>

Like Module::Changes, this module also tries to use a more defined format for Changes. Sadly, it has not caught on. Please also take a look at CPAN::Changes which seems to be the de facto standard nowadays.


=item L<Module::Changes>

Author: L<MARCEL|https://metacpan.org/author/MARCEL>

In general I'm not opposed to the idea of this module. The included 'changes' script is also pretty cool (which I'm trying to recreate, for CPAN::Changes).
<br><br>Just pointing out that I believe this module has not really &quot;caught on&quot; among the CPAN community. What has, is, CPAN::Changes which is followed by many authors and even employed on MetaCPAN.
<br>


=item L<Archive::Tar::Wrapper>

Author: L<ARFREITAS|https://metacpan.org/author/ARFREITAS>

Sadly there is not a single perfect Archive::Tar::* module out there. Either a module offers incomplete API, (was) buggy, or it is crippled/limited in some way. Plus, the modules are mostly incompatible with one another. And that's why TIMTOWTDI.
<br><br>For the task of just listing files in an archive, for example, it seems only Archive::Tar and Archive::Tar::Wrapper are usable. Archive::Tar::Wrapper is fast (because it utilizes external C-based tar utility) and does not load all contents of an archive into memory, but requires writing to temporary files and of course requires a tar utility so portability to non-Unix systems might be an issue.


=item L<Archive::Tar>

Author: L<BINGOS|https://metacpan.org/author/BINGOS>

Sadly there is not a single perfect Archive::Tar::* module out there. Either a module offers incomplete API, (was) buggy, or it is crippled/limited in some way. Plus, the modules are mostly incompatible with one another. And that's why TIMTOWTDI.
<br><br>For the task of just listing files in an archive, for example, it seems only Archive::Tar and Archive::Tar::Wrapper are usable. Archive::Tar is a core module, but relatively slow, and extracts all contents of an archive in memory so it's not workable for huge archives.
<br>


=item L<Hash::Util::Pick>

Author: L<PINE|https://metacpan.org/author/PINE>

One can easily use this idiom instead:
<br><br>$picked = { map {(exists $hash{$I<} ? ($>=&gt;$hash{$I<< }):())} @keys };
<br><br>or:
<br><br>$picked = { map {$ >>=&gt;$hash{$I<}} grep {exists $hash{$>}} @keys };
<br><br>or (if you want non-existing picked keys to be created instead):
<br><br>$picked = { map {$_ =&gt; $hash{$_}} @keys };
<br><br>but Hash::Util::Pick is implemented in XS and can be a few times faster than the above when the number of keys has reached thousands. So I guess this module has its uses.


=item L<NetObj::IPv4Address>

Author: L<HEEB|https://metacpan.org/author/HEEB>

Cons: more heavyweight (requires Moo), limited operations/methods, can only handle IPv4 and not IPv6. Pros: some operations are faster than competing modules, e.g. validation. See also: NetAddr::IP, Net::CIDR.
<br>


=item L<NetObj::MacAddress>

Author: L<HEEB|https://metacpan.org/author/HEEB>

Aside from being Moo-based (which, makes it a bit more heavyweight and with more dependencies), doesn't yet offer anything extra or more methods compared to previously existing modules like NetAddr::MAC.


Rating: 4/10

=item L<Acme::AsciiArtinator>

Author: L<MOB|https://metacpan.org/author/MOB>

Cool. Now you can create your own Camel Code with ease!


=item L<Object::Simple>

Author: L<KIMOTO|https://metacpan.org/author/KIMOTO>

I'd say in terms of footprint and runtime performance, this module is average (it's not the most lightweight nor the fastest pure-perl object system, not to mention against XS ones). See my Bencher::Scenarios::Accessors for a comparison, e.g. <a href="https://metacpan.org/pod/Bencher::Scenario::Accessors::Get" rel="nofollow">metacpan.org/pod/Bencher::Scenario::A...</a> and <a href="https://metacpan.org/pod/Bencher::Scenario::Accessors::Set" rel="nofollow">metacpan.org/pod/Bencher::Scenario::A...</a> .
<br><br>One drawback of using Mojo::Base and Object::Simple is its similar but slightly different and incompatible syntax with the Moo* family, so your code is not &quot;upgradable&quot; to Moo or Moose once you need more features. And often you'll end up wanting them, e.g. one day you'll probably read about the wonders of method modifiers (before, after, around), or roles, or wanting to have a lazy constructor, or triggers, and so on.
<br><br>I'd recommend instead Mo. It's more lightweight than Object::Simple and you can do default value, builder, ro/rw, required, even coercion. But the features are modular and you only pay for what you use. And once you need more features later, you normally should be able to just replace 'use Mo' in your code with 'use Moo' or 'use Moose'.
<br><br>Of course, this point is moot if you don't care about compatibility/upgradability to Moo*.


Rating: 6/10

=item L<Test::Needs>

Author: L<HAARG|https://metacpan.org/author/HAARG>

Nice. API is more convenient to use than Test::Requires, especially if you use subtests.
<br>


=item L<HTTP::Command::Wrapper>

Author: L<PINE|https://metacpan.org/author/PINE>

There are a few use-cases where this would be useful (mostly, to access https websites in the absence of required perl library like LWP::Protocol::https), but it would be more useful to provide an API that is already familiar to Perl programmers. That's why MIYAGAWA created HTTP::Tinyish.


=item L<File::Util>

Author: L<TOMMY|https://metacpan.org/author/TOMMY>

Point for documentation (lots of examples and cookbook). But the recipes in the cookbook currently don't really entice me to use the module. Let's see:
<br><br>1) batch file rename: it's much simpler to use 'rename' or 'perlmv' utility. Or, it's much shorter to just use plain perl like 'for (grep {-f} &lt;*&gt;) { rename $I<< , s/.log$/.txt/r }'.
<br><br>2) recursively remove a directory tree: it's much shorter to just use 'File::Path::remove >>tree()'.
<br><br>3) increment a counter file: no locking (it's classic 1990's counter.cgi race condition all over again). Take a look at, for example, The Perl Cookbook chapter 7.11. Or I think one of Randal Schwartz's articles.
<br><br>As an alternative, one can also take a look at Path::Tiny.


=item L<Common::Routine>

Author: L<PEKINGSAM|https://metacpan.org/author/PEKINGSAM>

A couple of comments:
<br><br>* Some functions like min(), max(), etc need not be reinvented because they are already in core module List::Util. But I guess the author wants to be able to say min([1,2,3]) in addition to min(1,2,3).
<br><br>* round() uses Number::Format, note that rounding number using this module is hundreds of times slower than using sprintf().
<br><br>


=item L<Submodules>

Author: L<ZARABOZO|https://metacpan.org/author/ZARABOZO>

A couple of prior arts:
<br><br>* all, <a href="https://metacpan.org/pod/all" rel="nofollow">metacpan.org/pod/all</a> (since 2003), nicer interface and offers &quot;use&quot;/compile-time interface, so it's more equivalent to the statements it wants to replace. The Submodules equivalent would be: BEGIN { for my $i (Submodules-&gt;find(&quot;Blah&quot;)) { $i-&gt;require } }.
<br><br>* Module::Require, <a href="https://metacpan.org/pod/Module::Require" rel="nofollow">metacpan.org/pod/Module::Require</a> (since 2001), also nicer interface, more flexible, and more lightweight implementation.
<br><br>I don't like Submodules' interface, it's too verbose and clunky. IMO, the interface should be a one-liner and without manual looping. 


=item L<Regexp::Assemble>

Author: L<RSAVAGE|https://metacpan.org/author/RSAVAGE>

I guess it depends on your data, but for random shortish strings (hundreds to thousands of them), I find that using raw joining is much faster to assemble the regex. And the resulting regex is also (much) faster to match. Please see Bencher::Scenario::RegexpAssemble if you're interested in the benchmark script.


=item L<Tie::Scalar::Callback>

Author: L<DFARRELL|https://metacpan.org/author/DFARRELL>

There is a prior art Tie::Simple (created in 2004) which works for scalar as well as the other types of ties that perl supports (array, hash, handle).
<br>


=item L<JSON::Create>

Author: L<BKB|https://metacpan.org/author/BKB>

Review for 0.02: Performance-wise, still has some catching up to do against JSON::XS &amp; Cpanel::JSON::XS with regards to encoding arrays &amp; hashes.
<br><br>UPDATE review for 0.19: Giving it 4 stars now. Speed has been improving and on-par/slightly better than the other JSON XS modules in some areas, while a bit worse in some other areas. Faster modules are always welcome.


Rating: 8/10

=item L<Set::Scalar>

Author: L<DAVIDO|https://metacpan.org/author/DAVIDO>

Confirming previous reviewer, the module is a lot slower (~ 20-40x) than other alternatives like Array::Utils or List::MoreUtils when you want to perform basic set operations like union/intersect/diff/symmetric diff.


=item L<Exporter::Easy>

Author: L<NEILB|https://metacpan.org/author/NEILB>

I can see the value of Exporter::Easy (although these days the saving in typing is not as big, with plain Exporter one can just say: use Exporter 'import'; our @EXPORT = qw(a b c)).
<br><br>However I fail to see the value of Exporter::Easiest. I'd rather use plain Perl than some DDL which cannot be checked statically or cannot be syntax-highlighted, just to save some []'s and ()'s (which I can get my editor to help me type them).
<br><br>In short, I'd rather use plain Exporter than save a few keystrokes but add a non-core dependency.


Rating: 6/10

=item L<App::cpm>

Author: L<SKAJI|https://metacpan.org/author/SKAJI>

Due to parallel processes and defaulting on no_test, can be several times faster than cpanminus (tried installing a module on a vanilla perlbrew instance with local CPAN mirror, which pulled +- 200 distributions, &quot;cpanm -n&quot; took 2m9s, while cpm took 38s.) I hope this gets developed further. Great job.
<br>


=item L<Zodiac::Chinese>

Author: L<CAVAC|https://metacpan.org/author/CAVAC>

From the doc: &quot;This module generates one's Chinese zodiac. However, for those born in late January to early February, it may be wrong.&quot; Well, a module that might return wrong results is not very useful.
<br>


Rating: 2/10

=item L<JSON::MultiValueOrdered>

Author: L<TOBYINK|https://metacpan.org/author/TOBYINK>

I guess if you want to switch JSON implementation more easily with JSON, JSON::PP, and JSON::XS, it's better to use JSON::Tiny::Subclassable instead of JSON::Tiny, because the interface is more similar to JSON{::XS,::PP}, although it's not exactly the same. JT:Subclassable also supports pretty() which is often used when debugging. In short, I found JSON::Tiny::Subclassable is a better &quot;Tiny JSON&quot; module than JSON::Tiny.


=item L<JSON::Tiny>

Author: L<DAVIDO|https://metacpan.org/author/DAVIDO>

Ah, the many JSON implementation modules out there... 
<br><br>I guess if you want to switch JSON implementation more easily with JSON, JSON::PP, and JSON::XS, it's better to use JSON::Tiny::Subclassable instead of JSON::Tiny, because the interface is more similar to JSON{::XS,::PP}, although it's not exactly the same.
<br><br>


=item L<Devel::Confess>

Author: L<HAARG|https://metacpan.org/author/HAARG>

Provides some more features compared to Carp::Always, like producing stack trace even when exception is ref/object, color &amp; dump function arguments (so you don't need a separate Carp::Always::Dump and Carp::Always::Color). Recommended.
<br>


=item L<Carp::Always>

Author: L<FERREIRA|https://metacpan.org/author/FERREIRA>

This module works well for string exceptions (e.g. die &quot;some message&quot;), but for ref/object exceptions (e.g. die [404,&quot;Not found&quot;] or die $some_object) it will simply print/return the ref/object and thus no stack trace information is produced.
<br><br>See also Devel::Confess, which can handle ref/object.
<br><br>References: 
<br>
<a href="http://blogs.perl.org/users/graham_knop/2013/09/carp-always-evenobjects.html" rel="nofollow">blogs.perl.org/users/graham_knop/2013...</a>


=item L<experimental>

Author: L<LEONT|https://metacpan.org/author/LEONT>

Our prayer has been answered. experimental was added to perl core in 5.19.11


=item L<Exporter::Lite>

Author: L<NEILB|https://metacpan.org/author/NEILB>

Mostly unnecessary. The main premise of this module is that you don't need to inherit to use it. But you also can use Exporter (a core module, BTW) without inherinting it:
<br><br>use Exporter qw(import);
<br>


=item L<Date::Holidays>

Author: L<JONASBN|https://metacpan.org/author/JONASBN>

The idea is good, but a couple of things prevents me from using this interface.
<br><br>First, the use of TryCatch (which brings the Moose ecosystem) makes the startup overhead too high for my taste (about 0.5s on my PC). Which is rather unfortunate because Date::Holidays itself does not use Moose.
<br><br>Second, the interface assumes that a country has a single set of holidays, which is too restrictive in some cases. A more flexible/general interface would allow adding more calendars based not only on country but also religion, special community, organization, etc. And allow adding custom calendars.
<br>


=item L<Furl>

Author: L<SYOHEX|https://metacpan.org/author/SYOHEX>

@Kira S (I wish cpanratings adds a feature to comment on a review):
<br><br>Comparing WWW::Mechanize with Furl is not really apples-to-apples, since Furl does not support parsing/following links or form processing. As the Furl POD itself suggests, Furl is positioned as a faster alternative to LWP, not WWW::Mechanize.


=item L<Lingua::EN::Inflect>

Author: L<DCONWAY|https://metacpan.org/author/DCONWAY>

Just add this review to link to Ben Bullock's Lingua::EN::PluralToSingular if you need to go the other way (converting English noun from plural to singular).
<br><br>BTW, I don't like the interface either, and wonder why the Env module needs to be involved. 
<br>


=item L<Lingua::EN::PluralToSingular>

Author: L<BKB|https://metacpan.org/author/BKB>

Not perfect or exhaustive, but good enough and lightweight. With a dead-simple interface. Just the sort of libraries that are reusable almost everywhere. Thanks for this.
<br><br>Also, this might not be immediately obvious since there's no mention on the See Also section: to go the other way (converting English noun from singular to plural) you can use Lingua::EN::Inflect.


=item L<Log::Declare>

Author: L<CHGOVUK|https://metacpan.org/author/CHGOVUK>

I haven't used or evaluated this module in detail, but if there is one advantage to using procedural/command syntax:
<br><br>info blah;
<br><br>as opposed to object syntax:
<br><br>$log-&gt;info(blah);
<br><br>then this module clearly demonstrates it. Using Devel::Declare (or the Perl 5.14+ keyword API), the former can be easily rewritten as something like:
<br><br>info &amp;&amp; blah;
<br><br>or:
<br><br>if (CONST_LOG_INFO) { info blah }
<br><br>and during compilation, Perl can optimize the line away and we get zero run-time penalty when logging (level) is disabled.
<br><br>(Actually, it's also possible for the object syntax to get rewritten, e.g. using source filter, but it's more cumbersome).


=item L<Benchmark::Timer>

Author: L<DCOPPIT|https://metacpan.org/author/DCOPPIT>

Nice alternative module for benchmarking with a different interface than Benchmark (marking portion of code to be benchmarked with start and stop).
<br><br>For most Perl programmers familiar to the core module Benchmark, I recommend looking at Benchmark::Dumb first though. It has an interface like Benchmark (cmpthese() et all) but with some statistical confidence.


=item L<Getargs::Long>

Author: L<DCOPPIT|https://metacpan.org/author/DCOPPIT>

Nice idea, but some performance concerns. If you want to use cgetargs (the compiled, faster version), you are restricted to the getargs() interface, which only features checking for required arguments and supplying default value. In which case you might as well use Params::Validate directly as it's several times (e.g. 3-4x) faster.
<br><br>If you want to use the more featured xgetargs, there is currently no compiled version.
<br><br>All in all, I think users should take a look at Params::Validate first. 


=item L<Debug::Easy>

Author: L<RKELSCH|https://metacpan.org/author/RKELSCH>

Not as easy as the name might claim. First of all, why do users need to pass B<LINE> explicitly for every call??? Other logging modules will get this information automatically via caller(). 
<br><br>Levels are a bit confusing: why is debug split to 2 (or 3)? 
<br><br>Not as flexible as it should be because the design conflates some things together. For example, most levels output to STDERR but some level (VERBOSE) outputs to STDOUT instead. The output concern and levels should've been separated. Another example would be the DEBUGWAIT level, where level is DEBUG I<and> execution is halted (wait on a keypress) on log. What if users want a lower level setting I<but> want execution to be halted on log? The halt/keypress setting should've been separated from the level.


Rating: 4/10

=item L<File::Slurper>

Author: L<LEONT|https://metacpan.org/author/LEONT>

Who'da thought that something as seemingly simple as &quot;slurping a file into a string&quot; would need several modules and false starts? Well, if you add encodings, Perl I/O layers, scalar/list context, DWIM-ness, ... it can get complex and buggy. I'm glad there are people taking care of this and making sure that a simple task stays simple and correct. 


=item L<File::Slurp>

Author: L<CAPOEIRAB|https://metacpan.org/author/CAPOEIRAB>

Use the newer File::Slurper instead, which has a clearer API (e.g. text vs binary, array/lines vs string) and encoding default. It's arguably &quot;saner&quot; than File::Slurp and File::Slurp::Tiny.
<br>


=item L<File::Slurp::Tiny>

Author: L<LEONT|https://metacpan.org/author/LEONT>

Use the newer File::Slurper instead, which has a clearer API (e.g. text vs binary, array/lines vs string) and encoding default. It's arguably &quot;saner&quot; than File::Slurp and File::Slurp::Tiny.
<br>


=item L<Perl::PrereqScanner::Lite>

Author: L<MOZNION|https://metacpan.org/author/MOZNION>

A significantly faster alternative to Perl::PrereqScanner. It's I<almost> a drop-in replacement, there might still be some bugs in missing detecting some modules, and you still have to do several add_extra_scanner() calls like $scanner-&gt;add_extra_scanner('Moose') to match the behavior of Perl::PrereqScanner.
<br><br>


=item L<Logfile::Rotate>

Author: L<PAULG|https://metacpan.org/author/PAULG>

First file rotating module I found and tried. Works, but needs to be modernized a bit. Indirect object notation in doc should be replaced. Bool option takes &quot;yes&quot; or &quot;no&quot;, should perhaps be 1 or 0. Capitalization adjustment, perhaps.
<br><br>


Rating: 6/10

=item L<File::ReadBackwards>

Author: L<PLICEASE|https://metacpan.org/author/PLICEASE>

At the time of this review, I find two modules for reading a file backwards: File::Bidirectional (FBidi) and File::ReadBackwards (FRB).
<br><br>Both modules have roughly the same footprint and minimal dependencies. Both provide OO as well as tie interface. Both respect the $/ setting.
<br><br>FRB pro's:
<br>
- FRB is 15-20% faster than FBidi when reading backwards;
<br><br>FRB con's:
<br>
- does not offer the feature of reading forward as well, but of course this is not the goal of the module.
<br><br>FBidi's POD contains information on benchmarks (it's roughly an order of magnitude slower than raw Perl's open+read/diamond operator, still the case in 2014). While FRB's POD contains information on how the thing works behind the scenes.
<br><br>In summary, both modules are roughly the same. I'd prefer FRB unless in the rarer cases where I need bidirectional reading.
<br>


Rating: 8/10

=item L<File::Bidirectional>

Author: L<KIANWIN|https://metacpan.org/author/KIANWIN>

At the time of this review, I find two modules for reading a file backwards: File::Bidirectional (FBidi) and File::ReadBackwards (FRB).
<br><br>Both modules have roughly the same footprint and minimal dependencies. Both provide OO as well as tie interface. Both respect the $/ setting.
<br><br>FBidi pro's:
<br>
- has the unique feature of reading backward/forward and switch direction in the middle;
<br><br>FBidi con's:
<br>
- FBidi is 15-20% slower than FBidi when reading backwards;
<br>
- reading forward is just as slow as backward, so if you only need to read forward, obviously there's no need to use this module;
<br><br>FBidi's POD contains information on benchmarks (it's roughly an order of magnitude slower than raw Perl's open+read/diamond operator, still the case in 2014). While FRB's POD contains information on how the thing works behind the scenes.
<br><br>In summary, both modules are roughly the same. I'd prefer FRB unless in the rarer cases where I need bidirectional reading.
<br>


Rating: 8/10

=item L<Signal::StackTrace::CarpLike>

Author: L<SARTAK|https://metacpan.org/author/SARTAK>

Nice, but Signal::StackTrace should've output something carp-like in the first place.


=item L<Devel::Messenger>

Author: L<KOLIBRIE|https://metacpan.org/author/KOLIBRIE>

I think this is basically logging under a fancy name and with a more cumbersome interface. Look at Log::Any instead.


=item L<Term::Twiddle>

Author: L<SCOTTW|https://metacpan.org/author/SCOTTW>

Cute! I didn't know SIGALRM still works even though you're doing blocking I/O or calling other programs. But unfortunately it doesn't work if you sleep(), making this approach not as attractive.
<br>


=item L<CHI>

Author: L<ASB|https://metacpan.org/author/ASB>

The move to Moo is very welcome, but I wish there were an alternative of CHI which is even more lightweight (starts in under 0.01s). CHI::Tiny, anyone?


=item L<App::YTDL>

Bit of a shame that we currently don't have a working YouTube download script/module (WWW::YouTube::Download is last updated 2013 and has been broken for a long while). This module actually requires another I<Python> script to do its job. I might as well skip this and go straight to the Python script.
<br><br>UPDATE 2016-03-04: I guess it's been so for a few years, but this still needs to be said: For downloading YouTube videos, use youtube-dl (a far more popular Python project) and just forget the rest. Keeping up with YouTube changes is many times a full time job. Nothing else comes remotely close. 


=item L<XXX>

Author: L<INGY|https://metacpan.org/author/INGY>

The part that makes this module convenient is that the functions return their original arguments. So when debugging (peppering dump statements), you don't have to change this:
<br><br>return [&quot;some&quot;, $expr];
<br><br>to this (taking an example from another dumping module, Data::Dump):
<br><br>my $tmp = [&quot;some&quot;, $expr]; dd $tmp; return $tmp;
<br><br>but just this:
<br><br>return YYY [&quot;some&quot;, $expr];
<br><br>This should be imitated by the other dumper functions.


=back

=head1 FAQ

=head2 What is an Acme::CPANModules::* module?

An Acme::CPANModules::* module, like this module, contains just a list of module
names that share a common characteristics. It is a way to categorize modules and
document CPAN. See L<Acme::CPANModules> for more details.

=head2 What are ways to use this Acme::CPANModules module?

Aside from reading this Acme::CPANModules module's POD documentation, you can
install all the listed modules (entries) using L<cpanm-cpanmodules> script (from
L<App::cpanm::cpanmodules> distribution):

 % cpanm-cpanmodules -n Import::CPANRatings::User::perlancar

Alternatively you can use the L<cpanmodules> CLI (from L<App::cpanmodules>
distribution):

    % cpanmodules ls-entries Import::CPANRatings::User::perlancar | cpanm -n

or L<Acme::CM::Get>:

    % perl -MAcme::CM::Get=Import::CPANRatings::User::perlancar -E'say $_->{module} for @{ $LIST->{entries} }' | cpanm -n

or directly:

    % perl -MAcme::CPANModules::Import::CPANRatings::User::perlancar -E'say $_->{module} for @{ $Acme::CPANModules::Import::CPANRatings::User::perlancar::LIST->{entries} }' | cpanm -n

This Acme::CPANModules module also helps L<lcpan> produce a more meaningful
result for C<lcpan related-mods> command when it comes to finding related
modules for the modules listed in this Acme::CPANModules module.
See L<App::lcpan::Cmd::related_mods> for more details on how "related modules"
are found.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANModules-Import-CPANRatings-User-perlancar>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANModules-Import-CPANRatings-User-perlancar>.

=head1 SEE ALSO

L<Acme::CPANModules> - about the Acme::CPANModules namespace

L<cpanmodules> - CLI tool to let you browse/view the lists

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2018 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANModules-Import-CPANRatings-User-perlancar>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
