/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.atp;

import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.DateUtil;

public class WorkdayCalculator {
    public static final WorkdayCalculator instance = new WorkdayCalculator();

    private WorkdayCalculator() {
    }

    public int calculateWorkdays(double start, double end, double[] holidays) {
        int saturdaysPast = this.pastDaysOfWeek(start, end, 7);
        int sundaysPast = this.pastDaysOfWeek(start, end, 1);
        int nonWeekendHolidays = this.calculateNonWeekendHolidays(start, end, holidays);
        return (int)(end - start + 1.0) - saturdaysPast - sundaysPast - nonWeekendHolidays;
    }

    public Date calculateWorkdays(double start, int workdays, double[] holidays) {
        Date startDate = DateUtil.getJavaDate(start);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(startDate);
        endDate.add(6, workdays);
        int skippedDays = 0;
        do {
            double end = DateUtil.getExcelDate(endDate.getTime());
            int saturdaysPast = this.pastDaysOfWeek(start, end, 7);
            int sundaysPast = this.pastDaysOfWeek(start, end, 1);
            int nonWeekendHolidays = this.calculateNonWeekendHolidays(start, end, holidays);
            skippedDays = saturdaysPast + sundaysPast + nonWeekendHolidays;
            endDate.add(6, skippedDays);
            start = end + (double)this.isNonWorkday(end, holidays);
        } while (skippedDays != 0);
        return endDate.getTime();
    }

    protected int pastDaysOfWeek(double start, double end, int dayOfWeek) {
        int pastDaysOfWeek = 0;
        int endDay = (int)Math.floor(end > start ? end : start);
        for (int startDay = (int)Math.floor(start < end ? start : end); startDay <= endDay; ++startDay) {
            Calendar today = Calendar.getInstance();
            today.setTime(DateUtil.getJavaDate(startDay));
            if (today.get(7) != dayOfWeek) continue;
            ++pastDaysOfWeek;
        }
        return start < end ? pastDaysOfWeek : -pastDaysOfWeek;
    }

    protected int calculateNonWeekendHolidays(double start, double end, double[] holidays) {
        int nonWeekendHolidays = 0;
        double startDay = start < end ? start : end;
        double endDay = end > start ? end : start;
        for (int i = 0; i < holidays.length; ++i) {
            if (!this.isInARange(startDay, endDay, holidays[i]) || this.isWeekend(holidays[i])) continue;
            ++nonWeekendHolidays;
        }
        return start < end ? nonWeekendHolidays : -nonWeekendHolidays;
    }

    protected boolean isWeekend(double aDate) {
        Calendar date = Calendar.getInstance();
        date.setTime(DateUtil.getJavaDate(aDate));
        return date.get(7) == 7 || date.get(7) == 1;
    }

    protected boolean isHoliday(double aDate, double[] holidays) {
        for (int i = 0; i < holidays.length; ++i) {
            if (Math.round(holidays[i]) != Math.round(aDate)) continue;
            return true;
        }
        return false;
    }

    protected int isNonWorkday(double aDate, double[] holidays) {
        return this.isWeekend(aDate) || this.isHoliday(aDate, holidays) ? 1 : 0;
    }

    protected boolean isInARange(double start, double end, double aDate) {
        return aDate >= start && aDate <= end;
    }
}

