/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.util.InternationalString;

@XmlType(name="MI_Platform_Type", propOrder={"citation", "identifier", "description", "sponsors", "instruments"})
@XmlRootElement(name="MI_Platform")
public class DefaultPlatform
extends ISOMetadata
implements Platform {
    private static final long serialVersionUID = -1607271701134014369L;
    private Citation citation;
    private InternationalString description;
    private Collection<ResponsibleParty> sponsors;
    private Collection<Instrument> instruments;

    public DefaultPlatform() {
    }

    public DefaultPlatform(Platform platform) {
        super(platform);
        if (platform != null) {
            this.citation = platform.getCitation();
            this.identifiers = this.singleton(platform.getIdentifier(), Identifier.class);
            this.description = platform.getDescription();
            this.sponsors = this.copyCollection(platform.getSponsors(), ResponsibleParty.class);
            this.instruments = this.copyCollection(platform.getInstruments(), Instrument.class);
        }
    }

    public static DefaultPlatform castOrCopy(Platform platform) {
        if (platform == null || platform instanceof DefaultPlatform) {
            return (DefaultPlatform)platform;
        }
        return new DefaultPlatform(platform);
    }

    @Override
    @XmlElement(name="citation")
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation citation) {
        this.checkWritePermission();
        this.citation = citation;
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return NonMarshalledAuthority.getMarshallable(this.identifiers);
    }

    public void setIdentifier(Identifier identifier) {
        this.checkWritePermission();
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        NonMarshalledAuthority.setMarshallable(this.identifiers, identifier);
    }

    @Override
    @XmlElement(name="description", required=true)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @XmlElement(name="sponsor")
    public Collection<ResponsibleParty> getSponsors() {
        this.sponsors = this.nonNullCollection(this.sponsors, ResponsibleParty.class);
        return this.sponsors;
    }

    public void setSponsors(Collection<? extends ResponsibleParty> collection) {
        this.sponsors = this.writeCollection(collection, this.sponsors, ResponsibleParty.class);
    }

    @XmlElement(name="instrument", required=true)
    public Collection<Instrument> getInstruments() {
        this.instruments = this.nonNullCollection(this.instruments, Instrument.class);
        return this.instruments;
    }

    public void setInstruments(Collection<? extends Instrument> collection) {
        this.instruments = this.writeCollection(collection, this.instruments, Instrument.class);
    }
}

