/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.distribution.StandardOrderProcess;

@XmlType(name="MD_Distributor_Type", propOrder={"distributorContact", "distributionOrderProcesses", "distributorFormats", "distributorTransferOptions"})
@XmlRootElement(name="MD_Distributor")
public class DefaultDistributor
extends ISOMetadata
implements Distributor {
    private static final long serialVersionUID = 5706757156163948001L;
    private ResponsibleParty distributorContact;
    private Collection<StandardOrderProcess> distributionOrderProcesses;
    private Collection<Format> distributorFormats;
    private Collection<DigitalTransferOptions> distributorTransferOptions;

    public DefaultDistributor() {
    }

    public DefaultDistributor(ResponsibleParty responsibleParty) {
        this.distributorContact = responsibleParty;
    }

    public DefaultDistributor(Distributor distributor) {
        super(distributor);
        if (distributor != null) {
            this.distributorContact = distributor.getDistributorContact();
            this.distributionOrderProcesses = this.copyCollection(distributor.getDistributionOrderProcesses(), StandardOrderProcess.class);
            this.distributorFormats = this.copyCollection(distributor.getDistributorFormats(), Format.class);
            this.distributorTransferOptions = this.copyCollection(distributor.getDistributorTransferOptions(), DigitalTransferOptions.class);
        }
    }

    public static DefaultDistributor castOrCopy(Distributor distributor) {
        if (distributor == null || distributor instanceof DefaultDistributor) {
            return (DefaultDistributor)distributor;
        }
        return new DefaultDistributor(distributor);
    }

    @Override
    @XmlElement(name="distributorContact", required=true)
    public ResponsibleParty getDistributorContact() {
        return this.distributorContact;
    }

    public void setDistributorContact(ResponsibleParty responsibleParty) {
        this.checkWritePermission();
        this.distributorContact = responsibleParty;
    }

    @XmlElement(name="distributionOrderProcess")
    public Collection<StandardOrderProcess> getDistributionOrderProcesses() {
        this.distributionOrderProcesses = this.nonNullCollection(this.distributionOrderProcesses, StandardOrderProcess.class);
        return this.distributionOrderProcesses;
    }

    public void setDistributionOrderProcesses(Collection<? extends StandardOrderProcess> collection) {
        this.distributionOrderProcesses = this.writeCollection(collection, this.distributionOrderProcesses, StandardOrderProcess.class);
    }

    @XmlElement(name="distributorFormat")
    public Collection<Format> getDistributorFormats() {
        this.distributorFormats = this.nonNullCollection(this.distributorFormats, Format.class);
        return this.distributorFormats;
    }

    public void setDistributorFormats(Collection<? extends Format> collection) {
        this.distributorFormats = this.writeCollection(collection, this.distributorFormats, Format.class);
    }

    @XmlElement(name="distributorTransferOptions")
    public Collection<DigitalTransferOptions> getDistributorTransferOptions() {
        this.distributorTransferOptions = this.nonNullCollection(this.distributorTransferOptions, DigitalTransferOptions.class);
        return this.distributorTransferOptions;
    }

    public void setDistributorTransferOptions(Collection<? extends DigitalTransferOptions> collection) {
        this.distributorTransferOptions = this.writeCollection(collection, this.distributorTransferOptions, DigitalTransferOptions.class);
    }
}

