use strict;
use warnings;

BEGIN { $ENV{TABSIZE} = 8 }
use SQL::Steno;

use Test::More tests => 7;



my $sth;
# Fake DBI
{
    package DBI::st::test;
    $sth = bless {
	Active => 1,
	NAME => ["a\nz", "b\tc", "d'e", 'b"c', 'x,y', 'f:g', 'Verrrrrrrry long name indeed', 'h<t&m>l', 'a;col']
    };

    my @rows;

    sub execute {
	@rows = ([1..7, '1999-12-31 23:59:59', undef],
		 ['shift', @{$sth->{NAME}}[0..@{$sth->{NAME}}-2]],
		 ["a\r\nz", 12..16, 'x;y', '', '1970-01-01 00:00:00']);
    }

    sub fetchrow_array {
	@rows ? @{shift @rows} : ();
    }
}



sub test($$;$$) {
    $sth->execute;
    open my $fh, '>', \my $str;
    my $ofh = select $fh;
    eval { no strict 'refs'; &{"SQL::Steno::render_$_[0]"}( $sth, $_[2], $_[3] ) };
    close $fh;
    select $ofh;
    (my $exp = $_[1]) =~ s/<<</\r/g;
    my $name = join '-', $_[0], $_[3] ? sort keys %{$_[3]} : ();
    is $str, $exp, $name;
}



test tabular => <<\OUT;
a\nz |b\tc|d'e |b"c|x,y|f:g|Verrrrrrrry long name indeed
     |    |    |   |   |   |   |h<t&m>l                     |a;col    |
-----|----|----|---|---|---|---|----------------------------|---------|
1    |2   |3   |4  |5  |6  |7  |1999-12-31 24:              |\@       |
shift|a\nz|b\tc|d'e|b"c|x,y|f:g|Verrrrrrrry long name indeed|h<t&m>l  |
a\Rz |12  |13  |14 |15 |16 |x;y|                            |1970- 00:|
OUT

test tabular => <<\OUT, undef, { all => undef };
a\nz  |b\tc|d'e |b"c|x,y|f:g|Verrrrrrrry long name indeed
      |    |    |   |   |   |   |h<t&m>l                     |a;col              |
------|----|----|---|---|---|---|----------------------------|-------------------|
1     |2   |3   |4  |5  |6  |7  |1999-12-31 23:59:59         |NULL               |
shift |a\nz|b\tc|d'e|b"c|x,y|f:g|Verrrrrrrry long name indeed|h<t&m>l            |
a\r\nz|12  |13  |14 |15 |16 |x;y|                            |1970-01-01 00:00:00|
OUT

test tabular => <<\OUT, undef, { map +($_ => undef), qw(date crlf null) };
a\nz  |b\tc|d'e |b"c|x,y|f:g|Verrrrrrrry long name indeed
      |    |    |   |   |   |   |h<t&m>l                     |a;col              |
------|----|----|---|---|---|---|----------------------------|-------------------|
1     |2   |3   |4  |5  |6  |7  |1999-12-31 23:59:59         |null               |
shift |a\nz|b\tc|d'e|b"c|x,y|f:g|Verrrrrrrry long name indeed|h<t&m>l            |
a\r\nz|12  |13  |14 |15 |16 |x;y|                            |1970-01-01 00:00:00|
OUT



test csv => <<\OUT;
"a
z",b	c,d'e,"b""c","x,y",f:g,Verrrrrrrry long name indeed,h<t&m>l,a;col
1,2,3,4,5,6,7,1999-12-31 23:59:59,
shift,"a
z",b	c,d'e,"b""c","x,y",f:g,Verrrrrrrry long name indeed,h<t&m>l
"a<<<
z",12,13,14,15,16,x;y,"",1970-01-01 00:00:00
OUT

test csv => <<\OUT, undef, { semi => 0 };
"a
z";b	c;d'e;"b""c";x,y;f:g;Verrrrrrrry long name indeed;h<t&m>l;"a;col"
1;2;3;4;5;6;7;1999-12-31 23:59:59;
shift;"a
z";b	c;d'e;"b""c";x,y;f:g;Verrrrrrrry long name indeed;h<t&m>l
"a<<<
z";12;13;14;15;16;"x;y";"";1970-01-01 00:00:00
OUT

test csv => <<\OUT, undef, { tab => 1 };
"a
z"	"b	c"	d'e	"b""c"	x,y	f:g	Verrrrrrrry long name indeed	h<t&m>l	a;col
1	2	3	4	5	6	7	1999-12-31 23:59:59	
shift	"a
z"	"b	c"	d'e	"b""c"	x,y	f:g	Verrrrrrrry long name indeed	h<t&m>l
"a<<<
z"	12	13	14	15	16	x;y	""	1970-01-01 00:00:00
OUT



test yaml => <<\OUT;
- "a\nz":                       1
  b	c:                      2
  "d'e":                        3
  "b\"c":                       4
  "x,y":                        5
  "f:g":                        6
  Verrrrrrrry long name indeed: 7
  "h<t&m>l":                    "1999-12-31 23:59:59"
  a;col:                        ~
- "a\nz":                       shift
  b	c:                      |2-
    a
    z
  "d'e":                        b	c
  "b\"c":                       "d'e"
  "x,y":                        "b\"c"
  "f:g":                        "x,y"
  Verrrrrrrry long name indeed: "f:g"
  "h<t&m>l":                    Verrrrrrrry long name indeed
  a;col:                        "h<t&m>l"
- "a\nz":                       "a\r\nz"
  b	c:                      12
  "d'e":                        13
  "b\"c":                       14
  "x,y":                        15
  "f:g":                        16
  Verrrrrrrry long name indeed: x;y
  "h<t&m>l":                    
  a;col:                        "1970-01-01 00:00:00"
OUT
