/* Generated by re2c 0.13.5 on Fri Sep  7 17:09:30 2012 */
/*
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// Generate js file as follows:

/*
re2c -isc Source/WebCore/inspector/front-end/SourceCSSTokenizer.re2js \
  | sed 's|^yy\([^:]*\)*\:|case \1:|' \
  | sed 's|[*]cursor[+][+]|this._charAt(cursor++)|' \
  | sed 's|[[*][+][+]cursor|this._charAt(++cursor)|' \
  | sed 's|[*]cursor|this._charAt(cursor)|' \
  | sed 's|yych = \*\([^;]*\)|yych = this._charAt\1|' \
  | sed 's|{ gotoCase = \([^; continue; };]*\)|{ gotoCase = \1; continue; }|' \
  | sed 's|yych <= \(0x[0-9a-fA-F]*\)|yych \<\= String.fromCharCode(\1)|' \
  | sed 's|unsigned\ int|var|' \
  | sed 's|var\ yych|case 1: case 1: var yych|' > Source/WebCore/inspector/front-end/SourceCSSTokenizer.js
*/

/**
 * @constructor
 * @extends {WebInspector.SourceTokenizer}
 */
WebInspector.SourceCSSTokenizer = function()
{
    WebInspector.SourceTokenizer.call(this);

    this._propertyKeywords = WebInspector.CSSCompletions.cssPropertiesMetainfoKeySet();
    this._colorKeywords = WebInspector.CSSKeywordCompletions.colors();

    this._valueKeywords = [
        "above", "absolute", "activeborder", "activecaption", "afar", "after-white-space", "ahead", "alias", "all", "all-scroll",
        "alternate", "always", "amharic", "amharic-abegede", "antialiased", "appworkspace", "arabic-indic", "armenian", "asterisks",
        "auto", "avoid", "background", "backwards", "baseline", "below", "bidi-override", "binary", "bengali", "blink",
        "block", "block-axis", "bold", "bolder", "border", "border-box", "both", "bottom", "break-all", "break-word", "button",
        "button-bevel", "buttonface", "buttonhighlight", "buttonshadow", "buttontext", "cambodian", "capitalize", "caps-lock-indicator",
        "caption", "captiontext", "caret", "cell", "center", "checkbox", "circle", "cjk-earthly-branch", "cjk-heavenly-stem", "cjk-ideographic",
        "clear", "clip", "close-quote", "col-resize", "collapse", "compact", "condensed", "contain", "content", "content-box", "context-menu",
        "continuous", "copy", "cover", "crop", "cross", "crosshair", "currentcolor", "cursive", "dashed", "decimal", "decimal-leading-zero", "default",
        "default-button", "destination-atop", "destination-in", "destination-out", "destination-over", "devanagari", "disc", "discard", "document",
        "dot-dash", "dot-dot-dash", "dotted", "double", "down", "e-resize", "ease", "ease-in", "ease-in-out", "ease-out", "element",
        "ellipsis", "embed", "end", "ethiopic", "ethiopic-abegede", "ethiopic-abegede-am-et", "ethiopic-abegede-gez",
        "ethiopic-abegede-ti-er", "ethiopic-abegede-ti-et", "ethiopic-halehame-aa-er", "ethiopic-halehame-aa-et",
        "ethiopic-halehame-am-et", "ethiopic-halehame-gez", "ethiopic-halehame-om-et", "ethiopic-halehame-sid-et",
        "ethiopic-halehame-so-et", "ethiopic-halehame-ti-er", "ethiopic-halehame-ti-et", "ethiopic-halehame-tig", "ew-resize", "expanded",
        "extra-condensed", "extra-expanded", "fantasy", "fast", "fill", "fixed", "flat", "footnotes", "forwards", "from", "geometricPrecision",
        "georgian", "graytext", "groove", "gujarati", "gurmukhi", "hand", "hangul", "hangul-consonant", "hebrew", "help",
        "hidden", "hide", "higher", "highlight", "highlighttext", "hiragana", "hiragana-iroha", "horizontal", "hsl", "hsla", "icon", "ignore",
        "inactiveborder", "inactivecaption", "inactivecaptiontext", "infinite", "infobackground", "infotext", "inherit", "initial", "inline",
        "inline-axis", "inline-block", "inline-table", "inset", "inside", "intrinsic", "invert", "italic", "justify", "kannada", "katakana",
        "katakana-iroha", "khmer", "landscape", "lao", "large", "larger", "left", "level", "lighter", "line-through", "linear", "lines",
        "list-item", "listbox", "listitem", "local", "logical", "loud", "lower", "lower-alpha", "lower-armenian", "lower-greek",
        "lower-hexadecimal", "lower-latin", "lower-norwegian", "lower-roman", "lowercase", "ltr", "malayalam", "match", "media-controls-background",
        "media-current-time-display", "media-fullscreen-button", "media-mute-button", "media-play-button", "media-return-to-realtime-button",
        "media-rewind-button", "media-seek-back-button", "media-seek-forward-button", "media-slider", "media-sliderthumb", "media-time-remaining-display",
        "media-volume-slider", "media-volume-slider-container", "media-volume-sliderthumb", "medium", "menu", "menulist", "menulist-button",
        "menulist-text", "menulist-textfield", "menutext", "message-box", "middle", "min-intrinsic", "mix", "mongolian", "monospace", "move", "multiple",
        "myanmar", "n-resize", "narrower", "navy", "ne-resize", "nesw-resize", "no-close-quote", "no-drop", "no-open-quote", "no-repeat", "none",
        "normal", "not-allowed", "nowrap", "ns-resize", "nw-resize", "nwse-resize", "oblique", "octal", "open-quote", "optimizeLegibility",
        "optimizeSpeed", "oriya", "oromo", "outset", "outside", "overlay", "overline", "padding", "padding-box", "painted", "paused",
        "persian", "plus-darker", "plus-lighter", "pointer", "portrait", "pre", "pre-line", "pre-wrap", "preserve-3d", "progress",
        "push-button", "radio", "read-only", "read-write", "read-write-plaintext-only", "relative", "repeat", "repeat-x",
        "repeat-y", "reset", "reverse", "rgb", "rgba", "ridge", "right", "round", "row-resize", "rtl", "run-in", "running", "s-resize", "sans-serif",
        "scroll", "scrollbar", "se-resize", "searchfield", "searchfield-cancel-button", "searchfield-decoration", "searchfield-results-button",
        "searchfield-results-decoration", "semi-condensed", "semi-expanded", "separate", "serif", "show", "sidama", "single",
        "skip-white-space", "slide", "slider-horizontal", "slider-vertical", "sliderthumb-horizontal", "sliderthumb-vertical", "slow",
        "small", "small-caps", "small-caption", "smaller", "solid", "somali", "source-atop", "source-in", "source-out", "source-over",
        "space", "square", "square-button", "start", "static", "status-bar", "stretch", "stroke", "sub", "subpixel-antialiased", "super",
        "sw-resize", "table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group",
        "table-row", "table-row-group", "telugu", "text", "text-bottom", "text-top", "textarea", "textfield", "thai", "thick", "thin",
        "threeddarkshadow", "threedface", "threedhighlight", "threedlightshadow", "threedshadow", "tibetan", "tigre", "tigrinya-er", "tigrinya-er-abegede",
        "tigrinya-et", "tigrinya-et-abegede", "to", "top", "transparent", "ultra-condensed", "ultra-expanded", "underline", "up", "upper-alpha", "upper-armenian",
        "upper-greek", "upper-hexadecimal", "upper-latin", "upper-norwegian", "upper-roman", "uppercase", "urdu", "url", "vertical", "vertical-text", "visible",
        "visibleFill", "visiblePainted", "visibleStroke", "visual", "w-resize", "wait", "wave", "white", "wider", "window", "windowframe", "windowtext",
        "x-large", "x-small", "xor", "xx-large", "xx-small", "yellow", "-wap-marquee", "-webkit-activelink", "-webkit-auto", "-webkit-baseline-middle",
        "-webkit-body", "-webkit-box", "-webkit-center", "-webkit-control", "-webkit-focus-ring-color", "-webkit-grab", "-webkit-grabbing",
        "-webkit-gradient", "-webkit-inline-box", "-webkit-left", "-webkit-link", "-webkit-marquee", "-webkit-mini-control", "-webkit-nowrap", "-webkit-pictograph",
        "-webkit-right", "-webkit-small-control", "-webkit-text", "-webkit-xxx-large", "-webkit-zoom-in", "-webkit-zoom-out",
    ].keySet();

    this._scssValueKeywords = [
        "abs", "adjust-color", "adjust-hue", "alpha", "append", "ceil", "change-color", "comparable", "complement", "darken", "desaturate",
        "fade-in", "fade-out", "floor", "grayscale", "hue", "ie-hex-str", "invert", "join", "length", "lighten",
        "lightness", "max", "min", "mix", "nth", "opacify", "opacity", "percentage", "quote", "round", "saturate",
        "saturation", "scale-color", "transparentize", "type-of", "unit", "unitless", "unquote", "zip"
    ].keySet();

    this._lexConditions = {
        INITIAL: 0,
        COMMENT: 1,
        DSTRING: 2,
        SSTRING: 3
    };

    this._parseConditions = {
        INITIAL: 0,
        PROPERTY: 1,
        PROPERTY_VALUE: 2,
        AT_RULE: 3,
        AT_MEDIA_RULE: 4
    };

    this.case_INITIAL = 1000;
    this.case_COMMENT = 1002;
    this.case_DSTRING = 1003;
    this.case_SSTRING = 1004;

    this.condition = this.createInitialCondition();
}

WebInspector.SourceCSSTokenizer.SCSSAtRelatedKeywords = ["from", "if", "in", "through"].keySet();

WebInspector.SourceCSSTokenizer.MediaTypes = ["all", "aural", "braille", "embossed", "handheld", "import", "print", "projection", "screen", "tty", "tv"].keySet();

WebInspector.SourceCSSTokenizer.prototype = {
    createInitialCondition: function()
    {
        return { lexCondition: this._lexConditions.INITIAL, parseCondition: this._parseConditions.INITIAL };
    },

    /**
     * @param {boolean=} stringEnds
     */
    _stringToken: function(cursor, stringEnds)
    {
        if (this._isPropertyValue())
            this.tokenType = "css-string";
        else
            this.tokenType = null;
        return cursor;
    },

    _isPropertyValue: function()
    {
        return this._condition.parseCondition === this._parseConditions.PROPERTY_VALUE || this._condition.parseCondition === this._parseConditions.AT_RULE;
    },

    _setParseCondition: function(condition)
    {
        this._condition.parseCondition = condition;
    },

    nextToken: function(cursor)
    {
        var cursorOnEnter = cursor;
        var gotoCase = 1;
        var YYMARKER;
        while (1) {
            switch (gotoCase)
            // Following comment is replaced with generated state machine.
            
        {
            case 1: var yych;
            var yyaccept = 0;
            if (this.getLexCondition() < 2) {
                if (this.getLexCondition() < 1) {
                    { gotoCase = this.case_INITIAL; continue; };
                } else {
                    { gotoCase = this.case_COMMENT; continue; };
                }
            } else {
                if (this.getLexCondition() < 3) {
                    { gotoCase = this.case_DSTRING; continue; };
                } else {
                    { gotoCase = this.case_SSTRING; continue; };
                }
            }
/* *********************************** */
case this.case_COMMENT:

            yych = this._charAt(cursor);
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 4; continue; };
                { gotoCase = 3; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 4; continue; };
                if (yych == '*') { gotoCase = 6; continue; };
                { gotoCase = 3; continue; };
            }
case 2:
            { this.tokenType = "css-comment"; return cursor; }
case 3:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 12; continue; };
case 4:
            ++cursor;
            { this.tokenType = null; return cursor; }
case 6:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == '*') { gotoCase = 9; continue; };
            if (yych != '/') { gotoCase = 11; continue; };
case 7:
            ++cursor;
            this.setLexCondition(this._lexConditions.INITIAL);
            { this.tokenType = "css-comment"; return cursor; }
case 9:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '*') { gotoCase = 9; continue; };
            if (yych == '/') { gotoCase = 7; continue; };
case 11:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 12:
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 2; continue; };
                { gotoCase = 11; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 2; continue; };
                if (yych == '*') { gotoCase = 9; continue; };
                { gotoCase = 11; continue; };
            }
/* *********************************** */
case this.case_DSTRING:
            yych = this._charAt(cursor);
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 17; continue; };
                if (yych <= '\f') { gotoCase = 16; continue; };
                { gotoCase = 17; continue; };
            } else {
                if (yych <= '"') {
                    if (yych <= '!') { gotoCase = 16; continue; };
                    { gotoCase = 19; continue; };
                } else {
                    if (yych == '\\') { gotoCase = 21; continue; };
                    { gotoCase = 16; continue; };
                }
            }
case 15:
            { return this._stringToken(cursor); }
case 16:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 23; continue; };
case 17:
            ++cursor;
case 18:
            { this.tokenType = null; return cursor; }
case 19:
            ++cursor;
case 20:
            this.setLexCondition(this._lexConditions.INITIAL);
            { return this._stringToken(cursor, true); }
case 21:
            yych = this._charAt(++cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 22; continue; };
                    if (yych <= '&') { gotoCase = 18; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych <= '[') { gotoCase = 18; continue; };
                    } else {
                        if (yych != 'b') { gotoCase = 18; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych >= 'g') { gotoCase = 18; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 22; continue; };
                        if (yych <= 'q') { gotoCase = 18; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych <= 's') { gotoCase = 18; continue; };
                    } else {
                        if (yych != 'v') { gotoCase = 18; continue; };
                    }
                }
            }
case 22:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 23:
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 15; continue; };
                if (yych <= '\f') { gotoCase = 22; continue; };
                { gotoCase = 15; continue; };
            } else {
                if (yych <= '"') {
                    if (yych <= '!') { gotoCase = 22; continue; };
                    { gotoCase = 26; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 22; continue; };
                }
            }
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 22; continue; };
                    if (yych >= '\'') { gotoCase = 22; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych >= '\\') { gotoCase = 22; continue; };
                    } else {
                        if (yych == 'b') { gotoCase = 22; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych <= 'f') { gotoCase = 22; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 22; continue; };
                        if (yych >= 'r') { gotoCase = 22; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych >= 't') { gotoCase = 22; continue; };
                    } else {
                        if (yych == 'v') { gotoCase = 22; continue; };
                    }
                }
            }
            cursor = YYMARKER;
            { gotoCase = 15; continue; };
case 26:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 20; continue; };
/* *********************************** */
case this.case_INITIAL:
            yych = this._charAt(cursor);
            if (yych <= ':') {
                if (yych <= '&') {
                    if (yych <= '"') {
                        if (yych <= ' ') { gotoCase = 29; continue; };
                        if (yych <= '!') { gotoCase = 31; continue; };
                        { gotoCase = 33; continue; };
                    } else {
                        if (yych <= '#') { gotoCase = 34; continue; };
                        if (yych <= '$') { gotoCase = 35; continue; };
                        if (yych >= '&') { gotoCase = 31; continue; };
                    }
                } else {
                    if (yych <= '-') {
                        if (yych <= '\'') { gotoCase = 36; continue; };
                        if (yych >= '-') { gotoCase = 37; continue; };
                    } else {
                        if (yych <= '.') { gotoCase = 38; continue; };
                        if (yych <= '/') { gotoCase = 39; continue; };
                        if (yych <= '9') { gotoCase = 40; continue; };
                        { gotoCase = 42; continue; };
                    }
                }
            } else {
                if (yych <= ']') {
                    if (yych <= '=') {
                        if (yych <= ';') { gotoCase = 44; continue; };
                        if (yych >= '=') { gotoCase = 31; continue; };
                    } else {
                        if (yych <= '?') { gotoCase = 29; continue; };
                        if (yych != '\\') { gotoCase = 31; continue; };
                    }
                } else {
                    if (yych <= 'z') {
                        if (yych == '_') { gotoCase = 31; continue; };
                        if (yych >= 'a') { gotoCase = 31; continue; };
                    } else {
                        if (yych <= '{') { gotoCase = 46; continue; };
                        if (yych == '}') { gotoCase = 48; continue; };
                    }
                }
            }
case 29:
            ++cursor;
case 30:
            { this.tokenType = null; return cursor; }
case 31:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 51; continue; };
case 32:
            {
                    var token = this._line.substring(cursorOnEnter, cursor);
                    this.tokenType = null;
                    if (this._condition.parseCondition === this._parseConditions.INITIAL || this._condition.parseCondition === this._parseConditions.PROPERTY) {
                        if (token.charAt(0) === "@") {
                            this.tokenType = "css-at-rule";
                            this._setParseCondition(token === "@media" ? this._parseConditions.AT_MEDIA_RULE : this._parseConditions.AT_RULE);
                            this._condition.atKeyword = token;
                        } else if (this._condition.parseCondition === this._parseConditions.INITIAL)
                            this.tokenType = "css-selector";
                        else if (this._propertyKeywords.hasOwnProperty(token))
                            this.tokenType = "css-property";
                    } else if (this._condition.parseCondition === this._parseConditions.AT_MEDIA_RULE || this._condition.parseCondition === this._parseConditions.AT_RULE) {
                        if (WebInspector.SourceCSSTokenizer.SCSSAtRelatedKeywords.hasOwnProperty(token))
                            this.tokenType = "css-at-rule";
                        else if (WebInspector.SourceCSSTokenizer.MediaTypes.hasOwnProperty(token))
                            this.tokenType = "css-keyword";
                    }
                    if (this.tokenType)
                        return cursor;

                    if (this._isPropertyValue()) {
                        var firstChar = token.charAt(0);
                        if (firstChar === "$")
                            this.tokenType = "scss-variable";
                        else if (firstChar === "!")
                            this.tokenType = "css-bang-keyword";
                        else if (this._condition.atKeyword === "@extend")
                            this.tokenType = "css-selector";
                        else if (this._valueKeywords.hasOwnProperty(token) || this._scssValueKeywords.hasOwnProperty(token))
                            this.tokenType = "css-keyword";
                        else if (this._colorKeywords.hasOwnProperty(token)) {
                            // FIXME: this does not convert tokens toLowerCase() for the sake of speed.
                            this.tokenType = "css-color";
                        }
                    } else if (this._condition.parseCondition !== this._parseConditions.PROPERTY_VALUE)
                        this.tokenType = "css-selector";
                    return cursor;
                }
case 33:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= '.') {
                if (yych <= '!') {
                    if (yych <= '\f') {
                        if (yych == '\n') { gotoCase = 32; continue; };
                        { gotoCase = 132; continue; };
                    } else {
                        if (yych <= '\r') { gotoCase = 32; continue; };
                        if (yych <= ' ') { gotoCase = 132; continue; };
                        { gotoCase = 130; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '"') { gotoCase = 116; continue; };
                        if (yych <= '%') { gotoCase = 132; continue; };
                        { gotoCase = 130; continue; };
                    } else {
                        if (yych == '-') { gotoCase = 130; continue; };
                        { gotoCase = 132; continue; };
                    }
                }
            } else {
                if (yych <= '\\') {
                    if (yych <= '=') {
                        if (yych <= '9') { gotoCase = 130; continue; };
                        if (yych <= '<') { gotoCase = 132; continue; };
                        { gotoCase = 130; continue; };
                    } else {
                        if (yych <= '?') { gotoCase = 132; continue; };
                        if (yych <= '[') { gotoCase = 130; continue; };
                        { gotoCase = 134; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych == '^') { gotoCase = 132; continue; };
                        { gotoCase = 130; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 132; continue; };
                        if (yych <= 'z') { gotoCase = 130; continue; };
                        { gotoCase = 132; continue; };
                    }
                }
            }
case 34:
            yych = this._charAt(++cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 30; continue; };
                if (yych <= '9') { gotoCase = 127; continue; };
                { gotoCase = 30; continue; };
            } else {
                if (yych <= 'Z') { gotoCase = 127; continue; };
                if (yych <= '`') { gotoCase = 30; continue; };
                if (yych <= 'z') { gotoCase = 127; continue; };
                { gotoCase = 30; continue; };
            }
case 35:
            yych = this._charAt(++cursor);
            if (yych <= '<') {
                if (yych <= '\'') {
                    if (yych <= ' ') { gotoCase = 30; continue; };
                    if (yych <= '"') { gotoCase = 124; continue; };
                    if (yych <= '%') { gotoCase = 30; continue; };
                    { gotoCase = 124; continue; };
                } else {
                    if (yych <= '-') {
                        if (yych <= ',') { gotoCase = 30; continue; };
                        { gotoCase = 124; continue; };
                    } else {
                        if (yych <= '.') { gotoCase = 30; continue; };
                        if (yych <= '9') { gotoCase = 124; continue; };
                        { gotoCase = 30; continue; };
                    }
                }
            } else {
                if (yych <= ']') {
                    if (yych <= '?') {
                        if (yych <= '=') { gotoCase = 124; continue; };
                        { gotoCase = 30; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 30; continue; };
                        { gotoCase = 124; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych <= '^') { gotoCase = 30; continue; };
                        { gotoCase = 124; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 30; continue; };
                        if (yych <= 'z') { gotoCase = 124; continue; };
                        { gotoCase = 30; continue; };
                    }
                }
            }
case 36:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= '.') {
                if (yych <= '"') {
                    if (yych <= '\f') {
                        if (yych == '\n') { gotoCase = 32; continue; };
                        { gotoCase = 118; continue; };
                    } else {
                        if (yych <= '\r') { gotoCase = 32; continue; };
                        if (yych <= ' ') { gotoCase = 118; continue; };
                        { gotoCase = 114; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '%') { gotoCase = 118; continue; };
                        if (yych <= '&') { gotoCase = 114; continue; };
                        { gotoCase = 116; continue; };
                    } else {
                        if (yych == '-') { gotoCase = 114; continue; };
                        { gotoCase = 118; continue; };
                    }
                }
            } else {
                if (yych <= '\\') {
                    if (yych <= '=') {
                        if (yych <= '9') { gotoCase = 114; continue; };
                        if (yych <= '<') { gotoCase = 118; continue; };
                        { gotoCase = 114; continue; };
                    } else {
                        if (yych <= '?') { gotoCase = 118; continue; };
                        if (yych <= '[') { gotoCase = 114; continue; };
                        { gotoCase = 120; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych == '^') { gotoCase = 118; continue; };
                        { gotoCase = 114; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 118; continue; };
                        if (yych <= 'z') { gotoCase = 114; continue; };
                        { gotoCase = 118; continue; };
                    }
                }
            }
case 37:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == '.') { gotoCase = 67; continue; };
            if (yych <= '/') { gotoCase = 51; continue; };
            if (yych <= '9') { gotoCase = 52; continue; };
            { gotoCase = 51; continue; };
case 38:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 30; continue; };
            if (yych <= '9') { gotoCase = 70; continue; };
            { gotoCase = 30; continue; };
case 39:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == '*') { gotoCase = 106; continue; };
            { gotoCase = 51; continue; };
case 40:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            switch (yych) {
            case '!':
            case '"':
            case '&':
            case '\'':
            case '-':
            case '/':
            case '=':
            case '@':
            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            case 'G':
            case 'I':
            case 'J':
            case 'K':
            case 'L':
            case 'M':
            case 'N':
            case 'O':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
            case 'T':
            case 'U':
            case 'V':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
            case '[':
            case ']':
            case 'a':
            case 'b':
            case 'f':
            case 'h':
            case 'j':
            case 'l':
            case 'n':
            case 'o':
            case 'q':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z':    { gotoCase = 50; continue; };
            case '%':    { gotoCase = 69; continue; };
            case '.':    { gotoCase = 67; continue; };
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':    { gotoCase = 52; continue; };
            case 'H':    { gotoCase = 54; continue; };
            case '_':    { gotoCase = 55; continue; };
            case 'c':    { gotoCase = 56; continue; };
            case 'd':    { gotoCase = 57; continue; };
            case 'e':    { gotoCase = 58; continue; };
            case 'g':    { gotoCase = 59; continue; };
            case 'i':    { gotoCase = 60; continue; };
            case 'k':    { gotoCase = 61; continue; };
            case 'm':    { gotoCase = 62; continue; };
            case 'p':    { gotoCase = 63; continue; };
            case 'r':    { gotoCase = 64; continue; };
            case 's':    { gotoCase = 65; continue; };
            case 't':    { gotoCase = 66; continue; };
            default:    { gotoCase = 41; continue; };
            }
case 41:
            {
                    if (this._isPropertyValue())
                        this.tokenType = "css-number";
                    else
                        this.tokenType = null;
                    return cursor;
                }
case 42:
            ++cursor;
            {
                    this.tokenType = null;
                    if (this._condition.parseCondition === this._parseConditions.PROPERTY || this._condition.parseCondition === this._parseConditions.INITIAL)
                        this._setParseCondition(this._parseConditions.PROPERTY_VALUE);
                    return cursor;
                }
case 44:
            ++cursor;
            {
                    this.tokenType = null;
                    this._setParseCondition(this._condition.openBraces ? this._parseConditions.PROPERTY : this._parseConditions.INITIAL);
                    delete this._condition.atKeyword;
                    return cursor;
                }
case 46:
            ++cursor;
            {
                    this.tokenType = "block-start";
                    this._condition.openBraces = (this._condition.openBraces || 0) + 1;
                    if (this._condition.parseCondition === this._parseConditions.AT_MEDIA_RULE)
                        this._setParseCondition(this._parseConditions.INITIAL);
                    else
                        this._setParseCondition(this._parseConditions.PROPERTY);
                    return cursor;
                }
case 48:
            ++cursor;
            {
                    this.tokenType = "block-end";
                    if (this._condition.openBraces > 0)
                        --this._condition.openBraces;
                    this._setParseCondition(this._condition.openBraces ? this._parseConditions.PROPERTY : this._parseConditions.INITIAL);
                    delete this._condition.atKeyword;
                    return cursor;
                }
case 50:
            ++cursor;
            yych = this._charAt(cursor);
case 51:
            if (yych <= '<') {
                if (yych <= '\'') {
                    if (yych <= ' ') { gotoCase = 32; continue; };
                    if (yych <= '"') { gotoCase = 50; continue; };
                    if (yych <= '%') { gotoCase = 32; continue; };
                    { gotoCase = 50; continue; };
                } else {
                    if (yych <= '-') {
                        if (yych <= ',') { gotoCase = 32; continue; };
                        { gotoCase = 50; continue; };
                    } else {
                        if (yych <= '.') { gotoCase = 32; continue; };
                        if (yych <= '9') { gotoCase = 50; continue; };
                        { gotoCase = 32; continue; };
                    }
                }
            } else {
                if (yych <= ']') {
                    if (yych <= '?') {
                        if (yych <= '=') { gotoCase = 50; continue; };
                        { gotoCase = 32; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 32; continue; };
                        { gotoCase = 50; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych <= '^') { gotoCase = 32; continue; };
                        { gotoCase = 50; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 32; continue; };
                        if (yych <= 'z') { gotoCase = 50; continue; };
                        { gotoCase = 32; continue; };
                    }
                }
            }
case 52:
            yyaccept = 1;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            switch (yych) {
            case '!':
            case '"':
            case '&':
            case '\'':
            case '-':
            case '/':
            case '=':
            case '@':
            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            case 'G':
            case 'I':
            case 'J':
            case 'K':
            case 'L':
            case 'M':
            case 'N':
            case 'O':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
            case 'T':
            case 'U':
            case 'V':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
            case '[':
            case ']':
            case 'a':
            case 'b':
            case 'f':
            case 'h':
            case 'j':
            case 'l':
            case 'n':
            case 'o':
            case 'q':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z':    { gotoCase = 50; continue; };
            case '%':    { gotoCase = 69; continue; };
            case '.':    { gotoCase = 67; continue; };
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':    { gotoCase = 52; continue; };
            case 'H':    { gotoCase = 54; continue; };
            case '_':    { gotoCase = 55; continue; };
            case 'c':    { gotoCase = 56; continue; };
            case 'd':    { gotoCase = 57; continue; };
            case 'e':    { gotoCase = 58; continue; };
            case 'g':    { gotoCase = 59; continue; };
            case 'i':    { gotoCase = 60; continue; };
            case 'k':    { gotoCase = 61; continue; };
            case 'm':    { gotoCase = 62; continue; };
            case 'p':    { gotoCase = 63; continue; };
            case 'r':    { gotoCase = 64; continue; };
            case 's':    { gotoCase = 65; continue; };
            case 't':    { gotoCase = 66; continue; };
            default:    { gotoCase = 41; continue; };
            }
case 54:
            yych = this._charAt(++cursor);
            if (yych == 'z') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 55:
            yych = this._charAt(++cursor);
            if (yych == '_') { gotoCase = 103; continue; };
            { gotoCase = 51; continue; };
case 56:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 57:
            yych = this._charAt(++cursor);
            if (yych == 'e') { gotoCase = 102; continue; };
            { gotoCase = 51; continue; };
case 58:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 65; continue; };
            if (yych == 'x') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 59:
            yych = this._charAt(++cursor);
            if (yych == 'r') { gotoCase = 100; continue; };
            { gotoCase = 51; continue; };
case 60:
            yych = this._charAt(++cursor);
            if (yych == 'n') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 61:
            yych = this._charAt(++cursor);
            if (yych == 'H') { gotoCase = 99; continue; };
            { gotoCase = 51; continue; };
case 62:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 65; continue; };
            if (yych == 's') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 63:
            yych = this._charAt(++cursor);
            if (yych <= 's') {
                if (yych == 'c') { gotoCase = 65; continue; };
                { gotoCase = 51; continue; };
            } else {
                if (yych <= 't') { gotoCase = 65; continue; };
                if (yych == 'x') { gotoCase = 65; continue; };
                { gotoCase = 51; continue; };
            }
case 64:
            yych = this._charAt(++cursor);
            if (yych == 'a') { gotoCase = 97; continue; };
            if (yych == 'e') { gotoCase = 98; continue; };
            { gotoCase = 51; continue; };
case 65:
            yych = this._charAt(++cursor);
            if (yych <= '<') {
                if (yych <= '\'') {
                    if (yych <= ' ') { gotoCase = 41; continue; };
                    if (yych <= '"') { gotoCase = 50; continue; };
                    if (yych <= '%') { gotoCase = 41; continue; };
                    { gotoCase = 50; continue; };
                } else {
                    if (yych <= '-') {
                        if (yych <= ',') { gotoCase = 41; continue; };
                        { gotoCase = 50; continue; };
                    } else {
                        if (yych <= '.') { gotoCase = 41; continue; };
                        if (yych <= '9') { gotoCase = 50; continue; };
                        { gotoCase = 41; continue; };
                    }
                }
            } else {
                if (yych <= ']') {
                    if (yych <= '?') {
                        if (yych <= '=') { gotoCase = 50; continue; };
                        { gotoCase = 41; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 41; continue; };
                        { gotoCase = 50; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych <= '^') { gotoCase = 41; continue; };
                        { gotoCase = 50; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 41; continue; };
                        if (yych <= 'z') { gotoCase = 50; continue; };
                        { gotoCase = 41; continue; };
                    }
                }
            }
case 66:
            yych = this._charAt(++cursor);
            if (yych == 'u') { gotoCase = 95; continue; };
            { gotoCase = 51; continue; };
case 67:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 68; continue; };
            if (yych <= '9') { gotoCase = 70; continue; };
case 68:
            cursor = YYMARKER;
            if (yyaccept <= 0) {
                { gotoCase = 32; continue; };
            } else {
                { gotoCase = 41; continue; };
            }
case 69:
            yych = this._charAt(++cursor);
            { gotoCase = 41; continue; };
case 70:
            yyaccept = 1;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'f') {
                if (yych <= 'H') {
                    if (yych <= '/') {
                        if (yych == '%') { gotoCase = 69; continue; };
                        { gotoCase = 41; continue; };
                    } else {
                        if (yych <= '9') { gotoCase = 70; continue; };
                        if (yych <= 'G') { gotoCase = 41; continue; };
                        { gotoCase = 82; continue; };
                    }
                } else {
                    if (yych <= 'b') {
                        if (yych == '_') { gotoCase = 74; continue; };
                        { gotoCase = 41; continue; };
                    } else {
                        if (yych <= 'c') { gotoCase = 76; continue; };
                        if (yych <= 'd') { gotoCase = 79; continue; };
                        if (yych >= 'f') { gotoCase = 41; continue; };
                    }
                }
            } else {
                if (yych <= 'm') {
                    if (yych <= 'i') {
                        if (yych <= 'g') { gotoCase = 80; continue; };
                        if (yych <= 'h') { gotoCase = 41; continue; };
                        { gotoCase = 78; continue; };
                    } else {
                        if (yych == 'k') { gotoCase = 83; continue; };
                        if (yych <= 'l') { gotoCase = 41; continue; };
                        { gotoCase = 77; continue; };
                    }
                } else {
                    if (yych <= 'q') {
                        if (yych == 'p') { gotoCase = 75; continue; };
                        { gotoCase = 41; continue; };
                    } else {
                        if (yych <= 'r') { gotoCase = 73; continue; };
                        if (yych <= 's') { gotoCase = 69; continue; };
                        if (yych <= 't') { gotoCase = 81; continue; };
                        { gotoCase = 41; continue; };
                    }
                }
            }
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 69; continue; };
            if (yych == 'x') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 73:
            yych = this._charAt(++cursor);
            if (yych == 'a') { gotoCase = 93; continue; };
            if (yych == 'e') { gotoCase = 94; continue; };
            { gotoCase = 68; continue; };
case 74:
            yych = this._charAt(++cursor);
            if (yych == '_') { gotoCase = 90; continue; };
            { gotoCase = 68; continue; };
case 75:
            yych = this._charAt(++cursor);
            if (yych <= 's') {
                if (yych == 'c') { gotoCase = 69; continue; };
                { gotoCase = 68; continue; };
            } else {
                if (yych <= 't') { gotoCase = 69; continue; };
                if (yych == 'x') { gotoCase = 69; continue; };
                { gotoCase = 68; continue; };
            }
case 76:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 77:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 69; continue; };
            if (yych == 's') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 78:
            yych = this._charAt(++cursor);
            if (yych == 'n') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 79:
            yych = this._charAt(++cursor);
            if (yych == 'e') { gotoCase = 89; continue; };
            { gotoCase = 68; continue; };
case 80:
            yych = this._charAt(++cursor);
            if (yych == 'r') { gotoCase = 87; continue; };
            { gotoCase = 68; continue; };
case 81:
            yych = this._charAt(++cursor);
            if (yych == 'u') { gotoCase = 85; continue; };
            { gotoCase = 68; continue; };
case 82:
            yych = this._charAt(++cursor);
            if (yych == 'z') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 83:
            yych = this._charAt(++cursor);
            if (yych != 'H') { gotoCase = 68; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'z') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 85:
            yych = this._charAt(++cursor);
            if (yych != 'r') { gotoCase = 68; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'n') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 87:
            yych = this._charAt(++cursor);
            if (yych != 'a') { gotoCase = 68; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'd') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 89:
            yych = this._charAt(++cursor);
            if (yych == 'g') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 90:
            yych = this._charAt(++cursor);
            if (yych != 'q') { gotoCase = 68; continue; };
            yych = this._charAt(++cursor);
            if (yych != 'e') { gotoCase = 68; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 93:
            yych = this._charAt(++cursor);
            if (yych == 'd') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 94:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 69; continue; };
            { gotoCase = 68; continue; };
case 95:
            yych = this._charAt(++cursor);
            if (yych != 'r') { gotoCase = 51; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'n') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 97:
            yych = this._charAt(++cursor);
            if (yych == 'd') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 98:
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 99:
            yych = this._charAt(++cursor);
            if (yych == 'z') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 100:
            yych = this._charAt(++cursor);
            if (yych != 'a') { gotoCase = 51; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'd') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 102:
            yych = this._charAt(++cursor);
            if (yych == 'g') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 103:
            yych = this._charAt(++cursor);
            if (yych != 'q') { gotoCase = 51; continue; };
            yych = this._charAt(++cursor);
            if (yych != 'e') { gotoCase = 51; continue; };
            yych = this._charAt(++cursor);
            if (yych == 'm') { gotoCase = 65; continue; };
            { gotoCase = 51; continue; };
case 106:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 110; continue; };
                { gotoCase = 106; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 110; continue; };
                if (yych != '*') { gotoCase = 106; continue; };
            }
case 108:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '*') { gotoCase = 108; continue; };
            if (yych == '/') { gotoCase = 112; continue; };
            { gotoCase = 106; continue; };
case 110:
            ++cursor;
            this.setLexCondition(this._lexConditions.COMMENT);
            { this.tokenType = "css-comment"; return cursor; }
case 112:
            ++cursor;
            { this.tokenType = "css-comment"; return cursor; }
case 114:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '.') {
                if (yych <= '"') {
                    if (yych <= '\f') {
                        if (yych == '\n') { gotoCase = 32; continue; };
                        { gotoCase = 118; continue; };
                    } else {
                        if (yych <= '\r') { gotoCase = 32; continue; };
                        if (yych <= ' ') { gotoCase = 118; continue; };
                        { gotoCase = 114; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '%') { gotoCase = 118; continue; };
                        if (yych <= '&') { gotoCase = 114; continue; };
                    } else {
                        if (yych == '-') { gotoCase = 114; continue; };
                        { gotoCase = 118; continue; };
                    }
                }
            } else {
                if (yych <= '\\') {
                    if (yych <= '=') {
                        if (yych <= '9') { gotoCase = 114; continue; };
                        if (yych <= '<') { gotoCase = 118; continue; };
                        { gotoCase = 114; continue; };
                    } else {
                        if (yych <= '?') { gotoCase = 118; continue; };
                        if (yych <= '[') { gotoCase = 114; continue; };
                        { gotoCase = 120; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych == '^') { gotoCase = 118; continue; };
                        { gotoCase = 114; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 118; continue; };
                        if (yych <= 'z') { gotoCase = 114; continue; };
                        { gotoCase = 118; continue; };
                    }
                }
            }
case 116:
            ++cursor;
            if ((yych = this._charAt(cursor)) <= '<') {
                if (yych <= '\'') {
                    if (yych <= ' ') { gotoCase = 117; continue; };
                    if (yych <= '"') { gotoCase = 50; continue; };
                    if (yych >= '&') { gotoCase = 50; continue; };
                } else {
                    if (yych <= '-') {
                        if (yych >= '-') { gotoCase = 50; continue; };
                    } else {
                        if (yych <= '.') { gotoCase = 117; continue; };
                        if (yych <= '9') { gotoCase = 50; continue; };
                    }
                }
            } else {
                if (yych <= ']') {
                    if (yych <= '?') {
                        if (yych <= '=') { gotoCase = 50; continue; };
                    } else {
                        if (yych != '\\') { gotoCase = 50; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych >= '_') { gotoCase = 50; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 117; continue; };
                        if (yych <= 'z') { gotoCase = 50; continue; };
                    }
                }
            }
case 117:
            { return this._stringToken(cursor, true); }
case 118:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 68; continue; };
                if (yych <= '\f') { gotoCase = 118; continue; };
                { gotoCase = 68; continue; };
            } else {
                if (yych <= '\'') {
                    if (yych <= '&') { gotoCase = 118; continue; };
                    { gotoCase = 123; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 118; continue; };
                }
            }
case 120:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'a') {
                if (yych <= '!') {
                    if (yych <= '\n') {
                        if (yych <= '\t') { gotoCase = 68; continue; };
                    } else {
                        if (yych != '\r') { gotoCase = 68; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '"') { gotoCase = 118; continue; };
                        if (yych <= '&') { gotoCase = 68; continue; };
                        { gotoCase = 118; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 118; continue; };
                        { gotoCase = 68; continue; };
                    }
                }
            } else {
                if (yych <= 'q') {
                    if (yych <= 'f') {
                        if (yych <= 'b') { gotoCase = 118; continue; };
                        if (yych <= 'e') { gotoCase = 68; continue; };
                        { gotoCase = 118; continue; };
                    } else {
                        if (yych == 'n') { gotoCase = 118; continue; };
                        { gotoCase = 68; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych == 's') { gotoCase = 68; continue; };
                        { gotoCase = 118; continue; };
                    } else {
                        if (yych == 'v') { gotoCase = 118; continue; };
                        { gotoCase = 68; continue; };
                    }
                }
            }
            ++cursor;
            this.setLexCondition(this._lexConditions.SSTRING);
            { return this._stringToken(cursor); }
case 123:
            yych = this._charAt(++cursor);
            { gotoCase = 117; continue; };
case 124:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '<') {
                if (yych <= '\'') {
                    if (yych <= ' ') { gotoCase = 126; continue; };
                    if (yych <= '"') { gotoCase = 124; continue; };
                    if (yych >= '&') { gotoCase = 124; continue; };
                } else {
                    if (yych <= '-') {
                        if (yych >= '-') { gotoCase = 124; continue; };
                    } else {
                        if (yych <= '.') { gotoCase = 126; continue; };
                        if (yych <= '9') { gotoCase = 124; continue; };
                    }
                }
            } else {
                if (yych <= ']') {
                    if (yych <= '?') {
                        if (yych <= '=') { gotoCase = 124; continue; };
                    } else {
                        if (yych != '\\') { gotoCase = 124; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych >= '_') { gotoCase = 124; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 126; continue; };
                        if (yych <= 'z') { gotoCase = 124; continue; };
                    }
                }
            }
case 126:
            {
                    if (this._condition.parseCondition === this._condition.parseCondition.INITIAL || this._condition.parseCondition === this._condition.parseCondition.AT_RULE)
                        this._setParseCondition(this._parseConditions.PROPERTY);
                    this.tokenType = "scss-variable";
                    return cursor;
                }
case 127:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 129; continue; };
                if (yych <= '9') { gotoCase = 127; continue; };
            } else {
                if (yych <= 'Z') { gotoCase = 127; continue; };
                if (yych <= '`') { gotoCase = 129; continue; };
                if (yych <= 'z') { gotoCase = 127; continue; };
            }
case 129:
            {
                    if (this._isPropertyValue())
                        this.tokenType = "css-color";
                    else if (this._condition.parseCondition === this._parseConditions.INITIAL)
                        this.tokenType = "css-selector";
                    else
                        this.tokenType = null;
                    return cursor;
                }
case 130:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '.') {
                if (yych <= '!') {
                    if (yych <= '\f') {
                        if (yych == '\n') { gotoCase = 32; continue; };
                    } else {
                        if (yych <= '\r') { gotoCase = 32; continue; };
                        if (yych >= '!') { gotoCase = 130; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '"') { gotoCase = 116; continue; };
                        if (yych >= '&') { gotoCase = 130; continue; };
                    } else {
                        if (yych == '-') { gotoCase = 130; continue; };
                    }
                }
            } else {
                if (yych <= '\\') {
                    if (yych <= '=') {
                        if (yych <= '9') { gotoCase = 130; continue; };
                        if (yych >= '=') { gotoCase = 130; continue; };
                    } else {
                        if (yych <= '?') { gotoCase = 132; continue; };
                        if (yych <= '[') { gotoCase = 130; continue; };
                        { gotoCase = 134; continue; };
                    }
                } else {
                    if (yych <= '_') {
                        if (yych != '^') { gotoCase = 130; continue; };
                    } else {
                        if (yych <= '`') { gotoCase = 132; continue; };
                        if (yych <= 'z') { gotoCase = 130; continue; };
                    }
                }
            }
case 132:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 68; continue; };
                if (yych <= '\f') { gotoCase = 132; continue; };
                { gotoCase = 68; continue; };
            } else {
                if (yych <= '"') {
                    if (yych <= '!') { gotoCase = 132; continue; };
                    { gotoCase = 123; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 132; continue; };
                }
            }
case 134:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'a') {
                if (yych <= '!') {
                    if (yych <= '\n') {
                        if (yych <= '\t') { gotoCase = 68; continue; };
                    } else {
                        if (yych != '\r') { gotoCase = 68; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '"') { gotoCase = 132; continue; };
                        if (yych <= '&') { gotoCase = 68; continue; };
                        { gotoCase = 132; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 132; continue; };
                        { gotoCase = 68; continue; };
                    }
                }
            } else {
                if (yych <= 'q') {
                    if (yych <= 'f') {
                        if (yych <= 'b') { gotoCase = 132; continue; };
                        if (yych <= 'e') { gotoCase = 68; continue; };
                        { gotoCase = 132; continue; };
                    } else {
                        if (yych == 'n') { gotoCase = 132; continue; };
                        { gotoCase = 68; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych == 's') { gotoCase = 68; continue; };
                        { gotoCase = 132; continue; };
                    } else {
                        if (yych == 'v') { gotoCase = 132; continue; };
                        { gotoCase = 68; continue; };
                    }
                }
            }
            ++cursor;
            this.setLexCondition(this._lexConditions.DSTRING);
            { return this._stringToken(cursor); }
/* *********************************** */
case this.case_SSTRING:
            yych = this._charAt(cursor);
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 141; continue; };
                if (yych <= '\f') { gotoCase = 140; continue; };
                { gotoCase = 141; continue; };
            } else {
                if (yych <= '\'') {
                    if (yych <= '&') { gotoCase = 140; continue; };
                    { gotoCase = 143; continue; };
                } else {
                    if (yych == '\\') { gotoCase = 145; continue; };
                    { gotoCase = 140; continue; };
                }
            }
case 139:
            { return this._stringToken(cursor); }
case 140:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 147; continue; };
case 141:
            ++cursor;
case 142:
            { this.tokenType = null; return cursor; }
case 143:
            ++cursor;
case 144:
            this.setLexCondition(this._lexConditions.INITIAL);
            { return this._stringToken(cursor, true); }
case 145:
            yych = this._charAt(++cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 146; continue; };
                    if (yych <= '&') { gotoCase = 142; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych <= '[') { gotoCase = 142; continue; };
                    } else {
                        if (yych != 'b') { gotoCase = 142; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych >= 'g') { gotoCase = 142; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 146; continue; };
                        if (yych <= 'q') { gotoCase = 142; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych <= 's') { gotoCase = 142; continue; };
                    } else {
                        if (yych != 'v') { gotoCase = 142; continue; };
                    }
                }
            }
case 146:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 147:
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 139; continue; };
                if (yych <= '\f') { gotoCase = 146; continue; };
                { gotoCase = 139; continue; };
            } else {
                if (yych <= '\'') {
                    if (yych <= '&') { gotoCase = 146; continue; };
                    { gotoCase = 150; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 146; continue; };
                }
            }
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 146; continue; };
                    if (yych >= '\'') { gotoCase = 146; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych >= '\\') { gotoCase = 146; continue; };
                    } else {
                        if (yych == 'b') { gotoCase = 146; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych <= 'f') { gotoCase = 146; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 146; continue; };
                        if (yych >= 'r') { gotoCase = 146; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych >= 't') { gotoCase = 146; continue; };
                    } else {
                        if (yych == 'v') { gotoCase = 146; continue; };
                    }
                }
            }
            cursor = YYMARKER;
            { gotoCase = 139; continue; };
case 150:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 144; continue; };
        }

        }
    },

    __proto__: WebInspector.SourceTokenizer.prototype
}
