'''OpenGL extension NV.primitive_restart

This module customises the behaviour of the 
OpenGL.raw.GL.NV.primitive_restart to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows applications to easily and inexpensively
	restart a primitive in its middle.  A "primitive restart" is simply
	the same as an End command, followed by another Begin command with
	the same mode as the original.  The typical expected use of this
	feature is to draw a mesh with many triangle strips, though primitive
	restarts are legal for all primitive types, even for points (where
	they are not useful).
	
	Although the EXT_multi_draw_arrays extension did reduce the overhead
	of such drawing techniques, they still remain more expensive than one
	would like.
	
	This extension provides an extremely lightweight primitive restart,
	which is accomplished by allowing the application to choose a special
	index number that signals that a primitive restart should occur,
	rather than a vertex being provoked.  This index can be an arbitrary
	32-bit integer for maximum application convenience.
	
	In addition, for full orthogonality, a special OpenGL command is
	provided to restart primitives when in immediate mode.  This command
	is not likely to increase performance in any significant fashion, but
	providing it greatly simplifies the specification and implementation
	of display list compilation and indirect rendering.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/primitive_restart.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.primitive_restart import *
from OpenGL.raw.GL.NV.primitive_restart import _EXTENSION_NAME

def glInitPrimitiveRestartNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION