<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>core - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Fonctionalits de Base Apache</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../de/mod/core.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="../en/mod/core.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../es/mod/core.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="../fr/mod/core.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/core.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../tr/mod/core.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Fonctionnalits de base du serveur HTTP Apache toujours
disponibles</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Core</td></tr></table>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#acceptfilter">AcceptFilter</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#acceptpathinfo">AcceptPathInfo</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#accessfilename">AccessFileName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#adddefaultcharset">AddDefaultCharset</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#allowencodedslashes">AllowEncodedSlashes</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#allowoverride">AllowOverride</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#allowoverridelist">AllowOverrideList</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cgimapextension">CGIMapExtension</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cgipassauth">CGIPassAuth</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cgivar">CGIVar</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#contentdigest">ContentDigest</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#defaultruntimedir">DefaultRuntimeDir</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#defaulttype">DefaultType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#define">Define</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#directory">&lt;Directory&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#directorymatch">&lt;DirectoryMatch&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#documentroot">DocumentRoot</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#else">&lt;Else&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#elseif">&lt;ElseIf&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#enablemmap">EnableMMAP</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#enablesendfile">EnableSendfile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#error">Error</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#errordocument">ErrorDocument</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#errorlog">ErrorLog</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#errorlogformat">ErrorLogFormat</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#extendedstatus">ExtendedStatus</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#fileetag">FileETag</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#files">&lt;Files&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#filesmatch">&lt;FilesMatch&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#forcetype">ForceType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#gprofdir">GprofDir</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#hostnamelookups">HostnameLookups</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#httpprotocoloptions">HttpProtocolOptions</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#if">&lt;If&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ifdefine">&lt;IfDefine&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ifmodule">&lt;IfModule&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#include">Include</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#includeoptional">IncludeOptional</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#keepalive">KeepAlive</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#keepalivetimeout">KeepAliveTimeout</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limit">&lt;Limit&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitexcept">&lt;LimitExcept&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitinternalrecursion">LimitInternalRecursion</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitrequestbody">LimitRequestBody</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitrequestfields">LimitRequestFields</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitrequestfieldsize">LimitRequestFieldSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitrequestline">LimitRequestLine</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitxmlrequestbody">LimitXMLRequestBody</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#location">&lt;Location&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#locationmatch">&lt;LocationMatch&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#loglevel">LogLevel</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#maxkeepaliverequests">MaxKeepAliveRequests</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#maxrangeoverlaps">MaxRangeOverlaps</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#maxrangereversals">MaxRangeReversals</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#maxranges">MaxRanges</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#mergetrailers">MergeTrailers</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#mutex">Mutex</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#namevirtualhost">NameVirtualHost</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#options">Options</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#protocol">Protocol</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#protocols">Protocols</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#protocolshonororder">ProtocolsHonorOrder</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#qualifyredirecturl">QualifyRedirectURL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#registerhttpmethod">RegisterHttpMethod</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rlimitcpu">RLimitCPU</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rlimitmem">RLimitMEM</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rlimitnproc">RLimitNPROC</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#scriptinterpretersource">ScriptInterpreterSource</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#seerequesttail">SeeRequestTail</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serveradmin">ServerAdmin</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serveralias">ServerAlias</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#servername">ServerName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serverpath">ServerPath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serverroot">ServerRoot</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serversignature">ServerSignature</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#servertokens">ServerTokens</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sethandler">SetHandler</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#setinputfilter">SetInputFilter</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#setoutputfilter">SetOutputFilter</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#timeout">TimeOut</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#traceenable">TraceEnable</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#undefine">UnDefine</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#usecanonicalname">UseCanonicalName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#usecanonicalphysicalport">UseCanonicalPhysicalPort</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#virtualhost">&lt;VirtualHost&gt;</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=core">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=core">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="#comments_section">Commentaires</a></li></ul></div>

<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="acceptfilter" id="acceptfilter">Directive</a> <a name="AcceptFilter" id="AcceptFilter">AcceptFilter</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Permet d'optimiser la configuration d'une socket pour
l'coute d'un protocole</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AcceptFilter <var>protocole</var> <var>filtre
d'acceptation</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet d'effectuer une optimisation de la socket
    d'coute d'un type de protocole en fonction du systme
    d'exploitation. Le but premier est de faire en sorte que le noyau
    n'envoie pas de socket au processus du serveur jusqu' ce que
    des donnes soient reues, ou qu'une requte HTTP complte soit mise
    en tampon. Seuls les <a href="http://www.freebsd.org/cgi/man.cgi?query=accept_filter&amp;     sektion=9">Filtres d'acceptation de FreeBSD</a>, le filtre plus
    primitif <code>TCP_DEFER_ACCEPT</code> sous Linux, et la version
    optimise d'AcceptEx() de Windows sont actuellement supports.</p>

    <p>L'utilisation de l'argument <code>none</code> va dsactiver tout
    filtre d'acceptation pour ce protocole. Ceci s'avre utile pour les
    protocoles qui ncessitent l'envoi de donnes par le serveur en
    premier, comme <code>ftp:</code> ou <code>nntp</code>:</p>
    <pre class="prettyprint lang-config">AcceptFilter nntp none</pre>


    <p>Les noms de protocoles par dfaut sont <code>https</code> pour le
    port 443 et <code>http</code> pour tous les autres ports. Pour
    spcifier un autre protocole  utiliser avec un port en coute,
    ajoutez l'argument <var>protocol</var>  la directive <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code>.</p>

    <p>Sous FreeBSD, les valeurs par dfaut sont :</p>
    <pre class="prettyprint lang-config">AcceptFilter http httpready
AcceptFilter https dataready</pre>


    <p>Le filtre d'acceptation <code>httpready</code> met en tampon des
    requtes HTTP entires au niveau du noyau. Quand une requte
    entire a t reue, le noyau l'envoie au serveur. Voir la page de
    manuel de <a href="http://www.freebsd.org/cgi/man.cgi?query=accf_http&amp;     sektion=9">accf_http(9)</a> pour plus de dtails. Comme les requtes
    HTTPS sont chiffres, celles-ci n'autorisent que le filtre <a href="http://www.freebsd.org/cgi/man.cgi?query=accf_data&amp;     sektion=9">accf_data(9)</a>.</p>

    <p>Sous Linux, les valeurs par dfaut sont :</p>
    <pre class="prettyprint lang-config">AcceptFilter http data
AcceptFilter https data</pre>


    <p>Le filtre <code>TCP_DEFER_ACCEPT</code> de Linux ne supporte pas
    la mise en tampon des requtes http. Toute valeur autre que
    <code>none</code> active le filtre <code>TCP_DEFER_ACCEPT</code>
    pour ce protocole. Pour plus de dtails, voir la page de
    manuel Linux de <a href="http://man7.org/linux/man-pages/man7/tcp.7.html">tcp(7)</a>.</p>

    <p>Sous Windows, les valeurs par dfaut sont :</p>
    <pre class="prettyprint lang-config">AcceptFilter http connect
AcceptFilter https connect</pre>


    <p>Le module MPM pour Windows mpm_winnt utilise la directive
    AcceptFilter comme commutateur de l'API AcceptEx(), et ne supporte
    pas la mise en tampon du protocole http. <code>connect</code>
    utilise l'API AcceptEx(), extrait aussi les adresses rseau finales,
    mais  l'instar de <code>none</code>, la valeur <code>connect</code>
    n'attend pas la transmission des donnes initiales.</p>

    <p>Sous Windows, <code>none</code> utilise accept() au lieu
    d'AcceptEx(), et ne recycle pas les sockets entre les connexions.
    Ceci s'avre utile pour les interfaces rseau dont le pilote est
    dfectueux, ainsi que pour certains fournisseurs de rseau comme les
    pilotes vpn, ou les filtres anti-spam, anti-virus ou
    anti-spyware.</p>

    <div class="warning">
      <h3>L'AcceptFilter <code>data</code> (Windows)</h3>

      <p>Jusqu' la version 2.4.23, le filtre d'acceptation <code>data</code>
      attendait que des donnes aient t transmises et que le tampon de donnes
      initial et l'adresse rseau finale aient t dtermins par l'invocation
      AcceptEx(). Cette implmentation tant vulnrable  une attaque de type
      denial of service, elle a t dsactive.</p>

      <p>La version actuelle de httpd prend par dfaut le filtre
      <code>connect</code> sous Windows, et reprendra la valeur
      <code>data</code> si <code>data</code> est spcifi. Il est fortement
      conseill aux utilisateurs des versions plus anciennes de dfinir
      explicitement le filtre <code>connect</code> pour leurs AcceptFilter
      comme indiqu plus haut.</p>
    </div>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#protocol">Protocol</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="acceptpathinfo" id="acceptpathinfo">Directive</a> <a name="AcceptPathInfo" id="AcceptPathInfo">AcceptPathInfo</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Les ressources acceptent des informations sous forme d'un
nom de chemin en fin de requte.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AcceptPathInfo On|Off|Default</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AcceptPathInfo Default</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>

    <p>Cette directive permet de dfinir si les requtes contenant des
    informations sous forme d'un nom de chemin suivant le nom d'un
    fichier rel (ou un fichier qui n'existe pas dans un rpertoire qui
    existe) doivent tre acceptes ou rejetes. Les scripts peuvent
    accder  cette information via la variable d'environnement
    <code>PATH_INFO</code>.</p>

    <p>Supposons par exemple que <code>/test/</code> pointe vers un
    rpertoire qui ne contient que le fichier <code>here.html</code>.
    Les requtes pour <code>/test/here.html/more</code> et
    <code>/test/nothere.html/more</code> vont affecter la valeur
    <code>/more</code>  la variable d'environnement
    <code>PATH_INFO</code>.</p>

    <p>L'argument de la directive <code class="directive">AcceptPathInfo</code>
    possde trois valeurs possibles :</p>
    <dl>
    <dt><code>Off</code></dt><dd>Une requte ne sera accepte que si
    elle correspond  un chemin qui existe. Par consquent, une requte
    contenant une information de chemin aprs le nom de fichier rel
    comme <code>/test/here.html/more</code> dans l'exemple ci-dessus
    renverra une erreur "404 NOT FOUND".</dd>

    <dt><code>On</code></dt><dd>Une requte sera accepte si la partie
    principale du chemin correspond  un fichier existant. Dans
    l'exemple ci-dessus <code>/test/here.html/more</code>, la requte
    sera accepte si <code>/test/here.html</code> correspond  un nom de
    fichier valide.</dd>

    <dt><code>Default</code></dt><dd>Le traitement des requtes est
    dtermin par le <a href="../handler.html">gestionnaire</a> responsable de la requte.
    Le gestionnaire de base pour les fichiers normaux rejette par dfaut
    les requtes avec <code>PATH_INFO</code>. Les gestionnaires qui
    servent des scripts, comme<a href="mod_cgi.html">cgi-script</a> et <a href="mod_isapi.html">isapi-handler</a>, acceptent en gnral par
    dfaut les requtes avec <code>PATH_INFO</code>.</dd>
    </dl>

    <p>Le but premier de la directive <code>AcceptPathInfo</code> est de
    vous permettre de remplacer le choix du gestionnaire d'accepter ou
    de rejeter <code>PATH_INFO</code>. Ce remplacement est ncessaire
    par exemple, lorsque vous utilisez un <a href="../filter.html">filtre</a>, comme <a href="mod_include.html">INCLUDES</a>, pour gnrer un contenu bas
    sur <code>PATH_INFO</code>. Le gestionnaire de base va en gnral
    rejeter la requte, et vous pouvez utiliser la configuration
    suivante pour utiliser un tel script :</p>
<pre class="prettyprint lang-config">&lt;Files "mypaths.shtml"&gt;
  Options +Includes
  SetOutputFilter INCLUDES
  AcceptPathInfo On
&lt;/Files&gt;</pre>

    


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="accessfilename" id="accessfilename">Directive</a> <a name="AccessFileName" id="AccessFileName">AccessFileName</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom du fichier de configuration distribu</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AccessFileName <var>nom-du-fichier</var>
[<var>nom-du-fichier</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AccessFileName .htaccess</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Au cours du traitement d'une requte, le serveur recherche le
    premier fichier de configuration existant  partir de la liste
    de noms dans chaque rpertoire composant le chemin du document, 
    partir du moment o les fichiers de configuration distribus sont <a href="#allowoverride">activs pour ce rpertoire</a>. Par exemple
    :</p>

    <pre class="prettyprint lang-config">AccessFileName .acl</pre>


    <p>avant de renvoyer le document
    <code>/usr/local/web/index.html</code>, le serveur va rechercher les
    fichiers <code>/.acl</code>, <code>/usr/.acl</code>,
    <code>/usr/local/.acl</code> et <code>/usr/local/web/.acl</code>
    pour y lire d'ventuelles directives,  moins quelles n'aient t
    dsactives avec</p>

    <pre class="prettyprint lang-config">&lt;Directory "/"&gt;
    AllowOverride None
&lt;/Directory&gt;</pre>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#allowoverride">AllowOverride</a></code></li>
<li><a href="../configuring.html">Fichiers de configuration</a></li>
<li><a href="../howto/htaccess.html">Fichiers .htaccess</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="adddefaultcharset" id="adddefaultcharset">Directive</a> <a name="AddDefaultCharset" id="AddDefaultCharset">AddDefaultCharset</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Paramtre jeu de caractres par dfaut  ajouter quand le
type de contenu d'une rponse est <code>text/plain</code> ou
<code>text/html</code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddDefaultCharset On|Off|<var>jeu de caractres</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AddDefaultCharset Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive spcifie une valeur par dfaut pour le paramtre
    jeu de caractres du type de mdia (le nom d'un codage de
    caractres)  ajouter  une rponse, si et seulement si le type de
    contenu de la rponse est soit <code>text/plain</code>, soit
    <code>text/html</code>. Ceci va remplacer
    tout jeu de caractres spcifi dans le corps de la rponse via un
    lment <code>META</code>, bien que cet effet dpende en fait
    souvent de la configuration du client de l'utilisateur. La
    dfinition de <code>AddDefaultCharset Off</code> dsactive cette
    fonctionnalit. <code>AddDefaultCharset On</code> ajoute un jeu de
    caractres par dfaut de <code>iso-8859-1</code>. Toute autre valeur
    peut tre dfinie via le paramtre <var>jeu de caractres</var>, qui
    doit appartenir  la liste des <a href="http://www.iana.org/assignments/character-sets">valeurs de
    jeux de caractres enregistrs par l'IANA</a>  utiliser dans les
    types de mdia Internet (types MIME).
    Par exemple :</p>

    <pre class="prettyprint lang-config">AddDefaultCharset utf-8</pre>


    <p>La directive <code class="directive">AddDefaultCharset</code> ne doit
    tre utilise que lorsque toutes les ressources textes auxquelles
    elle s'applique possdent le jeu de caractre spcifi, et qu'il est
    trop contraignant de dfinir leur jeu de caractres
    individuellement. Un exemple de ce type est l'ajout du paramtre jeu
    de caractres aux ressources comportant un contenu gnr, comme les
    scripts CGI hrits qui peuvent tre vulnrables  des attaques de
    type cross-site scripting  cause des donnes utilisateurs incluses
    dans leur sortie. Notez cependant qu'une meilleur solution consiste
     corriger (ou supprimer) ces scripts, car la dfinition d'un jeu de
    caractres par dfaut ne protge pas les utilisateurs qui ont activ
    la fonctionnalit "Dtection automatique de l'encodage des
    caractres" dans leur navigateur.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_mime.html#addcharset">AddCharset</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="allowencodedslashes" id="allowencodedslashes">Directive</a> <a name="AllowEncodedSlashes" id="AllowEncodedSlashes">AllowEncodedSlashes</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si les sparateurs de chemin encods sont
autoriss  transiter dans les URLs tels quels</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AllowEncodedSlashes On|Off|NoDecode</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AllowEncodedSlashes Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>L'option NoDecode est disponible depuis la version
2.3.12.</td></tr>
</table>
    <p>La directive <code class="directive">AllowEncodedSlashes</code> permet
    l'utilisation des URLs contenant des sparateurs de chemin
    encods dans la partie chemin
    (<code>%2F</code> pour <code>/</code> et mme <code>%5C</code> pour
    <code>\</code> sur les systmes concerns).</p>

    <p>Avec la valeur par dfaut, <code>Off</code>, de telles URLs sont
    refuses et provoquent le renvoi d'une erreur 404 (Not found).</p>

    <p>Avec la valeur <code>On</code>, ces URLs sont acceptes, et les
    slashes encods sont dcods comme tout autre caractre cod.</p>

    <p>Avec la valeur <code>NoDecode</code>, ces URLs sont acceptes,
    mais les slashes cods ne sont pas dcods et laisss dans leur tat
    cod.</p>

    <p>Dfinir <code class="directive">AllowEncodedSlashes</code> 
    <code>On</code> est surtout utile en association avec
    <code>PATH_INFO</code>.</p>

    <div class="note"><h3>Note</h3>
      <p>Si le codage des slashes dans la partie chemin est ncessaire,
      l'utilisation de l'option <code>NoDecode</code> est fortement
      recommande par mesure de scurit. Permettre le dcodage des
      slashes pourrait ventuellement induire l'autorisation de chemins
      non srs.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#acceptpathinfo">AcceptPathInfo</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="allowoverride" id="allowoverride">Directive</a> <a name="AllowOverride" id="AllowOverride">AllowOverride</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Types de directives autorises dans les fichiers
<code>.htaccess</code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AllowOverride All|None|<var>type directive</var>
[<var>type directive</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AllowOverride None  partir de la version 2.3.9, AllowOverride
All pour les versions antrieures</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Lorsque le serveur trouve un fichier <code>.htaccess</code> (dont
    le nom est dfini par la directive <code class="directive"><a href="#accessfilename">AccessFileName</a></code>), il doit savoir lesquelles
    des directives places dans ce fichier sont autorises  modifier la
    configuration prexistante.</p>

    <div class="note"><h3>Valable seulement dans les sections
    &lt;Directory&gt;</h3>
    La directive <code class="directive">AllowOverride</code> ne peut tre
    utilise que dans les sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> dfinies sans expressions
    rationnelles, et non dans les sections <code class="directive"><a href="#location">&lt;Location&gt;</a></code>, <code class="directive"><a href="#directorymatch">&lt;DirectoryMatch&gt;</a></code> ou
    <code class="directive"><a href="#files">&lt;Files&gt;</a></code>.
    </div>

    <p>Lorsque cette directive et la directive <code class="directive"><a href="#allowoverridelist">AllowOverrideList</a></code> sont dfinies  <code>None</code>, les
    fichiers <a href="#accessfilename">.htaccess</a> sont totalement
    ignors. Dans ce cas, le serveur n'essaiera mme pas de lire les
    fichiers <code>.htaccess</code> du systme de fichiers.</p>

    <p>Lorsque cette directive est dfinie  <code>All</code>, toute
    directive valable dans le <a href="directive-dict.html#Context">Contexte</a> .htaccess sera
    autorise dans les fichiers <code>.htaccess</code>.</p>

    <p>L'argument <var>type directive</var> peut contenir les
    groupements de directives suivants (voir <a href="overrides.html">ce
    document</a> pour obtenir la liste  jour des directives actives pour
    chaque type de directive) :</p>

    <dl>
      <dt><a href="overrides.html#override-authconfig">AuthConfig</a></dt>

      <dd>

      Permet l'utilisation des directives d'autorisation (<code class="directive"><a href="../mod/mod_authz_dbm.html#authdbmgroupfile">AuthDBMGroupFile</a></code>,
      <code class="directive"><a href="../mod/mod_authn_dbm.html#authdbmuserfile">AuthDBMUserFile</a></code>,
      <code class="directive"><a href="../mod/mod_authz_groupfile.html#authgroupfile">AuthGroupFile</a></code>,
      <code class="directive"><a href="../mod/mod_authn_core.html#authname">AuthName</a></code>,
      <code class="directive"><a href="../mod/mod_authn_core.html#authtype">AuthType</a></code>, <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code>, <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>, <em>etc...</em>).</dd>

      <dt><a href="overrides.html#override-fileinfo">FileInfo</a></dt>

      <dd>
      Permet l'utilisation des directives qui contrlent les types de
      documents (directives  <code class="directive"><a href="#errordocument">ErrorDocument</a></code>, <code class="directive"><a href="#forcetype">ForceType</a></code>, <code class="directive"><a href="../mod/mod_negotiation.html#languagepriority">LanguagePriority</a></code>,
      <code class="directive"><a href="#sethandler">SetHandler</a></code>, <code class="directive"><a href="#setinputfilter">SetInputFilter</a></code>, <code class="directive"><a href="#setoutputfilter">SetOutputFilter</a></code>, et directives du
      module <code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code> Add* et Remove*), des metadonnes
      des documents (<code class="directive"><a href="../mod/mod_headers.html#header">Header</a></code>, <code class="directive"><a href="../mod/mod_headers.html#requestheader">RequestHeader</a></code>, <code class="directive"><a href="../mod/mod_setenvif.html#setenvif">SetEnvIf</a></code>, <code class="directive"><a href="../mod/mod_setenvif.html#setenvifnocase">SetEnvIfNoCase</a></code>, <code class="directive"><a href="../mod/mod_setenvif.html#browsermatch">BrowserMatch</a></code>, <code class="directive"><a href="../mod/mod_usertrack.html#cookieexpires">CookieExpires</a></code>, <code class="directive"><a href="../mod/mod_usertrack.html#cookiedomain">CookieDomain</a></code>, <code class="directive"><a href="../mod/mod_usertrack.html#cookiestyle">CookieStyle</a></code>, <code class="directive"><a href="../mod/mod_usertrack.html#cookietracking">CookieTracking</a></code>, <code class="directive"><a href="../mod/mod_usertrack.html#cookiename">CookieName</a></code>), des directives du
      module <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> directives (<code class="directive"><a href="../mod/mod_rewrite.html#rewriteengine">RewriteEngine</a></code>, <code class="directive"><a href="../mod/mod_rewrite.html#rewriteoptions">RewriteOptions</a></code>, <code class="directive"><a href="../mod/mod_rewrite.html#rewritebase">RewriteBase</a></code>, <code class="directive"><a href="../mod/mod_rewrite.html#rewritecond">RewriteCond</a></code>, <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code>), des directives du
      module <code class="module"><a href="../mod/mod_alias.html">mod_alias</a></code> directives (<code class="directive"><a href="../mod/mod_alias.html#redirect">Redirect</a></code>, <code class="directive"><a href="../mod/mod_alias.html#redirecttemp">RedirectTemp</a></code>, <code class="directive"><a href="../mod/mod_alias.html#redirectpermanent">RedirectPermanent</a></code>, <code class="directive"><a href="../mod/mod_alias.html#redirectmatch">RedirectMatch</a></code>), et de la directive
      <code class="directive"><a href="../mod/mod_actions.html#action">Action</a></code> du module
      <code class="module"><a href="../mod/mod_actions.html">mod_actions</a></code>.
      </dd>

      <dt><a href="overrides.html#override-indexes">Indexes</a></dt>

      <dd>
      Permet l'utilisation des directives qui contrlent l'indexation
      des rpertoires (<code class="directive"><a href="../mod/mod_autoindex.html#adddescription">AddDescription</a></code>,
      <code class="directive"><a href="../mod/mod_autoindex.html#addicon">AddIcon</a></code>, <code class="directive"><a href="../mod/mod_autoindex.html#addiconbyencoding">AddIconByEncoding</a></code>,
      <code class="directive"><a href="../mod/mod_autoindex.html#addiconbytype">AddIconByType</a></code>,
      <code class="directive"><a href="../mod/mod_autoindex.html#defaulticon">DefaultIcon</a></code>, <code class="directive"><a href="../mod/mod_dir.html#directoryindex">DirectoryIndex</a></code>, <a href="mod_autoindex.html#indexoptions.fancyindexing"><code>FancyIndexing</code></a>,
      <code class="directive"><a href="../mod/mod_autoindex.html#headername">HeaderName</a></code>, <code class="directive"><a href="../mod/mod_autoindex.html#indexignore">IndexIgnore</a></code>, <code class="directive"><a href="../mod/mod_autoindex.html#indexoptions">IndexOptions</a></code>, <code class="directive"><a href="../mod/mod_autoindex.html#readmename">ReadmeName</a></code>,
      <em>etc...</em>).</dd>

      <dt><a href="overrides.html#override-limit">Limit</a></dt>

      <dd>
      Permet l'utilisation des directives contrlant l'accs au serveur
      (<code class="directive"><a href="../mod/mod_access_compat.html#allow">Allow</a></code>, <code class="directive"><a href="../mod/mod_access_compat.html#deny">Deny</a></code> et <code class="directive"><a href="../mod/mod_access_compat.html#order">Order</a></code>).</dd>

      <dt>Nonfatal=[Override|Unknown|All]</dt>

      <dd>
      Permet d'utiliser l'option AllowOverride pour rendre les erreurs
      de syntaxe non fatales dans les fichiers .htaccess : au lieu de
      causer une Internal Server Error, les directives non autorises ou
      non reconnues seront ignores et un avertissement enregistr dans
      le journal :
      <ul>
          <li><strong>Nonfatal=Override</strong> rend les directives
	  interdite par AllowOverride non fatales.</li>
          <li><strong>Nonfatal=Unknown</strong> rend les directives
	  inconnues non fatales. Sont concernes les erreurs de frappe
	  et les directives implmentes par un module non charg.</li>
          <li><strong>Nonfatal=All</strong> rend toutes les directives
	  prcdentes non fatales.</li>
      </ul>
      <p>Notez qu'une erreur de syntaxe dans une directive valide
      causera toujours une internal server error.</p>
      <div class="warning"><h3>Scurit</h3>
          Les erreurs non fatales peuvent tre  l'origine de problmes
	  de scurit pour les utilisateurs de fichiers .htaccess. Par
	  exemple, si AllowOverride interdit AuthConfig, toute
	  configuration utilisateur destine  restreindre l'accs  un
	  site ne sera pas prise en compte.
      </div>
      </dd>

      <dt><a href="overrides.html#override-options">Options</a>[=<var>Option</var>,...]</dt>

      <dd>
      Permet l'utilisation des directives contrlant les fonctionnalits
      spcifiques d'un rpertoire (<code class="directive"><a href="#options">Options</a></code> et <code class="directive"><a href="../mod/mod_include.html#xbithack">XBitHack</a></code>). "Options" doit tre
      suivi d'un signe "gal", puis d'une liste d'options spares par des
      virgules (pas d'espaces) ; ces options doivent tre dfinies 
      l'aide de la commande <code class="directive"><a href="#options">Options</a></code>.

      <div class="note"><h3>Dsactivation implicite des options</h3>
      <p>Bien que la liste des options disponibles dans les fichiers
      .htaccess puisse tre limite par cette directive, tant qu'un
      directive <code class="directive"><a href="#options">Options</a></code> est
      autorise, toute autre option hrite peut tre dsactive en
      utilisant la syntaxe non-relative. En d'autres termes, ce
      mcanisme ne peut pas forcer une option spcifique  rester
      <em>active</em> tout en permettant  toute autre option d'tre
      active.
      </p></div>

      <div class="example"><p><code>
      AllowOverride Options=Indexes,MultiViews
      </code></p></div>
      
      </dd>
    </dl>

    <p>Exemple :</p>

    <pre class="prettyprint lang-config">AllowOverride AuthConfig Indexes</pre>


    <p>Dans l'exemple ci-dessus, toutes les directives qui ne font
    partie ni du groupe <code>AuthConfig</code>, ni du groupe
    <code>Indexes</code>, provoquent une erreur "internal
    server error".</p>

    <div class="note"><p>Pour des raisons de scurit et de performance, ne
    dfinissez pas <code>AllowOverride</code>  autre chose que
    <code>None</code> dans votre bloc <code>&lt;Directory "/"&gt;</code>.
    Recherchez plutt (ou crez) le bloc <code>&lt;Directory&gt;</code>
    qui se rfre au rpertoire o vous allez prcisment placer un
    fichier <code>.htaccess</code>.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#accessfilename">AccessFileName</a></code></li>
<li><code class="directive"><a href="#allowoverridelist">AllowOverrideList</a></code></li>
<li><a href="../configuring.html">Fichiers de configuration</a></li>
<li><a href="../howto/htaccess.html">Fichiers .htaccess</a></li>
<li><a href="overrides.html">Override Class Index for .htaccess</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="allowoverridelist" id="allowoverridelist">Directive</a> <a name="AllowOverrideList" id="AllowOverrideList">AllowOverrideList</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Directives autorises dans les fichiers <code>.htaccess</code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AllowOverrideList None|<var>directive</var>
[<var>directive-type</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AllowOverrideList None</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Lorsque le serveur trouve un fichier <code>.htaccess</code>
    (comme spcifi par la directive <code class="directive"><a href="#accessfilename">AccessFileName</a></code>), il doit savoir lesquelles
    des directives dclares dans ce fichier peuvent remplacer des
    directives des fichiers de configuration du serveur.</p>

    <div class="note"><h3>Seulement disponible dans les sections &lt;Directory&gt;</h3>
    La directive <code class="directive">AllowOverrideList</code> n'est
    disponible que dans les sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> spcifies sans expressions
    rationnelles.
    </div>

    <p>Lorsque cette directive et la directive <code class="directive"><a href="#allowoverride">AllowOverride</a></code> sont dfinies 
    <code>None</code>, les fichiers <a href="#accessfilename">.htaccess</a> sont totalement ignors. Dans
    ce cas, le serveur ne cherchera mme pas  lire des fichiers
    <code>.htaccess</code> dans le systme de fichiers.</p>

    <p>Example:</p>

    <pre class="prettyprint lang-config">AllowOverride None
AllowOverrideList Redirect RedirectMatch</pre>


    <p>Dans l'exemple ci-dessus, seules les directives
    <code>Redirect</code> et <code>RedirectMatch</code> sont autorises.
    Toutes les autres provoqueront une erreur interne du serveur.</p>

    <p>Example:</p>

    <pre class="prettyprint lang-config">AllowOverride AuthConfig
AllowOverrideList CookieTracking CookieName</pre>


    <p>Dans l'exemple ci-dessus, la directive <code class="directive"><a href="#allowoverride">AllowOverride</a></code> autorise les directives du
    groupement <code>AuthConfig</code>, et
    <code class="directive">AllowOverrideList</code> n'autorise que deux
    directives du groupement <code>FileInfo</code>. Toutes les autres
    provoqueront une erreur interne du serveur.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#accessfilename">AccessFileName</a></code></li>
<li><code class="directive"><a href="#allowoverride">AllowOverride</a></code></li>
<li><a href="../configuring.html">Fichiers de configuration</a></li>
<li><a href="../howto/htaccess.html">Fichiers .htaccess</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="cgimapextension" id="cgimapextension">Directive</a> <a name="CGIMapExtension" id="CGIMapExtension">CGIMapExtension</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Technique permettant de localiser l'interprteur des
scripts CGI</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CGIMapExtension <var>chemin CGI</var> <var>.extension</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>NetWare uniquement</td></tr>
</table>
    <p>Cette directive permet de contrler la manire dont Apache httpd trouve
    l'interprteur servant  excuter les scripts CGI. Par exemple, avec
    la dfinition <code>CGIMapExtension sys:\foo.nlm .foo</code>, tous
    les fichiers scripts CGI possdant une extension <code>.foo</code>
    seront passs  l'interprteur FOO.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="cgipassauth" id="cgipassauth">Directive</a> <a name="CGIPassAuth" id="CGIPassAuth">CGIPassAuth</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la transmission d'en-ttes d'autorisation HTTP aux scripts en
tant que variables CGI</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CGIPassAuth On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CGIPassAuth Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.13 du serveur HTTP
Apache</td></tr>
</table>
    <p>La directive <code class="directive">CGIPassAuth</code> permet aux
    scripts d'accder aux en-ttes d'autorisation HTTP tels que
    <code>Authorization</code>, en-tte ncessaire aux scripts qui
    implmente une authentification HTTP de base. Normalement, ces
    en-ttes HTTP sont invisibles pour les scripts car ils leurs
    permettraient de voir les identifiants et mots de passe
    utiliss pour accder au serveur lorsque l'authentification HTTP de
    base est active au niveau du serveur web. Cette directive doit tre
    dfinie  "On" lorsque des scripts sont autoriss  implmenter une
    authentification HTTP de base.</p>

    <p>Cette directive constitue une alternative  l'option de
    compilation <code>SECURITY_HOLE_PASS_AUTHORIZATION</code> qui tait
    dj disponible dans les versions prcdentes du serveur HTTP
    Apache.</p>

    <p>Cette option est prise en compte par tout module qui utilise
    <code>ap_add_common_vars()</code>, comme <code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code>,
    <code class="module"><a href="../mod/mod_cgid.html">mod_cgid</a></code>, <code class="module"><a href="../mod/mod_proxy_fcgi.html">mod_proxy_fcgi</a></code>,
    <code class="module"><a href="../mod/mod_proxy_scgi.html">mod_proxy_scgi</a></code>, etc... En particulier, elle affecte
    les modules qui ne traitent pas  proprement parler les requtes,
    mais utilisent quand-mme cette API, comme
    <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> ou <code class="module"><a href="../mod/mod_ext_filter.html">mod_ext_filter</a></code>. Les
    modules tiers qui n'utilisent pas <code>ap_add_common_vars()</code>
    peuvent aussi choisir de prendre en compte cette option.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="cgivar" id="cgivar">Directive</a> <a name="CGIVar" id="CGIVar">CGIVar</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contrle la manire dont certaines variables CGI sont dfinies</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CGIVar <var>variable</var> <var>rule</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.21 du serveur HTTP Apache</td></tr>
</table>
  <p>Cette directive permet de contrler la manire dont certaines variables CGI
  sont dfinies.</p>

  <p>rgles <strong>REQUEST_URI</strong> :</p>
  <dl>
    <dt><code>original-uri</code> (valeur par dfaut)</dt>
    <dd>La valeur est extraite de la requte originale, et ne tient pas compte
    des redirections internes ou des sous-requtes qui pourraient modifier la
    ressource demande.</dd>
    <dt><code>current-uri</code></dt>
    <dd>La valeur reflte la ressource en cours de traitement ; elle peut tre
    diffrente de la ressource demande dans la requte initiale du client suite 
    d'ventuelles redirections internes ou sous-requtes.</dd>
  </dl>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="contentdigest" id="contentdigest">Directive</a> <a name="ContentDigest" id="ContentDigest">ContentDigest</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la gnration d'un en-tte <code>Content-MD5</code>
dans la rponse HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ContentDigest On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ContentDigest Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Options</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive active la gnration d'un en-tte
    <code>Content-MD5</code> selon les dfinitions des RFC 1864 et
    2616.</p>

    <p>MD5 est un algorithme permettant de gnrer un condens (parfois
    appel "empreinte")  partir de donnes d'une taille alatoire ; le
    degr de prcision est tel que la moindre altration des donnes
    d'origine entrane une altration de l'empreinte.</p>

    <p>L'en-tte <code>Content-MD5</code> permet de vrifier
    l'intgrit de la rponse HTTP dans son ensemble. Un serveur mandataire
    ou un client peut utiliser cet en-tte pour rechercher une
    ventuelle modification accidentelle de la rponse au cours de sa
    transmission. Exemple d'en-tte :</p>

    <div class="example"><p><code>
      Content-MD5: AuLb7Dp1rqtRtxz2m9kRpA==
    </code></p></div>

    <p>Notez que des problmes de performances peuvent affecter votre
    serveur, car l'empreinte est gnre pour chaque requte (il n'y a
    pas de mise en cache).</p>

    <p>L'en-tte <code>Content-MD5</code> n'est envoy qu'avec les
    documents servis par le module <code class="module"><a href="../mod/core.html">core</a></code>,  l'exclusion
    de tout autre module. Ainsi, les documents SSI, les sorties de
    scripts CGI, et les rponses  des requtes partielles (byte range)
    ne comportent pas cet en-tte.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="defaultruntimedir" id="defaultruntimedir">Directive</a> <a name="DefaultRuntimeDir" id="DefaultRuntimeDir">DefaultRuntimeDir</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Rpertoire de base des fichiers crs au cours de l'excution du serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DefaultRuntimeDir <var>chemin-rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DefaultRuntimeDir DEFAULT_REL_RUNTIMEDIR (logs/)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.4.2 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive">DefaultRuntimeDir</code> permet de
    dfinir le rpertoire dans lequel le serveur va crer les diffrents
    fichiers relatifs  son excution (mmoire partage, verrous,
    etc...). Si le chemin spcifi est relatif, le chemin absolu sera
    gnr relativement  la valeur de la directive
    <code class="directive">ServerRoot</code></p>

    <p><strong>Example</strong></p>
   <pre class="prettyprint lang-config">DefaultRuntimeDir scratch/</pre>


    <p>La valeur par dfaut de la directive
    <code class="directive">DefaultRuntimeDir</code> peut tre modifie en
    changeant la valeur de la macro <code>DEFAULT_REL_RUNTIMEDIR</code>
    dfinie  la compilation.</p>

   <p>Note: si la valeur de <code class="directive">ServerRoot</code> n'a pas
   t spcifie avant d'utiliser cette directive, c'est la valeur par
   dfaut de <code class="directive">ServerRoot</code> qui sera utilise pour
   dfinir la base du rpertoire.</p>


<h3>Voir aussi</h3>
<ul>
<li>Voir les <a href="../misc/security_tips.html#serverroot">conseils  propos de
ssurit</a> pour plus d'informations en vue de dfinir correctement les
permissions sur la racine du serveur <code class="directive">ServerRoot</code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="defaulttype" id="defaulttype">Directive</a> <a name="DefaultType" id="DefaultType">DefaultType</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Les seuls effets de cette directive sont des missions
d'avertissements si sa valeur est diffrente de <code>none</code>. Dans
les versions prcdentes, DefaultType permettait de spcifier un type de
mdia  assigner par dfaut au contenu d'une rponse pour lequel aucun
autre type de mdia n'avait t trouv.
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DefaultType <var>type mdia|none</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DefaultType none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>L'argument <code>none</code> est disponible dans les
versions d'Apache httpd 2.2.7 et suprieures. Tous les autres choix sont
DESACTIVS  partir des version 2.3.x.</td></tr>
</table>
    <p>Cette directive a t dsactive. Pour la compatibilit
    ascendante avec les anciens fichiers de configuration, elle peut
    tre spcifie avec la valeur <code>none</code>, c'est  dire sans
    type de mdium par dfaut. Par exemple :</p>

    <pre class="prettyprint lang-config">DefaultType None</pre>


    <p><code>DefaultType None</code> n'est disponible que dans les
    versions d'Apache 2.2.7 et suprieures.</p>

    <p>Utilisez le fichier de configuration mime.types et la directive
    <code class="directive"><a href="../mod/mod_mime.html#addtype">AddType</a></code> pour configurer
    l'assignement d'un type de mdium via les extensions de fichiers, ou
    la directive <code class="directive"><a href="#forcetype">ForceType</a></code> pour
    attribuer un type de mdium  des ressources spcifiques. Dans le
    cas contraire, le serveur enverra sa rponse sans champ d'en-tte
    Content-Type, et le destinataire devra dterminer lui-mme le type
    de mdium.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="define" id="define">Directive</a> <a name="Define" id="Define">Define</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Permet de dfinir une variable</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Define <var>nom-paramtre</var> [<var>valeur-paramtre</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Avec un seul paramtre, l'effet de la directive
    <code class="directive">Define</code> est identique  celui de l'argument
    <code>-D</code> du programme <code class="program"><a href="../programs/httpd.html">httpd</a></code>. Il permet de
    modifier le comportement des sections <code class="directive"><a href="#ifdefine">&lt;IfDefine&gt;</a></code> sans avoir  ajouter d'argument
    <code>-D</code> au sein des scripts de dmarrage.</p>

    <p>De plus, le second paramtre permet d'affecter une valeur  la
    variable dfinie par le premier. Cette variable peut tre rfrence
    dans le fichier de configuration via la syntaxe <code>${VAR}</code>.
    La porte de la variable est toujours globale, et n'est jamais
    limite  la section de configuration courante.</p>

    <pre class="prettyprint lang-config">&lt;IfDefine TEST&gt;
  Define servername test.example.com
&lt;/IfDefine&gt;
&lt;IfDefine !TEST&gt;
  Define servername www.example.com
  Define SSL
&lt;/IfDefine&gt;

DocumentRoot "/var/www/${servername}/htdocs"</pre>


    <p>Le caractre ":" est interdit dans les noms de variables afin
    d'viter les conflits avec la syntaxe de la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewritemap">RewriteMap</a></code>.</p>

    <div class="note"><h3>Porte de la directive et piges  viter</h3>
    <p>Si cette directive est dfinie au sein d'un bloc VirtualHost, les
    changements qu'elle induit sont visibles de toute directive
    ultrieure, au del de tout bloc VirtualHost.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#undefine">UnDefine</a></code></li>
<li><code class="directive"><a href="#ifdefine">IfDefine</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="directory" id="directory">Directive</a> <a name="Directory" id="Directory">&lt;Directory&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Regroupe un ensemble de directives qui ne s'appliquent
qu'au rpertoire concern du systme de fichiers,  ses
sous-rpertoires, et  leur contenu.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;Directory <var>chemin rpertoire</var>&gt;
... &lt;/Directory&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Les balises <code class="directive">&lt;Directory&gt;</code> et
    <code>&lt;/Directory&gt;</code> permettent de regrouper un ensemble
    de directives qui ne s'appliquent qu'au rpertoire prcis,
     ses sous-rpertoires, et aux fichiers situs dans ces
    sous-rpertoires. Toute directive
    autorise dans un contexte de rpertoire peut tre utilise.
    <var>chemin rpertoire</var> est soit le chemin absolu d'un
    rpertoire, soit une chane de caractres avec caractres gnriques
    utilisant la comparaison Unix de style shell. Dans une chane de
    caractres avec caractres gnriques, <code>?</code> correspond 
    un caractre quelconque, et <code>*</code>  toute chane de
    caractres. Les intervalles de caractres <code>[]</code> sont aussi
    autoriss. Aucun caractre gnrique ne peut remplacer le caractre
    `/', si bien que l'expression <code>&lt;Directory
    "/*/public_html"&gt;</code> ne conviendra pas pour le chemin
     * <code>/home/user/public_html</code>, alors que <code>&lt;Directory
    "/home/*/public_html"&gt;</code> conviendra. Exemple :</p>

    <pre class="prettyprint lang-config">&lt;Directory "/usr/local/httpd/htdocs"&gt;
  Options Indexes FollowSymLinks
&lt;/Directory&gt;</pre>


    <p>Les chemins de rpertoires contenant des espaces <em>doivent</em> tre
    entours de guillemets afin d'empcher l'interprtation de ces
    espaces comme fins d'arguments.</p>

    <div class="note">
      <p>Soyez prudent avec l'argument <var>chemin rpertoire</var> : il
      doit correspondre exactement au chemin du systme de fichier
      qu'Apache httpd utilise pour accder aux fichiers. Les directives
      comprises dans une section <code>&lt;Directory&gt;</code> ne
      s'appliqueront pas aux fichiers du mme rpertoire auxquels on
      aura accd via un chemin diffrent, per exemple via un lien
      symbolique.</p>
    </div>

    <p> Les <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">Expressions rationnelles</a>
    peuvent aussi tre utilises en ajoutant le caractre
    <code>~</code>. Par exemple :</p>

    <pre class="prettyprint lang-config">&lt;Directory ~ "^/www/[0-9]{3}"&gt;

&lt;/Directory&gt;</pre>


    <p>pourra correspondre  tout rpertoire situ dans /www/ et dont le
    nom se compose de trois chiffres.</p>

    <p>Si plusieurs sections <code class="directive">&lt;Directory&gt;</code> (sans expression rationnelle)
    correspondent au rpertoire (ou  un de ses parents) qui contient le
    document, les directives de la section <code class="directive">&lt;Directory&gt;</code> dont le chemin est le plus
    court sont appliques en premier, en s'intercalant avec les
    directives des fichiers <a href="#accessfilename">.htaccess</a>. Par
    exemple, avec</p>

    <pre class="prettyprint lang-config">&lt;Directory "/"&gt;
  AllowOverride None
&lt;/Directory&gt;

&lt;Directory "/home"&gt;
  AllowOverride FileInfo
&lt;/Directory&gt;</pre>


    <p>l'accs au document <code>/home/web/dir/doc.html</code> emprunte
    le chemin suivant :</p>

    <ul>
      <li>Aplication de la directive <code>AllowOverride None</code>
      (qui dsactive les fichiers <code>.htaccess</code>).</li>

      <li>Application de la directive <code>AllowOverride
      FileInfo</code> (pour le rpertoire <code>/home</code>).</li>

      <li>Application de toute directive <code>FileInfo</code> qui se
      trouverait dans d'ventuels fichiers <code>/home/.htaccess</code>,
      <code>/home/web/.htaccess</code> ou
      <code>/home/web/dir/.htaccess</code>, dans cet ordre.</li>
    </ul>

    <p>Les directives associes aux rpertoires sous forme d'expressions
    rationnelles ne sont prises en compte qu'une fois toutes les
    directives des sections sans expressions rationnelles appliques.
    Alors, tous les rpertoires avec expressions rationnelles sont
    tests selon l'ordre dans lequel ils apparaissent dans le fichier de
    configuration. Par exemple, avec</p>

    <pre class="prettyprint lang-config">&lt;Directory ~ "abc$"&gt;
  # ... directives ici ...
&lt;/Directory&gt;</pre>


    <p>la section avec expression rationnelle ne sera prise en compte
    qu'aprs les sections <code class="directive">&lt;Directory&gt;</code> sans expression rationnelle
    et les fichiers <code>.htaccess</code>. Alors, l'expression
    rationnelle conviendra pour <code>/home/abc/public_html/abc</code>
    et la section <code class="directive">&lt;Directory&gt;</code>
    correspondante s'appliquera.</p>

   <p><strong>Notez que la politique d'accs par dfaut
   dans les sections <code>&lt;Directory "/"&gt;</code> consiste 
   autoriser tout accs sans restriction. Ceci signifie qu'Apache httpd va servir tout fichier
   correspondant  une URL. Il est recommand de modifier cette
   situation  l'aide d'un bloc du style</strong></p>

    <pre class="prettyprint lang-config">&lt;Directory "/"&gt;
  Require all denied
&lt;/Directory&gt;</pre>


    <p><strong>puis d'affiner la configuration pour les rpertoires que vous
    voulez rendre accessibles. Voir la page <a href="../misc/security_tips.html">Conseils  propos de scurit</a>
    pour plus de dtails.</strong></p>

    <p>Les sections <code class="directive">&lt;Directory&gt;</code> se situent
    dans le fichier <code>httpd.conf</code>. Les directives <code class="directive">&lt;Directory&gt;</code> ne peuvent pas tre imbriques
    et ne sont pas autorises dans les sections <code class="directive"><a href="#limit">&lt;Limit&gt;</a></code> ou <code class="directive"><a href="#limitexcept">&lt;LimitExcept&gt;</a></code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour des
explications  propos de la manire dont ces diffrentes sections se
combinent entre elles  la rception d'une requte</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="directorymatch" id="directorymatch">Directive</a> <a name="DirectoryMatch" id="DirectoryMatch">&lt;DirectoryMatch&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Regroupe des directives qui s'appliquent au contenu de rpertoires
du systme de fichiers correspondant  une expression rationnelle</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;DirectoryMatch <var>regex</var>&gt;
... &lt;/DirectoryMatch&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Les balises <code class="directive">&lt;DirectoryMatch&gt;</code>
    et <code>&lt;/DirectoryMatch&gt;</code> permettent de regrouper un
    ensemble de directives qui ne s'appliqueront qu'au rpertoire
    prcis (et aux fichiers qu'il contient), comme pour la section <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>. Cependant, le
    rpertoire est prcis sous la forme d'une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>. Par exemple :</p>

    <pre class="prettyprint lang-config">&lt;DirectoryMatch "^/www/(.+/)?[0-9]{3}/"&gt;
    # ...
&lt;/DirectoryMatch&gt;</pre>


    <p>convient pour les sous-rpertoires de <code>/www/</code> dont
    le nom se compose de trois chiffres.</p>

    <div class="note"><h3>Compatibilit</h3>
      Avant la version 2.3.9, cette directive s'appliquait aussi aux
      sous-rpertoires (comme la directive <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>), et ne tenait pas compte du
      symbole de fin de ligne ($). Depuis la version 2.3.9, seuls les
      rpertoires qui correspondent  l'expression sont affects par les
      directives contenues dans la section.
    </div>

    <div class="note"><h3>slash de fin</h3>
      Cette directive s'applique aux requtes pour des rpertoires avec
      ou sans slash de fin ; les expressions contenant un symbole de fin
      de ligne ($) doivent donc faire l'objet d'une attention
      particulire.
    </div>
    
    <p>A partir de la version 2.4.8, les groupes nomms et les
    rfrences arrires sont extraits et enregistrs dans
    l'environnement avec leur nom en majuscules et prfix
    par "MATCH_". Ceci permet
    de rfrencer des URLs dans des <a href="../expr.html">expressions</a>
    ou au sein de modules comme <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Pour
    viter toute confusion, les rfrences arrires numrotes (non
    nommes) sont ignores. Vous devez utiliser  la place des groupes
    nomms.</p>

<pre class="prettyprint lang-config">&lt;DirectoryMatch "^/var/www/combined/(?&lt;sitename&gt;[^/]+)"&gt;
    Require ldap-group cn=%{env:MATCH_SITENAME},ou=combined,o=Example
&lt;/DirectoryMatch&gt;</pre>
    


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>
pour une description de la manire dont les expressions rationnelles
sont traites en prsence d'autres sections <code class="directive">&lt;Directory&gt;</code> sans expressions rationnelles</li>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication  propos de la manire dont ces diffrentes sections se
combinent entre elles  la rception d'une requte</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="documentroot" id="documentroot">Directive</a> <a name="DocumentRoot" id="DocumentRoot">DocumentRoot</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Racine principale de l'arborescence des documents visible
depuis Internet</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DocumentRoot <var>chemin rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DocumentRoot "/usr/local/apache/htdocs"</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet de dfinir le rpertoire  partir duquel
    <code class="program"><a href="../programs/httpd.html">httpd</a></code> va servir les fichiers. S'il ne correspond
    pas  un <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code>, le chemin
    de l'URL sera ajout par le serveur  la racine des documents afin
    de construire le chemin du document recherch. Exemple :</p>

    <pre class="prettyprint lang-config">DocumentRoot "/usr/web"</pre>


    <p>un accs  <code>http://my.example.com/index.html</code> se
    rfre alors  <code>/usr/web/index.html</code>. Si <var>chemin
    rpertoire</var> n'est pas un chemin absolu, il est considr comme
    relatif au chemin dfini par la directive <code class="directive"><a href="#serverroot">ServerRoot</a></code>.</p>

    <p>Le rpertoire dfini par la directive
    <code class="directive">DocumentRoot</code> ne doit pas comporter de slash
    final.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../urlmapping.html#documentroot">Mise en
correspondance des URLs avec le systme de fichiers</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="else" id="else">Directive</a> <a name="Else" id="Else">&lt;Else&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui ne s'appliquent que si la
condition correspondant  la section <code class="directive"><a href="#if">&lt;If&gt;</a></code> ou <code class="directive"><a href="#elseif">&lt;ElseIf&gt;</a></code> prcdente n'est pas satisfaite par la
requte  l'excution</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;Else&gt; ... &lt;/Else&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Les conditions imbriques sont supportes  partir de la version
2.4.26 du serveur HTTP Apache</td></tr>
</table>
    <p>La section <code class="directive">&lt;Else&gt;</code> applique
    les directives qu'elle contient si et seulement si les conditions
    correspondant  la section <code class="directive">&lt;If&gt;</code>
    ou <code class="directive">&lt;ElseIf&gt;</code> immdiatement
    suprieure et dans la mme porte n'ont pas t satisfaites. Par
    exemple, dans :</p>

    <pre class="prettyprint lang-config">&lt;If "-z req('Host')"&gt;
  # ...
&lt;/If&gt;
&lt;Else&gt;
  # ...
&lt;/Else&gt;</pre>


    <p>La condition de la section <code class="directive">&lt;If&gt;</code> serait satisfaite pour les requtes
    HTTP/1.0 sans en-tte <var>Host:</var>, alors que celle de la section
    <code class="directive">&lt;Else&gt;</code> le serait pour les
    requtes comportant un en-tte <var>Host:</var>.</p>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#if">&lt;If&gt;</a></code></li>
<li><code class="directive"><a href="#elseif">&lt;ElseIf&gt;</a></code></li>
<li><a href="../sections.html">Fonctionnement des sections &lt;Directory&gt;, &lt;Location&gt;,
    &lt;Files&gt;</a> pour une explication de la manire dont ces
    diffrentes section se combinent entre elles lorsqu'une requte est
    reue. Les directives <code class="directive">&lt;If&gt;</code>,
    <code class="directive">&lt;ElseIf&gt;</code>, et <code class="directive">&lt;Else&gt;</code> s'appliquent en dernier.</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="elseif" id="elseif">Directive</a> <a name="ElseIf" id="ElseIf">&lt;ElseIf&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui ne s'appliquent que si la
condition correspondante est satisfaite par une requte  l'excution,
alors que la condition correspondant  la section <code class="directive"><a href="#if">&lt;If&gt;</a></code> ou <code class="directive">&lt;ElseIf&gt;</code> prcdente ne l'tait pas.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;ElseIf <var>expression</var>&gt; ... &lt;/ElseIf&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Les conditions imbriques sont supportes  partir de la version
2.4.26 du serveur HTTP Apache</td></tr>
</table>
    <p>La section <code class="directive">&lt;ElseIf&gt;</code> applique
    les directives qu'elle contient si et seulement si d'une part la
    condition correspondante est satisfaite, et d'autre part la condition
    correspondant  la section <code class="directive">&lt;If&gt;</code>
    ou <code class="directive">&lt;ElseIf&gt;</code> de la mme porte ne
    l'est pas. Par exemple, dans :</p>

    <pre class="prettyprint lang-config">&lt;If "-R '10.1.0.0/16'"&gt;
  #...
&lt;/If&gt;
&lt;ElseIf "-R '10.0.0.0/8'"&gt;
  #...
&lt;/ElseIf&gt;
&lt;Else&gt;
  #...
&lt;/Else&gt;</pre>


    <p>La condition correspondant  la section <code class="directive">&lt;ElseIf&gt;</code> est satisfaite si l'adresse
    distante de la requte appartient au sous-rseau 10.0.0.0/8, mais
    pas si elle appartient au sous-rseau 10.1.0.0/16.</p>


<h3>Voir aussi</h3>
<ul>
<li><a href="../expr.html">Les expressions dans le serveur HTTP
Apache</a>, pour une rfrence complte et d'autres exemples.</li>
<li><code class="directive"><a href="#if">&lt;If&gt;</a></code></li>
<li><code class="directive"><a href="#else">&lt;Else&gt;</a></code></li>
<li><a href="../sections.html">Fonctionnement des sections &lt;Directory&gt;, &lt;Location&gt;,
    &lt;Files&gt;</a> pour une explication de la manire dont ces
    diffrentes section se combinent entre elles lorsqu'une requte est
    reue. Les directives <code class="directive">&lt;If&gt;</code>,
    <code class="directive">&lt;ElseIf&gt;</code>, et <code class="directive">&lt;Else&gt;</code> s'appliquent en dernier.</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="enablemmap" id="enablemmap">Directive</a> <a name="EnableMMAP" id="EnableMMAP">EnableMMAP</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Utilise la projection en mmoire (Memory-Mapping) pour
lire les fichiers pendant qu'ils sont servis</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>EnableMMAP On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>EnableMMAP On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive dfinit si <code class="program"><a href="../programs/httpd.html">httpd</a></code> peut utiliser
    la projection en mmoire (Memory-Mapping) quand il doit lire le contenu
    d'un fichier pendant qu'il est servi. Par dfaut, lorsque le
    traitement d'une requte requiert l'accs aux donnes contenues dans
    un fichier -- par exemple, pour servir un fichier interprt par le
    serveur  l'aide de <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> -- Apache httpd projette
    le fichier en mmoire si le systme d'exploitation le permet.</p>

    <p>Cette projection en mmoire induit parfois une amlioration des
    performances. Sur certains systmes cependant, il est prfrable de
    dsactiver la projection en mmoire afin d'viter certains problmes
    oprationnels :</p>

    <ul>
    <li>Sur certains systmes multi-processeurs, la projection en
    mmoire peut dgrader les performances du programme
    <code class="program"><a href="../programs/httpd.html">httpd</a></code>.</li>
    <li>S'il fait l'objet d'une projection en mmoire par
    <code class="program"><a href="../programs/httpd.html">httpd</a></code>, la suppression ou la troncature d'un
    fichier peut provoquer un crash de <code class="program"><a href="../programs/httpd.html">httpd</a></code> avec une
    erreur de segmentation.</li>
    </ul>

    <p>Pour les configurations de serveur sujettes  ce genre de
    problme, il est prfrable de dsactiver la projection en mmoire
    des fichiers servis en spcifiant :</p>
    
    <pre class="prettyprint lang-config">EnableMMAP Off</pre>


    <p>Pour les montages NFS, cette fonctionnalit peut tre
    explicitement dsactive pour les fichiers concerns en spcifiant
    :</p>

    <pre class="prettyprint lang-config">&lt;Directory "/path-to-nfs-files"&gt;
  EnableMMAP Off
&lt;/Directory&gt;</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="enablesendfile" id="enablesendfile">Directive</a> <a name="EnableSendfile" id="EnableSendfile">EnableSendfile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Utilise le support sendfile du noyau pour servir les
fichiers aux clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>EnableSendfile On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>EnableSendfile Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Par dfaut  Off depuis la version 2.3.9.</td></tr>
</table>
    <p>Cette directive dfinit si le programme <code class="program"><a href="../programs/httpd.html">httpd</a></code>
    peut utiliser le support sendfile du noyau pour transmettre le
    contenu des fichiers aux clients. Par dfaut, lorsque le traitement
    d'une requte ne requiert pas l'accs aux donnes contenues dans un
    fichier -- par exemple, pour la transmission d'un fichier statique
    -- Apache httpd utilise sendfile pour transmettre le contenu du fichier
    sans mme lire ce dernier, si le systme d'exploitation le
    permet.</p>

    <p>Ce mcanisme sendfile vite la sparation des oprations de
    lecture et d'envoi, ainsi que les rservations de tampons. sur
    certains systmes cependant, ou sous certains systmes de fichiers,
    il est prfrable de dsactiver cette fonctionnalit afin d'viter
    certains problmes oprationnels :</p>

    <ul>
    <li>Certains systmes peuvent prsenter un support sendfile
    dfectueux que le systme de compilation n'a pas dtect, en
    particulier si les excutables ont t compils sur une autre
    machine, puis copis sur la premire avec un support sendfile
    dfectueux.</li>
    <li>Sous Linux, l'utilisation de sendfile induit des bogues lors de
    la rcupration des paquets de vrification TCP (TCP-checksum) avec
    certaines cartes rseau lorsqu'on utilise IPv6.</li>
    <li>Sous Linux sur Itanium, <code>sendfile</code> peut s'avrer incapable de
    traiter les fichiers de plus de 2 Go.</li>
    <li>Avec un montage rseau de <code class="directive"><a href="#documentroot">DocumentRoot</a></code> (par exemple NFS, SMB, CIFS,
    FUSE), le
    noyau peut s'avrer incapable de servir un fichier de ce montage
    rseau en passant par son propre cache.</li>
    </ul>

    <p>Pour les configurations de serveur non sujettes  ce genre de
    problme, vous pouvez activer cette fonctionnalit en
    spcifiant :</p>

    <pre class="prettyprint lang-config">EnableSendfile On</pre>


    <p>Pour les montages rseau, cette fonctionnalit peut tre
    explicitement dsactive pour les fichiers concerns en spcifiant
    :</p>

    <pre class="prettyprint lang-config">&lt;Directory "/path-to-nfs-files"&gt;
  EnableSendfile Off
&lt;/Directory&gt;</pre>

    <p>Veuillez noter que la configuration de la directive
    <code class="directive">EnableSendfile</code> dans un contexte de rpertoire
    ou de fichier .htaccess n'est pas supporte par
    <code class="module"><a href="../mod/mod_cache_disk.html">mod_cache_disk</a></code>. Le module ne prend en compte la
    dfinition de <code class="directive">EnableSendfile</code> que dans un
    contexte global.
    </p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="error" id="error">Directive</a> <a name="Error" id="Error">Error</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Interrompt la lecture de la configuration avec un message
d'erreur personnalis</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Error <var>message</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td> partir de la version 2.3.9</td></tr>
</table>
    <p>Si une erreur peut tre dtecte dans la configuration, souvent
    un module manquant, cette
    directive peut tre utilise pour gnrer un message d'erreur
    personnalis, et interrompre la lecture de la configuration. </p>

    <pre class="prettyprint lang-config"># Exemple
# vrification du chargement de mod_include
&lt;IfModule !include_module&gt;
  Error "mod_include is required by mod_foo.  Load it with LoadModule."
&lt;/IfModule&gt;

# vrification de la dfinition de SSL ou (exclusif) NOSSL
&lt;IfDefine SSL&gt;
&lt;IfDefine NOSSL&gt;
  Error "Both SSL and NOSSL are defined.  Define only one of them."
&lt;/IfDefine&gt;
&lt;/IfDefine&gt;
&lt;IfDefine !SSL&gt;
&lt;IfDefine !NOSSL&gt;
  Error "Either SSL or NOSSL must be defined."
&lt;/IfDefine&gt;
&lt;/IfDefine&gt;</pre>



</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="errordocument" id="errordocument">Directive</a> <a name="ErrorDocument" id="ErrorDocument">ErrorDocument</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Document que le serveur renvoie au client en cas
d'erreur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ErrorDocument <var>code erreur</var> <var>document</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Apache httpd peut traiter les problmes et les erreurs de quatre
    manires,</p>

    <ol>
      <li>afficher un simple message d'erreur au contenu fixe</li>

      <li>afficher un message personnalis</li>

      <li>rediriger en interne vers un <var>chemin d'URL</var> local pour traiter
      le problme ou l'erreur</li>

      <li>rediriger vers une <var>URL</var> externe pour traiter
      le problme ou l'erreur</li>
    </ol>

    <p>La premire option constitue le comportement par dfaut; pour
    choisir une des trois autres options, il faut configurer Apache 
    l'aide de la directive <code class="directive">ErrorDocument</code>, suivie
    du code de la rponse HTTP et d'une URL ou d'un message. Apache
    httpd fournit parfois des informations supplmentaires  propos du
    problme ou de l'erreur.</p>

    <p>A partir de la version 2.4.13, il est possible d'utiliser la <a href="../expr.html">syntaxe des expressions</a> dans cette directive
    afin de gnrer des chanes et URLs dynamiques.</p>

    <p>Les URLs peuvent commencer par un slash (/) pour les chemins web
    locaux (relatifs au rpertoire dfini par la directive <code class="directive"><a href="#documentroot">DocumentRoot</a></code>), ou se prsenter sous la
    forme d'une URL complte que le client pourra rsoudre.
    Alternativement, un message  afficher par le navigateur pourra tre
    fourni. Notez que la dcision de considrer le paramtre comme URL,
    chemin ou message intervient avant toute interprtation
    d'expression. Exemples :</p>

    <pre class="prettyprint lang-config">ErrorDocument 500 http://example.com/cgi-bin/server-error.cgi
ErrorDocument 404 /errors/bad_urls.php
ErrorDocument 401 /subscription_info.html
ErrorDocument 403 "Sorry can't allow you access today"
ErrorDocument 403 Forbidden!
ErrorDocument 403 /errors/forbidden.py?referrer=%{escape:%{HTTP_REFERER}}</pre>


    <p>De plus, on peut spcifier la valeur spciale <code>default</code>
    pour indiquer l'utilisation d'un simple message d'Apache httpd cod en
    dur. Bien que non ncessaire dans des circonstances normales, la
    spcification de la valeur <code>default</code> va permettre de
    rtablir l'utilisation du simple message d'Apache httpd cod en dur pour
    les configurations qui sans cela, hriteraient d'une directive
    <code class="directive">ErrorDocument</code> existante.</p>

    <pre class="prettyprint lang-config">ErrorDocument 404 /cgi-bin/bad_urls.pl

&lt;Directory "/web/docs"&gt;
  ErrorDocument 404 default
&lt;/Directory&gt;</pre>


    <p>Notez que lorsque vous spcifiez une directive
    <code class="directive">ErrorDocument</code> pointant vers une URL distante
    (c'est  dire tout ce qui commence par le prfixe http), le serveur
    HTTP Apache va
    envoyer une redirection au client afin de lui indiquer o trouver le
    document, mme dans le cas o ce document se trouve sur le serveur
    local. Ceci a de nombreuses consquences dont la plus importante
    rside dans le fait que le client ne recevra pas le code d'erreur
    original, mais au contraire un code de statut de redirection. Ceci
    peut en retour semer la confusion chez les robots web et divers
    clients qui tentent de dterminer la validit d'une URL en examinant
    le code de statut. De plus, si vous utilisez une URL distante avec
    <code>ErrorDocument 401</code>, le client ne saura pas qu'il doit
    demander un mot de passe  l'utilisateur car il ne recevra pas le
    code de statut 401. C'est pourquoi, <strong>si vous utilisez une
    directive <code>ErrorDocument 401</code>, elle devra faire rfrence
     un document par le biais d'un chemin local.</strong></p>

    <p>Microsoft Internet Explorer (MSIE) ignore par dfaut les messages
    d'erreur gnrs par le serveur lorsqu'ils sont trop courts et
    remplacent ses propres messages d'erreur "amicaux". Le seuil de
    taille varie en fonction du type d'erreur, mais en gnral, si la
    taille de votre message d'erreur est suprieure  512 octets, il y a
    peu de chances pour que MSIE l'occulte, et il sera affich par ce
    dernier. Vous trouverez d'avantage d'informations dans l'article de
    la base de connaissances Microsoft <a href="http://support.microsoft.com/default.aspx?scid=kb;en-us;Q294807">Q294807</a>.</p>

    <p>Bien que la plupart des messages d'erreur internes originaux
    puissent tre remplacs, ceux-ci sont cependant conservs dans
    certaines circonstances sans tenir compte de la dfinition de la
    directive <code class="directive"><a href="#errordocument">ErrorDocument</a></code>. En
    particulier, en cas de dtection d'une requte mal forme, le
    processus de traitement normal des requtes est immdiatement
    interrompu, et un message d'erreur interne est renvoy, ceci afin de
    se prmunir contre les problmes de scurit lis aux requtes mal
    formes.</p>

    <p>Si vous utilisez mod_proxy, il est en gnral prfrable
    d'activer <code class="directive"><a href="../mod/mod_proxy.html#proxyerroroverride">ProxyErrorOverride</a></code> afin d'tre en
    mesure de produire des messages d'erreur personnaliss pour le
    compte de votre serveur d'origine. Si vous n'activez pas
    ProxyErrorOverride, Apache httpd ne gnrera pas de messages d'erreur
    personnaliss pour le contenu mandat.</p>


<h3>Voir aussi</h3>
<ul>
<li><a href="../custom-error.html">documentation sur la
personnalisation des rponses</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="errorlog" id="errorlog">Directive</a> <a name="ErrorLog" id="ErrorLog">ErrorLog</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinition du chemin du journal des erreurs</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code> ErrorLog <var>file-path</var>|syslog[:[<var>facility</var>][:<var>tag</var>]]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ErrorLog logs/error_log (Unix) ErrorLog logs/error.log (Windows and OS/2)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ErrorLog</code> permet de dfinir le
    nom du fichier dans lequel le serveur va journaliser toutes les
    erreurs qu'il rencontre. Si le <var>file-path</var> n'est pas
    absolu, il est considr comme relatif au chemin dfini par la
    directive <code class="directive"><a href="#serverroot">ServerRoot</a></code>.</p>

    <pre class="prettyprint lang-config">ErrorLog "/var/log/httpd/error_log"</pre>


    <p>Si le <var>file-path</var> commence par une barre verticale
    "<code>(|)</code>", il est considr comme une commande  lancer pour traiter la
    journalisation de l'erreur.</p>

    <pre class="prettyprint lang-config">ErrorLog "|/usr/local/bin/httpd_errors"</pre>


    <p>Voir les notes  propos des <a href="../logs.html#piped">journaux
    redirigs</a> pour plus d'informations.</p>

    <p>L'utilisation de <code>syslog</code>  la place d'un nom de
    fichier active la journalisation via syslogd(8) si le systme le
    supporte. Le dispositif syslog par dfaut est <code>local7</code>,
    mais vous pouvez le modifier  l'aide de la syntaxe
    <code>syslog:<var>facility</var></code>, o <var>facility</var> peut
    tre remplac par un des noms habituellement documents dans la page
    de man syslog(1). Le dispositif syslog <code>local7</code> est
    global, et si il est modifi dans un serveur virtuel, le dispositif
    final spcifi affecte l'ensemble du serveur. La mme rgle s'applique au
    tag syslog qui utilise par dfaut le nom du binaire du serveur HTTP Apache
    <code>httpd</code> dans la plupart des cas. Vous pouvez aussi modifier cette
    valeur en utilisant la syntaxe <code>syslog::<var>tag</var></code>.</p>

    <pre class="prettyprint lang-config">ErrorLog syslog:user
ErrorLog syslog:user:httpd.srv1
ErrorLog syslog::httpd.srv2</pre>


    <p>Des modules supplmentaires peuvent fournir leurs propres
    fournisseurs ErrorLog. La syntaxe est similaire  celle de
    l'exemple <code>syslog</code> ci-dessus.</p>

    <p>SECURITE : Voir le document <a href="../misc/security_tips.html#serverroot">conseils  propos de
    scurit</a> pour des dtails sur les raisons pour lesquelles votre
    scurit peut tre compromise si le rpertoire contenant les
    fichiers journaux prsente des droits en criture pour tout autre
    utilisateur que celui sous lequel le serveur est dmarr.</p>
    <div class="warning"><h3>Note</h3>
      <p>Lors de la spcification d'un chemin de fichier sur les
      plates-formes non-Unix, on doit veiller  n'utiliser que des
      slashes (/), mme si la plate-forme autorise l'utilisation des
      anti-slashes (\). Et d'une manire gnrale, il est recommand de
      n'utiliser que des slashes (/) dans les fichiers de
      configuration.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#loglevel">LogLevel</a></code></li>
<li><a href="../logs.html">Fichiers journaux du serveur HTTP Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="errorlogformat" id="errorlogformat">Directive</a> <a name="ErrorLogFormat" id="ErrorLogFormat">ErrorLogFormat</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcification du format des entres du journal des erreurs</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code> ErrorLogFormat [connection|request] <var>format</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ErrorLogFormat</code> permet de
    spcifier quelles informations supplmentaires vont tre enregistres
    dans le journal des erreurs en plus du message habituel.</p>

    <pre class="prettyprint lang-config"># Exemple simple
ErrorLogFormat "[%t] [%l] [pid %P] %F: %E: [client %a] %M"</pre>


    <p>La spcification de <code>connection</code> ou
    <code>request</code> comme premier paramtre permet de dfinir des
    formats supplmentaires, ce qui a pour effet de journaliser des
    informations additionnelles lorsque le premier message est
    enregistr respectivement pour une connexion ou une requte
    spcifique. Ces informations additionnelles ne sont enregistres
    qu'une seule fois par connexion/requte. Si le traitement d'une
    connexion ou d'une requte ne gnre aucun message dans le journal,
    alors aucune information additionnelle n'est enregistre.</p>

    <p>Il peut arriver que certains items de la chane de format ne
    produisent aucune sortie. Par exemple, l'en-tte Referer n'est
    prsent que si le message du journal est associ  une requte et s'il
    est gnr  un moment o l'en-tte Referer a dj t lu par le
    client. Si aucune sortie n'est gnre, le comportement par dfaut
    consiste  supprimer tout ce qui se trouve entre l'espace prcdent
    et le suivant. Ceci implique que la ligne de journalisation est
    divise en champs ne contenant pas d'espace spars par des espaces.
    Si un item de la chane de format ne gnre aucune sortie,
    l'ensemble du champ est omis. Par exemple, si l'adresse distante
    <code>%a</code> du format <code>[%t] [%l] [%a] %M&nbsp;</code> n'est
    pas disponible, les crochets qui l'entourent ne seront eux-mmes pas
    enregistrs. Il est possible d'chapper les espaces par un anti-slash
    afin qu'ils ne soient pas considrs comme sparateurs de champs.
    La combinaison '%&nbsp;' (pourcentage espace) est un dlimiteur de
    champ de taille nulle qui ne gnre aucune sortie.</p>

    <p>Ce comportement peut tre chang en ajoutant des modificateurs 
    l'item de la chane de format. Le modificateur <code>-</code>
    (moins) provoque l'enregistrement d'un signe moins si l'item
    considr ne gnre aucune sortie. Pour les formats  enregistrement
    unique par connexion/requte, il est aussi possible d'utiliser le
    modificateur <code>+</code> (plus). Si un item ne gnrant aucune
    sortie possde le modificateur plus, la ligne dans son ensemble est
    omise.</p>

    <p>Un modificateur de type entier permet d'assigner un niveau de
    svrit  un item de format. L'item considr ne
    sera journalis que si la svrit du message n'est pas
    plus haute que le niveau de svrit spcifi. Les
    valeurs possibles vont de 1 (alert)  15 (trace8), en passant par 4
    (warn) ou 7 (debug).</p>

    <p>Par exemple, voici ce qui arriverait si vous ajoutiez des
    modificateurs  l'item <code>%{Referer}i</code> qui enregistre le
    contenu de l'en-tte <code>Referer</code>.</p>

    <table class="bordered"><tr class="header"><th>Item modifi</th><th>Signification</th></tr>
<tr>
    <td><code>%-{Referer}i</code></td>
    <td>Enregistre le caractre <code>-</code> si l'en-tte
    <code>Referer</code> n'est pas dfini.</td>
    </tr>
<tr class="odd">
    <td><code>%+{Referer}i</code></td>
    <td>N'enregistre rien si l'en-tte
    <code>Referer</code> n'est pas dfini.</td>
    </tr>
<tr>
    <td><code>%4{Referer}i</code></td>
    <td>N'enregistre le contenu de l'en-tte <code>Referer</code> que si
    la svrit du message de journalisation est suprieure  4.</td>
    </tr>
</table>

    <p>Certains items de format acceptent des paramtres supplmentaires
    entre accolades.</p>

    <table class="bordered"><tr class="header"><th>Chane&nbsp;de&nbsp;format</th> <th>Description</th></tr>
<tr><td><code>%%</code></td>
        <td>Le signe pourcentage</td></tr>
<tr class="odd"><td><code>%a</code></td>
        <td>Adresse IP et port clients</td></tr>
<tr><td><code>%{c}a</code></td>
        <td>Port et adresse IP sous-jacents du correspondant pour la
	connexion (voir le module
	<code class="module"><a href="../mod/mod_remoteip.html">mod_remoteip</a></code>)</td></tr>
<tr class="odd"><td><code>%A</code></td>
        <td>Adresse IP et port locaux</td></tr>
<tr><td><code>%{<em>name</em>}e</code></td>
        <td>Variable d'environnement de requte <em>name</em></td></tr>
<tr class="odd"><td><code>%E</code></td>
        <td>Etat d'erreur APR/OS et chane</td></tr>
<tr><td><code>%F</code></td>
        <td>Nom du fichier source et numro de ligne de l'appel du
	journal</td></tr>
<tr class="odd"><td><code>%{<em>name</em>}i</code></td>
        <td>En-tte de requte <em>name</em></td></tr>
<tr><td><code>%k</code></td>
        <td>Nombre de requtes persistantes pour cette connexion</td></tr>
<tr class="odd"><td><code>%l</code></td>
        <td>Svrit du message</td></tr>
<tr><td><code>%L</code></td>
        <td>Identifiant journal de la requte</td></tr>
<tr class="odd"><td><code>%{c}L</code></td>
        <td>Identifiant journal de la connexion</td></tr>
<tr><td><code>%{C}L</code></td>
        <td>Identifiant journal de la connexion si utilis dans la
	porte de la connexion, vide sinon</td></tr>
<tr class="odd"><td><code>%m</code></td>
        <td>Nom du module qui effectue la journalisation du message</td></tr>
<tr><td><code>%M</code></td>
        <td>Le message effectif</td></tr>
<tr class="odd"><td><code>%{<em>name</em>}n</code></td>
        <td>Note de requte <em>name</em></td></tr>
<tr><td><code>%P</code></td>
        <td>Identifiant du processus courant</td></tr>
<tr class="odd"><td><code>%T</code></td>
        <td>Identifiant du thread courant</td></tr>
<tr><td><code>%{g}T</code></td>
        <td>Identifiant unique de thread systme du thread courant
	(l'identifiant affich par la commande <code>top</code> par
	exemple ; seulement sous Linux pour l'instant)</td></tr>
<tr class="odd"><td><code>%t</code></td>
        <td>L'heure courante</td></tr>
<tr><td><code>%{u}t</code></td>
        <td>L'heure courante avec les microsecondes</td></tr>
<tr class="odd"><td><code>%{cu}t</code></td>
        <td>L'heure courante au format compact ISO 8601, avec les
	microsecondes</td></tr>
<tr><td><code>%v</code></td>
        <td>Le nom de serveur canonique <code class="directive"><a href="#servername">ServerName</a></code> du serveur courant.</td></tr>
<tr class="odd"><td><code>%V</code></td>
        <td>Le nom de serveur du serveur qui sert la requte en accord
	avec la dfinition de la directive <code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code>.</td></tr>
<tr><td><code>\&nbsp;</code> (anti-slash espace)</td>
        <td>Espace non dlimiteur</td></tr>
<tr class="odd"><td><code>%&nbsp;</code> (pourcentage espace)</td>
        <td>Dlimiteur de champ (aucune sortie)</td></tr>
</table>

    <p>L'item de format identifiant journal <code>%L</code> gnre un
    identifiant unique pour une connexion ou une requte. Il peut servir
     dterminer quelles lignes correspondent  la mme connexion ou
    requte ou quelle requte est associe  tel connexion. Un item de
    format <code>%L</code> est aussi disponible dans le module
    <code class="module"><a href="../mod/mod_log_config.html">mod_log_config</a></code>, mais il permet dans ce contexte de
    corrler les entres du journal des accs avec celles du journal des
    erreurs. Si le module <code class="module"><a href="../mod/mod_unique_id.html">mod_unique_id</a></code> est charg,
    c'est son identifiant unique qui sera utilis comme identifiant de
    journal pour les requtes.</p>

    <pre class="prettyprint lang-config"># Exemple (format par dfaut pour les MPMs threads)
ErrorLogFormat "[%{u}t] [%-m:%l] [pid %P:tid %T] %7F: %E: [client\ %a] %M%,\referer\%{Referer}i"</pre>


    <p>Cet exemple renverrait un message d'erreur du style :</p>

    <div class="example"><p><code>
    [Thu May 12 08:28:57.652118 2011] [core:error] [pid 8777:tid 4326490112] [client ::1:58619] File does not exist: /usr/local/apache2/htdocs/favicon.ico
    </code></p></div>

    <p>Notez que, comme indiqu plus haut, certains champs sont
    totalement supprims s'ils n'ont pas t dfinis.</p>

    <pre class="prettyprint lang-config"># Exemple (similaire au format 2.2.x)
ErrorLogFormat "[%t] [%l] %7F: %E: [client\ %a] %M%,\referer\%{Referer}i"</pre>


    <pre class="prettyprint lang-config"># Exemple avanc avec identifiants journal de requte/connexion
ErrorLogFormat "[%{uc}t] [%-m:%-l] [R:%L] [C:%{C}L] %7F: %E: %M"
ErrorLogFormat request "[%{uc}t] [R:%L] Request %k on C:%{c}L pid:%P tid:%T"
ErrorLogFormat request "[%{uc}t] [R:%L] UA:'%+{User-Agent}i'"
ErrorLogFormat request "[%{uc}t] [R:%L] Referer:'%+{Referer}i'"
ErrorLogFormat connection "[%{uc}t] [C:%{c}L] local\ %a remote\ %A"</pre>



<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#errorlog">ErrorLog</a></code></li>
<li><code class="directive"><a href="#loglevel">LogLevel</a></code></li>
<li><a href="../logs.html">Fichiers journaux du serveur HTTP Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="extendedstatus" id="extendedstatus">Directive</a> <a name="ExtendedStatus" id="ExtendedStatus">ExtendedStatus</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Extrait des informations d'tat tendues pour chaque
requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ExtendedStatus On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ExtendedStatus Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>

	<p>Cette option permet d'extraire des donnes supplmentaires
	concernant la requte en cours de traitement pour un processus
	donn, et cre un rsum d'utilisation ; vous pouvez accder 
	ces variables pendant l'excution en configurant
	<code class="module"><a href="../mod/mod_status.html">mod_status</a></code>. Notez que d'autres modules sont
	susceptibles de s'appuyer sur ce tableau de bord.</p>

    <p>Cette directive s'applique au serveur dans son ensemble, et ne
    peut pas tre active/dsactive pour un serveur virtuel
    particulier. Notez que l'extraction des informations d'tat tendues
    peut ralentir le serveur. Notez aussi que cette dfinition ne peut
    pas tre modifie au cours d'un redmarrage graceful.</p>

    <div class="note">
    <p>Notez que le chargement de <code class="module"><a href="../mod/mod_status.html">mod_status</a></code> dfinit
    automatiquement ExtendedStatus  On, et que d'autres modules tiers
    sont susceptibles d'en faire de mme. De tels modules ont besoin
    d'informations dtailles  propos de l'tat de tous les processus.
    Depuis la version 2.3.6, <code class="module"><a href="../mod/mod_status.html">mod_status</a></code> a dfinit la
    valeur par dfaut  On, alors qu'elle tait  Off dans les versions
    antrieures.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="fileetag" id="fileetag">Directive</a> <a name="FileETag" id="FileETag">FileETag</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Caractristiques de fichier utilises lors de la gnration
de l'en-tte de rponse HTTP ETag pour les fichiers statiques</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>FileETag <var>composant</var> ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>FileETag MTime Size</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>La valeur par dfaut tait "INode&nbsp;MTime&nbsp;Size"
dans les versions 2.3.14 et antrieures.</td></tr>
</table>
    <p>
    La directive <code class="directive">FileETag</code> dfinit les
    caractristiques de fichier utilises lors de la gnration de
    l'en-tte de rponse HTTP <code>ETag</code> (entity tag) quand le
    document est contenu dans un fichier statique(la valeur de
    <code>ETag</code>
    est utilise dans le cadre de la gestion du cache pour prserver la
    bande passante rseau). La directive
    <code class="directive">FileETag</code> vous permet maintenant de choisir
    quelles caractristiques du fichier vont tre utilises, le cas
    chant. Les mots-cls reconnus sont :
    </p>

    <dl>
     <dt><strong>INode</strong></dt>
     <dd>Le numro d'i-node du fichier sera inclus dans le processus de
     gnration</dd>
     <dt><strong>MTime</strong></dt>
     <dd>La date et l'heure auxquelles le fichier a t modifi la
     dernire fois seront incluses</dd>
     <dt><strong>Size</strong></dt>
     <dd>La taille du fichier en octets sera incluse</dd>
     <dt><strong>All</strong></dt>
     <dd>Tous les champs disponibles seront utiliss. Cette dfinition
     est quivalente  : 
     <pre class="prettyprint lang-config">FileETag INode MTime Size</pre>
</dd>
     <dt><strong>None</strong></dt>
     <dd>Si le document se compose d'un fichier, aucun champ
     <code>ETag</code> ne sera inclus dans la rponse</dd>
    </dl>

    <p>Les mots-cls <code>INode</code>, <code>MTime</code>, et
    <code>Size</code> peuvent tre prfixs par <code>+</code> ou
    <code>-</code>, ce qui permet de modifier les valeurs par dfaut
    hrites d'un niveau de configuration plus gnral. Tout mot-cl
    apparaissant sans aucun prfixe annule entirement et immdiatement
    les configurations hrites.</p>

    <p>Si la configuration d'un rpertoire contient
    <code>FileETag&nbsp;INode&nbsp;MTime&nbsp;Size</code>, et si un de
    ses sous-rpertoires contient <code>FileETag&nbsp;-INode</code>, la
    configuration de ce sous-rpertoire (qui sera propage vers tout
    sous-rpertoire qui ne la supplante pas), sera quivalente 
    <code>FileETag&nbsp;MTime&nbsp;Size</code>.</p>
    <div class="warning"><h3>Avertissement</h3>
    Ne modifiez pas les valeurs par dfaut pour les rpertoires ou
    localisations o WebDAV est activ et qui utilisent
    <code class="module"><a href="../mod/mod_dav_fs.html">mod_dav_fs</a></code> comme fournisseur de stockage.
    <code class="module"><a href="../mod/mod_dav_fs.html">mod_dav_fs</a></code> utilise
    <code>MTime&nbsp;Size</code> comme format fixe pour les
    comparaisons de champs <code>ETag</code> dans les requtes
    conditionnelles. Ces requtes conditionnelles choueront si le
    format <code>ETag</code> est modifi via la directive
    <code class="directive">FileETag</code>.
    </div>
    <div class="note"><h3>Inclusions ct serveur</h3>
    Aucun champ ETag n'est gnr pour les rponses interprtes par
    <code class="module"><a href="../mod/mod_include.html">mod_include</a></code>, car l'entit de la rponse peut
    changer sans modification de l'INode, du MTime, ou de la taille du
    fichier statique contenant les directives SSI.
    </div>



</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="files" id="files">Directive</a> <a name="Files" id="Files">&lt;Files&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui s'appliquent aux fichiers
prciss</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;Files <var>nom fichier</var>&gt; ... &lt;/Files&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">&lt;Files&gt;</code> limite
    la porte des directives qu'elle contient aux fichiers prciss.
    Elle est comparable aux directives <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> et <code class="directive"><a href="#location">&lt;Location&gt;</a></code>. Elle doit se terminer par une
    balise <code>&lt;/Files&gt;</code>. Les directives contenues dans
    cette section s'appliqueront  tout objet dont le nom de base (la
    dernire partie du nom de fichier) correspond au fichier spcifi.
    Les sections <code class="directive">&lt;Files&gt;</code> sont
    traites selon l'ordre dans lequel elles apparaissent dans le
    fichier de configuration, aprs les sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> et la lecture des fichiers
    <code>.htaccess</code>, mais avant les sections <code class="directive"><a href="#location">&lt;Location&gt;</a></code>. Notez que les
    sections <code class="directive">&lt;Files&gt;</code> peuvent tre
    imbriques dans les sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> afin de restreindre la portion
    du systme de fichiers  laquelle ces dernires vont
    s'appliquer.</p>

    <p>L'argument <var>filename</var> peut contenir un nom de fichier
    ou une chane de caractres avec caractres gnriques, o
    <code>?</code> remplace un caractre, et <code>*</code> toute chane
    de caractres.</p>
    <pre class="prettyprint lang-config">&lt;Files "cat.html"&gt;
    # Insrer ici des directives qui s'appliquent au fichier cat.html
&lt;/Files&gt;

&lt;Files "?at.*"&gt;
    # Les directives insres ici s'appliqueront aux fichiers
    # cat.html, bat.html, hat.php, et ainsi de suite.
&lt;/Files&gt;</pre>

    
    <p>On peut aussi utiliser les <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">Expressions rationnelles</a> en ajoutant la
    caractre <code>~</code>. Par exemple :</p>

    <pre class="prettyprint lang-config">&lt;Files ~ "\.(gif|jpe?g|png)$"&gt;
    #...
&lt;/Files&gt;</pre>


    <p>correspondrait  la plupart des formats graphiques de l'Internet.
    Il est cependant prfrable d'utiliser la directive <code class="directive"><a href="#filesmatch">&lt;FilesMatch&gt;</a></code>.</p>

    <p>Notez qu' la diffrence des sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> et <code class="directive"><a href="#location">&lt;Location&gt;</a></code>, les sections <code class="directive">&lt;Files&gt;</code> peuvent tre utilises dans les
    fichiers <code>.htaccess</code>. Ceci permet aux utilisateurs de
    contrler l'accs  leurs propres ressources, fichier par
    fichier.</p>


<h3>Voir aussi</h3>
<ul>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manire dont ces diffrentes sections se combinent
entre elles  la rception d'une requte</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="filesmatch" id="filesmatch">Directive</a> <a name="FilesMatch" id="FilesMatch">&lt;FilesMatch&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui s'appliquent  des fichiers
spcifis sous la forme d'expressions rationnelles</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;FilesMatch <var>expression rationnelle</var>&gt; ...
&lt;/FilesMatch&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La section <code class="directive">&lt;FilesMatch&gt;</code>
    limite la porte des directives qu'elle contient aux fichiers
    spcifis, tout comme le ferait une section <code class="directive"><a href="#files">&lt;Files&gt;</a></code>. Mais elle accepte aussi les
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expressions rationnelles</a>. Par
    exemple :</p>

    <pre class="prettyprint lang-config">&lt;FilesMatch ".+\.(gif|jpe?g|png)$"&gt;
    # ...
&lt;/FilesMatch&gt;</pre>


    <p>correspondrait  la plupart des formats graphiques de
    l'Internet.</p>

    <div class="note">Les caractres <code>.+</code> au dbut de l'expression
    rationnelle permettent de s'assurer que les fichiers de nom
    <code>.png</code>, ou <code>.gif</code>, par exemple, ne seront pas
    pris en compte.</div>

    <p>A partir de la version 2.4.8, les groupes nomms et les
    rfrences arrires sont extraits et enregistrs dans
    l'environnement avec leur nom en majuscules et prfix
    par "MATCH_". Ceci permet
    de rfrencer des URLs dans des <a href="../expr.html">expressions</a>
    ou au sein de modules comme <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Pour
    viter toute confusion, les rfrences arrires numrotes (non
    nommes) sont ignores. Vous devez utiliser  la place des groupes
    nomms.</p>

<pre class="prettyprint lang-config">&lt;FilesMatch "^(?&lt;sitename&gt;[^/]+)"&gt;
    require ldap-group cn=%{env:MATCH_SITENAME},ou=combined,o=Example
&lt;/FilesMatch&gt;</pre>



<h3>Voir aussi</h3>
<ul>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manire dont ces diffrentes sections se combinent
entre elles  la rception d'une requte</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="forcetype" id="forcetype">Directive</a> <a name="ForceType" id="ForceType">ForceType</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Force le type de mdium spcifi dans le champ d'en-tte
HTTP Content-Type pour les fichiers correspondants</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ForceType <var>type mdium</var>|None</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Lorsqu'elle est place dans un fichier <code>.htaccess</code> ou
    une section <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>, <code class="directive"><a href="#location">&lt;Location&gt;</a></code>, ou <code class="directive"><a href="#files">&lt;Files&gt;</a></code>, cette directive force
    l'identification du type MIME des fichiers spcifis  la valeur de
    l'argument <var>type mdium</var>. Par exemple, si vous possdez un
    rpertoire ne contenant que des fichiers GIF, et si vous ne voulez
    pas leur ajouter l'extension <code>.gif</code>, vous pouvez utiliser
    :</p>

    <pre class="prettyprint lang-config">ForceType image/gif</pre>


    <p>Notez que cette directive l'emporte sur d'autres associations de
    type de mdium indirectes dfinies dans mime.types ou via la
    directive <code class="directive"><a href="../mod/mod_mime.html#addtype">AddType</a></code>.</p>

    <p>Vous pouvez aussi annuler toute dfinition plus gnrale de
    <code class="directive">ForceType</code> en affectant la valeur
    <code>None</code>  l'argument <var>type mdium</var> :</p>

    <pre class="prettyprint lang-config"># force le type MIME de tous les fichiers  image/gif:
&lt;Location "/images"&gt;
  ForceType image/gif
&lt;/Location&gt;

# mais utilise les mthodes classiques d'attribution du type MIME
# dans le sous-rpertoire suivant :
&lt;Location "/images/mixed"&gt;
  ForceType None
&lt;/Location&gt;</pre>

    
    <p>A la base, cette directive crase le type de contenu gnr pour
    les fichiers statiques servis  partir du sytme de fichiers. Pour
    les ressources autres que les fichiers statiques pour lesquels le
    gnrateur de rponse spcifie en gnral un type de contenu, cette
    directive est ignore.</p>

    <div class="note"><h3>Note</h3>
    <p>Lorsque des directives explicites comme <code class="directive"><a href="#sethandler">SetHandler</a></code> ou
    <code class="directive">module="mod_mime"&gt;AddHandler</code> ne s'appliquent
    pas  la requte courante, le nom du gestionnaire interne
    normalement dfini par ces directives correspondra alors au type de
    contenu spcifi par cette directive. Il s'agit d'un
    comportement historique que certains modules
    tiers, comme mod_php, peuvent interprter comme un type de contenu
    artificiel ne servant qu' indiquer le module qui doit prendre en
    compte la requte considre. Dans la mesure du
    possible, il est conseill d'viter les
    configurations qui comportent de tels types artificiels en utilisant
    les directives <code class="directive"><a href="#sethandler">SetHandler</a></code> ou
    <code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code>.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="gprofdir" id="gprofdir">Directive</a> <a name="GprofDir" id="GprofDir">GprofDir</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Rpertoire dans lequel crire les donnes de profiling
gmon.out.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>GprofDir <var>/tmp/gprof/</var>|<var>/tmp/gprof/</var>%</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Lorsque le serveur a t compil avec le support du profiling
    gprof, la directive <code class="directive">GprofDir</code> permet de
    spcifier dans quel rpertoire les fichiers <code>gmon.out</code>
    doivent tre crits lorsque le processus s'arrte. Si l'argument se
    termine par un caractre pourcentage ('%'), des sous-rpertoires
    sont crs pour chaque identifiant de processus.</p>

    <p>Cette directive ne fonctionne actuellement qu'avec le MPM
    <code class="module"><a href="../mod/prefork.html">prefork</a></code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="hostnamelookups" id="hostnamelookups">Directive</a> <a name="HostnameLookups" id="HostnameLookups">HostnameLookups</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la recherche DNS sur les adresses IP des
clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>HostnameLookups On|Off|Double</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>HostnameLookups Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive active la recherche DNS afin de pouvoir
    journaliser les nom d'htes (et les passer aux programmes CGI et aux
    inclusions SSI via la variable <code>REMOTE_HOST</code>). La valeur
    <code>Double</code> dclenche une double recherche DNS inverse. En
    d'autres termes, une fois la recherche inverse effectue, on lance
    une recherche directe sur le rsultat de cette dernire. Au moins
    une des adresses IP fournies par la recherche directe doit
    correspondre  l'adresse originale (ce que l'on nomme
    <code>PARANOID</code> dans la terminologie "tcpwrappers").</p>

    <p>Quelle que soit la configuration, lorsqu'on utilise
    <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code> pour contrler l'accs en fonction
    du nom d'hte, une double recherche DNS inverse est effectue,
    scurit oblige. Notez cependant que le rsultat de cette double
    recherche n'est en gnral pas accessible,  moins que vous n'ayez
    spcifi <code>HostnameLookups Double</code>. Par exemple, si vous
    n'avez spcifi que <code>HostnameLookups On</code>, et si une
    requte concerne un objet protg par des restrictions en fonction
    du nom d'hte, quel que soit le rsultat de la double recherche
    inverse, les programmes CGI ne recevront que le rsultat de la
    recherche inverse simple dans la variable
    <code>REMOTE_HOST</code>.</p>

    <p>La valeur par dfaut est <code>Off</code> afin de prserver le
    traffic rseau des sites pour lesquels la recherche inverse n'est
    pas vraiment ncessaire. Cette valeur par dfaut est aussi bnfique
    pour les utilisateurs finaux car il n'ont ainsi pas  subir de temps
    d'attente supplmentaires dus aux recherches DNS. Les sites
    fortement chargs devraient laisser cette directive 
    <code>Off</code>, car les recherches DNS peuvent prendre des temps
    trs longs. Vous pouvez ventuellement utiliser hors ligne
    l'utilitaire <code class="program"><a href="../programs/logresolve.html">logresolve</a></code>, compil par dfaut dans
    le sous-rpertoire <code>bin</code> de votre rpertoire
    d'installation, afin de dterminer les noms d'htes associs aux
    adresses IP journalises.</p>

    <p>Enfin, si vous avez des <a href="mod_authz_host.html#reqhost">directives Require  base de
    nom</a>, une recherche de nom d'hte sera effectue quelle que soit
    la dfinition de la directive <code>HostnameLookups</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="httpprotocoloptions" id="httpprotocoloptions">Directive</a> <a name="HttpProtocolOptions" id="HttpProtocolOptions">HttpProtocolOptions</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Modifie les contraintes sur les messages des requtes HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>HttpProtocolOptions [Strict|Unsafe] [RegisteredMethods|LenientMethods]
 [Allow0.9|Require1.0]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>HttpProtocolOptions Strict LenientMethods Allow0.9</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir des versions 2.2.32 et 2.4.24 du serveur HTTP
Apache</td></tr>
</table>
    <p>Cette directive permet de modifier les rgles qui s'appliquent  la ligne
    de requte HTTP (<a href="https://tools.ietf.org/html/rfc7230#section-3.1.1">RFC 7230
    3.1.1</a>) et aux champs des en-ttes des requtes HTTP (<a href="https://tools.ietf.org/html/rfc7230#section-3.2">RFC 7230
    3.2</a>), qui s'appliquent maintenant par dfaut ou en utilisant
    l'option <code>Strict</code>. L'option <code>Unsafe</code>
    a t ajoute pour pouvoir restaurer les anciens
    comportements ncessaires aux anciens modules et applications et aux agents
    utilisateurs personnaliss considrs comme obsoltes.</p>

    <p>Ces rgles
    s'appliquant avant le traitement de la requte, elles doivent, pour tre prises en
    compte, tre dfinies
    au niveau global ou dans la premire section par dfaut du serveur virtuel
    qui correspond  la requte considre, par interface IP/port et non par
    nom.</p>

    <p>Cette directive accepte trois paramtres issus de la liste suivante, ceux
    qui ne sont pas spcifis prenant leur valeur par dfaut :</p>

    <dl>
    <dt>Strict|Unsafe</dt>
    <dd>
    <p>Avant l'introduction de cette directive, les interprteurs de requtes du
    serveur HTTP Apache tolraient un grand nombre de formats en entre qui
    n'taient pas forcment conformes au protocole. <a href="https://tools.ietf.org/html/rfc7230#section-9.4">RFC 7230 9.4
    Request Splitting</a> et <a href="https://tools.ietf.org/html/rfc7230#section-9.5">9.5 Response
    Smuggling</a> ne rappellent que deux des risques potentiels induits par des
    requtes non conformes, alors que <a href="https://tools.ietf.org/html/rfc7230#section-3.5">RFC 7230
    3.5</a> signale les risques encourus par l'acceptation de blancs non
    conformes dans les lignes de requte. Avec l'introduction de cette
    directive, toutes les rgles de grammaire de la spcification doivent tre
    respectes dans le mode d'oprations par dfaut <code>Strict</code>.</p>

    <div class="warning"><h3>Risques de scurit lis au mode Unsafe</h3>
    <p>Il est fortement dconseill aux utilisateurs d'utiliser le mode
    d'opration <code>Unsafe</code>, ou
    <code>UnsafeWhitespace</code>, en particulier pour les dploiements de
    serveurs ouverts sur l'extrieur et/ou accessibles au public. Si un moniteur
    dfectueux ou autre logiciel spcialis ne s'excutant que sur un intranet
    ncessite une interface, les utilisateurs ne doivent utiliser les options de
    type UnSafe qu'en cas de ncessit et uniquement au sein d'un serveur
    virtuel bien spcifique et sur un rseau priv.</p>
    </div>

    <div class="example"><h3>Exemple de requte provoquant l'envoi d'un message HTTP 400 en
	mode Strict</h3><p><code>
        
        # Missing CRLF<br />
        GET / HTTP/1.0\n\n
      </code></p></div>
      <div class="warning"><h3>Utilitaires en ligne de commande et CRLF</h3>
        <p>Il peut s'avrer ncessaire de forcer certains utilitaires  utiliser
	CRLF ; si ce n'est pas le cas, httpd reverra une rponse HTTP 400 comme
	dans le cas prcdent. Par exemple, le <strong>client OpenSSL s_client
	doit utiliser le paramtre -crlf pour fonctionner correctement</strong>.</p>
        <p>Pour dtecter des problmes tels que l'absence de CRLF, vous pouvez
	utiliser la directive <code class="directive"><a href="../mod/mod_dumpio.html#dumpioinput">DumpIOInput</a></code> qui permet de dcortiquer
	les requtes HTTP.</p>
      </div>
    </dd>
    <dt>RegisteredMethods|LenientMethods</dt>
    <dd>
    <p>La section de la <a href="https://tools.ietf.org/html/rfc7231#section-4.1">RFC 7231
    4.1</a> "Request Methods" "Overview" indique que les serveurs doivent
    renvoyer un message d'erreur lorsque la ligne de requte comporte une
    mthode non supporte. C'est dj le cas lorsque l'option
    <code>LenientMethods</code> est utilise, mais les administrateurs ont la
    possibilit de limiter les mthodes utilises via l'option
    <code>RegisteredMethods</code> en enregistrant toute mthode non standard
    via la directive <code class="directive">RegisterHttpMethod</code>, en particulier
    si l'option <code>Unsafe</code> est utilise.</p>

    <div class="warning"><h3>Compatibilit avec le mandat direct</h3>
    <p>L'option
    <code>RegisteredMethods</code> <strong>ne doit pas</strong> tre utilise
    pour les serveurs mandataires car ces derniers ne connaissent pas les
    mthodes supportes par les serveurs originaux.</p>
    </div>

    <div class="example"><h3>Exemple de requte provoquant l'envoi d'un message HTTP 501 en
	mode LenientMethods</h3><p><code>
        
        # Mthode HTTP inconnue<br />
        WOW / HTTP/1.0\r\n\r\n<br /><br />
        # Mthode HTTP spcifie en minuscules<br />
        get / HTTP/1.0\r\n\r\n<br />
      </code></p></div>
      </dd>
      <dt>Allow0.9|Require1.0</dt>
      <dd>
    <p>La section de la <a href="https://tools.ietf.org/html/rfc2616#section-19.6">RFC 2616
    19.6</a> "Compatibility With Previous Versions" encouragait les
    serveurs HTTP  supporter les anciennes requtes HTTP/0.9. La RFC 7230 va
    cependant  son encontre via sa prconisation "Le souhait de supporter les
    requtes HTTP/0.9 a t supprim" et y adjoint des commentaires dans <a href="https://tools.ietf.org/html/rfc7230#appendix-A">RFC 7230 Appendix
    A</a>. A ce titre, l'option <code>Require1.0</code> permet  l'utilisateur
    d'inhiber le comportement induit par l'option par dfaut
    <code>Allow0.9</code>.</p>

    <div class="example"><h3>Exemple de requte provoquant l'envoi d'un message HTTP 400 en
	mode Require1.0</h3><p><code>
        
        # Version HTTP non supporte<br />
        GET /\r\n\r\n
      </code></p></div>
    </dd>
    </dl>

    <p>La consultation des messages enregistrs dans le journal
    <code class="directive">ErrorLog</code>, configur via la directive
    <code class="directive">LogLevel</code> avec un niveau <code>info</code>, pourra
    vous aider  identifier de telles requtes non conformes ainsi que leur
    provenance. Les utilisateurs devront accorder une attention particulire aux
    messages d'erreur de type 400 dans le journal access pour dtecter les
    requtes apparemment valides mais rejetes.</p>    

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="if" id="if">Directive</a> <a name="If" id="If">&lt;If&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui ne s'appliquent que si une
condition est satisfaite au cours du traitement d'une
requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;If <var>expression</var>&gt; ... &lt;/If&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Les conditions imbriques sont supportes  partir de la version
2.4.26 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive">&lt;If&gt;</code> value une
    expression  la vole, et applique les directives qu'elle contient
    si et seulement si l'expression renvoie la valeur "vrai". Par
    exemple :</p>

    <pre class="prettyprint lang-config">&lt;If "-z req('Host')"&gt;</pre>


    <p>serait satisfaite pour les requtes HTTP/1.0 sans en-tte
    <var>Host:</var>. Les expressions peuvent contenir diffrents
    oprateurs de type shell pour la comparaison de chanes
    (<code>==</code>, <code>!=</code>, <code>&lt;</code>, ...), la
    comparaison d'entiers (<code>-eq</code>, <code>-ne</code>, ...), ou
     usages divers (<code>-n</code>, <code>-z</code>, <code>-f</code>,
    ...). Les expressions rationnelles sont aussi supportes,</p>

    <pre class="prettyprint lang-config">&lt;If "%{QUERY_STRING} =~ /(delete|commit)=.*?elem/"&gt;</pre>


    <p>ainsi que les comparaison de modles de type shell et de
    nombreuses autres oprations. Ces oprations peuvent tre effectues
    sur les en-ttes de requtes (<code>req</code>), les variables
    d'environnement (<code>env</code>), et un grand nombre d'autres
    proprits. La documentation complte est disponible dans <a href="../expr.html">Les expressions dans le serveur HTTP Apache</a>.</p>

    <p>Cette section de configuration ne peut contenir que des
    directives qui supportent le <a href="directive-dict.html#Context">contexte de rpertoire</a>.</p>

    <div class="warning">
    Certain variables, such as <code>CONTENT_TYPE</code> and other
    response headers, are set after &lt;If&gt; conditions have already
    been evaluated, and so will not be available to use in this
    directive.
    </div>


<h3>Voir aussi</h3>
<ul>
<li><a href="../expr.html">Les expressions dans le serveur HTTP
Apache</a>, pour une rfrence complte et d'autres exemples.</li>
<li><code class="directive"><a href="#elseif">&lt;ElseIf&gt;</a></code></li>
<li><code class="directive"><a href="#else">&lt;Else&gt;</a></code></li>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manire dont ces diffrentes sections se combinent
entre elles  la rception d'une requte. Les
directives <code class="directive">&lt;If&gt;</code>, <code class="directive">&lt;ElseIf&gt;</code>, et <code class="directive">&lt;Else&gt;</code> s'appliquent en dernier.</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ifdefine" id="ifdefine">Directive</a> <a name="IfDefine" id="IfDefine">&lt;IfDefine&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui ne s'appliqueront que si un
test retourne "vrai" au dmarrage du serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;IfDefine [!]<var>paramtre</var>&gt; ...
    &lt;/IfDefine&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La section <code>&lt;IfDefine
    <var>test</var>&gt;...&lt;/IfDefine&gt;</code> permet de
    confrer un caractre conditionnel  un ensemble de directives. Les
    directives situes  l'intrieur d'une section <code class="directive">&lt;IfDefine&gt;</code> ne s'appliquent que si
    <var>test</var> est vrai. Si <var>test</var> est faux, tout ce qui
    se trouve entre les balises de dbut et de fin est ignor.</p>

    <p><var>test</var> peut se prsenter sous deux formes :</p>

    <ul>
      <li><var>nom paramtre</var></li>

      <li><code>!</code><var>nom paramtre</var></li>
    </ul>

    <p>Dans le premier cas, les directives situes entre les balises de
    dbut et de fin ne s'appliqueront que si le paramtre nomm <var>nom
    paramtre</var> est dfini. Le second format inverse le test, et
    dans ce cas, les directives ne s'appliqueront que si <var>nom
    paramtre</var> n'est <strong>pas</strong> dfini.</p>

    <p>L'argument <var>nom paramtre</var> est une dfinition qui peut
    tre effectue par la ligne de commande
    <code class="program"><a href="../programs/httpd.html">httpd</a></code> via le paramtre
    <code>-D<var>paramtre</var></code> au dmarrage du serveur, ou via la
    directive <code class="directive"><a href="#define">Define</a></code>.</p>

    <p>Les sections <code class="directive">&lt;IfDefine&gt;</code>
    peuvent tre imbriques, ce qui permet d'implmenter un test
    multi-paramtres simple. Exemple :</p>

    <div class="example"><p><code>httpd -DReverseProxy -DUseCache -DMemCache ...</code></p></div>
    <pre class="prettyprint lang-config">&lt;IfDefine ReverseProxy&gt;
  LoadModule proxy_module   modules/mod_proxy.so
  LoadModule proxy_http_module   modules/mod_proxy_http.so
  &lt;IfDefine UseCache&gt;
    LoadModule cache_module   modules/mod_cache.so
    &lt;IfDefine MemCache&gt;
      LoadModule mem_cache_module   modules/mod_mem_cache.so
    &lt;/IfDefine&gt;
    &lt;IfDefine !MemCache&gt;
      LoadModule cache_disk_module   modules/mod_cache_disk.so
    &lt;/IfDefine&gt;
  &lt;/IfDefine&gt;
&lt;/IfDefine&gt;</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ifmodule" id="ifmodule">Directive</a> <a name="IfModule" id="IfModule">&lt;IfModule&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui ne s'appliquent qu'en fonction
de la prsence ou de l'absence d'un module spcifique</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;IfModule [!]<var>fichier module</var>|<var>identificateur
module</var>&gt; ... &lt;/IfModule&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Les identificateurs de modules sont disponibles dans les
versions 2.1 et suprieures.</td></tr>
</table>
    <p>La section <code>&lt;IfModule
    <var>test</var>&gt;...&lt;/IfModule&gt;</code> permet de confrer 
    des directives un caractre conditionnel bas sur la prsence d'un
    module spcifique. Les directives situes dans une section
    <code class="directive">&lt;IfModule&gt;</code> ne s'appliquent que
    si <var>test</var> est vrai. Si <var>test</var> est faux, tout ce
    qui se trouve entre les balises de dbut et de fin est ignor.</p>

    <p><var>test</var> peut se prsenter sous deux formes :</p>

    <ul>
      <li><var>module</var></li>

      <li>!<var>module</var></li>
    </ul>

    <p>Dans le premier cas, les directives situes entre les balises de
    dbut et de fin ne s'appliquent que si le module <var>module</var>
    est prsent -- soit compil avec le binaire Apache httpd, soit charg
    dynamiquement via la directive <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code>. Le second format inverse le test, et dans
    ce cas, les directives ne s'appliquent que si <var>module</var>
    n'est <strong>pas</strong> prsent.</p>

    <p>L'argument <var>module</var> peut contenir soit l'identificateur
    du module, soit le nom du fichier source du module. Par exemple,
    <code>rewrite_module</code> est un identificateur et
    <code>mod_rewrite.c</code> le nom du fichier source
    correspondant. Si un module comporte plusieurs fichiers sources,
    utilisez le nom du fichier qui contient la chane de caractres
    <code>STANDARD20_MODULE_STUFF</code>.</p>

    <p>Les sections <code class="directive">&lt;IfModule&gt;</code>
    peuvent tre imbriques, ce qui permet d'implmenter des tests
    multi-modules simples.</p>

    <div class="note">Cette section ne doit tre utilise que si votre fichier de
    configuration ne fonctionne qu'en fonction de la prsence ou de
    l'absence d'un module spcifique. D'une manire gnrale, il n'est
    pas ncessaire de placer les directives  l'intrieur de sections
    <code class="directive">&lt;IfModule&gt;</code>.</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="include" id="include">Directive</a> <a name="Include" id="Include">Include</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Inclut d'autres fichiers de configuration dans un des
fichiers de configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Include <var>chemin-fichier</var>|<var>chemin-rpertoire</var>|<var>wildcard</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Utilisation des caractres gnriques dans la partie chemin depuis la
version 2.3.6</td></tr>
</table>
    <p>Cette directive permet l'inclusion d'autres fichiers de
    configuration dans un des fichiers de configuration du serveur.</p>

    <p>On peut utiliser des caractres gnriques de style Shell
    (<code>fnmatch()</code>) aussi bien dans la partie nom de fichier du
    chemin que dans la partie rpertoires pour inclure plusieurs
    fichiers en une
    seule fois, selon leur ordre alphabtique. De plus, si la directive
    <code class="directive">Include</code> pointe vers un rpertoire, Apache
    httpd inclura tous les fichiers de ce rpertoire et de tous ces
    sous-rpertoires. L'inclusion de rpertoires entiers est cependant
    dconseille, car il est frquent d'oublier des fichiers
    temporaires dans un rpertoire, ce qui causerait une erreur
    <code class="program"><a href="../programs/httpd.html">httpd</a></code> en cas d'inclusion. Pour inclure des
    fichiers qui correspondent  un certain modle, comme *.conf par
    exemple, nous vous recommandons d'utiliser plutt la syntaxe avec
    caractres gnriques comme ci-dessous.</p>

    <p>La directive <code class="directive"><a href="#include">Include</a></code>
    <strong>chouera avec un code d'erreur</strong> si une expression
   contenant des caractres gnriques ne correspond  aucun fichier.
   Pour ignorer les expressions contenant des caractres gnriques ne
   correspondant  aucun fichier, utilisez la directive <code class="directive"><a href="#includeoptional">IncludeOptional</a></code>.</p>

    <p>Le chemin fichier spcifi peut tre soit un chemin absolu, soit
    un chemin relatif au rpertoire dfini par la directive <code class="directive"><a href="#serverroot">ServerRoot</a></code>.</p>

    <p>Exemples :</p>

    <pre class="prettyprint lang-config">Include /usr/local/apache2/conf/ssl.conf
Include /usr/local/apache2/conf/vhosts/*.conf</pre>


    <p>ou encore, avec des chemins relatifs au rpertoire dfini par la
    directive <code class="directive"><a href="#serverroot">ServerRoot</a></code> :</p>

    <pre class="prettyprint lang-config">Include conf/ssl.conf
Include conf/vhosts/*.conf</pre>


    <p>On peut aussi insrer des caractres gnriques dans la partie
    rpertoires du chemin. Dans l'exemple suivant, la directive
    chouera si aucun sous-rpertoire de conf/vhosts ne contient au
    moins un fichier *.conf :</p>
  
    <pre class="prettyprint lang-config">Include conf/vhosts/*/*.conf</pre>


    <p>Par contre, dans l'exemple suivant, la directive sera simplement
    ignore si aucun sous-rpertoire de conf/vhosts ne contient au
    moins un fichier *.conf :</p>

    <pre class="prettyprint lang-config">IncludeOptional conf/vhosts/*/*.conf</pre>

  

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#includeoptional">IncludeOptional</a></code></li>
<li><code class="program"><a href="../programs/apachectl.html">apachectl</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="includeoptional" id="includeoptional">Directive</a> <a name="IncludeOptional" id="IncludeOptional">IncludeOptional</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Inclusion de fichiers dans le fichier de configuration</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>IncludeOptional
<var>chemin-fichier</var>|<var>chemin-rpertoire</var>|<var>wildcard</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.3.6 du serveur HTTP
Apache</td></tr>
</table>
    <p>Cette directive permet d'inclure des fichiers dans les fichiers
    de configuration du serveur. Elle fonctionne de manire identique 
    la directive <code class="directive"><a href="#include">Include</a></code>, 
    l'exception du fait que si l'expression avec caractres gnriques
    wilcard ne correspond  aucun fichier ou rpertoire, elle sera
    ignore silencieusement au lieu de causer une erreur.</p>    
    

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#include">Include</a></code></li>
<li><code class="program"><a href="../programs/apachectl.html">apachectl</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="keepalive" id="keepalive">Directive</a> <a name="KeepAlive" id="KeepAlive">KeepAlive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active les connexions HTTP persistantes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>KeepAlive On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>KeepAlive On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>L'extension Keep-Alive de HTTP/1.0 et l'implmentation des
    connexions persistantes dans HTTP/1.1 ont rendu possibles des
    sessions HTTP de longue dure, ce qui permet de transmettre
    plusieurs requtes via la mme connexion TCP. Dans certains cas, le
    gain en rapidit pour des documents comportant de nombreuses images
    peut atteindre 50%. Pour activer les connexions persistantes,
    dfinissez <code>KeepAlive On</code>.</p>

    <p>Pour les clients HTTP/1.0, les connexions persistantes ne seront
    mises en oeuvre que si elles ont t spcialement demandes par un
    client. De plus, une connexion persistante avec un client HTTP/1.0
    ne peut tre utilise que si la taille du contenu est connue
    d'avance. Ceci implique que les contenus dynamiques comme les
    sorties CGI, les pages SSI, et les listings de rpertoires gnrs
    par le serveur n'utiliseront en gnral pas les connexions
    persistantes avec les clients HTTP/1.0. Avec les clients HTTP/1.1,
    les connexions persistantes sont utilises par dfaut, sauf
    instructions contraires. Si le client le demande, le transfert par
    tronons de taille fixe (chunked encoding) sera utilis afin de
    transmettre un contenu de longueur inconnue via une connexion
    persistante.</p>

    <p>Lorsqu'un client utilise une connexion persistante, elle comptera
    pour une seule requte pour la directive <code class="directive"><a href="../mod/mpm_common.html#maxconnectionsperchild">MaxConnectionsPerChild</a></code>, quel
    que soit le nombre de requtes transmises via cette connexion.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#maxkeepaliverequests">MaxKeepAliveRequests</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="keepalivetimeout" id="keepalivetimeout">Directive</a> <a name="KeepAliveTimeout" id="KeepAliveTimeout">KeepAliveTimeout</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dure pendant laquelle le serveur va attendre une requte
avant de fermer une connexion persistante</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>KeepAliveTimeout <var>nombre</var>[ms]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>KeepAliveTimeout 5</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Le nombre de secondes pendant lesquelles Apache httpd va attendre une
    requte avant de fermer la connexion. Le dlai peut tre dfini en
    millisecondes en suffixant sa valeur par ms. La valeur du dlai
    spcifie par la directive <code class="directive"><a href="#timeout">Timeout</a></code> s'applique ds qu'une requte a
    t reue.</p>

    <p>Donner une valeur trop lve 
    <code class="directive">KeepAliveTimeout</code> peut induire des problmes
    de performances sur les serveurs fortement chargs. Plus le dlai
    est lv, plus nombreux seront les processus serveur en attente de
    requtes de la part de clients inactifs.</p>

    <p>Si la directive <code class="directive">KeepAliveTimeout</code> n'est
    <strong>pas</strong> dfinie pour un serveur virtuel  base de nom, c'est
    la valeur de la paire adresse IP/port du serveur virtuel qui
    correspond le mieux qui sera utilise.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limit" id="limit">Directive</a> <a name="Limit" id="Limit">&lt;Limit&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite les contrles d'accs que la section contient 
certaines mthodes HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;Limit <var>mthode</var> [<var>mthode</var>] ... &gt; ...
    &lt;/Limit&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig, Limit</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Les contrles d'accs s'appliquent normalement 
    <strong>toutes</strong> les mthodes d'accs, et c'est en gnral le
    comportement souhait. <strong>Dans le cas gnral, les directives
    de contrle d'accs n'ont pas  tre places dans une section
    <code class="directive">&lt;Limit&gt;</code>.</strong></p>

    <p>La directive <code class="directive">&lt;Limit&gt;</code> a pour
    but de limiter les effets des contrles d'accs aux mthodes HTTP
    spcifies. Pour toutes les autres mthodes, les restrictions
    d'accs contenues dans la section <code class="directive">&lt;Limit&gt;</code> <strong>n'auront aucun
    effet</strong>. L'exemple suivant n'applique les contrles d'accs
    qu'aux mthodes <code>POST</code>, <code>PUT</code>, et
    <code>DELETE</code>, en laissant les autres mthodes sans protection
    :</p>

    <pre class="prettyprint lang-config">&lt;Limit POST PUT DELETE&gt;
  Require valid-user
&lt;/Limit&gt;</pre>


    <p>La liste des noms de mthodes peut contenir une ou plusieurs
    valeurs parmi les suivantes : <code>GET</code>, <code>POST</code>,
    <code>PUT</code>, <code>DELETE</code>, <code>CONNECT</code>,
    <code>OPTIONS</code>, <code>PATCH</code>, <code>PROPFIND</code>,
    <code>PROPPATCH</code>, <code>MKCOL</code>, <code>COPY</code>,
    <code>MOVE</code>, <code>LOCK</code>, et <code>UNLOCK</code>.
    <strong>Le nom de mthode est sensible  la casse.</strong> Si la
    valeur <code>GET</code> est prsente, les requtes <code>HEAD</code>
    seront aussi concernes. La mthode <code>TRACE</code> ne peut pas
    tre limite (voir la directive <code class="directive"><a href="#traceenable">TraceEnable</a></code>).</p>

    <div class="warning">Une section <code class="directive">&lt;LimitExcept&gt;</code> doit toujours tre prfre 
    une section <code class="directive">&lt;Limit&gt;</code> pour la
    restriction d'accs, car une section <code class="directive"><a href="#limitexcept">&lt;LimitExcept&gt;</a></code> fournit une protection contre
    les mthodes arbitraires.</div>

    <p>Les directives <code class="directive">&lt;Limit&gt;</code> et
    <code class="directive"><a href="#limitexcept">&lt;LimitExcept&gt;</a></code>
    peuvent tre imbriques. Dans ce cas, pour chaque niveau des
    directives <code class="directive">&lt;Limit&gt;</code> ou  <code class="directive"><a href="#limitexcept">&lt;LimitExcept&gt;</a></code>, ces dernires
    doivent restreindre l'accs pour les mthodes auxquelles les
    contrles d'accs s'appliquent.</p>

    <div class="warning">Lorsqu'on utilise les directives <code class="directive">&lt;Limit&gt;</code> ou <code class="directive">&lt;LimitExcept&gt;</code> avec la directive <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>, la premire directive
    <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> dont la
    condition est satisfaite autorise la requte, sans tenir compte de
    la prsence d'autres directives <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>.</div>

    <p>Par exemple, avec la configuration suivante, tous les
    utilisateurs seront autoriss  effectuer des requtes
    <code>POST</code>, et la directive <code>Require group
    editors</code> sera ignore dans tous les cas :</p>

    <pre class="prettyprint lang-config">&lt;LimitExcept GET&gt;
  Require valid-user
&lt;/LimitExcept&gt;
&lt;Limit POST&gt;
  Require group editors
&lt;/Limit&gt;</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitexcept" id="limitexcept">Directive</a> <a name="LimitExcept" id="LimitExcept">&lt;LimitExcept&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Applique les contrles d'accs  toutes les mthodes HTTP,
sauf celles qui sont spcifies</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;LimitExcept <var>mthode</var> [<var>mthode</var>] ... &gt; ...
    &lt;/LimitExcept&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig, Limit</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p><code class="directive">&lt;LimitExcept&gt;</code> et
    <code>&lt;/LimitExcept&gt;</code> permettent de regrouper des
    directives de contrle d'accs qui s'appliqueront  toutes les
    mthodes d'accs HTTP qui ne font <strong>pas</strong> partie de la
    liste des arguments ; en d'autres termes, elles ont un comportement
    oppos  celui de la section <code class="directive"><a href="#limit">&lt;Limit&gt;</a></code>, et on peut les utiliser pour
    contrler aussi bien les mthodes standards que les mthodes non
    standards ou non reconnues. Voir la documentation de la section
    <code class="directive"><a href="#limit">&lt;Limit&gt;</a></code> pour plus
    de dtails.</p>

    <p>Par exemple :</p>

    <pre class="prettyprint lang-config">&lt;LimitExcept POST GET&gt;
  Require valid-user
&lt;/LimitExcept&gt;</pre>



</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitinternalrecursion" id="limitinternalrecursion">Directive</a> <a name="LimitInternalRecursion" id="LimitInternalRecursion">LimitInternalRecursion</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine le nombre maximal de redirections internes et de
sous-requtes imbriques</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitInternalRecursion <var>nombre</var> [<var>nombre</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitInternalRecursion 10</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Une redirection interne survient, par exemple, quand on utilise
    la directive <code class="directive"><a href="../mod/mod_actions.html#action">Action</a></code> qui
    redirige en interne la requte d'origine vers un script CGI. Une
    sous-requte est le mcanisme qu'utilise Apache httpd pour dterminer ce
    qui se passerait pour un URI s'il faisait l'objet d'une requte. Par
    exemple, <code class="module"><a href="../mod/mod_dir.html">mod_dir</a></code> utilise les sous-requtes pour
    rechercher les fichiers lists dans la directive <code class="directive"><a href="../mod/mod_dir.html#directoryindex">DirectoryIndex</a></code>.</p>

    <p>La directive <code class="directive">LimitInternalRecursion</code> permet
    d'viter un crash du serveur d  un bouclage infini de redirections
    internes ou de sous-requtes. De tels bouclages sont dus en gnral
     des erreurs de configuration.</p>

    <p>La directive accepte, comme arguments, deux limites qui sont
    values  chaque requte. Le premier <var>nombre</var> est le
    nombre maximum de redirections internes qui peuvent se succder. Le
    second <var>nombre</var> dtermine la profondeur d'imbrication
    maximum des sous-requtes. Si vous ne spcifiez qu'un seul
    <var>nombre</var>, il sera affect aux deux limites.</p>

    <pre class="prettyprint lang-config">LimitInternalRecursion 5</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitrequestbody" id="limitrequestbody">Directive</a> <a name="LimitRequestBody" id="LimitRequestBody">LimitRequestBody</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>limite la taille maximale du corps de la requte HTTP
envoye par le client</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitRequestBody <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitRequestBody 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive spcifie la taille maximale autorise pour le
    corps d'une requte ; la valeur de l'argument <var>octets</var> va
    de 0 (pour une taille illimite),  2147483647 (2Go). Voir la note
    ci-dessous pour la limite d'applicabilit aux requtes mandates.</p>

    <p>La directive <code class="directive">LimitRequestBody</code> permet de
    dfinir une limite pour la taille maximale autorise du corps d'une
    requte HTTP en tenant compte du contexte dans lequel la directive
    a t place (c'est  dire au niveau du serveur, d'un rpertoire,
    d'un fichier ou d'une localisation). Si la requte du client dpasse
    cette limite, le serveur rpondra par un message d'erreur et ne
    traitera pas la requte. La taille du corps d'une requte normale va
    varier de manire importante en fonction de la nature de la
    ressource et des mthodes autorises pour cette dernire. Les
    scripts CGI utilisent souvent le corps du message pour extraire les
    informations d'un formulaire. Les implmentations de la mthode
    <code>PUT</code> ncessitent une valeur au moins aussi leve que la
    taille maximale des reprsentations que le serveur dsire accepter
    pour cette ressource.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contrler plus efficacement les comportements anormaux des requtes
    des clients, ce qui lui permettra de prvenir certaines formes
    d'attaques par dni de service.</p>

    <p>Si par exemple, vous autorisez le chargement de fichiers vers une
    localisation particulire, et souhaitez limiter la taille des
    fichiers chargs  100Ko, vous pouvez utiliser la directive suivante
    :</p>

    <pre class="prettyprint lang-config">LimitRequestBody 102400</pre>


    <div class="note"><p>Pour une description dtaille de la manire dont cette
    directive est interprte par les requtes mandates, voir la
    documentation du module <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitrequestfields" id="limitrequestfields">Directive</a> <a name="LimitRequestFields" id="LimitRequestFields">LimitRequestFields</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite le nombre de champs d'en-tte autoriss dans une
requte HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitRequestFields <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitRequestFields 100</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p><var>nombre</var> est un entier de 0 (nombre de champs illimit)
     32767. La valeur par dfaut est dfinie  la compilation par la
    constante <code>DEFAULT_LIMIT_REQUEST_FIELDS</code> (100 selon la
    distribution).</p>

    <p>La directive <code class="directive">LimitRequestFields</code> permet 
    l'administrateur du serveur de modifier le nombre maximum de champs
    d'en-tte autoriss dans une requte HTTP. Pour un serveur, cette
    valeur doit tre suprieure au nombre de champs qu'une requte
    client normale peut contenir. Le nombre de champs d'en-tte d'une
    requte qu'un client utilise dpasse rarement 20, mais ce nombre
    peut varier selon les implmentations des clients, et souvent en
    fonction des extensions que les utilisateurs configurent dans leurs
    navigateurs pour supporter la ngociation de contenu dtaille. Les
    extensions HTTP optionnelles utilisent souvent les
    champs d'en-tte des requtes.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contrler plus efficacement les comportements anormaux des requtes
    des clients, ce qui lui permettra de prvenir certaines formes
    d'attaques par dni de service. La valeur spcifie doit tre
    augmente si les clients standards reoivent une erreur du serveur
    indiquant que la requte comportait un nombre d'en-ttes trop
    important.</p>

    <p>Par exemple :</p>

    <pre class="prettyprint lang-config">LimitRequestFields 50</pre>


    <div class="warning"><h3>Avertissement</h3>
     <p>Dans le cas des serveurs virtuels  base de noms, la valeur de
     cette directive est extraite du serveur virtuel par dfaut (le
     premier de la liste) pour la paire adresse IP/port.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitrequestfieldsize" id="limitrequestfieldsize">Directive</a> <a name="LimitRequestFieldSize" id="LimitRequestFieldSize">LimitRequestFieldSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ddinit la taille maximale autorise d'un en-tte de
requte HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitRequestFieldSize <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitRequestFieldSize 8190</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet de dfinir le nombre maximum
    d'<var>octets</var> autoriss dans un en-tte de requte HTTP.</p>

    <p>La directive <code class="directive">LimitRequestFieldSize</code> permet
     l'administrateur du serveur de dfinir la taille
    maximale autorise d'un en-tte de requte HTTP. Pour un serveur,
    cette valeur doit tre suffisamment grande pour contenir tout
    en-tte d'une requte client normale. La taille d'un champ d'en-tte
    de requte normal va varier selon les implmentations des clients,
    et en fonction des extensions que les utilisateurs
    configurent dans leurs navigateurs pour supporter la ngociation de
    contenu dtaille. Les en-ttes d'authentification SPNEGO peuvent
    atteindre une taille de 12392 octets.</p>

    <p>&gt;L'administrateur du serveur peut utiliser cette directive pour
    contrler plus efficacement les comportements anormaux des requtes
    des clients, ce qui lui permettra de prvenir certaines formes
    d'attaques par dni de service.</p>

    <p>Par exemple ::</p>

    <pre class="prettyprint lang-config">LimitRequestFieldSize 4094</pre>


    <div class="note">Dans des conditions normales, la valeur par dfaut de cette
    directive ne doit pas tre modifie.</div>

    <div class="warning"><h3>Avertissement</h3>
     <p>Dans le cas des serveurs virtuels  base de noms, la valeur de
     cette directive est extraite du serveur virtuel par dfaut (le
     premier de la liste) pour lequel la paire adresse IP/port
     correspond le mieux.</p>
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitrequestline" id="limitrequestline">Directive</a> <a name="LimitRequestLine" id="LimitRequestLine">LimitRequestLine</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la taille maximale d'une ligne de requte
HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitRequestLine <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitRequestLine 8190</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet de dfinir la taille maximale autorise
    pour une ligne de requte HTTP en <var>octets</var>.</p>

    <p>La directive <code class="directive">LimitRequestLine</code> permet 
    l'administrateur du serveur de dfinir la taille
    maximale autorise d'une ligne de requte HTTP client. Comme une
    requte comporte une mthode HTTP, un URI, et une version de
    protocole, la directive <code class="directive">LimitRequestLine</code>
    impose une restriction sur la longueur maximale autorise pour un
    URI dans une requte au niveau du serveur. Pour un serveur, cette
    valeur doit tre suffisamment grande pour rfrencer les noms de
    toutes ses ressources, y compris toutes informations pouvant tre
    ajoutes dans la partie requte d'une mthode <code>GET</code>.</p>

    <p>L'administrateur du serveur peut utiliser cette directive pour
    contrler plus efficacement les comportements anormaux des requtes
    des clients, ce qui lui permettra de prvenir certaines formes
    d'attaques par dni de service.</p>

    <p>Par exemple :</p>

    <pre class="prettyprint lang-config">LimitRequestLine 4094</pre>


    <div class="note">Dans des conditions normales, cette directive doit conserver
    sa valeur par dfaut.</div>

    <div class="warning"><h3>Avertissement</h3>
     <p>Dans le cas des serveurs virtuels  base de noms, la valeur de
     cette directive est extraite du serveur virtuel par dfaut (le
     premier de la liste) pour lequel la paire adresse IP/port
     correspond le mieux.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="limitxmlrequestbody" id="limitxmlrequestbody">Directive</a> <a name="LimitXMLRequestBody" id="LimitXMLRequestBody">LimitXMLRequestBody</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la taille maximale du corps d'une requte au format
XML</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LimitXMLRequestBody <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LimitXMLRequestBody 1000000</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Taille maximale (en octets) du corps d'une requte au format XML.
    Une valeur de <code>0</code> signifie qu'aucune limite n'est
    impose.</p>

    <p>Exemple :</p>

    <pre class="prettyprint lang-config">LimitXMLRequestBody 0</pre>



</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="location" id="location">Directive</a> <a name="Location" id="Location">&lt;Location&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>N'applique les directives contenues qu'aux URLs
spcifies</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;Location
    <var>chemin URL</var>|<var>URL</var>&gt; ... &lt;/Location&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">&lt;Location&gt;</code>
    limite la porte des directives contenues aux URLs dfinies par
    l'argument URL. Elle est similaire  la directive <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>, et marque le
    dbut d'une section qui se termine par une directive
    <code>&lt;/Location&gt;</code>. Les sections <code class="directive">&lt;Location&gt;</code> sont traites selon l'ordre dans
    lequel elles apparaissent dans le fichier de configuration, mais
    aprs les sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> et la lecture des
    fichiers <code>.htaccess</code>, et aprs les sections <code class="directive"><a href="#files">&lt;Files&gt;</a></code>.</p>

    <p>Les sections <code class="directive">&lt;Location&gt;</code>
    agissent compltement en dehors du systme de fichiers. Ceci a de
    nombreuses consquences. Parmi les plus importantes, on ne doit pas
    utiliser les sections <code class="directive">&lt;Location&gt;</code>
    pour contrler l'accs aux rpertoires du systme de fichiers. Comme
    plusieurs URLs peuvent correspondre au mme rpertoire du systme de
    fichiers, un tel contrle d'accs pourrait tre contourn.</p>

    <p>Les directives que contient cette section seront appliques aux
    requtes si la partie chemin de l'URL satisfait  l'un au moins de
    ces critres :
    </p>
    <ul>
      <li>Le chemin spcifi correspond exactement  la partie chemin de
      l'URL.
      </li>
      <li>Le chemin spcifi, qui se termine par un slash, est un
      prfixe de la partie chemin de l'URL (trait comme une racine du
      contexte).
      </li>
      <li>Le chemin spcifi, si on lui ajoute un slash de fin, est un
      prfixe de la partie chemin de l'URL (aussi trait comme une racine du
      contexte).
      </li>
    </ul>
    <p>
    Dans l'exemple ci-dessous, o aucun slash de fin n'est utilis, les
    directives contenues dans la section s'appliqueront  /private1,
    /private1/ et /private1/file.txt, mais pas  /private1other. 
    </p>
    <pre class="prettyprint lang-config">&lt;Location "/private1"&gt;
    #  ...
&lt;/Location&gt;</pre>

    <p>
    De mme, dans l'exemple ci-dessous, o l'on utilise un slash de fin, les
    directives contenues dans la section s'appliqueront  /private2/ et
     /private2/file.txt, mais pas  /private2other.
    </p>
    <pre class="prettyprint lang-config">&lt;Location "/private2<em>/</em>"&gt;
    # ...
&lt;/Location&gt;</pre>

    
    <div class="note"><h3>Quand utiliser la section <code class="directive">&lt;Location&gt;</code></h3>

    <p>Vous pouvez utiliser une section <code class="directive">&lt;Location&gt;</code> pour appliquer des directives 
    des contenus situs en dehors du systme de fichiers. Pour les
    contenus situs  l'intrieur du systme de fichiers, utilisez
    plutt les sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> et <code class="directive"><a href="#files">&lt;Files&gt;</a></code>. <code>&lt;Location
    "/"&gt;</code> constitue une exception et permet d'appliquer aisment
    une configuration  l'ensemble du serveur.</p>
    </div>

    <p>Pour toutes les requtes originales (non mandates), l'argument
    URL est un chemin d'URL de la forme
    <code>/chemin/</code>. <em>Aucun protocole, nom d'hte, port, ou chane
    de requte ne doivent apparatre.</em> Pour les requtes mandates, l'URL
    spcifie doit tre de la forme
    <code>protocole://nom_serveur/chemin</code>, et vous devez inclure
    le prfixe.</p>

    <p>L'URL peut contenir des caractres gnriques. Dans une chane
    avec caractres gnriques, <code>?</code> correspond  un caractre
    quelconque, et <code>*</code>  toute chane de caractres. Les
    caractres gnriques ne peuvent pas remplacer un / dans le chemin
    URL.</p>

    <p>On peut aussi utiliser les <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">Expressions
    rationnelles</a>, moyennant l'addition d'un caractre
    <code>~</code>. Par exemple :</p>

    <pre class="prettyprint lang-config">&lt;Location ~ "/(extra|special)/data"&gt;
    #...
&lt;/Location&gt;</pre>


    <p>concernerait les URLs contenant les sous-chane
    <code>/extra/data</code> ou <code>/special/data</code>. La directive
    <code class="directive"><a href="#locationmatch">&lt;LocationMatch&gt;</a></code>
    prsente un comportement identique  la version avec expressions
    rationnelles de la directive <code class="directive">&lt;Location&gt;</code>, et son utilisation est
    prfrable  l'utilisation de cette dernire pour la simple raison
    qu'il est difficile de distinguer <code>~</code> de <code>-</code>
    dans la plupart des fontes.</p>

    <p>La directive <code class="directive">&lt;Location&gt;</code>
    s'utilise principalement avec la directive <code class="directive"><a href="#sethandler">SetHandler</a></code>. Par exemple, pour activer les
    requtes d'tat, mais ne les autoriser que depuis des navigateurs
    appartenant au domaine <code>example.com</code>, vous pouvez
    utiliser :</p>

    <pre class="prettyprint lang-config">&lt;Location "/status"&gt;
  SetHandler server-status
  Require host example.com
&lt;/Location&gt;</pre>


    <div class="note"><h3>Note  propos du slash (/)</h3>
      <p>La signification du caractre slash dpend de l'endroit o il
      se trouve dans l'URL. Les utilisateurs peuvent tre habitus 
      son comportement dans le systme de fichiers o plusieurs slashes
      successifs sont souvent rduits  un slash unique (en d'autres
      termes, <code>/home///foo</code> est identique 
      <code>/home/foo</code>). Dans l'espace de nommage des URLs, ce
      n'est cependant pas toujours le cas. Pour la directive <code class="directive"><a href="#locationmatch">&lt;LocationMatch&gt;</a></code> et la
      version avec expressions rationnelles de la directive <code class="directive">&lt;Location&gt;</code>, vous devez spcifier
      explicitement les slashes multiples si telle est votre
      intention.</p>

      <p>Par exemple, <code>&lt;LocationMatch "^/abc"&gt;</code> va
      correspondre  l'URL <code>/abc</code> mais pas  l'URL <code>
      //abc</code>. La directive <code class="directive">&lt;Location&gt;</code> sans expression rationnelle se comporte de
      la mme manire lorsqu'elle est utilise pour des requtes
      mandates. Par contre, lorsque la directive <code class="directive">&lt;Location&gt;</code> sans expression rationnelle
      est utilise pour des requtes non mandates, elle fera
      correspondre implicitement les slashes multiples  des slashes
      uniques. Par exemple, si vous spcifiez <code>&lt;Location
      "/abc/def"&gt;</code>, une requte de la forme
      <code>/abc//def</code> correspondra.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manire dont ces diffrentes sections se combinent
entre elles  la rception d'une requte.</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="locationmatch" id="locationmatch">Directive</a> <a name="LocationMatch" id="LocationMatch">&lt;LocationMatch&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>N'applique les directives contenues qu'aux URLs
correspondant  une expression rationnelle</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;LocationMatch
    <var>regex</var>&gt; ... &lt;/LocationMatch&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">&lt;LocationMatch&gt;</code>
    limite la porte des directives contenues  l'URL spcifie, de
    manire identique  la directive <code class="directive"><a href="#location">&lt;Location&gt;</a></code>. Mais son argument permettant de
    spcifier les URLs concernes est une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a> au lieu d'une simple
    chane de caractres. Par exemple :</p>

    <pre class="prettyprint lang-config">&lt;LocationMatch "/(extra|special)/data"&gt;
    # ...
&lt;/LocationMatch&gt;</pre>


    <p>correspondrait  toute URL contenant les sous-chanes
    <code>/extra/data</code> ou <code>/special/data</code>.</p>

    <div class="note"><p>Si vous recherchez une URL <strong>commenant par</strong>
    plutt que seulement contenant <code>/extra/data</code>, prfixez
    l'expression rationnelle avec un <code>^</code>.</p>

    <pre class="prettyprint lang-config">&lt;LocationMatch "^/(extra|special)/data"&gt;</pre>

    </div>

    <p>A partir de la version 2.4.8, les groupes nomms et les
    rfrences arrires sont extraits et enregistrs dans
    l'environnement avec leur nom en majuscules et prfix
    par "MATCH_". Ceci permet
    de rfrencer des URLs dans des <a href="../expr.html">expressions</a>
    ou au sein de modules comme <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Pour
    viter toute confusion, les rfrences arrires numrotes (non
    nommes) sont ignores. Vous devez utiliser  la place des groupes
    nomms.</p>

<pre class="prettyprint lang-config">&lt;LocationMatch "^/combined/(?&lt;sitename&gt;[^/]+)"&gt;
    require ldap-group cn=%{env:MATCH_SITENAME},ou=combined,o=Example
&lt;/LocationMatch&gt;</pre>



<h3>Voir aussi</h3>
<ul>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manire dont ces diffrentes sections se combinent
entre elles  la rception d'une requte.</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="loglevel" id="loglevel">Directive</a> <a name="LogLevel" id="LogLevel">LogLevel</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contrle la verbosit du journal des erreurs</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>LogLevel [<var>module</var>:]<var>niveau</var>
    [<var>module</var>:<var>niveau</var>] ...
</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>LogLevel warn</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>La configuration du niveau de journalisation par module
et par rpertoire est disponible depuis la version 2.3.6 du serveur HTTP
Apache</td></tr>
</table>
    <p>La directive <code class="directive">LogLevel</code> permet d'ajuster la
    verbosit des messages enregistrs dans les journaux d'erreur (voir
    la directive <code class="directive"><a href="#errorlog">ErrorLog</a></code>
    directive). Les <var>niveau</var>x disponibles sont prsents
    ci-aprs, par ordre de criticit dcroissante :</p>

    <table class="bordered">
    
      <tr>
        <th><strong>Niveau</strong> </th>

        <th><strong>Description</strong> </th>

        <th><strong>Exemple</strong> </th>
      </tr>

      <tr>
        <td><code>emerg</code> </td>

        <td>Urgences - le systme est inutilisable.</td>

        <td>"Child cannot open lock file. Exiting"</td>
      </tr>

      <tr>
        <td><code>alert</code> </td>

        <td>Des mesures doivent tre prises immdiatement.</td>

        <td>"getpwuid: couldn't determine user name from uid"</td>
      </tr>

      <tr>
        <td><code>crit</code> </td>

        <td>Conditions critiques.</td>

        <td>"socket: Failed to get a socket, exiting child"</td>
      </tr>

      <tr>
        <td><code>error</code> </td>

        <td>Erreurs.</td>

        <td>"Premature end of script headers"</td>
      </tr>

      <tr>
        <td><code>warn</code> </td>

        <td>Avertissements.</td>

        <td>"child process 1234 did not exit, sending another
        SIGHUP"</td>
      </tr>

      <tr>
        <td><code>notice</code> </td>

        <td>Evnement important mais normal.</td>

        <td>"httpd: caught SIGBUS, attempting to dump core in
        ..."</td>
      </tr>

      <tr>
        <td><code>info</code> </td>

        <td>Informations.</td>

        <td>"Server seems busy, (you may need to increase
        StartServers, or Min/MaxSpareServers)..."</td>
      </tr>

      <tr>
        <td><code>debug</code> </td>

        <td>Messages de dbogage.</td>

        <td>"Opening config file ..."</td>
      </tr>
      <tr>
        <td><code>trace1</code> </td>

        <td>Messages de traces</td>

        <td>"proxy: FTP: control connection complete"</td>
      </tr>
      <tr>
        <td><code>trace2</code> </td>

        <td>Messages de traces</td>

        <td>"proxy: CONNECT: sending the CONNECT request to the remote proxy"</td>
      </tr>
      <tr>
        <td><code>trace3</code> </td>

        <td>Messages de traces</td>

        <td>"openssl: Handshake: start"</td>
      </tr>
      <tr>
        <td><code>trace4</code> </td>

        <td>Messages de traces</td>

        <td>"read from buffered SSL brigade, mode 0, 17 bytes"</td>
      </tr>
      <tr>
        <td><code>trace5</code> </td>

        <td>Messages de traces</td>

        <td>"map lookup FAILED: map=rewritemap key=keyname"</td>
      </tr>
      <tr>
        <td><code>trace6</code> </td>

        <td>Messages de traces</td>

        <td>"cache lookup FAILED, forcing new map lookup"</td>
      </tr>
      <tr>
        <td><code>trace7</code> </td>

        <td>Messages de traces, enregistrement d'une grande quantit de
	donnes</td>

        <td>"| 0000: 02 23 44 30 13 40 ac 34 df 3d bf 9a 19 49 39 15 |"</td>
      </tr>
      <tr>
        <td><code>trace8</code> </td>

        <td>Messages de traces, enregistrement d'une grande quantit de
	donnes</td>

        <td>"| 0000: 02 23 44 30 13 40 ac 34 df 3d bf 9a 19 49 39 15 |"</td>
      </tr>
    </table>

    <p>Lorsqu'un niveau particulier est spcifi, les messages de tous
    les autres niveaux de criticit suprieure seront aussi enregistrs.
    <em>Par exemple</em>, si <code>LogLevel info</code> est spcifi,
    les messages de niveaux <code>notice</code> et <code>warn</code>
    seront aussi mis.</p>

    <p>Il est recommand d'utiliser un niveau <code>crit</code> ou
    infrieur.</p>

    <p>Par exemple :</p>

    <pre class="prettyprint lang-config">LogLevel notice</pre>


    <div class="note"><h3>Note</h3>
      <p>Si la journalisation s'effectue directement dans un fichier,
      les messages de niveau <code>notice</code> ne peuvent pas tre
      supprims et sont donc toujours journaliss. Cependant, ceci ne
      s'applique pas lorsque la journalisation s'effectue vers
      <code>syslog</code>.</p>
    </div>
    
    <p>Spcifier un niveau sans nom de module va attribuer ce niveau 
    tous les modules. Spcifier un niveau avec nom de module va
    attribuer ce niveau  ce module seulement. Il est possible de
    spcifier un module par le nom de son fichier source ou par son
    identificateur, avec ou sans le suffixe <code>_module</code>. Les
    trois spcifications suivantes sont donc quivalentes :</p>

    <pre class="prettyprint lang-config">LogLevel info ssl:warn
LogLevel info mod_ssl.c:warn
LogLevel info ssl_module:warn</pre>


    <p>Il est aussi possible d'attribuer un niveau de journalisation par
    rpertoire :</p>

    <pre class="prettyprint lang-config">LogLevel info
&lt;Directory "/usr/local/apache/htdocs/app"&gt;
  LogLevel debug
&lt;/Directory&gt;</pre>


    <div class="note">
        La configuration du niveau de journalisation par rpertoire
	n'affecte que les messages journaliss aprs l'interprtation de
	la requte et qui sont associs  cette dernire. Les messages
	de journalisation associs  la connexion ou au serveur ne sont
	pas affects.
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#errorlog">ErrorLog</a></code></li>
<li><code class="directive"><a href="#errorlogformat">ErrorLogFormat</a></code></li>
<li><a href="../logs.html">Journaux du serveur HTTP Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="maxkeepaliverequests" id="maxkeepaliverequests">Directive</a> <a name="MaxKeepAliveRequests" id="MaxKeepAliveRequests">MaxKeepAliveRequests</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre de requtes permises pour une connexion
persistante</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MaxKeepAliveRequests <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MaxKeepAliveRequests 100</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">MaxKeepAliveRequests</code> permet
    de limiter le nombre de requtes autorises par connexion lorsque
    <code class="directive"><a href="#keepalive">KeepAlive</a></code> est  "on". Si sa
    valeur est <code>0</code>, le nombre de requtes autorises est
    illimit. Il est recommand de dfinir une valeur assez haute pour
    des performances du serveur maximales.</p>

    <p>Par exemple :</p>

    <pre class="prettyprint lang-config">MaxKeepAliveRequests 500</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="maxrangeoverlaps" id="maxrangeoverlaps">Directive</a> <a name="MaxRangeOverlaps" id="MaxRangeOverlaps">MaxRangeOverlaps</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre de chevauchements de segments de donnes autoris
    (par exemple <code>100-200,150-300</code>) avant le renvoi de la
    ressource complte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MaxRangeOverlaps default | unlimited | none | <var>nombre de
    chevauchements</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MaxRangeOverlaps 20</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.15 du serveur HTTP
    Apache</td></tr>
</table>
        <p>La directive <code class="directive">MaxRangeOverlaps</code> permet
	de limiter le nombre de chevauchements de segments de donnes HTTP
	autoris par le serveur. Si le nombre de
	chevauchements de segments demand est suprieur au nombre maximal
	autoris, la ressource sera renvoye dans son intgralit.</p>

        <dl>
            <dt><strong>default</strong></dt>
            <dd>Limite le nombre de chevauchements de segments  la valeur
	    par dfaut 20 dfinie  la compilation.</dd>

            <dt><strong>none</strong></dt>
            <dd>Aucun chevauchement de segment n'est autoris.</dd>

            <dt><strong>unlimited</strong></dt>
            <dd>Le nombre de chevauchements de segments est illimit.</dd>

            <dt><var>number-of-ranges</var></dt>
            <dd>Un nombre positif reprsente le nombre maximal de
	    chevauchements de segments autoris par le serveur.</dd>
        </dl>
    
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="maxrangereversals" id="maxrangereversals">Directive</a> <a name="MaxRangeReversals" id="MaxRangeReversals">MaxRangeReversals</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre d'inversions d'ordre autoris dans la spcification des
    segments de donnes (par exemple <code>100-200,50-70</code>) avant le renvoi de la
    ressource complte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MaxRangeReversals default | unlimited | none | <var>nombre
    d'inversions</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MaxRangeReversals 20</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.15 du serveur HTTP
    Apache</td></tr>
</table>
        <p>La directive <code class="directive">MaxRangeReversals</code> permet
	de limiter le nombre d'inversions d'ordre dans la spcification
	des segments de donnes HTTP
	autoris par le serveur. Si le nombre
	d'inversions demand est suprieur au nombre maximal
	autoris, la ressource sera renvoye dans son intgralit.</p>

        <dl>
            <dt><strong>default</strong></dt>
            <dd>Limite le nombre d'inversions  la valeur
	    par dfaut 20 dfinie  la compilation.</dd>

            <dt><strong>none</strong></dt>
            <dd>Aucune inversion n'est autorise.</dd>

            <dt><strong>unlimited</strong></dt>
            <dd>Le nombre d'inversions est illimit.</dd>

            <dt><var>number-of-ranges</var></dt>
            <dd>Un nombre positif reprsente le nombre maximal
	    d'inversions autoris par le serveur.</dd>
        </dl>
    
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="maxranges" id="maxranges">Directive</a> <a name="MaxRanges" id="MaxRanges">MaxRanges</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre de segments de donnes autoris avant le renvoi de
l'intgralit de la ressource</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MaxRanges default | unlimited | none | <var>nombre de segments</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MaxRanges 200</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.15 du serveur HTTP
Apache</td></tr>
</table>
    <p>La directive <code class="directive">MaxRanges</code> permet de limiter
    le nombre de segments de donnes que le serveur va renvoyer au
    client. Si un nombre de segments plus important est demand, la
    ressource sera renvoye dans son intgralit.</p>

    <dl>  
      <dt><strong>default</strong></dt>
      <dd>Limite le nombre de segments de donnes  200 (valeur par
      dfaut dfinie  la compilation).</dd>
   
      <dt><strong>none</strong></dt>
      <dd>Les en-ttes Range sont ignors.</dd>
          
      <dt><strong>unlimited</strong></dt>
      <dd>Le nombre de segments de donnes est illimit.</dd>

      <dt><var>nombre de segments</var></dt>
      <dd>Un nombre positif reprsentera la nombre de segments de
      donnes maximal que le serveur renverra au client.</dd>
    </dl>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="mergetrailers" id="mergetrailers">Directive</a> <a name="MergeTrailers" id="MergeTrailers">MergeTrailers</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si les donnes supplmentaires (trailers) sont
fusionnes avec les en-ttes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MergeTrailers [on|off]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MergeTrailers off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.11 du serveur HTTP
Apache</td></tr>
</table>
    <p>Cette directive permet de contrler la fusion des donnes HTTP
    supplmentaires (trailers) avec la reprsentation interne des
    en-ttes. Cette fusion intervient lorsque le corps de la requte a
    t entirement reu, bien longtemps aprs que la majeure partie du
    traitement des en-ttes ait une chance de pouvoir examiner ou
    modifier les en-ttes de la requte.</p>
    <p>Cette option a t introduite dans un souci de compatibilit avec
    les versions antrieures  2.4.11, o les donnes supplmentaires
    taient systmatiquement fusionnes avec les en-ttes de la requte.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="mutex" id="mutex">Directive</a> <a name="Mutex" id="Mutex">Mutex</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les mcanismes de mutex et le repertoire du fichier
verrou pour tous les mutex ou seulement les mutex spcifis</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Mutex <var>mcanisme</var> [default|<var>nom-mutex</var>] ... [OmitPID]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Mutex default</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.4 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive">Mutex</code> permet de dfinir le
    mcanisme de mutex, et ventuellement le rpertoire du fichier
    verrou que les modules et httpd utilisent pour srialiser l'accs aux
    ressources. Spcifiez <code>default</code> comme second argument
    pour modifier la configuration de tous les mutex ; spcifiez un nom
    de mutex (voir la table ci-dessous) comme second argument pour
    ne modifier que la configuration de ce mutex.</p>

    <p>La directive <code class="directive">Mutex</code> est typiquement
    utilise dans les situations exceptionnelles suivantes :</p>

    <ul>
        <li>choix d'un autre mcanisme de mutex lorsque le mcanisme par
	dfaut slectionn par <a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">APR</a> prsente un
	problme de fonctionnement ou de performances.</li>

        <li>choix d'un autre rpertoire utilis par les mutex  base de
	fichier lorsque le rpertoire par dfaut ne supporte pas le
	verrouillage</li>
    </ul>

    <div class="note"><h3>Modules supports</h3>
    <p>Cette directive ne configure que les mutex qui ont t
    enregistrs avec le serveur de base via l'API
    <code>ap_mutex_register()</code>. Tous les modules fournis avec
    httpd supportent la directive <code class="directive">Mutex</code>, mais il
    n'en sera pas forcment de mme pour les modules tiers.
    Reportez-vous  la documentation du module tiers considr afin de
    dterminer le(s) nom(s) de mutex qui pourront tre dfinis si la
    directive est supporte.</p>
    </div>

    

    <p>Les <em>mcanismes</em> de mutex disponibles sont les suivants :</p>
    <ul>
        <li><code>default | yes</code>
        <p>C'est l'implmentation du verrouillage par dfaut, telle
	qu'elle est dfinie par <a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">APR</a>. On peut
	afficher l'implmentation du verrouillage par dfaut via la
	commande <code class="program"><a href="../programs/httpd.html">httpd</a></code> avec l'option <code>-V</code>.</p></li>

        <li><code>none | no</code>
        <p>Le mutex est dsactiv, et cette valeur n'est permise pour un
	mutex que si le module indique qu'il s'agit d'un choix valide.
	Consultez la documentation du module pour plus d'informations.</p></li>

        <li><code>posixsem</code>
        <p>Une variante de mutex base sur un smaphore Posix.</p>

        <div class="warning"><h3>Avertissement</h3>
        <p>La proprit du smaphore n'est pas restitue si un thread du
	processus grant le mutex provoque une erreur de segmentation,
	ce qui provoquera un blocage du serveur web.</p>
        </div>
        </li>

        <li><code>sysvsem</code>
        <p>Une variante de mutex base sur un smaphore IPC SystemV.</p>

        <div class="warning"><h3>Avertissement</h3>
        <p>Il peut arriver que les smaphores SysV soient conservs si le
	processus se crashe avant que le smaphore ne soit supprim.</p>
	</div>

        <div class="warning"><h3>Scurit</h3>
        <p>L'API des smaphores permet les attaques par dni de service
	par tout programme CGI s'excutant sous le mme uid que le
	serveur web (autrement dit tous les programmes CGI,  moins que
	vous n'utilisiez un programme du style <code class="program"><a href="../programs/suexec.html">suexec</a></code>
	ou <code>cgiwrapper</code>).</p>
	</div>
        </li>

        <li><code>sem</code>
        <p>Slection de la "meilleure" implmentation des smaphores
	disponible ; le choix s'effectue entre les smaphores posix et
	IPC SystemV, dans cet ordre.</p></li>

        <li><code>pthread</code>
        <p>Une variante de mutex  base de mutex de thread Posix
	inter-processus.</p>

        <div class="warning"><h3>Avertissement</h3>
        <p>Sur la plupart des systmes, si un processus enfant se
	termine anormalement alors qu'il dtenait un mutex qui utilise
	cette implmentation, le serveur va se bloquer et cesser de
	rpondre aux requtes. Dans ce cas, un redmarrage manuel est
	ncessaire pour rcuprer le mutex.</p>
        <p>Solaris et Linux constituent des exceptions notables, en ceci qu'ils	fournissent
	un mcanisme qui permet en gnral de rcuprer le mutex aprs
	l'arrt anormal d'un processus enfant qui dtenait le mutex.</p>
        <p>Si votre systme est compatible POSIX ou implmente la fonction
	<code>pthread_mutexattr_setrobust_np()</code>, vous devriez
	pouvoir utiliser l'option <code>pthread</code> sans problme.</p>
        </div>
        </li>

        <li><code>fcntl:/chemin/vers/mutex</code>
        <p>Une variante de mutex utilisant un fichier verrou physique et
	la fonction <code>fcntl()</code>.</p>

        <div class="warning"><h3>Avertissement</h3>
        <p>Lorsqu'on utilise plusieurs mutex bass sur ce mcanisme dans
	un environnement multi-processus, multi-thread, des erreurs de
	blocage (EDEADLK) peuvent tre rapportes pour des oprations de
	mutex valides si la fonction <code>fcntl()</code> ne gre pas
	les threads, comme sous Solaris.</p>
	</div>
        </li>

        <li><code>flock:/chemin/vers/mutex</code>
        <p>Mthode similaire  <code>fcntl:/chemin/vers/mutex</code>,
	mais c'est la fonction <code>flock()</code> qui est utilise
	pour grer le verrouillage par fichier.</p></li>

        <li><code>file:/chemin/vers/mutex</code>
        <p>Slection de la "meilleure" implmentation de verrouillage
	par fichier disponible ; le choix s'effectue entre
	<code>fcntl</code> et <code>flock</code>, dans cet ordre.</p></li>
    </ul>

    <p>La plupart des mcanismes ne sont disponibles que sur les
    plate-formes o ces dernires et <a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">APR</a> les
    supportent. Les mcanismes qui ne sont pas disponibles sur toutes
    les plate-formes sont <em>posixsem</em>,
    <em>sysvsem</em>, <em>sem</em>, <em>pthread</em>, <em>fcntl</em>, 
    <em>flock</em>, et <em>file</em>.</p>

    <p>Avec les mcanismes  base de fichier <em>fcntl</em> et
    <em>flock</em>, le chemin, s'il est fourni, est un rpertoire dans
    lequel le fichier verrou sera cr. Le rpertoire par
    dfaut est le rpertoire d'excution de httpd relatif  la
    directive <code class="directive"><a href="#serverroot">ServerRoot</a></code>.
    Utilisez toujours un systme
    de fichiers local sur disque pour <code>/chemin/vers/mutex</code> et
    jamais un rpertoire se trouvant dans un systme de fichiers NFS ou
    AFS. Le nom de base du fichier se composera du type de mutex, d'une
    chane optionnelle correspondant  l'instance et fournie par le
    module ; et, sauf si le mot-cl <code>OmitPID</code> a t spcifi,
    l'identificateur du processus parent httpd sera ajout afin de
    rendre le nom du fichier unique, vitant ainsi tout conflit lorsque
    plusieurs instances d'httpd partagent le mme rpertoire de
    verrouillage. Par exemple, si le nom de mutex est
    <code>mpm-accept</code>, et si le rpertoire de verrouillage est
    <code>/var/httpd/locks</code>, le nom du fichier verrou pour
    l'instance httpd dont le processus parent a pour identifiant 12345
    sera <code>/var/httpd/locks/mpm-accept.12345</code>.</p>

    <div class="warning"><h3>Scurit</h3>
    <p>Il est conseill d'<em>viter</em> de placer les fichiers mutex
    dans un rpertoire o tout le monde peut crire comme
    <code>/var/tmp</code>, car quelqu'un pourrait initier une attaque
    par dni de service et empcher le serveur de dmarrer en crant un
    fichier verrou possdant un nom identique  celui que le serveur va
    tenter de crer.</p>
    </div>

    <p>La table suivante dcrit les noms de mutex utiliss par httpd et
    ses modules associs.</p>

    <table class="bordered"><tr class="header">
            <th>Nom mutex</th>
            <th>Module(s)</th>
            <th>Ressource protge</th>
	</tr>
<tr>
            <td><code>mpm-accept</code></td>
            <td>modules MPM <code class="module"><a href="../mod/prefork.html">prefork</a></code> et <code class="module"><a href="../mod/worker.html">worker</a></code></td>
            <td>connexions entrantes, afin d'viter le problme de
	    l'afflux de requtes ; pour plus d'informations, voir la
	    documentation <a href="../misc/perf-tuning.html">Amlioration des
	    performances</a></td>
	</tr>
<tr class="odd">
            <td><code>authdigest-client</code></td>
            <td><code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code></td>
            <td>liste de clients en mmoire partage</td>
	</tr>
<tr>
            <td><code>authdigest-opaque</code></td>
            <td><code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code></td>
            <td>compteur en mmoire partage</td>
	</tr>
<tr class="odd">
            <td><code>ldap-cache</code></td>
            <td><code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code></td>
            <td>cache de rsultat de recherche LDAP</td>
	</tr>
<tr>
            <td><code>rewrite-map</code></td>
            <td><code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code></td>
            <td>communication avec des programmes externes
	    d'associations de valeurs, afin d'viter les interfrences
	    d'entres/sorties entre plusieurs requtes</td>
	</tr>
<tr class="odd">
            <td><code>ssl-cache</code></td>
            <td><code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code></td>
            <td>cache de session SSL</td>
	</tr>
<tr>
            <td><code>ssl-stapling</code></td>
            <td><code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code></td>
            <td>cache de l'tiquetage OCSP ("OCSP stapling")</td>
	</tr>
<tr class="odd">
            <td><code>watchdog-callback</code></td>
            <td><code class="module"><a href="../mod/mod_watchdog.html">mod_watchdog</a></code></td>
            <td>fonction de rappel d'un module client particulier</td>
	</tr>
</table>

    <p>Le mot-cl <code>OmitPID</code> permet d'empcher l'addition de
    l'identifiant du processus httpd parent au nom du fichier verrou.</p>


    <p>Dans l'exemple suivant, le mcanisme de mutex pour le mutex
    mpm-accept est modifi pour passer du mcanisme par dfaut au
    mcanisme <code>fcntl</code>, avec le fichier verrou associ cr
    dans le rpertoire <code>/var/httpd/locks</code>. Le mcanisme de
    mutex par dfaut pour tous les autres mutex deviendra
    <code>sysvsem</code>.</p>

    <pre class="prettyprint lang-config">Mutex sysvsem default
Mutex fcntl:/var/httpd/locks mpm-accept</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="namevirtualhost" id="namevirtualhost">Directive</a> <a name="NameVirtualHost" id="NameVirtualHost">NameVirtualHost</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>OBSOLETE : Dfinit une adresse IP pour les serveurs virtuels  base de
nom</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>NameVirtualHost <var>adresse</var>[:<var>port</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>

    <p>Avant la version 2.3.11, il tait ncessaire de dfinir une
    directive <code class="directive">NameVirtualHost</code> pour indiquer au
    serveur qu'une paire adresse IP/port particulire pouvait tre
    utilise comme serveur virtuel  base de nom. Depuis la version
    2.3.11, chaque fois qu'une paire adresse IP/port est utilise dans
    plusieurs serveurs virtuels, l'hbergement virtuel  base de nom est
    automatiquement activ pour cette adresse.</p>
    
    <p>Cette directive n'a actuellement plus aucun effet.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../vhosts/">Documentation sur les serveurs
virtuels</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="options" id="options">Directive</a> <a name="Options" id="Options">Options</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les fonctionnalits disponibles pour un rpertoire
particulier</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Options
    [+|-]<var>option</var> [[+|-]<var>option</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Options FollowSymlinks</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>Options</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Avec la version 2.3.11, la valeur par dfaut passe de All
 FollowSymlinks</td></tr>
</table>
    <p>La directive <code class="directive">Options</code> permet de dfinir
    les fonctionnalits de serveur disponibles pour un rpertoire
    particulier.</p>

    <p><var>option</var> peut tre dfini  <code>None</code>, auquel
    cas aucune fonctionnalit spcifique n'est active, ou comprendre
    une ou plusieurs des options suivantes :</p>

    <dl>
      <dt><code>All</code></dt>

      <dd>Toutes les options except <code>MultiViews</code>.</dd>

      <dt><code>ExecCGI</code></dt>

      <dd>L'excution de scripts CGI  l'aide du module
      <code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code> est permise.</dd>

      <dt><code>FollowSymLinks</code></dt>

      <dd>

      Le serveur va suivre les liens symboliques dans le rpertoire
      concern. Il s'agit de la valeur par dfaut.
      <div class="note">
      <p>Bien que le serveur suive les liens symboliques, il ne modifie
      <em>pas</em> le nom de chemin concern dfini par la section
      <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>.</p>
      
      <p>Les options <code>FollowSymLinks</code> et
      <code>SymLinksIfOwnerMatch</code> ne fonctionnent que dans les
      sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> ou les fichiers
      <code>.htaccess</code>.</p>

      <p>Le fait d'omettre cette option ne doit pas tre considr comme
      une mesure de scurit efficace, car il existe toujours une
      situation de comptition (race condition) entre l'instant o l'on
      vrifie qu'un chemin n'est pas un lien symbolique, et l'instant o
      l'on utilise effectivement ce chemin.</p>
      </div></dd>

      <dt><code>Includes</code></dt>

      <dd>
      Les inclusions ct serveur (SSI)  l'aide du module
      <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> sont autorises.</dd>

      <dt><code>IncludesNOEXEC</code></dt>

      <dd>

      Les inclusions ct serveur (SSI) sont permises, mais <code>#exec
      cmd</code> et <code>#exec cgi</code> sont dsactivs.
      L'utilisation de <code>#include virtual</code> pour les scripts
      CGI est cependant toujours possible depuis des rpertoires
      dfinis par <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code>.</dd>

      <dt><code>Indexes</code></dt>

      <dd>
      Si une URL requise correspond au rpertoire concern, et si aucun
      <code class="directive"><a href="../mod/mod_dir.html#directoryindex">DirectoryIndex</a></code> (<em>par
      exemple</em> <code>index.html</code>) n'est dfini pour ce
      rpertoire, le module <code class="module"><a href="../mod/mod_autoindex.html">mod_autoindex</a></code> va renvoyer
      un listing format du rpertoire.</dd>

      <dt><code>MultiViews</code></dt>

      <dd>
      Les vues multiples ("multiviews")  <a href="../content-negotiation.html">contenu ngoci</a>  l'aide du
      module <code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code> sont autorises.
      <div class="note"><h3>Note</h3> <p>Cette option est ignore si elle est
      dfinie en tout autre endroit qu'une section <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code>, car
      <code class="module"><a href="../mod/mod_negotiation.html">mod_negotiation</a></code> a besoin de ressources relles
      pour effectuer ses comparaisons et ses valuations.</p></div>
      
      </dd>

      <dt><code>SymLinksIfOwnerMatch</code></dt>

      <dd>Le serveur ne suivra que les liens symboliques qui renvoient
      vers un fichier ou un rpertoire dont le propritaire est le mme
      que celui du lien.

      <div class="note"><h3>Note</h3>
      <p>Les options <code>FollowSymLinks</code> et
      <code>SymLinksIfOwnerMatch</code> ne fonctionnent que dans les
      sections <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> ou les fichiers
      <code>.htaccess</code>.</p>

      <p>Le fait d'omettre cette option ne doit pas tre considr comme
      une mesure de scurit efficace, car il existe toujours une
      situation de comptition (race condition) entre l'instant o l'on
      vrifie qu'un chemin n'est pas un lien symbolique, et l'instant o
      l'on utilise effectivement ce chemin.</p>
      </div> </dd>
    </dl>

    <p>Normalement, si plusieurs directives
    <code class="directive">Options</code> peuvent s'appliquer  un rpertoire,
    c'est la plus spcifique qui est utilise et les autres sont
    ignores ; les options ne sont pas fusionnes (voir <a href="../sections.html#merging">comment les sections sont
    fusionnes</a>). Elles le sont cependant si <em>toutes</em> les
    options de la directive <code class="directive">Options</code> sont
    prcdes d'un symbole <code>+</code> ou <code>-</code>. Toute
    option prcde d'un <code>+</code> est ajoute  la liste des
    options courantes de manire force et toute option prcde d'un
    <code>-</code> est supprime de la liste des options courantes de la
    mme manire.</p>

    <div class="note"><h3>Note</h3>
    <p>Mlanger des <code class="directive">Options</code> avec <code>+</code>
    ou <code>-</code> avec des <code class="directive">Options</code> sans
    <code>+</code> ou <code>-</code> constitue une erreur de syntaxe, et
    la vrification de la syntaxe au cours du dmarrage du serveur fera
    chouer ce dernier.</p>
    </div>

    <p>Par exemple, sans aucun symbole <code>+</code> et <code>-</code>
    :</p>

    <pre class="prettyprint lang-config">&lt;Directory "/web/docs"&gt;
  Options Indexes FollowSymLinks
&lt;/Directory&gt;

&lt;Directory "/web/docs/spec"&gt;
  Options Includes
&lt;/Directory&gt;</pre>


    <p>ici, seule l'option <code>Includes</code> sera prise en compte
    pour le rpertoire <code>/web/docs/spec</code>. Par contre, si la
    seconde directive <code class="directive">Options</code> utilise les
    symboles <code>+</code> et <code>-</code> :</p>

    <pre class="prettyprint lang-config">&lt;Directory "/web/docs"&gt;
  Options Indexes FollowSymLinks
&lt;/Directory&gt;

&lt;Directory "/web/docs/spec"&gt;
  Options +Includes -Indexes
&lt;/Directory&gt;</pre>


    <p>alors, les options <code>FollowSymLinks</code> et
    <code>Includes</code> seront prises en compte pour le rpertoire
    <code>/web/docs/spec</code>.</p>

    <div class="note"><h3>Note</h3>
      <p>L'utilisation de <code>-IncludesNOEXEC</code> ou
      <code>-Includes</code> dsactive compltement les inclusions ct
      serveur sans tenir compte des dfinitions prcdentes.</p>
    </div>

    <p>En l'absence de toute dfinition d'options, la valeur par dfaut
    est <code>FollowSymlinks</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="protocol" id="protocol">Directive</a> <a name="Protocol" id="Protocol">Protocol</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Protocole pour une socket d'coute</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Protocol <var>protocole</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.1.5 d'Apache, mais
seulement depuis la version 2.3.3 sous Windows.</td></tr>
</table>
    <p>Cette directive permet de spcifier le protocole utilis pour une
    socket d'coute particulire. Le protocole sert  dterminer quel
    module doit traiter une requte, et d'appliquer les optimisations
    spcifiques au protocole via la directive
    <code class="directive">AcceptFilter</code>.</p>

    <p>Vous ne devez dfinir le protocole que si vous travaillez avec
    des ports non standards ; dans le cas gnral, le protocole
    <code>http</code> est associ au port 80 et le protocole
    <code>https</code> au port 443.</p>

    <p>Par exemple, si vous travaillez avec le protocole
    <code>https</code> sur un port non standard, spcifiez le protocole
    de manire explicite :</p>

    <pre class="prettyprint lang-config">Protocol https</pre>


    <p>Vous pouvez aussi spcifier le protocole via la directive
    <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#acceptfilter">AcceptFilter</a></code></li>
<li><code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="protocols" id="protocols">Directive</a> <a name="Protocols" id="Protocols">Protocols</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Protocoles disponibles pour un serveur virtuel ou non</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Protocols <var>protocole</var> ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Protocols http/1.1</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.17 du serveur
    HTTP Apache.</td></tr>
</table>
        <p>Cette directive permet de spcifier la liste des protocoles
	supports par un serveur virtuel ou non. Cette liste numre les
	protocoles qu'un client sera autoris  ngocier avec ce
	serveur.</p>
        
        <p>Par dfaut,
	seul le	protocole http/1.1 est disponible (compatible avec les
	clients http/1.0 et http/0.9). Par consquent, vous devez
	fournir cette liste si vous voulez tendre les protocoles
	disponibles pour le serveur.</p>
        
        <p>Par exemple, si vous voulez autoriser le protocole
	HTTP/2 pour un serveur avec TLS, utilisez
	cette directive comme suit :</p>
        
        <pre class="prettyprint lang-config">Protocols h2 http/1.1</pre>


        <p>Les protocoles valides sont <code>http/1.1</code> pour les
	connexions http et https, <code>h2</code> pour les connections
	https et <code>h2c</code> pour les connexions http. D'autres
	modules peuvent fournir d'autres protocoles.</p>
        
        <p>Spcifier des protocoles non disponibles ou dsactivs n'aura
	aucun effet, et ceux-ci seront simplement ignors.</p>
        
        <p>Si un serveur virtuel ne possde pas de directive Protocols
	propre, il hrite des protocoles spcifis pour le serveur
	principal. Autrement dit, les directives Protocols dfinies au
	niveau d'un serveur virtuel remplacent celles dfinies au niveau
	du serveur principal.
        </p>

    
<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#protocolshonororder">ProtocolsHonorOrder</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="protocolshonororder" id="protocolshonororder">Directive</a> <a name="ProtocolsHonorOrder" id="ProtocolsHonorOrder">ProtocolsHonorOrder</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine qui du client ou du serveur dtermine l'ordre
    des protocoles au cours de la ngociation de la connexion</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProtocolsHonorOrder On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProtocolsHonorOrder On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.17 du serveur
    HTTP Apache.</td></tr>
</table>
        <p>Cette directive permet de dfinir si le serveur doit tenir
	compte de l'ordre des protocoles dfinis par la directive
	<code class="directive">Protocols</code>.</p>
        
        <p>Si cette directive est dfinie  Off, l'ordre de la liste des
	protocoles fournie par le client l'emporte sur l'ordre dfini
	dans la configuration du serveur.</p>
        
        <p>Si la directive <code class="directive">ProtocolsHonorOrder</code>
	est dfinie  <code>on</code> (valeur par dfaut),
	il n'est pas tenu compte de l'ordre de la liste des protocoles
	fournie par le client, et seul l'ordre de la liste des protocles
	dfinie au niveau du serveur influera la
	ngociation du protocole.</p>
        
    
<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#protocols">Protocols</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="qualifyredirecturl" id="qualifyredirecturl">Directive</a> <a name="QualifyRedirectURL" id="QualifyRedirectURL">QualifyRedirectURL</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Vrifie si la variable d'environnement REDIRECT_URL est
pleinement qualifie</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>QualifyRedirectURL ON|OFF</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>QualifyRedirectURL OFF</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Directive supporte  partir de la version 2.4.18 du
serveur HTTP Apache. Jusqu' la version 2.4.17, le serveur se comportait
comme si la directive QualifyRedirectURL tait dfinie  ON.</td></tr>
</table>
    <p>Cette directive permet de s'assurer que le serveur vrifiera que
    la variable d'environnement REDIRECT_URL est bien pleinement
    qualifie. Par dfaut, cette variable contient l'URL textuellement
    demande par le client, par exemple "/index.html". Avec <code class="directive"><a href="#qualifyredirecturl on">QualifyRedirectURL ON</a></code>, la mme requte
    affectera  la variable REDIRECT_URL une valeur du style
    "http://www.example.com/index.html".</p>
    <p>Mme si cette directive n'est pas dfinie, lorsqu'une requte est
    soumise avec une URL pleinement qualifie, la variable REDIRECT_URL
    contiendra quand-mme une URL pleinement qualifie.
    </p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="registerhttpmethod" id="registerhttpmethod">Directive</a> <a name="RegisterHttpMethod" id="RegisterHttpMethod">RegisterHttpMethod</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Enregistrement de mthodes HTTP non standards</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RegisterHttpMethod <var>mthode</var> [<var>mthode</var> [...]]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
<p>Normalement, les mthodes HTTP non conformes aux RFCs correspondantes
sont rejetes au cours du traitement de la requte par HTTPD. Pour
viter ceci, les modules peuvent enregistrer les mthodes HTTP non
standards qu'ils supportent. La directive
<code class="directive">RegisterHttpMethod</code> permet d'enregistrer de telles
mthodes manuellement. Ceci peut s'avrer utile si de telle mthodes
doivent tre utilises dans un traitement externe, comme un script CGI.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="rlimitcpu" id="rlimitcpu">Directive</a> <a name="RLimitCPU" id="RLimitCPU">RLimitCPU</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite le temps CPU allou aux processus initis par les
processus enfants d'Apache httpd</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RLimitCPU <var>secondes</var>|max [<var>secondes</var>|max]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Non dfini ; utilise les valeurs par dfaut du systme
d'exploitation</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Prend 1 ou 2 paramtres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux paramtres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond  la valeur
    maximale autorise par la configuration du systme d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'excuter en tant que <code>root</code>, ou se trouver dans sa
    phase de dmarrage.</p>

    <p>Cette directive s'applique aux processus initis par les
    processus enfants d'Apache httpd qui traitent les requtes, et non aux
    processus enfants eux-mmes. Sont concerns les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initis par
    le processus parent d'Apache httpd comme les journalisations rediriges
    vers un programme.</p>

    <p>Les limites de ressources CPU sont exprimes en secondes par
    processus.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#rlimitmem">RLimitMEM</a></code></li>
<li><code class="directive"><a href="#rlimitnproc">RLimitNPROC</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="rlimitmem" id="rlimitmem">Directive</a> <a name="RLimitMEM" id="RLimitMEM">RLimitMEM</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite la mmoire alloue aux processus initis par les
processus enfants d'Apache httpd</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RLimitMEM <var>octets</var>|max [<var>octets</var>|max]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Non dfini ; utilise les valeurs par dfaut du systme
d'exploitation</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Prend 1 ou 2 paramtres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux paramtres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond  la valeur
    maximale autorise par la configuration du systme d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'excuter en tant que <code>root</code>, ou se trouver dans sa
    phase de dmarrage.</p>

    <p>Cette directive s'applique aux processus initis par les
    processus enfants d'Apache httpd qui traitent les requtes, et non aux
    processus enfants eux-mmes. Sont concerns les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initis par
    le processus parent d'Apache httpd comme les journalisations rediriges
    vers un programme.</p>

    <p>Les limites de ressources mmoire sont exprimes en octets par
    processus.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#rlimitcpu">RLimitCPU</a></code></li>
<li><code class="directive"><a href="#rlimitnproc">RLimitNPROC</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="rlimitnproc" id="rlimitnproc">Directive</a> <a name="RLimitNPROC" id="RLimitNPROC">RLimitNPROC</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite le nombre de processus qui peuvent tre initis par
les processus initis par les processus enfants d'Apache httpd</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RLimitNPROC <var>nombre</var>|max [<var>nombre</var>|max]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Unset; uses operating system defaults</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Prend 1 ou 2 paramtres. Le premier definit la limite de
    consommation de ressources pour tous les processus, et le second la
    consommation de ressources maximale. Les deux paramtres peuvent
    contenir soit un nombre, soit <code>max</code> pour indiquer au
    serveur que la limite de consommation correspond  la valeur
    maximale autorise par la configuration du systme d'exploitation.
    Pour augmenter la consommation maximale de ressources, le serveur
    doit s'excuter en tant que <code>root</code>, ou se trouver dans sa
    phase de dmarrage.</p>

    <p>Cette directive s'applique aux processus initis par les
    processus enfants d'Apache httpd qui traitent les requtes, et non aux
    processus enfants eux-mmes. Sont concerns les scripts CGI et les
    commandes exec des SSI, mais en aucun cas les processus initis par
    le processus parent d'Apache httpd comme les journalisations rediriges
    vers un programme.</p>

    <p>Les limites des processus contrlent le nombre de processus par
    utilisateur.</p>

    <div class="note"><h3>Note</h3>
      <p>Si les processus CGI s'excutent sous le mme
      utilisateur que celui du serveur web, cette
      directive va limiter le nombre de processus que le serveur
      pourra lui-mme crer. La prsence de messages
      <strong><code>cannot fork</code></strong> dans le journal des
      erreurs indiquera que la limite est atteinte.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#rlimitmem">RLimitMEM</a></code></li>
<li><code class="directive"><a href="#rlimitcpu">RLimitCPU</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="scriptinterpretersource" id="scriptinterpretersource">Directive</a> <a name="ScriptInterpreterSource" id="ScriptInterpreterSource">ScriptInterpreterSource</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Permet de localiser l'interprteur des scripts
CGI</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ScriptInterpreterSource Registry|Registry-Strict|Script</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ScriptInterpreterSource Script</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Win32 seulement.</td></tr>
</table>
    <p>Cette directive permet de contrler la mthode qu'utilise Apache
    httpd pour trouver l'interprteur destin  excuter les scripts CGI. La
    dfinition par dfaut est <code>Script</code> : ceci indique 
    Apache httpd qu'il doit utiliser l'interprteur prcis dans la ligne
    shebang du script (la premire ligne, commenant par
    <code>#!</code>). Sur les systmes Win32, cette ligne ressemble
    souvent  ceci :</p>

    <pre class="prettyprint lang-perl">#!C:/Perl/bin/perl.exe</pre>


    <p>ou simplement, dans le cas o <code>perl</code> est dans le
    <code>PATH</code> :</p>

    <pre class="prettyprint lang-perl">#!perl</pre>


    <p>Avec <code>ScriptInterpreterSource Registry</code>, Windows va
    effectuer une recherche dans l'arborescence
    <code>HKEY_CLASSES_ROOT</code> de la base de registre avec comme
    mot-cl l'extension du fichier contenant le script (par exemple
    <code>.pl</code>). C'est la commande dfinie par la sous-cl de
    registre <code>Shell\ExecCGI\Command</code> ou, si elle n'existe
    pas, la sous-cl <code>Shell\Open\Command</code> qui est utilise
    pour ouvrir le fichier du script. Si ces cls de registre ne sont
    pas trouves, Apache httpd utilise la mthode de l'option
    <code>Script</code>.</p>

    <div class="warning"><h3>Scurit</h3>
    <p>Soyez prudent si vous utilisez <code>ScriptInterpreterSource
    Registry</code> avec des rpertoires faisant l'objet d'un <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code>, car Apache httpd va essayer
    d'excuter <strong>tous</strong> les fichiers contenus dans
    celui-ci. L'option <code>Registry</code> peut causer des appels de
    programmes non voulus sur des fichiers non destins  tre excuts.
    Par exemple, la commande par dfaut open sur les fichiers
    <code>.htm</code> sur la plupart des systmes Windows va lancer
    Microsoft Internet Explorer ; ainsi, toute requte HTTP pour un
    fichier <code>.htm</code> situ dans le rpertoire des scripts
    va lancer le navigateur en arrire-plan sur le serveur, ce qui a
    toutes les chances de crasher votre systme dans les minutes qui
    suivent.</p>
    </div>

    <p>L'option <code>Registry-Strict</code>, apparue avec la version
    2.0 du serveur HTTP Apache,
    agit de manire identique  <code>Registry</code>, mais n'utilise
    que la sous-cl <code>Shell\ExecCGI\Command</code>. La prsence de
    la cl <code>ExecCGI</code> n'tant pas systmatique, Elle doit tre
    dfinie manuellement dans le registre Windows et vite ainsi tout
    appel de programme accidentel sur votre systme.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="seerequesttail" id="seerequesttail">Directive</a> <a name="SeeRequestTail" id="SeeRequestTail">SeeRequestTail</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si mod_status affiche les 63 premiers caractres
d'une requte ou les 63 derniers, en supposant que la requte
elle-mme possde plus de 63 caractres.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SeeRequestTail On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>SeeRequestTail Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.2.7
d'Apache httpd.</td></tr>
</table>
    <p>Avec <code>ExtendedStatus On</code>, mod_status affiche la
    vritable requte en cours de traitement. Pour des raisons
    historiques, seuls 63 caractres de la requte sont rellement
    stocks  des fins d'affichage. Cette directive permet de dterminer
    si ce sont les 63 premiers caractres qui seront stocks (c'est le
    comportement par dfaut),
    ou si ce sont les 63 derniers. Ceci ne s'applique bien entendu que
    si la taille de la requte est de 64 caractres ou plus.</p>

    <p>Si Apache httpd traite la requte <code>GET&nbsp;/disque1/stockage/apache/htdocs/images/rep-images1/nourriture/pommes.jpg&nbsp;HTTP/1.1</code>
    , l'affichage de la requte par mod_status se prsentera comme suit :
    </p>

    <table class="bordered">
      <tr>
        <th>Off (dfaut)</th>
        <td>GET&nbsp;/disque1/stockage/apache/htdocs/images/rep-images1/nourritu</td>
      </tr>
      <tr>
        <th>On</th>
        <td>apache/htdocs/images/rep-images1/nourriture/pommes.jpg&nbsp;HTTP/1.1</td>
      </tr>
    </table>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="serveradmin" id="serveradmin">Directive</a> <a name="ServerAdmin" id="ServerAdmin">ServerAdmin</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>L'adresse lectronique que le serveur inclut dans les
messages d'erreur envoys au client</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerAdmin <var>adresse lectronique</var>|<var>URL</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ServerAdmin</code> permet de dfinir
    l'adresse de contact que le serveur va inclure dans tout message
    d'erreur qu'il envoie au client. Si le programme <code>httpd</code>
    ne reconnait pas l'argument fourni comme une URL, il suppose que
    c'est une <var>adresse lectronique</var>, et lui ajoute le prfixe
    <code>mailto:</code> dans les cibles des hyperliens. Il est
    cependant recommand d'utiliser exclusivement une adresse
    lectronique, car de nombreux scripts CGI considrent ceci comme
    implicite. Si vous utilisez une URL, elle doit pointer vers un autre
    serveur que vous contrlez. Dans le cas contraire, les utilisateurs
    seraient dans l'impossibilit de vous contacter en cas de problme.</p>

    <p>Il peut s'avrer utile de dfinir une adresse ddie 
    l'administration du serveur, par exemple :</p>

    <pre class="prettyprint lang-config">ServerAdmin www-admin@foo.example.com</pre>

    <p>car les utilisateurs ne mentionnent pas systmatiquement le
    serveur dont ils parlent !</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="serveralias" id="serveralias">Directive</a> <a name="ServerAlias" id="ServerAlias">ServerAlias</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Autres noms d'un serveur utilisables pour atteindre des
serveurs virtuels  base de nom</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerAlias <var>nom serveur</var> [<var>nom serveur</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ServerAlias</code> permet de dfinir
    les noms alternatifs d'un serveur utilisables pour atteindre des <a href="../vhosts/name-based.html">serveurs virtuels  base de
    nom</a>. La directive <code class="directive">ServerAlias</code> peut
    contenir des caractres gnriques, si ncessaire.</p>

    <pre class="prettyprint lang-config">&lt;VirtualHost *:80&gt;
  ServerName server.example.com
  ServerAlias server server2.example.com server2
  ServerAlias *.example.com
  UseCanonicalName Off
  # ...
&lt;/VirtualHost&gt;</pre>

    <p>La recherche du serveur virtuel  base de nom correspondant au
    plus prs  la requte s'effectue selon l'ordre d'apparition des
    directives <code class="directive"><a href="#virtualhost">&lt;virtualhost&gt;</a></code> dans le fichier de
    configuration. Le premier serveur virtuel dont le <code class="directive"><a href="#servername">ServerName</a></code> ou le <code class="directive"><a href="#serveralias">ServerAlias</a></code> correspond est choisi, sans
    priorit particulire si le nom contient des caractres gnriques
    (que ce soit pour ServerName ou ServerAlias).</p>

    <p>Tous les noms spcifis au sein d'une section <code class="directive"><a href="#virtualhost">&lt;VirtualHost&gt;</a></code> sont traits comme un
    <code class="directive">ServerAlias</code> (sans caractres gnriques).</p>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code></li>
<li><a href="../vhosts/">Documentation sur les serveurs virtuels
du serveur HTTP Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="servername" id="servername">Directive</a> <a name="ServerName" id="ServerName">ServerName</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom d'hte et port que le serveur utilise pour
s'authentifier lui-mme</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerName
[<var>protocole</var>://]<var>nom-de-domaine</var>|<var>adresse-ip</var>[:<var>port</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ServerName</code> permet de dfinir
    les protocole, nom d'hte et port d'une requte que le serveur
    utilise pour s'authentifier lui-mme.</p>

    <p>La directive <code class="directive">ServerName</code> permet (ventuellement en
    conjonction avec la directive <code class="directive"><a href="#serveralias">ServerAlias</a></code>) d'identifier de manire unique un
    serveur virtuel, lorsqu'elle est utilise dans un contexte de <a href="../vhosts/name-based.html">serveurs virtuels  base de noms</a>.</p>

    <p>Cette directive est aussi utilise lors de la cration d'URLs de
    redirection relatives quand la directive <code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code> est dfinie  une valeur autre
    que la valeur par dfaut.</p>
    
    <p>Par exemple, si le nom de la
    machine hbergeant le serveur web est
    <code>simple.example.com</code>, la machine possde l'alias
    DNS <code>www.example.com</code>, et si vous voulez que le serveur
    web s'identifie avec cet alias, vous devez utilisez la dfinition
    suivante :</p>

    <pre class="prettyprint lang-config">ServerName www.example.com</pre>


    <p>La directive <code class="directive">ServerName</code> peut apparatre 
    toutes les tapes de la dfinition du serveur. Toute occurrence
    annule cependant la prcdente (pour ce serveur).</p>

    <p>Si la directive <code class="directive">ServerName</code> n'est pas
    dfinie, le serveur tente de dterminer le nom
    d'hte visible du point de vue du client en demandant tout d'abord au
    systme d'exploitation le nom d'hte systme, et en cas d'chec, en effectuant
    une recherche DNS inverse sur une adresse IP prsente sur le systme.</p>
    
    <p>Si la directive
    <code class="directive">ServerName</code> ne prcise pas de port, le serveur
    utilisera celui de la requte entrante. Il est recommand de
    spcifier un nom d'hte et un port spcifiques  l'aide de la
    directive <code class="directive">ServerName</code> pour une fiabilit
    optimale et  titre prventif.</p>

    <p>Si vous dfinissez des <a href="../vhosts/name-based.html">serveurs virtuels  base de
    nom</a>, une directive <code class="directive">ServerName</code> situe 
    l'intrieur d'une section <code class="directive"><a href="#virtualhost">&lt;VirtualHost&gt;</a></code> spcifiera quel nom d'hte
    doit apparatre dans l'en-tte de requte <code>Host:</code> pour
    pouvoir atteindre ce serveur virtuel.</p>


    <p>Parfois, le serveur s'excute en amont d'un dispositif qui
    implmente SSL, comme un mandataire inverse, un rpartiteur de
    charge ou un botier ddi SSL. Dans ce cas, spcifiez le protocole
    <code>https://</code> et le port auquel les clients se connectent
    dans la directive <code class="directive">ServerName</code>, afin de
    s'assurer que le serveur gnre correctement ses URLs
    d'auto-identification.
    </p>

    <p>Voir la description des directives <code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code> et <code class="directive"><a href="#usecanonicalphysicalport">UseCanonicalPhysicalPort</a></code> pour les
    dfinitions qui permettent de dterminer si les URLs
    auto-identifiantes (par exemple via le module
    <code class="module"><a href="../mod/mod_dir.html">mod_dir</a></code>) vont faire rfrence au port spcifi, ou
    au port indiqu dans la requte du client.
    </p>

    <div class="warning">
    <p>Si la valeur de la directive <code class="directive">ServerName</code> ne
    peut pas tre rsolue en adresse IP, le dmarrage du serveur
    provoquera un avertissement. <code>httpd</code> va alors utiliser le
    rsultat de la commande systme <code>hostname</code> pour
    dterminer le nom du serveur, ce qui ne correspondra pratiquement
    jamais au nom de serveur que vous souhaitez rellement.</p>
    <div class="example"><p><code>
    httpd: Could not reliably determine the server's fully qualified domain name, using rocinante.local for ServerName
    </code></p></div>
    </div>


<h3>Voir aussi</h3>
<ul>
<li><a href="../dns-caveats.html">Problmes concernant le DNS et
le serveur HTTP Apache</a></li>
<li><a href="../vhosts/">Documentation sur les serveurs virtuels
du serveur HTTP Apache</a></li>
<li><code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code></li>
<li><code class="directive"><a href="#usecanonicalphysicalport">UseCanonicalPhysicalPort</a></code></li>
<li><code class="directive"><a href="#serveralias">ServerAlias</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="serverpath" id="serverpath">Directive</a> <a name="ServerPath" id="ServerPath">ServerPath</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom de chemin d'URL hrit pour un serveur virtuel  base
de nom accd par un navigateur incompatible</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerPath <var>chemin d'URL</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ServerPath</code> permet de dfinir
    le nom de chemin d'URL hrit d'un hte,  utiliser avec les <a href="../vhosts/">serveurs virtuels  base de nom</a>.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../vhosts/">Documentation sur les serveurs virtuels
du serveur HTTP Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="serverroot" id="serverroot">Directive</a> <a name="ServerRoot" id="ServerRoot">ServerRoot</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Racine du rpertoire d'installation du
serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerRoot <var>chemin de rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ServerRoot /usr/local/apache</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ServerRoot</code> permet de dfinir
    le rpertoire dans lequel le serveur est install. En particulier,
    il contiendra les sous-rpertoires <code>conf/</code> et
    <code>logs/</code>. Les chemins relatifs indiqus dans les autres
    directives (comme <code class="directive"><a href="#include">Include</a></code> ou <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code>) seront dfinis par
    rapport  ce rpertoire.</p>

    <pre class="prettyprint lang-config">ServerRoot "/home/httpd"</pre>


    <p>La valeur par dfaut de <code class="directive">ServerRoot</code> peut
    tre modifie via l'argument <code>--prefix</code> de la commande <a href="../programs/configure.html"><code>configure</code></a>, et de
    nombreuses distributions tierces du serveur proposent une valeur
    diffrente de celles listes ci-dessus.</p>


<h3>Voir aussi</h3>
<ul>
<li><a href="../invoking.html">the <code>-d</code>
    options de <code>httpd</code></a></li>
<li><a href="../misc/security_tips.html#serverroot">les conseils 
propos de scurit</a> pour des informations sur la manire de dfinir
correctement les permissions sur le rpertoire indiqu par la directive
<code class="directive">ServerRoot</code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="serversignature" id="serversignature">Directive</a> <a name="ServerSignature" id="ServerSignature">ServerSignature</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit un pied de page pour les documents gnrs par le
serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerSignature On|Off|EMail</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ServerSignature Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>All</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">ServerSignature</code> permet de
    dfinir une ligne de pied de page fixe pour les documents gnrs
    par le serveur (messages d'erreur, listings de rpertoires ftp de
    <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>, sorties de <code class="module"><a href="../mod/mod_info.html">mod_info</a></code>,
    etc...). Dans le cas d'une chane de mandataires, l'utilisateur n'a
    souvent aucun moyen de dterminer lequel des mandataires chans a
    gnr un message d'erreur, et c'est une des raisons pour lesquelles
    on peut tre amen  ajouter un tel pied de page.</p>

    <p>La valeur par dfaut <code>Off</code> supprime la ligne de pied
    de page (et est ainsi compatible avec le comportement des
    versions 1.2 et antrieures d'Apache). la valeur <code>On</code>
    ajoute simplement une ligne contenant le numro de version du
    serveur ainsi que le nom du serveur virtuel issu de la directive
    <code class="directive"><a href="#servername">ServerName</a></code>, alors que la valeur
    <code>EMail</code> ajoute en plus une rfrence "mailto:" 
    l'administrateur du document rfrenc issu la directive
    <code class="directive"><a href="#serveradmin">ServerAdmin</a></code>.</p>

    <p>Aprs la version 2.0.44, les dtails  propos du numro de
    version du serveur sont contrls  l'aide de la directive
    <code class="directive"><a href="#servertokens">ServerTokens</a></code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#servertokens">ServerTokens</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="servertokens" id="servertokens">Directive</a> <a name="ServerTokens" id="ServerTokens">ServerTokens</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configure l'en-tte <code>Server</code> de la rponse
HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ServerTokens Major|Minor|Min[imal]|Prod[uctOnly]|OS|Full</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ServerTokens Full</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive permet de contrler le contenu de l'en-tte
    <code>Server</code> inclus dans la rponse envoye au client : cet
    en-tte peut contenir le type de systme d'exploitation du serveur,
    ainsi que des informations  propos des modules compils avec le
    serveur.</p>

    <dl>
	<dt><code>ServerTokens Full</code> (ou non spcifi)</dt>

	<dd>Le serveur envoie par exemple : <code>Server: Apache/2.4.2
	(Unix) PHP/4.2.2 MyMod/1.2</code></dd>

    	<dt><code>ServerTokens Prod[uctOnly]</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache</code></dd>

      <dt><code>ServerTokens Major</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2</code></dd>

      <dt><code>ServerTokens Minor</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.4</code></dd>

      <dt><code>ServerTokens Min[imal]</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.4.2</code></dd>

      <dt><code>ServerTokens OS</code></dt>

      <dd>Le serveur renvoie (<em>par exemple</em>): <code>Server:
      Apache/2.4.2 (Unix)</code></dd>

      
      
    </dl>

    <p>Cette dfinition s'applique  l'ensemble du serveur et ne peut
    tre active ou dsactive pour tel ou tel serveur virtuel.</p>

    <p>Dans les versions postrieures  2.0.44, cette directive contrle
    aussi les informations fournies par la directive <code class="directive"><a href="#serversignature">ServerSignature</a></code>.</p>

    <div class="note">Dfinir <code class="directive">ServerTokens</code>  une
    valeur infrieure  <code>minimal</code> n'est pas
    recommand car le dbogage des problmes
    interoprationnels n'en sera alors que plus difficile. Notez
    aussi que la dsactivation de l'en-tte Server:
    n'amliore en rien la scurit de votre
    serveur ; le concept de "scurit par
    l'obscurit" est un mythe et conduit 
    une mauvaise perception de ce qu'est la scurit.</div>



<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#serversignature">ServerSignature</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="sethandler" id="sethandler">Directive</a> <a name="SetHandler" id="SetHandler">SetHandler</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Force le traitement des fichiers spcifis par un
gestionnaire particulier</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SetHandler <var>handler-name</var>|none|<var>expression</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>L'argument expression est disponible  partir de la version
2.4.19 su serveur HTTP Apache</td></tr>
</table>
    <p>Lorsqu'elle se situe  l'intrieur d'un fichier
    <code>.htaccess</code>, ou d'une section <code class="directive"><a href="#directory">&lt;Directory&gt;</a></code> ou <code class="directive"><a href="#location">&lt;Location&gt;</a></code>, cette directive force le
    traitement de tous les fichiers spcifis par le <a href="../handler.html">gestionnaire</a> dfini par l'argument
    <var>nom gestionnaire</var>. Par exemple, dans le cas d'un
    rpertoire dont vous voulez interprter le contenu comme des
    fichiers de rgles d'images cliquables, sans tenir compte des
    extensions, vous pouvez ajouter la ligne suivante dans un fichier
    <code>.htaccess</code> de ce rpertoire :</p>

    <pre class="prettyprint lang-config">SetHandler imap-file</pre>


    <p>Autre exemple : si vous voulez que le serveur affiche un
    compte-rendu d'tat chaque fois qu'une URL du type <code>http://nom
    serveur/status</code> est appele, vous pouvez ajouter ceci dans
    <code>httpd.conf</code> :</p>

    <pre class="prettyprint lang-config">&lt;Location "/status"&gt;
  SetHandler server-status
&lt;/Location&gt;</pre>


    <p>Vous pouvez aussi utiliser cette directive pour associer un
    gestionnaire  des fichiers possdant une extension de nom de
    fichier particulire. Par exemple :</p>

    <pre class="prettyprint lang-config">&lt;FilesMatch "\.php$"&gt;
    SetHandler application/x-httpd-php
&lt;/FilesMatch&gt;</pre>


    <p>Pour rfrencer des variables spcifiques  une requte, y compris les
    rfrences arrires vers des expressions rationnelles nommes, vous pouvez
    utiliser des expressions ayant pour valeur une chane : </p>

    <pre class="prettyprint lang-config">&lt;LocationMatch ^/app/(?&lt;sub&gt;[^/]+)/&gt;
     SetHandler "proxy:unix:/var/run/app_%{env:MATCH_sub}.sock|fcgi://localhost:8080"
&lt;/LocationMatch&gt;</pre>


    <p>Vous pouvez craser la dfinition antrieure d'une directive
    <code class="directive">SetHandler</code> en utilisant la valeur
    <code>None</code>.</p>

    <div class="note"><h3>Note</h3>
    <p>Comme <code class="directive">SetHandler</code> l'emporte sur la
    dfinition des gestionnaires par dfaut, le comportement habituel
    consistant  traiter les URLs se terminant par un slash (/) comme
    des rpertoires ou des fichiers index est dsactiv.</p></div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="setinputfilter" id="setinputfilter">Directive</a> <a name="SetInputFilter" id="SetInputFilter">SetInputFilter</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les filtres par lesquels vont passer les requtes
client et les donnes POST</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SetInputFilter <var>filtre</var>[;<var>filtre</var>...]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">SetInputFilter</code> permet de
    dfinir le ou les filtres par lesquels vont passer les requtes
    client et les donnes POST au moment o le serveur les reoit. Cette
    dfinition vient en ajout  tout autre filtre dfini en
    quelqu'endroit que ce soit, y compris via la directive <code class="directive"><a href="../mod/mod_mime.html#addinputfilter">AddInputFilter</a></code>.</p>

    <p>Si la directive comporte plusieurs filtres, ils doivent tre
    spars par des points-virgules, et spcifis selon l'ordre dans
    lequel vous souhaitez les voir agir sur les contenus.</p>

<h3>Voir aussi</h3>
<ul>
<li>documentation des <a href="../filter.html">Filtres</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="setoutputfilter" id="setoutputfilter">Directive</a> <a name="SetOutputFilter" id="SetOutputFilter">SetOutputFilter</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les filtres par lesquels vont passer les rponses
du serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SetOutputFilter <var>filtre</var>[;<var>filtre</var>...]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">SetOutputFilter</code> permet de
    dfinir les filtres par lesquels vont passer les rponses du serveur
    avant d'tre envoyes au client. Cette dfinition vient en ajout 
    tout autre filtre dfini en quelqu'endroit que ce soit, y compris
    via la directive <code class="directive"><a href="../mod/mod_mime.html#addoutputfilter">AddOutputFilter</a></code>.</p>

    <p>Par exemple, la configuration suivante va traiter tous les
    fichiers du rpertoire <code>/www/data/</code> comme des inclusions
    ct serveur (SSI) :</p>

    <pre class="prettyprint lang-config">&lt;Directory "/www/data/"&gt;
  SetOutputFilter INCLUDES
&lt;/Directory&gt;</pre>


    <p>Si la directive comporte plusieurs filtres, ils doivent tre
    spars par des points-virgules, et spcifis selon l'ordre dans
    lequel vous souhaitez les voir agir sur les contenus.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../filter.html">Filters</a> documentation</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="timeout" id="timeout">Directive</a> <a name="TimeOut" id="TimeOut">TimeOut</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Temps pendant lequel le serveur va attendre certains
vnements avant de considrer qu'une requte a chou</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>TimeOut <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>TimeOut 60</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>La directive <code class="directive">TimeOut</code> permet de dfinir le
    temps maximum pendant lequel Apache httpd va attendre des entres/sorties
    selon les circonstances :</p>

    <ul>
      <li><p>Lors de la lecture de donnes en provenance du client, le
      temps maximum jusqu' l'arrive d'un paquet TCP si le tampon est
      vide.</p>
      <p>Pour les donnes initiales d'une nouvelle connexion, et tant qu'une
      directive <code class="directive"><a href="#acceptfilter">AcceptFilter</a></code> n'aura pas
      transmis cette nouvelle connexion au serveur, cette directive n'aura aucun
      effet.</p>
      </li>

      <li>Lors de l'criture de donnes destines au client, le temps
      maximum jusqu' l'arrive de l'accus-rception d'un paquet si le
      tampon d'envoi est plein.</li>

      <li>Avec <code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code> et <code class="module"><a href="../mod/mod_cgid.html">mod_cgid</a></code>, le temps
      d'attente maximum pour un bloc individuel en sortie d'un script CGI.</li>

      <li>Avec <code class="module"><a href="../mod/mod_ext_filter.html">mod_ext_filter</a></code>, le temps d'attente
      maximum des sorties d'un processus de filtrage.</li>

      <li>Avec <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>, la valeur du dlai par dfaut
      si <code class="directive"><a href="../mod/mod_proxy.html#proxytimeout">ProxyTimeout</a></code> n'est
      pas dfini.</li>
    </ul>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="traceenable" id="traceenable">Directive</a> <a name="TraceEnable" id="TraceEnable">TraceEnable</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine le comportement des requtes
<code>TRACE</code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>TraceEnable <var>[on|off|extended]</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>TraceEnable on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Cette directive l'emporte sur le comportement de
    <code>TRACE</code> pour le noyau du serveur et
    <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>. La dfinition par dfaut
    <code>TraceEnable on</code> permet des requtes <code>TRACE</code>
    selon la RFC 2616, qui interdit d'ajouter tout corps  la requte.
    La dfinition <code>TraceEnable off</code> indique au noyau du
    serveur et  <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code> de retourner un code
    d'erreur <code>405</code> (Mthode non autorise) au client.</p>

    <p>En fait, et  des fins de test et de diagnostic seulement, on
    peut autoriser l'ajout d'un corps de requte  l'aide de la
    dfinition non standard <code>TraceEnable extended</code>. Le noyau
    du serveur (dans le cas d'un serveur d'origine) va limiter la taille
    du corps de requte  64Kb (plus 8Kb pour les en-ttes de
    fractionnement si <code>Transfer-Encoding: chunked</code> est
    utilis). Le noyau du serveur va reproduire l'ensemble des en-ttes,
    y compris les en-ttes de fractionnement avec le corps de la
    rponse. Dans le cas d'un serveur mandataire, la taille du corps de
    requte n'est pas limite  64Kb.</p>

    <div class="note"><h3>Note</h3>
    <p>Bien que certains prtendent le contraire, activer la mthode
    <code>TRACE</code> ne constitue pas un problme de scurit dans Apache
    httpd. La mthode <code>TRACE</code> est dfinie par la spcification
    HTTP/1.1 et les diffrentes implmentations sont censes la supporter.</p>
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="undefine" id="undefine">Directive</a> <a name="UnDefine" id="UnDefine">UnDefine</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Invalide la dfinition d'une variable</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>UnDefine <var>nom-variable</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Annule l'effet d'une directive <code class="directive"><a href="#define">Define</a></code> ou d'un argument <code>-D</code> de
    <code class="program"><a href="../programs/httpd.html">httpd</a></code> en invalidant l'existence de la variable
    correspondante.</p>
    <p>On peut utiliser cette directive pour inverser l'effet d'une
    section <code class="directive"><a href="#ifdefine">&lt;IfDefine&gt;</a></code>
    sans avoir  modifier les arguments <code>-D</code> dans les scripts
    de dmarrage.</p>
    <p>Si cette directive est dfinie au sein d'un bloc VirtualHost, les
    changements qu'elle induit sont visibles de toute directive
    ultrieure, au del de tout bloc VirtualHost.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#define">Define</a></code></li>
<li><code class="directive"><a href="#ifdefine">IfDefine</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="usecanonicalname" id="usecanonicalname">Directive</a> <a name="UseCanonicalName" id="UseCanonicalName">UseCanonicalName</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la manire dont le serveur dtermine son propre nom
et son port</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>UseCanonicalName On|Off|DNS</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>UseCanonicalName Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Dans de nombreuses situations, Apache httpd doit construire une URL
    <em>auto-identifiante</em> -- c'est  dire une URL qui fait
    rfrence au serveur lui-mme. Avec <code>UseCanonicalName
    On</code>, Apache httpd va utiliser le nom d'hte et le port spcifis par
    la directive <code class="directive"><a href="#servername">ServerName</a></code> pour
    construire le nom canonique du serveur. Ce nom est utilis dans
    toutes les URLs auto-identifiantes, et affect aux variables
    <code>SERVER_NAME</code> et <code>SERVER_PORT</code> dans les
    programmes CGI.</p>

    <p>Avec <code>UseCanonicalName Off</code>, Apache httpd va construire ses
    URLs auto-identifiantes  l'aide du nom d'hte et du port fournis
    par le client, si ce dernier en a fourni un (dans la ngative,
    Apache utilisera le nom canonique, de la mme manire que
    ci-dessus). Ces valeurs sont les mmes que celles qui sont utilises
    pour implmenter les <a href="../vhosts/name-based.html">serveurs virtuels  base de
    nom</a>, et sont disponibles avec les mmes clients. De mme, les
    variables CGI <code>SERVER_NAME</code> et <code>SERVER_PORT</code>
    seront affectes des valeurs fournies par le client.</p>

    <p>Cette directive peut s'avrer utile, par exemple, sur un serveur
    intranet auquel les utilisateurs se connectent en utilisant des noms
    courts tels que <code>www</code>. Si les utilisateurs tapent un nom
    court suivi d'une URL qui fait rfrence  un rpertoire, comme
    <code>http://www/splat</code>, <em>sans le slash terminal</em>, vous
    remarquerez qu'Apache httpd va les rediriger vers
    <code>http://www.example.com/splat/</code>. Si vous avez activ
    l'authentification, ceci va obliger l'utilisateur  s'authentifier
    deux fois (une premire fois pour <code>www</code> et une seconde
    fois pour <code>www.example.com</code> -- voir <a href="http://wiki.apache.org/httpd/FAQ#Why_does_Apache_ask_for_my_password_twice_before_serving_a_file.3F">la
    foire aux questions sur ce sujet pour plus d'informations</a>).
    Par contre, si <code class="directive">UseCanonicalName</code> est dfinie 
    <code>Off</code>, Apache httpd redirigera l'utilisateur vers
    <code>http://www/splat/</code>.</p>

    <p>Pour l'hbergement virtuel en masse  base d'adresse IP, on
    utilise une troisime option, <code>UseCanonicalName
    DNS</code>, pour supporter les clients anciens qui ne
    fournissent pas d'en-tte <code>Host:</code>. Apache httpd effectue alors
    une recherche DNS inverse sur l'adresse IP du serveur auquel le
    client s'est connect afin de construire ses URLs
    auto-identifiantes.</p>

    <div class="warning"><h3>Avertissement</h3>
    <p>Les programmes CGI risquent d'tre perturbs par cette option
    s'ils tiennent compte de la variable <code>SERVER_NAME</code>. Le
    client est pratiquement libre de fournir la valeur qu'il veut comme
    nom d'hte. Mais si le programme CGI n'utilise
    <code>SERVER_NAME</code> que pour construire des URLs
    auto-identifiantes, il ne devrait pas y avoir de problme.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#usecanonicalphysicalport">UseCanonicalPhysicalPort</a></code></li>
<li><code class="directive"><a href="#servername">ServerName</a></code></li>
<li><code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="usecanonicalphysicalport" id="usecanonicalphysicalport">Directive</a> <a name="UseCanonicalPhysicalPort" id="UseCanonicalPhysicalPort">UseCanonicalPhysicalPort</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la manire dont le serveur
dtermine son propre port</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>UseCanonicalPhysicalPort On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>UseCanonicalPhysicalPort Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Dans de nombreuses situations, Apache httpd doit construire une URL
    <em>auto-identifiante</em> -- c'est  dire une URL qui fait
    rfrence au serveur lui-mme. Avec <code>UseCanonicalPhysicalPort
    On</code>, Apache httpd va fournir le numro de port physique rel utilis
    par la requte en tant que port potentiel, pour construire le port
    canonique afin que le serveur puisse alimenter la directive
    <code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code>. Avec
    <code>UseCanonicalPhysicalPort Off</code>, Apache httpd n'utilisera pas le
    numro de port physique rel, mais au contraire se rfrera aux
    informations de configuration pour construire un numro de port
    valide.</p>

    <div class="note"><h3>Note</h3>
    <p>L'ordre dans lequel s'effectue la recherche quand on utilise le
    port physique est le suivant :</p>
     <dl>
     <dt><code>UseCanonicalName On</code></dt>
     <dd>
     <ol>
      <li>Port indiqu dans <code class="directive"><a href="#servername">Servername</a></code></li>
      <li>Port physique</li>
      <li>Port par dfaut</li>
     </ol>
     </dd>
     <dt><code>UseCanonicalName Off | DNS</code></dt>
     <dd>
     <ol>
      <li>Port spcifi dans l'en-tte <code>Host:</code></li>
      <li>Port physique</li>
      <li>Port spcifi par <code class="directive"><a href="#servername">Servername</a></code></li>
      <li>Port par dfaut</li>
     </ol>
     </dd>
     </dl>

    <p>Avec <code>UseCanonicalPhysicalPort Off</code>, on reprend
    l'ordre ci-dessus en supprimant "Port physique".</p>
    </div>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#usecanonicalname">UseCanonicalName</a></code></li>
<li><code class="directive"><a href="#servername">ServerName</a></code></li>
<li><code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="virtualhost" id="virtualhost">Directive</a> <a name="VirtualHost" id="VirtualHost">&lt;VirtualHost&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Contient des directives qui ne s'appliquent qu' un nom
d'hte spcifique ou  une adresse IP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;VirtualHost
    <var>adresse IP</var>[:<var>port</var>] [<var>adresse
    IP</var>[:<var>port</var>]] ...&gt; ...
    &lt;/VirtualHost&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Core</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>core</td></tr>
</table>
    <p>Les balises <code class="directive">&lt;VirtualHost&gt;</code> et
    <code>&lt;/VirtualHost&gt;</code> permettent de rassembler un groupe
    de directives qui ne s'appliquent qu' un serveur virtuel
    particulier. Toute directive autorise dans un contexte de serveur
    virtuel peut tre utilise. Lorsque le serveur reoit un requte
    pour un document hberg par un serveur virtuel particulier, il
    applique les directives de configuration rassembles dans la section
    <code class="directive">&lt;VirtualHost&gt;</code>. <var>adresse
    IP</var> peut tre une des entits suivantes, ventuellement suivies
    d'un caractre ':' et d'un numro de port (ou *) :</p>

    <ul>
      <li>L'adresse IP du serveur virtuel ;</li>

      <li>Un nom de domaine entirement qualifi correspondant 
      l'adresse IP du serveur virtuel (non recommand) ;</li>

      <li>Le caractre <code>*</code>, qui agit comme un
      caractre gnrique, et correspond  toute adresse IP.</li>

      <li>La chane <code>_default_</code>, dont la signification est
      identique  celle du caractre <code>*</code></li>

    </ul>

    <pre class="prettyprint lang-config">&lt;VirtualHost 10.1.2.3:80&gt;
  ServerAdmin webmaster@host.example.com
  DocumentRoot "/www/docs/host.example.com"
  ServerName host.example.com
  ErrorLog "logs/host.example.com-error_log"
  TransferLog "logs/host.example.com-access_log"
&lt;/VirtualHost&gt;</pre>



    <p>Les adresses IPv6 doivent tre entoures de crochets car dans le
    cas contraire, un ventuel port optionnel ne pourrait pas tre
    dtermin. Voici un exemple de serveur virtuel avec adresse IPv6
    :</p>

    <pre class="prettyprint lang-config">&lt;VirtualHost [2001:db8::a00:20ff:fea7:ccea]:80&gt;
  ServerAdmin webmaster@host.example.com
  DocumentRoot "/www/docs/host.example.com"
  ServerName host.example.com
  ErrorLog "logs/host.example.com-error_log"
  TransferLog "logs/host.example.com-access_log"
&lt;/VirtualHost&gt;</pre>


    <p>Chaque serveur virtuel doit correspondre  une adresse IP, un
    port ou un nom d'hte spcifique ; dans le premier cas, le serveur
    doit tre configur pour recevoir les paquets IP de plusieurs
    adresses (si le serveur n'a qu'une interface rseau, on peut
    utiliser  cet effet la commande <code>ifconfig alias</code> -- si
    votre systme d'exploitation le permet).</p>

    <div class="note"><h3>Note</h3>
    <p>L'utilisation de la directive <code class="directive">&lt;VirtualHost&gt;</code> n'affecte en rien les
    adresses IP sur lesquelles Apache httpd est en coute. Vous devez vous
    assurer que les adresses des serveurs virtuels sont bien incluses
    dans la liste des adresses prcises par la directive <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code>.</p>
    </div>
    
    <p>Tout bloc <code class="directive">&lt;VirtualHost&gt;</code> doit comporter une directive
    <code class="directive"><a href="#servername">ServerName</a></code>. Dans le cas
    contraire, le serveur virtuel hritera de la valeur de la directive
    <code class="directive"><a href="#servername">ServerName</a></code> issue de la
    configuration du serveur principal.</p>

    <p>A l'arrive d'une requte, le serveur tente de la
    faire prendre en compte par la section <code class="directive">&lt;VirtualHost&gt;</code> qui correspond le mieux en ne
    se basant que sur la paire adresse IP/port. Les chanes sans
    caractres gnriques l'emportent sur celles qui en contiennent. Si
    aucune correspondance du point de vue de l'adresse IP/port n'est
    trouve, c'est la configuration du serveur "principal" qui sera
    utilise.</p>
    
    <p>Si plusieurs serveurs virtuels correspondent du point de vue de
    l'adresse IP/port, le serveur slectionne celui qui correspond le
    mieux du point de vue du nom d'hte de la requte. Si aucune
    correspondance du point de vue du nom d'hte n'est trouve, c'est le
    premier serveur virtuel dont l'adresse IP/port correspond qui sera
    utilis. Par voie de consquence, le premier serveur virtuel
    comportant une certaine paire adresse IP/port est le serveur virtuel
    par dfaut pour cette paire adresse IP/port.</p>

    <div class="warning"><h3>Scurit</h3>
    <p>Voir le document sur les <a href="../misc/security_tips.html">conseils  propos de scurit</a>
    pour une description dtaille des raisons pour lesquelles la
    scurit de votre serveur pourrait tre compromise, si le rpertoire
    contenant les fichiers journaux est inscriptible par tout autre
    utilisateur que celui qui dmarre le serveur.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><a href="../vhosts/">Documentation des serveurs virtuels
du serveur HTTP Apache</a></li>
<li><a href="../dns-caveats.html">Problmes concernant le DNS et
le serveur HTTP Apache</a></li>
<li><a href="../bind.html">Dfinition des adresses et ports
qu'utilise le serveur HTTP Apache</a></li>
<li><a href="../sections.html">Comment fonctionnent les sections
&lt;Directory&gt;, &lt;Location&gt; et &lt;Files&gt;</a> pour une
explication de la manire dont ces diffrentes sections se combinent
entre elles  la rception d'une requte</li>
</ul>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../de/mod/core.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="../en/mod/core.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../es/mod/core.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="../fr/mod/core.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/core.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../tr/mod/core.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/core.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2017 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>