/* encoding.c generated by valac 0.26.2, the Vala compiler
 * generated from encoding.vala, do not modify */

/*
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define KKC_TYPE_ENCODING_CONVERTER (kkc_encoding_converter_get_type ())
#define KKC_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverter))
#define KKC_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverterClass))
#define KKC_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ENCODING_CONVERTER))
#define KKC_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ENCODING_CONVERTER))
#define KKC_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverterClass))

typedef struct _KkcEncodingConverter KkcEncodingConverter;
typedef struct _KkcEncodingConverterClass KkcEncodingConverterClass;
typedef struct _KkcEncodingConverterPrivate KkcEncodingConverterPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KKC_ENCODING_CONVERTER_TYPE_ENCODING_CODING_SYSTEM_ENTRY (kkc_encoding_converter_encoding_coding_system_entry_get_type ())
typedef struct _KkcEncodingConverterEncodingCodingSystemEntry KkcEncodingConverterEncodingCodingSystemEntry;
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _KkcEncodingConverter {
	GObject parent_instance;
	KkcEncodingConverterPrivate * priv;
};

struct _KkcEncodingConverterClass {
	GObjectClass parent_class;
};

struct _KkcEncodingConverterPrivate {
	gchar* _encoding;
	GCharsetConverter* encoder;
	GCharsetConverter* decoder;
};

struct _KkcEncodingConverterEncodingCodingSystemEntry {
	gchar* key;
	gchar* value;
};


static gpointer kkc_encoding_converter_parent_class = NULL;
static GRegex* kkc_encoding_converter_coding_cookie_regex;
static GRegex* kkc_encoding_converter_coding_cookie_regex = NULL;
static GInitableIface* kkc_encoding_converter_g_initable_parent_iface = NULL;

GType kkc_encoding_converter_get_type (void) G_GNUC_CONST;
#define KKC_ENCODING_CONVERTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverterPrivate))
enum  {
	KKC_ENCODING_CONVERTER_DUMMY_PROPERTY,
	KKC_ENCODING_CONVERTER_ENCODING
};
#define KKC_ENCODING_CONVERTER_BUFSIZ 4096
#define KKC_ENCODING_CONVERTER_INTERNAL_ENCODING "UTF-8"
static GType kkc_encoding_converter_encoding_coding_system_entry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static KkcEncodingConverterEncodingCodingSystemEntry* kkc_encoding_converter_encoding_coding_system_entry_dup (const KkcEncodingConverterEncodingCodingSystemEntry* self);
static void kkc_encoding_converter_encoding_coding_system_entry_free (KkcEncodingConverterEncodingCodingSystemEntry* self);
static void kkc_encoding_converter_encoding_coding_system_entry_copy (const KkcEncodingConverterEncodingCodingSystemEntry* self, KkcEncodingConverterEncodingCodingSystemEntry* dest);
static void kkc_encoding_converter_encoding_coding_system_entry_destroy (KkcEncodingConverterEncodingCodingSystemEntry* self);
gchar* kkc_encoding_converter_extract_coding_system (const gchar* line);
static gboolean kkc_encoding_converter_real_init (GInitable* base, GCancellable* cancellable, GError** error);
const gchar* kkc_encoding_converter_get_encoding (KkcEncodingConverter* self);
KkcEncodingConverter* kkc_encoding_converter_new (const gchar* encoding, GError** error);
KkcEncodingConverter* kkc_encoding_converter_construct (GType object_type, const gchar* encoding, GError** error);
KkcEncodingConverter* kkc_encoding_converter_new_from_coding_system (const gchar* coding, GError** error);
KkcEncodingConverter* kkc_encoding_converter_construct_from_coding_system (GType object_type, const gchar* coding, GError** error);
static gchar* kkc_encoding_converter_convert (KkcEncodingConverter* self, GCharsetConverter* converter, const gchar* str, GError** error);
static guint8* _vala_array_dup5 (guint8* self, int length);
gchar* kkc_encoding_converter_encode (KkcEncodingConverter* self, const gchar* internal_str, GError** error);
gchar* kkc_encoding_converter_decode (KkcEncodingConverter* self, const gchar* external_str, GError** error);
void kkc_encoding_converter_set_encoding (KkcEncodingConverter* self, const gchar* value);
static void kkc_encoding_converter_finalize (GObject* obj);
static void _vala_kkc_encoding_converter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_encoding_converter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const KkcEncodingConverterEncodingCodingSystemEntry KKC_ENCODING_CONVERTER_ENCODING_TO_CODING_SYSTEM_RULE[7] = {{"UTF-8", "utf-8"}, {"EUC-JP", "euc-jp"}, {"Shift_JIS", "shift_jis"}, {"ISO-2022-JP", "iso-2022-jp"}, {"EUC-JISX0213", "euc-jisx0213"}, {"EUC-JISX0213", "euc-jis-2004"}, {"SHIFT_JISX0213", "shift_jis-2004"}};

gchar* kkc_encoding_converter_extract_coding_system (const gchar* line) {
	gchar* result = NULL;
	GMatchInfo* info = NULL;
	GRegex* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GMatchInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (line != NULL, NULL);
	info = NULL;
	_tmp0_ = kkc_encoding_converter_coding_cookie_regex;
	_tmp1_ = line;
	_tmp3_ = g_regex_match (_tmp0_, _tmp1_, 0, &_tmp2_);
	_g_match_info_free0 (info);
	info = _tmp2_;
	if (_tmp3_) {
		GMatchInfo* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = info;
		_tmp5_ = g_match_info_fetch (_tmp4_, 1);
		result = _tmp5_;
		_g_match_info_free0 (info);
		return result;
	}
	result = NULL;
	_g_match_info_free0 (info);
	return result;
}


static gboolean kkc_encoding_converter_real_init (GInitable* base, GCancellable* cancellable, GError** error) {
	KkcEncodingConverter * self;
	gboolean result = FALSE;
	GCharsetConverter* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GCharsetConverter* _tmp2_ = NULL;
	GCharsetConverter* _tmp3_ = NULL;
	GCharsetConverter* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GCharsetConverter* _tmp6_ = NULL;
	GCharsetConverter* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcEncodingConverter*) base;
	_tmp1_ = self->priv->_encoding;
	_tmp2_ = g_charset_converter_new (_tmp1_, KKC_ENCODING_CONVERTER_INTERNAL_ENCODING, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->encoder);
	self->priv->encoder = _tmp3_;
	_tmp5_ = self->priv->_encoding;
	_tmp6_ = g_charset_converter_new (KKC_ENCODING_CONVERTER_INTERNAL_ENCODING, _tmp5_, &_inner_error_);
	_tmp4_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp0_);
		return FALSE;
	}
	_tmp7_ = _tmp4_;
	_tmp4_ = NULL;
	_g_object_unref0 (self->priv->decoder);
	self->priv->decoder = _tmp7_;
	result = TRUE;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp0_);
	return result;
}


KkcEncodingConverter* kkc_encoding_converter_construct (GType object_type, const gchar* encoding, GError** error) {
	KkcEncodingConverter * self = NULL;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (encoding != NULL, NULL);
	_tmp0_ = encoding;
	self = (KkcEncodingConverter*) g_object_new (object_type, "encoding", _tmp0_, NULL);
	g_initable_init ((GInitable*) self, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


KkcEncodingConverter* kkc_encoding_converter_new (const gchar* encoding, GError** error) {
	return kkc_encoding_converter_construct (KKC_TYPE_ENCODING_CONVERTER, encoding, error);
}


KkcEncodingConverter* kkc_encoding_converter_construct_from_coding_system (GType object_type, const gchar* coding, GError** error) {
	KkcEncodingConverter * self = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (coding != NULL, NULL);
	{
		KkcEncodingConverterEncodingCodingSystemEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = KKC_ENCODING_CONVERTER_ENCODING_TO_CODING_SYSTEM_RULE;
		entry_collection_length1 = G_N_ELEMENTS (KKC_ENCODING_CONVERTER_ENCODING_TO_CODING_SYSTEM_RULE);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (KKC_ENCODING_CONVERTER_ENCODING_TO_CODING_SYSTEM_RULE); entry_it = entry_it + 1) {
			KkcEncodingConverterEncodingCodingSystemEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				KkcEncodingConverterEncodingCodingSystemEntry _tmp0_ = {0};
				const gchar* _tmp1_ = NULL;
				const gchar* _tmp2_ = NULL;
				_tmp0_ = entry;
				_tmp1_ = _tmp0_.value;
				_tmp2_ = coding;
				if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
					KkcEncodingConverterEncodingCodingSystemEntry _tmp3_ = {0};
					const gchar* _tmp4_ = NULL;
					_tmp3_ = entry;
					_tmp4_ = _tmp3_.key;
					self = (KkcEncodingConverter*) kkc_encoding_converter_construct (object_type, _tmp4_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (self);
						return NULL;
					}
					return self;
				}
			}
		}
	}
	g_assert_not_reached ();
	return self;
}


KkcEncodingConverter* kkc_encoding_converter_new_from_coding_system (const gchar* coding, GError** error) {
	return kkc_encoding_converter_construct_from_coding_system (KKC_TYPE_ENCODING_CONVERTER, coding, error);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static guint8* _vala_array_dup5 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gchar* kkc_encoding_converter_convert (KkcEncodingConverter* self, GCharsetConverter* converter, const gchar* str, GError** error) {
	gchar* result = NULL;
	guint8* inbuf = NULL;
	const gchar* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint inbuf_length1 = 0;
	gint _inbuf_size_ = 0;
	guint8* outbuf = NULL;
	guint8* _tmp4_ = NULL;
	gint outbuf_length1 = 0;
	gint _outbuf_size_ = 0;
	GString* builder = NULL;
	GString* _tmp5_ = NULL;
	gsize total_bytes_read = 0UL;
	GString* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (converter != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = string_get_data (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup5 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	inbuf = _tmp3_;
	inbuf_length1 = _tmp3__length1;
	_inbuf_size_ = inbuf_length1;
	_tmp4_ = g_new0 (guint8, KKC_ENCODING_CONVERTER_BUFSIZ);
	outbuf = _tmp4_;
	outbuf_length1 = KKC_ENCODING_CONVERTER_BUFSIZ;
	_outbuf_size_ = outbuf_length1;
	_tmp5_ = g_string_new ("");
	builder = _tmp5_;
	total_bytes_read = (gsize) 0;
	while (TRUE) {
		gsize _tmp6_ = 0UL;
		guint8* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gsize bytes_read = 0UL;
		gsize bytes_written = 0UL;
		GCharsetConverter* _tmp8_ = NULL;
		guint8* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gsize _tmp10_ = 0UL;
		guint8* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		guint8* _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		gsize _tmp13_ = 0UL;
		gsize _tmp14_ = 0UL;
		gsize _tmp23_ = 0UL;
		gsize _tmp24_ = 0UL;
		_tmp6_ = total_bytes_read;
		_tmp7_ = inbuf;
		_tmp7__length1 = inbuf_length1;
		if (!(_tmp6_ < ((gsize) _tmp7__length1))) {
			break;
		}
		_tmp8_ = converter;
		_tmp9_ = inbuf;
		_tmp9__length1 = inbuf_length1;
		_tmp10_ = total_bytes_read;
		_tmp11_ = inbuf;
		_tmp11__length1 = inbuf_length1;
		_tmp12_ = outbuf;
		_tmp12__length1 = outbuf_length1;
		g_converter_convert ((GConverter*) _tmp8_, _tmp9_ + ((gint) _tmp10_), (gsize) (_tmp11__length1 - ((gint) _tmp10_)), (void*) _tmp12_, (gsize) _tmp12__length1, G_CONVERTER_INPUT_AT_END, &_tmp13_, &_tmp14_, &_inner_error_);
		bytes_read = _tmp13_;
		bytes_written = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (builder);
			outbuf = (g_free (outbuf), NULL);
			inbuf = (g_free (inbuf), NULL);
			return NULL;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					gint _tmp17_ = 0;
					gsize _tmp18_ = 0UL;
					GString* _tmp19_ = NULL;
					guint8* _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					gint _tmp21_ = 0;
					guint8 _tmp22_ = 0U;
					if (!_tmp15_) {
						gint _tmp16_ = 0;
						_tmp16_ = i;
						i = _tmp16_ + 1;
					}
					_tmp15_ = FALSE;
					_tmp17_ = i;
					_tmp18_ = bytes_written;
					if (!(((gsize) _tmp17_) < _tmp18_)) {
						break;
					}
					_tmp19_ = builder;
					_tmp20_ = outbuf;
					_tmp20__length1 = outbuf_length1;
					_tmp21_ = i;
					_tmp22_ = _tmp20_[_tmp21_];
					g_string_append_c (_tmp19_, (gchar) _tmp22_);
				}
			}
		}
		_tmp23_ = total_bytes_read;
		_tmp24_ = bytes_read;
		total_bytes_read = _tmp23_ + _tmp24_;
	}
	_tmp25_ = builder;
	_tmp26_ = _tmp25_->str;
	_tmp27_ = g_strdup (_tmp26_);
	result = _tmp27_;
	_g_string_free0 (builder);
	outbuf = (g_free (outbuf), NULL);
	inbuf = (g_free (inbuf), NULL);
	return result;
}


gchar* kkc_encoding_converter_encode (KkcEncodingConverter* self, const gchar* internal_str, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	GCharsetConverter* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (internal_str != NULL, NULL);
	_tmp1_ = self->priv->encoder;
	_tmp2_ = internal_str;
	_tmp3_ = kkc_encoding_converter_convert (self, _tmp1_, _tmp2_, &_inner_error_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_free0 (_tmp0_);
	return result;
}


gchar* kkc_encoding_converter_decode (KkcEncodingConverter* self, const gchar* external_str, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	GCharsetConverter* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (external_str != NULL, NULL);
	_tmp1_ = self->priv->decoder;
	_tmp2_ = external_str;
	_tmp3_ = kkc_encoding_converter_convert (self, _tmp1_, _tmp2_, &_inner_error_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_free0 (_tmp0_);
	return result;
}


const gchar* kkc_encoding_converter_get_encoding (KkcEncodingConverter* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_encoding;
	result = _tmp0_;
	return result;
}


void kkc_encoding_converter_set_encoding (KkcEncodingConverter* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_encoding);
	self->priv->_encoding = _tmp1_;
	g_object_notify ((GObject *) self, "encoding");
}


static void kkc_encoding_converter_encoding_coding_system_entry_copy (const KkcEncodingConverterEncodingCodingSystemEntry* self, KkcEncodingConverterEncodingCodingSystemEntry* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = (*self).key;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).key);
	(*dest).key = _tmp1_;
	_tmp2_ = (*self).value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).value);
	(*dest).value = _tmp3_;
}


static void kkc_encoding_converter_encoding_coding_system_entry_destroy (KkcEncodingConverterEncodingCodingSystemEntry* self) {
	_g_free0 ((*self).key);
	_g_free0 ((*self).value);
}


static KkcEncodingConverterEncodingCodingSystemEntry* kkc_encoding_converter_encoding_coding_system_entry_dup (const KkcEncodingConverterEncodingCodingSystemEntry* self) {
	KkcEncodingConverterEncodingCodingSystemEntry* dup;
	dup = g_new0 (KkcEncodingConverterEncodingCodingSystemEntry, 1);
	kkc_encoding_converter_encoding_coding_system_entry_copy (self, dup);
	return dup;
}


static void kkc_encoding_converter_encoding_coding_system_entry_free (KkcEncodingConverterEncodingCodingSystemEntry* self) {
	kkc_encoding_converter_encoding_coding_system_entry_destroy (self);
	g_free (self);
}


static GType kkc_encoding_converter_encoding_coding_system_entry_get_type (void) {
	static volatile gsize kkc_encoding_converter_encoding_coding_system_entry_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_encoding_converter_encoding_coding_system_entry_type_id__volatile)) {
		GType kkc_encoding_converter_encoding_coding_system_entry_type_id;
		kkc_encoding_converter_encoding_coding_system_entry_type_id = g_boxed_type_register_static ("KkcEncodingConverterEncodingCodingSystemEntry", (GBoxedCopyFunc) kkc_encoding_converter_encoding_coding_system_entry_dup, (GBoxedFreeFunc) kkc_encoding_converter_encoding_coding_system_entry_free);
		g_once_init_leave (&kkc_encoding_converter_encoding_coding_system_entry_type_id__volatile, kkc_encoding_converter_encoding_coding_system_entry_type_id);
	}
	return kkc_encoding_converter_encoding_coding_system_entry_type_id__volatile;
}


static void kkc_encoding_converter_class_init (KkcEncodingConverterClass * klass) {
	GError * _inner_error_ = NULL;
	kkc_encoding_converter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcEncodingConverterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_encoding_converter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_encoding_converter_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_encoding_converter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ENCODING_CONVERTER_ENCODING, g_param_spec_string ("encoding", "encoding", "encoding", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
		_tmp1_ = g_regex_new ("-\\*-.*[ \t]coding:[ \t]*([^ \t;]+?)[ \t;].*-\\*-", 0, 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch20_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (kkc_encoding_converter_coding_cookie_regex);
		kkc_encoding_converter_coding_cookie_regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally20;
	__catch20_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally20:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void kkc_encoding_converter_g_initable_interface_init (GInitableIface * iface) {
	kkc_encoding_converter_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*)(GInitable*, GCancellable*, GError**)) kkc_encoding_converter_real_init;
}


static void kkc_encoding_converter_instance_init (KkcEncodingConverter * self) {
	self->priv = KKC_ENCODING_CONVERTER_GET_PRIVATE (self);
}


static void kkc_encoding_converter_finalize (GObject* obj) {
	KkcEncodingConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverter);
	_g_free0 (self->priv->_encoding);
	_g_object_unref0 (self->priv->encoder);
	_g_object_unref0 (self->priv->decoder);
	G_OBJECT_CLASS (kkc_encoding_converter_parent_class)->finalize (obj);
}


GType kkc_encoding_converter_get_type (void) {
	static volatile gsize kkc_encoding_converter_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_encoding_converter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcEncodingConverterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_encoding_converter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcEncodingConverter), 0, (GInstanceInitFunc) kkc_encoding_converter_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) kkc_encoding_converter_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_encoding_converter_type_id;
		kkc_encoding_converter_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcEncodingConverter", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_encoding_converter_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&kkc_encoding_converter_type_id__volatile, kkc_encoding_converter_type_id);
	}
	return kkc_encoding_converter_type_id__volatile;
}


static void _vala_kkc_encoding_converter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcEncodingConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverter);
	switch (property_id) {
		case KKC_ENCODING_CONVERTER_ENCODING:
		g_value_set_string (value, kkc_encoding_converter_get_encoding (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_encoding_converter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcEncodingConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverter);
	switch (property_id) {
		case KKC_ENCODING_CONVERTER_ENCODING:
		kkc_encoding_converter_set_encoding (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



