; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 < %s | FileCheck -check-prefixes=WAVE64 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 < %s | FileCheck -check-prefixes=WAVE32 %s

define amdgpu_ps void @i1_vcc_to_vcc_copy(i32 %val, float %a0, float %a1, float %b0, float %b1) {
; WAVE64-LABEL: i1_vcc_to_vcc_copy:
; WAVE64:       ; %bb.0: ; %main_body
; WAVE64-NEXT:    v_cmp_eq_u32_e32 vcc, 2, v0
; WAVE64-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; WAVE64-NEXT:    v_cndmask_b32_e32 v1, v4, v3, vcc
; WAVE64-NEXT:    exp mrt0 v0, v1, v0, v0 done vm
; WAVE64-NEXT:    s_endpgm
;
; WAVE32-LABEL: i1_vcc_to_vcc_copy:
; WAVE32:       ; %bb.0: ; %main_body
; WAVE32-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 2, v0
; WAVE32-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; WAVE32-NEXT:    v_cndmask_b32_e32 v1, v4, v3, vcc_lo
; WAVE32-NEXT:    exp mrt0 v0, v1, v0, v0 done vm
; WAVE32-NEXT:    s_endpgm
main_body:
  %vcc = icmp eq i32 %val, 2
  %a = select i1 %vcc, float %a0, float %a1
  %b = select i1 %vcc, float %b0, float %b1
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %a, float %b, float undef, float undef, i1 true, i1 true)
  ret void
}

define amdgpu_ps void @i1_sgpr_to_vcc_copy(i32 inreg %val, float %a0, float %a1, float %b0, float %b1) {
; WAVE64-LABEL: i1_sgpr_to_vcc_copy:
; WAVE64:       ; %bb.0: ; %main_body
; WAVE64-NEXT:    s_cmp_eq_u32 s0, 2
; WAVE64-NEXT:    s_cselect_b32 s0, 1, 0
; WAVE64-NEXT:    s_and_b32 s0, 1, s0
; WAVE64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; WAVE64-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; WAVE64-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; WAVE64-NEXT:    exp mrt0 v0, v1, v0, v0 done vm
; WAVE64-NEXT:    s_endpgm
;
; WAVE32-LABEL: i1_sgpr_to_vcc_copy:
; WAVE32:       ; %bb.0: ; %main_body
; WAVE32-NEXT:    s_cmp_eq_u32 s0, 2
; WAVE32-NEXT:    s_cselect_b32 s0, 1, 0
; WAVE32-NEXT:    s_and_b32 s0, 1, s0
; WAVE32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; WAVE32-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; WAVE32-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc_lo
; WAVE32-NEXT:    exp mrt0 v0, v1, v0, v0 done vm
; WAVE32-NEXT:    s_endpgm
main_body:
  %uniform_i1 = icmp eq i32 %val, 2
  %a = select i1 %uniform_i1, float %a0, float %a1
  %b = select i1 %uniform_i1, float %b0, float %b1
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %a, float %b, float undef, float undef, i1 true, i1 true)
  ret void
}

declare void @llvm.amdgcn.exp.f32(i32, i32, float, float, float, float, i1, i1)
