/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGForeignObjectElement.h"

#include "JSSVGAnimatedLength.h"
#include "SVGForeignObjectElement.h"
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGForeignObjectElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementHeight), (intptr_t)0, NoIntrinsic },
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGForeignObjectElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGForeignObjectElementTable = { 18, 15, JSSVGForeignObjectElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGForeignObjectElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGForeignObjectElementConstructorTable = { 1, 0, JSSVGForeignObjectElementConstructorTableValues, 0 };
const ClassInfo JSSVGForeignObjectElementConstructor::s_info = { "SVGForeignObjectElementConstructor", &Base::s_info, &JSSVGForeignObjectElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGForeignObjectElementConstructor) };

JSSVGForeignObjectElementConstructor::JSSVGForeignObjectElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGForeignObjectElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGForeignObjectElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGForeignObjectElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGForeignObjectElementConstructor, JSDOMWrapper>(exec, &JSSVGForeignObjectElementConstructorTable, jsCast<JSSVGForeignObjectElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGForeignObjectElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGForeignObjectElementConstructor, JSDOMWrapper>(exec, &JSSVGForeignObjectElementConstructorTable, jsCast<JSSVGForeignObjectElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGForeignObjectElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGForeignObjectElementPrototypeTable = { 1, 0, JSSVGForeignObjectElementPrototypeTableValues, 0 };
const ClassInfo JSSVGForeignObjectElementPrototype::s_info = { "SVGForeignObjectElementPrototype", &Base::s_info, &JSSVGForeignObjectElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGForeignObjectElementPrototype) };

JSObject* JSSVGForeignObjectElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGForeignObjectElement>(exec, globalObject);
}

const ClassInfo JSSVGForeignObjectElement::s_info = { "SVGForeignObjectElement", &Base::s_info, &JSSVGForeignObjectElementTable, 0 , CREATE_METHOD_TABLE(JSSVGForeignObjectElement) };

JSSVGForeignObjectElement::JSSVGForeignObjectElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGForeignObjectElement> impl)
    : JSSVGGraphicsElement(structure, globalObject, impl)
{
}

void JSSVGForeignObjectElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGForeignObjectElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGForeignObjectElementPrototype::create(exec->vm(), globalObject, JSSVGForeignObjectElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGraphicsElementPrototype::self(exec, globalObject)));
}

bool JSSVGForeignObjectElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGForeignObjectElement* thisObject = jsCast<JSSVGForeignObjectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGForeignObjectElement, Base>(exec, &JSSVGForeignObjectElementTable, thisObject, propertyName, slot);
}

bool JSSVGForeignObjectElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGForeignObjectElement* thisObject = jsCast<JSSVGForeignObjectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGForeignObjectElement, Base>(exec, &JSSVGForeignObjectElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGForeignObjectElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGForeignObjectElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGForeignObjectElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGForeignObjectElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGForeignObjectElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* castedThis = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGForeignObjectElement* impl = static_cast<SVGForeignObjectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGForeignObjectElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGForeignObjectElement* domObject = jsCast<JSSVGForeignObjectElement*>(asObject(slotBase));
    return JSSVGForeignObjectElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGForeignObjectElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGForeignObjectElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
