/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTextMetrics.h"

#include "TextMetrics.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTextMetricsTableValues[] =
{
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsWidth), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextMetricsConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextMetricsTable = { 4, 3, JSTextMetricsTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSTextMetricsConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextMetricsConstructorTable = { 1, 0, JSTextMetricsConstructorTableValues, 0 };
const ClassInfo JSTextMetricsConstructor::s_info = { "TextMetricsConstructor", &Base::s_info, &JSTextMetricsConstructorTable, 0, CREATE_METHOD_TABLE(JSTextMetricsConstructor) };

JSTextMetricsConstructor::JSTextMetricsConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTextMetricsConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSTextMetricsPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSTextMetricsConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextMetricsConstructor, JSDOMWrapper>(exec, &JSTextMetricsConstructorTable, jsCast<JSTextMetricsConstructor*>(cell), propertyName, slot);
}

bool JSTextMetricsConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTextMetricsConstructor, JSDOMWrapper>(exec, &JSTextMetricsConstructorTable, jsCast<JSTextMetricsConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSTextMetricsPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextMetricsPrototypeTable = { 1, 0, JSTextMetricsPrototypeTableValues, 0 };
const ClassInfo JSTextMetricsPrototype::s_info = { "TextMetricsPrototype", &Base::s_info, &JSTextMetricsPrototypeTable, 0, CREATE_METHOD_TABLE(JSTextMetricsPrototype) };

JSObject* JSTextMetricsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTextMetrics>(exec, globalObject);
}

const ClassInfo JSTextMetrics::s_info = { "TextMetrics", &Base::s_info, &JSTextMetricsTable, 0 , CREATE_METHOD_TABLE(JSTextMetrics) };

JSTextMetrics::JSTextMetrics(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<TextMetrics> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSTextMetrics::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSTextMetrics::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTextMetricsPrototype::create(exec->vm(), globalObject, JSTextMetricsPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSTextMetrics::destroy(JSC::JSCell* cell)
{
    JSTextMetrics* thisObject = static_cast<JSTextMetrics*>(cell);
    thisObject->JSTextMetrics::~JSTextMetrics();
}

JSTextMetrics::~JSTextMetrics()
{
    releaseImplIfNotNull();
}

bool JSTextMetrics::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTextMetrics* thisObject = jsCast<JSTextMetrics*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSTextMetrics, Base>(exec, &JSTextMetricsTable, thisObject, propertyName, slot);
}

bool JSTextMetrics::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTextMetrics* thisObject = jsCast<JSTextMetrics*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSTextMetrics, Base>(exec, &JSTextMetricsTable, thisObject, propertyName, descriptor);
}

JSValue jsTextMetricsWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTextMetrics* castedThis = jsCast<JSTextMetrics*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TextMetrics* impl = static_cast<TextMetrics*>(castedThis->impl());
    JSValue result = jsNumber(impl->width());
    return result;
}


JSValue jsTextMetricsConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTextMetrics* domObject = jsCast<JSTextMetrics*>(asObject(slotBase));
    return JSTextMetrics::getConstructor(exec, domObject->globalObject());
}

JSValue JSTextMetrics::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextMetricsConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSTextMetrics* jsTextMetrics)
{
    if (jsTextMetrics->hasCustomProperties())
        return true;
    return false;
}

bool JSTextMetricsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSTextMetrics* jsTextMetrics = jsCast<JSTextMetrics*>(handle.get().asCell());
    if (!isObservable(jsTextMetrics))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSTextMetricsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSTextMetrics* jsTextMetrics = jsCast<JSTextMetrics*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTextMetrics->impl(), jsTextMetrics);
    jsTextMetrics->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, TextMetrics* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTextMetrics>(exec, impl))
        return result;
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TextMetrics.
    COMPILE_ASSERT(!__is_polymorphic(TextMetrics), TextMetrics_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<TextMetrics>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSTextMetrics>(exec, globalObject, impl);
}

TextMetrics* toTextMetrics(JSC::JSValue value)
{
    return value.inherits(&JSTextMetrics::s_info) ? jsCast<JSTextMetrics*>(asObject(value))->impl() : 0;
}

}
