/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMTextTrackCueList.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMTextTrackCueListPrivate.h"
#include "WebKitDOMTextTrackCuePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_TEXT_TRACK_CUE_LIST_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_TEXT_TRACK_CUE_LIST, WebKitDOMTextTrackCueListPrivate)

typedef struct _WebKitDOMTextTrackCueListPrivate {
#if ENABLE(VIDEO_TRACK)
    RefPtr<WebCore::TextTrackCueList> coreObject;
#endif // ENABLE(VIDEO_TRACK)
} WebKitDOMTextTrackCueListPrivate;

#if ENABLE(VIDEO_TRACK)

namespace WebKit {

WebKitDOMTextTrackCueList* kit(WebCore::TextTrackCueList* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_TEXT_TRACK_CUE_LIST(ret);

    return wrapTextTrackCueList(obj);
}

WebCore::TextTrackCueList* core(WebKitDOMTextTrackCueList* request)
{
    return request ? static_cast<WebCore::TextTrackCueList*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMTextTrackCueList* wrapTextTrackCueList(WebCore::TextTrackCueList* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_TEXT_TRACK_CUE_LIST(g_object_new(WEBKIT_TYPE_DOM_TEXT_TRACK_CUE_LIST, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(VIDEO_TRACK)

G_DEFINE_TYPE(WebKitDOMTextTrackCueList, webkit_dom_text_track_cue_list, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_LENGTH,
};

static void webkit_dom_text_track_cue_list_finalize(GObject* object)
{
    WebKitDOMTextTrackCueListPrivate* priv = WEBKIT_DOM_TEXT_TRACK_CUE_LIST_GET_PRIVATE(object);
#if ENABLE(VIDEO_TRACK)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(VIDEO_TRACK)
    priv->~WebKitDOMTextTrackCueListPrivate();
    G_OBJECT_CLASS(webkit_dom_text_track_cue_list_parent_class)->finalize(object);
}

static void webkit_dom_text_track_cue_list_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO_TRACK)
    WebKitDOMTextTrackCueList* self = WEBKIT_DOM_TEXT_TRACK_CUE_LIST(object);
    WebCore::TextTrackCueList* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO_TRACK)
    switch (propertyId) {
    case PROP_LENGTH: {
#if ENABLE(VIDEO_TRACK)
        g_value_set_ulong(value, coreSelf->length());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_text_track_cue_list_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_text_track_cue_list_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(VIDEO_TRACK)
    WebKitDOMTextTrackCueListPrivate* priv = WEBKIT_DOM_TEXT_TRACK_CUE_LIST_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::TextTrackCueList*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(VIDEO_TRACK)
    return object;
}

static void webkit_dom_text_track_cue_list_class_init(WebKitDOMTextTrackCueListClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMTextTrackCueListPrivate));
    gobjectClass->constructor = webkit_dom_text_track_cue_list_constructor;
    gobjectClass->finalize = webkit_dom_text_track_cue_list_finalize;
    gobjectClass->get_property = webkit_dom_text_track_cue_list_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "text_track_cue_list_length", /* short description */
                                                           "read-only  gulong TextTrackCueList.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_text_track_cue_list_init(WebKitDOMTextTrackCueList* request)
{
    WebKitDOMTextTrackCueListPrivate* priv = WEBKIT_DOM_TEXT_TRACK_CUE_LIST_GET_PRIVATE(request);
    new (priv) WebKitDOMTextTrackCueListPrivate();
}

WebKitDOMTextTrackCue*
webkit_dom_text_track_cue_list_item(WebKitDOMTextTrackCueList* self, gulong index)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE_LIST(self), 0);
    WebCore::TextTrackCueList* item = WebKit::core(self);
    RefPtr<WebCore::TextTrackCue> gobjectResult = WTF::getPtr(item->item(index));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

WebKitDOMTextTrackCue*
webkit_dom_text_track_cue_list_get_cue_by_id(WebKitDOMTextTrackCueList* self, const gchar* id)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE_LIST(self), 0);
    g_return_val_if_fail(id, 0);
    WebCore::TextTrackCueList* item = WebKit::core(self);
    WTF::String convertedId = WTF::String::fromUTF8(id);
    RefPtr<WebCore::TextTrackCue> gobjectResult = WTF::getPtr(item->getCueById(convertedId));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

gulong
webkit_dom_text_track_cue_list_get_length(WebKitDOMTextTrackCueList* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_CUE_LIST(self), 0);
    WebCore::TextTrackCueList* item = WebKit::core(self);
    gulong result = item->length();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<gulong>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

