/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLOptionElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLFormElementPrivate.h"
#include "WebKitDOMHTMLOptionElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLOptionElement* kit(WebCore::HTMLOptionElement* obj)
{
    return WEBKIT_DOM_HTML_OPTION_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLOptionElement* core(WebKitDOMHTMLOptionElement* request)
{
    return request ? static_cast<WebCore::HTMLOptionElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLOptionElement* wrapHTMLOptionElement(WebCore::HTMLOptionElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_OPTION_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_OPTION_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLOptionElement, webkit_dom_html_option_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_DISABLED,
    PROP_FORM,
    PROP_LABEL,
    PROP_DEFAULT_SELECTED,
    PROP_SELECTED,
    PROP_VALUE,
    PROP_TEXT,
    PROP_INDEX,
};

static void webkit_dom_html_option_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLOptionElement* self = WEBKIT_DOM_HTML_OPTION_ELEMENT(object);
    WebCore::HTMLOptionElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DISABLED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_LABEL: {
        coreSelf->setLabel(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DEFAULT_SELECTED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::selectedAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_SELECTED: {
        coreSelf->setSelected((g_value_get_boolean(value)));
        break;
    }
    case PROP_VALUE: {
        coreSelf->setValue(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_option_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLOptionElement* self = WEBKIT_DOM_HTML_OPTION_ELEMENT(object);
    WebCore::HTMLOptionElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DISABLED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
        break;
    }
    case PROP_FORM: {
        RefPtr<WebCore::HTMLFormElement> ptr = coreSelf->form();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_LABEL: {
        g_value_take_string(value, convertToUTF8String(coreSelf->label()));
        break;
    }
    case PROP_DEFAULT_SELECTED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::selectedAttr));
        break;
    }
    case PROP_SELECTED: {
        g_value_set_boolean(value, coreSelf->selected());
        break;
    }
    case PROP_VALUE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->value()));
        break;
    }
    case PROP_TEXT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->text()));
        break;
    }
    case PROP_INDEX: {
        g_value_set_long(value, coreSelf->index());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_option_element_class_init(WebKitDOMHTMLOptionElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_option_element_set_property;
    gobjectClass->get_property = webkit_dom_html_option_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_DISABLED,
                                    g_param_spec_boolean("disabled", /* name */
                                                           "html_option_element_disabled", /* short description */
                                                           "read-write  gboolean HTMLOptionElement.disabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM,
                                    g_param_spec_object("form", /* name */
                                                           "html_option_element_form", /* short description */
                                                           "read-only  WebKitDOMHTMLFormElement* HTMLOptionElement.form", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_FORM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LABEL,
                                    g_param_spec_string("label", /* name */
                                                           "html_option_element_label", /* short description */
                                                           "read-write  gchar* HTMLOptionElement.label", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEFAULT_SELECTED,
                                    g_param_spec_boolean("default-selected", /* name */
                                                           "html_option_element_default-selected", /* short description */
                                                           "read-write  gboolean HTMLOptionElement.default-selected", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SELECTED,
                                    g_param_spec_boolean("selected", /* name */
                                                           "html_option_element_selected", /* short description */
                                                           "read-write  gboolean HTMLOptionElement.selected", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE,
                                    g_param_spec_string("value", /* name */
                                                           "html_option_element_value", /* short description */
                                                           "read-write  gchar* HTMLOptionElement.value", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TEXT,
                                    g_param_spec_string("text", /* name */
                                                           "html_option_element_text", /* short description */
                                                           "read-only  gchar* HTMLOptionElement.text", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INDEX,
                                    g_param_spec_long("index", /* name */
                                                           "html_option_element_index", /* short description */
                                                           "read-only  glong HTMLOptionElement.index", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_option_element_init(WebKitDOMHTMLOptionElement* request)
{
}

gboolean
webkit_dom_html_option_element_get_disabled(WebKitDOMHTMLOptionElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self), FALSE);
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::disabledAttr);
    return result;
}

void
webkit_dom_html_option_element_set_disabled(WebKitDOMHTMLOptionElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self));
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value);
}

WebKitDOMHTMLFormElement*
webkit_dom_html_option_element_get_form(WebKitDOMHTMLOptionElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self), 0);
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLFormElement> gobjectResult = WTF::getPtr(item->form());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_option_element_get_label(WebKitDOMHTMLOptionElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self), 0);
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->label());
    return result;
}

void
webkit_dom_html_option_element_set_label(WebKitDOMHTMLOptionElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setLabel(convertedValue);
}

gboolean
webkit_dom_html_option_element_get_default_selected(WebKitDOMHTMLOptionElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self), FALSE);
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::selectedAttr);
    return result;
}

void
webkit_dom_html_option_element_set_default_selected(WebKitDOMHTMLOptionElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self));
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::selectedAttr, value);
}

gboolean
webkit_dom_html_option_element_get_selected(WebKitDOMHTMLOptionElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self), FALSE);
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    gboolean result = item->selected();
    return result;
}

void
webkit_dom_html_option_element_set_selected(WebKitDOMHTMLOptionElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self));
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    item->setSelected(value);
}

gchar*
webkit_dom_html_option_element_get_value(WebKitDOMHTMLOptionElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self), 0);
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->value());
    return result;
}

void
webkit_dom_html_option_element_set_value(WebKitDOMHTMLOptionElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setValue(convertedValue);
}

gchar*
webkit_dom_html_option_element_get_text(WebKitDOMHTMLOptionElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self), 0);
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->text());
    return result;
}

glong
webkit_dom_html_option_element_get_index(WebKitDOMHTMLOptionElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OPTION_ELEMENT(self), 0);
    WebCore::HTMLOptionElement* item = WebKit::core(self);
    glong result = item->index();
    return result;
}

