/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.WriterPackage;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class ResourceExpr
extends Expr {
    private static final Map<String, String> RESOURCE_TYPE_TO_R_OBJECT = ImmutableMap.builder().put("colorStateList", "color  ").put("dimenOffset", "dimen  ").put("dimenSize", "dimen  ").put("intArray", "array  ").put("stateListAnimator", "animator  ").put("stringArray", "array  ").put("typedArray", "array").build();
    private Map<String, ModelClass> mResourceToTypeMapping;
    protected final String mPackage;
    protected final String mResourceType;
    protected final String mResourceId;

    public ResourceExpr(String packageName, String resourceType, String resourceName, List<Expr> args) {
        super(args);
        this.mPackage = "android".equals(packageName) ? "android." : "";
        this.mResourceType = resourceType;
        this.mResourceId = resourceName;
    }

    private Map<String, ModelClass> getResourceToTypeMapping(ModelAnalyzer modelAnalyzer) {
        if (this.mResourceToTypeMapping == null) {
            Map<String, String> imports = this.getModel().getImports();
            this.mResourceToTypeMapping = ImmutableMap.builder().put("anim", modelAnalyzer.findClass("android.view.animation.Animation", imports)).put("animator", modelAnalyzer.findClass("android.animation.Animator", imports)).put("colorStateList", modelAnalyzer.findClass("android.content.res.ColorStateList", imports)).put("drawable", modelAnalyzer.findClass("android.graphics.drawable.Drawable", imports)).put("stateListAnimator", modelAnalyzer.findClass("android.animation.StateListAnimator", imports)).put("transition", modelAnalyzer.findClass("android.transition.Transition", imports)).put("typedArray", modelAnalyzer.findClass("android.content.res.TypedArray", imports)).put("interpolator", modelAnalyzer.findClass("android.view.animation.Interpolator", imports)).put("bool", modelAnalyzer.findClass(Boolean.TYPE)).put("color", modelAnalyzer.findClass(Integer.TYPE)).put("dimenOffset", modelAnalyzer.findClass(Integer.TYPE)).put("dimenSize", modelAnalyzer.findClass(Integer.TYPE)).put("id", modelAnalyzer.findClass(Integer.TYPE)).put("integer", modelAnalyzer.findClass(Integer.TYPE)).put("layout", modelAnalyzer.findClass(Integer.TYPE)).put("dimen", modelAnalyzer.findClass(Float.TYPE)).put("fraction", modelAnalyzer.findClass(Float.TYPE)).put("intArray", modelAnalyzer.findClass(int[].class)).put("string", modelAnalyzer.findClass(String.class)).put("stringArray", modelAnalyzer.findClass(String[].class)).build();
        }
        return this.mResourceToTypeMapping;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        Map<String, ModelClass> mapping = this.getResourceToTypeMapping(modelAnalyzer);
        ModelClass modelClass = mapping.get(this.mResourceType);
        if (modelClass != null) {
            return modelClass;
        }
        if ("plurals".equals(this.mResourceType)) {
            if (this.getChildren().isEmpty()) {
                return modelAnalyzer.findClass(Integer.TYPE);
            }
            return modelAnalyzer.findClass(String.class);
        }
        return modelAnalyzer.findClass(this.mResourceType, this.getModel().getImports());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    @Override
    protected String computeUniqueKey() {
        String base = this.mPackage == null ? "@" + this.mResourceType + "/" + this.mResourceId : "@android:" + this.mResourceType + "/" + this.mResourceId;
        return sUniqueKeyJoiner.join(base, this.computeChildrenKey(), new Object[0]);
    }

    public String getResourceId() {
        return this.mPackage + "R." + this.getResourceObject() + "." + this.mResourceId;
    }

    public String toJava() {
        String context = "getRoot().getContext()";
        String resources = "getRoot().getResources()";
        String resourceName = this.mPackage + "R." + this.getResourceObject() + "." + this.mResourceId;
        if ("anim".equals(this.mResourceType)) {
            return "android.view.animation.AnimationUtils.loadAnimation(getRoot().getContext(), " + resourceName + ")";
        }
        if ("animator".equals(this.mResourceType)) {
            return "android.animation.AnimatorInflater.loadAnimator(getRoot().getContext(), " + resourceName + ")";
        }
        if ("bool".equals(this.mResourceType)) {
            return "getRoot().getResources().getBoolean(" + resourceName + ")";
        }
        if ("color".equals(this.mResourceType)) {
            return "getRoot().getResources().getColor(" + resourceName + ")";
        }
        if ("colorStateList".equals(this.mResourceType)) {
            return "getRoot().getResources().getColorStateList(" + resourceName + ")";
        }
        if ("dimen".equals(this.mResourceType)) {
            return "getRoot().getResources().getDimension(" + resourceName + ")";
        }
        if ("dimenOffset".equals(this.mResourceType)) {
            return "getRoot().getResources().getDimensionPixelOffset(" + resourceName + ")";
        }
        if ("dimenSize".equals(this.mResourceType)) {
            return "getRoot().getResources().getDimensionPixelSize(" + resourceName + ")";
        }
        if ("drawable".equals(this.mResourceType)) {
            return "getRoot().getResources().getDrawable(" + resourceName + ")";
        }
        if ("fraction".equals(this.mResourceType)) {
            String base = this.getChildCode(0, "1");
            String pbase = this.getChildCode(1, "1");
            return "getRoot().getResources().getFraction(" + resourceName + ", " + base + ", " + pbase + ")";
        }
        if ("id".equals(this.mResourceType)) {
            return resourceName;
        }
        if ("intArray".equals(this.mResourceType)) {
            return "getRoot().getResources().getIntArray(" + resourceName + ")";
        }
        if ("integer".equals(this.mResourceType)) {
            return "getRoot().getResources().getInteger(" + resourceName + ")";
        }
        if ("interpolator".equals(this.mResourceType)) {
            return "android.view.animation.AnimationUtils.loadInterpolator(getRoot().getContext(), " + resourceName + ")";
        }
        if ("layout".equals(this.mResourceType)) {
            return resourceName;
        }
        if ("plurals".equals(this.mResourceType)) {
            if (this.getChildren().isEmpty()) {
                return resourceName;
            }
            return this.makeParameterCall(resourceName, "getQuantityString");
        }
        if ("stateListAnimator".equals(this.mResourceType)) {
            return "android.animation.AnimatorInflater.loadStateListAnimator(getRoot().getContext(), " + resourceName + ")";
        }
        if ("string".equals(this.mResourceType)) {
            return this.makeParameterCall(resourceName, "getString");
        }
        if ("stringArray".equals(this.mResourceType)) {
            return "getRoot().getResources().getStringArray(" + resourceName + ")";
        }
        if ("transition".equals(this.mResourceType)) {
            return "android.transition.TransitionInflater.from(getRoot().getContext()).inflateTransition(" + resourceName + ")";
        }
        if ("typedArray".equals(this.mResourceType)) {
            return "getRoot().getResources().obtainTypedArray(" + resourceName + ")";
        }
        String property2 = Character.toUpperCase(this.mResourceType.charAt(0)) + this.mResourceType.substring(1);
        return "getRoot().getResources().get" + property2 + "(" + resourceName + ")";
    }

    private String getChildCode(int childIndex, String defaultValue) {
        if (this.getChildren().size() <= childIndex) {
            return defaultValue;
        }
        return WriterPackage.toCode(this.getChildren().get(childIndex), false).generate();
    }

    private String makeParameterCall(String resourceName, String methodCall) {
        StringBuilder sb = new StringBuilder("getRoot().getResources().");
        sb.append(methodCall).append("(").append(resourceName);
        for (Expr expr : this.getChildren()) {
            sb.append(", ").append(WriterPackage.toCode(expr, false).generate());
        }
        sb.append(")");
        return sb.toString();
    }

    private String getResourceObject() {
        String rFileObject = RESOURCE_TYPE_TO_R_OBJECT.get(this.mResourceType);
        if (rFileObject == null) {
            rFileObject = this.mResourceType;
        }
        return rFileObject;
    }
}

