//start of WindowsDate.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * WindowsDate.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util;

//import classes and interfaces
import java.util.Date;
import java.lang.Cloneable;

//import exceptions
import java.lang.IllegalArgumentException;

/**
 * WindowsFILETIME`̏Date̔hNXB<br>
 * FILETIME  1601N 1 1 000b̌oߎԂ
 * 100imbPʂŎ64rbglB<br>
 * ̃NXł FILETIME  long(64rbgl)ƂĈƂ
 * {IɕƂ݂ȂB<br>
 * 1601N 1 1 000bȑO̎Ԃꍇ
 * WindowsDate( Date date ) AWindowsDate.setTime( long time )gpB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: WindowsDate.java,v $
 * Revision 1.1  2002/12/05 00:00:00  dangan
 * [maintenance]
 *     javadoc Rg̃Xy~XCB
 *     \[X
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [bug fix] 
 *     setn\bh ͈͊O̎ԂZbg悤Ƃ
 *     O𓊂P[XŎԂ̏߂sĂȂB
 *     checkRange ̎Ԃ͈̔͂ԈĂB
 * [maintenance]
 *     ^u̔p~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class WindowsDate extends Date
                         implements Cloneable{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  public static final long TIME_DIFFERENCE
    //------------------------------------------------------------------
    /**
     * FILETIME`̃f[^ƁAjava.util.Date.getTime() 
     * 鎞Ԍ`Ƃ̎ԍ 100imZJhPʂŎlB
     * ȂA[b͍lɓĂȂB
     */
    public static final long TIME_DIFFERENCE = 0x19DB1DED53E8000L;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  private int NanoSecounds
    //------------------------------------------------------------------
    /**
     * java.util.Date ł͕ێłȂ 
     * imbPʂ̎Ԃێ邽߂ɗpB
     */
    private int NanoSecounds;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  public WindowsDate()
    //  public WindowsDate( Date date )
    //  public WindowsDate( long time )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * ݂̎ԏ WindowsDate\zB
     * imbPʂ̎Ԃ͎擾łȂ߁A0ɐݒ肳B
     * 
     * @exception IllegalArgumentException
     *                  ݂̎Ԃ FILETIME `ŕ\ł
     *                  ͈͊OꍇB
     */
    public WindowsDate(){
        super();
        this.NanoSecounds = 0;

        this.checkRange();
    }

    /**
     * dateŎ鎞Ԃ\ WindowsDate\zB<br>
     * date WindowsDate ̃CX^XȂ
     * imbPʂ̏Rs[邪AȊȌꍇ
     * imbPʂ̏ɂ 0 ݒ肳B
     * 
     * @param date V\z WindowsDate ̌ƂȂ鎞ԏ 
     *             Date ̃IuWFNg
     * 
     * @exception IllegalArgumentException
     *                  ݂̎Ԃ FILETIME `ŕ\ł
     *                  ͈͊OꍇB
     */
    public WindowsDate( Date date ){
        super( date.getTime() );
        if( date instanceof WindowsDate ){
            this.NanoSecounds = ((WindowsDate)date).NanoSecounds;
        }else{
            this.NanoSecounds = 0;
            this.checkRange();
        }
    }

    /**
     * 64rbgFILETIME`̎ԏ񂩂
     * VWindowsDate\zB<br>
     * 
     * @param time FILETIME`̎ԏ
     */
    public WindowsDate( long time ){
        super( 0 <= time 
         ? ( time - WindowsDate.TIME_DIFFERENCE ) / 10000L
         : ( ( time >>> 1 ) - ( WindowsDate.TIME_DIFFERENCE >>> 1 ) ) / 5000L );

        this.NanoSecounds = 
                 (int)( ( time >>> 1 ) % 5000L * 2 + ( time & 1 ) ) * 100;
    }


    //------------------------------------------------------------------
    //  method of java.lang.Cloneable
    //------------------------------------------------------------------
    //  public Object clone()
    //------------------------------------------------------------------
    /**
     * ̃IuWFNg̃Rs[ԂB
     * 
     * @return WindowsDateIuWFNg̕
     */
    public Object clone(){
        return new WindowsDate( this );
    }


    //------------------------------------------------------------------
    //  method of java.util.Date
    //------------------------------------------------------------------
    //  set method with range check
    //------------------------------------------------------------------
    //  public void setYear( int year )
    //  public void setMonth( int month )
    //  public void setDate( int day )
    //  public void setHours( int hour )
    //  public void setMinutes( int minute )
    //  public void setSecounds( int secound )
    //  public void setTime( long time )
    //------------------------------------------------------------------
    /**
     *  WindowsDate ̎N year 
     * w肳ꂽl1900𑫂̂ɐݒ肷B<br>
     * ̃\bh͔͈̓`FbNŝ߂ɑ݂B<br>
     *
     * @param year 1900𑫂ƂŐ\悤 N̒l
     * 
     * @exception IllegalArgumentException
     *             year ɕύXƂ FILETIME`ňȂ
     *             ͈͂̎ԂɂȂꍇ
     * @deprecated
     */
    public void setYear( int year ){
        long temp = this.getTime();

        try{
            super.setYear( year );
            this.checkRange();
        }catch( IllegalArgumentException exception ){
            this.setTime( temp );
            throw exception;
        }
    }

    /**
     *  WindowsDate ̎ month Ŏw肳ꂽlɐݒ肷B<br>
     * ̃\bh͔͈̓`FbNŝ߂ɑ݂B<br>
     *
     * @param month 01A12悤Ȍ̒l
     * 
     * @exception IllegalArgumentException
     *             month ɕύXƂ FILETIME`ňȂ
     *             ͈͂̎ԂɂȂꍇ
     * @deprecated
     */
    public void setMonth( int month ){
        long temp = this.getTime();

        try{
            super.setMonth( month );
            this.checkRange();
        }catch( IllegalArgumentException exception ){
            this.setTime( temp );
            throw exception;
        }
    }

    /**
     *  WindowsDate ̎ ꃖ
     * ł̉ڂ date Ŏw肳ꂽlɐݒ肷B<br>
     * ̃\bh͔͈̓`FbNŝ߂ɑ݂B<br>
     *
     * @param date 11A22悤ȓ̒l
     * 
     * @exception IllegalArgumentException
     *             date ɕύXƂ FILETIME`ňȂ
     *             ͈͂̎ԂɂȂꍇ
     * @deprecated
     */
    public void setDate( int date ){
        long temp = this.getTime();

        try{
            super.setDate( date );
            this.checkRange();
        }catch( IllegalArgumentException exception ){
            this.setTime( temp );
            throw exception;
        }
    }

    /**
     *  WindowsDate ̎̒ł̎Ԃ
     * hours Ŏw肳ꂽlɐݒ肷B<br>
     * ̃\bh͔͈̓`FbNŝ߂ɑ݂B<br>
     *
     * @param hours Ԃ̒l
     * 
     * @exception IllegalArgumentException
     *             hours ɕύXƂ FILETIME`ňȂ
     *             ͈͂̎ԂɂȂꍇ
     * @deprecated
     */
    public void setHours( int hours ){
        long temp = this.getTime();

        try{
            super.setHours( hours );
            this.checkRange();
        }catch( IllegalArgumentException exception ){
            this.setTime( temp );
            throw exception;
        }
    }

    /**
     *  WindowsDate ̎ꎞԂ̒ł̕
     * minutes Ŏw肳ꂽlɐݒ肷B<br>
     * ̃\bh͔͈̓`FbNŝ߂ɑ݂B<br>
     *
     * @param minutes ̒l
     * 
     * @exception IllegalArgumentException
     *             minutes ɕύXƂ FILETIME`ňȂ
     *             ͈͂̎ԂɂȂꍇ
     * @deprecated
     */
    public void setMinutes( int minutes ){
        long temp = this.getTime();

        try{
            super.setMinutes( minutes );
            this.checkRange();
        }catch( IllegalArgumentException exception ){
            this.setTime( temp );
            throw exception;
        }
    }

    /**
     *  WindowsDate ̎ꕪ̒ł̕b
     * secounds Ŏw肳ꂽlɐݒ肷B<br>
     * ̃\bh͔͈̓`FbNŝ߂ɑ݂B<br>
     *
     * @param secounds b
     * 
     * @exception IllegalArgumentException
     *             secounds ɕύXƂ FILETIME`ňȂ
     *             ͈͂̎ԂɂȂꍇ
     * @deprecated
     */
    public void setSeconds( int seconds ){
        long temp = this.getTime();

        try{
            super.setSeconds( seconds );
            this.checkRange();
        }catch( IllegalArgumentException exception ){
            this.setTime( temp );
            throw exception;
        }
    }

    /**
     *  WindowsDate ̎Ԃ 
     * 1970N11 00:00:00 GMT
     * time ~bo߂ɐݒ肷B<br>
     * ̃\bh͔͈̓`FbNŝ߂ɑ݂B<br>
     * 
     * @param time 1970N11 00:00:00GMT ̌o߃~b
     * 
     * @exception IllegalArgumentException
     *             time FILETIME`ňȂ
     *             ͈͂̎ԂĂꍇ
     */
    public void setTime( long time ){
        long temp = this.getTime();

        try{
            super.setTime( time );
            this.checkRange();
        }catch( IllegalArgumentException exception ){
            this.setTime( temp );
            throw exception;
        }
    }

    //------------------------------------------------------------------
    //  original method
    //------------------------------------------------------------------
    //  access method with FILETIME format
    //------------------------------------------------------------------
    //  public void setWindowsTime( long time )
    //  public long getWindowsTime()
    //------------------------------------------------------------------
    /**
     *  WindowsDate  FILETIME`̎ԏݒ肷B
     * 
     * @param time FILETIME`̎ԏ
     */
    public void setWindowsTime( long time ){
        super.setTime( 0 <= time 
         ? ( time - WindowsDate.TIME_DIFFERENCE ) / 10000L
         : ( ( time >>> 1 ) - ( WindowsDate.TIME_DIFFERENCE >>> 1 ) ) / 5000L );

        this.NanoSecounds = 
                 (int)( ( time >>> 1 ) % 5000L * 2 + ( time & 1 ) ) * 100;
    }

    /**
     *  WindowsDateԏ FILETIME `œB
     * 
     * @return FILETIME`̒l
     */
    public long getWindowsTime() {
        return ( super.getTime() * 10000L + WindowsDate.TIME_DIFFERENCE
                 + (long)( this.NanoSecounds / 100 ) );
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  private void checkRange()
    //------------------------------------------------------------------
    /**
     *  WindowsDate  FILETIME`ŕ\鎞Ԃ
     * ͈͓ł邩𔻒肷B܂sS
     * 
     * @exception IllegalArgumentException
     *              WindowsDate  FILETIME`ňȂ
     *             ͈͂̎ԂĂꍇ
     */
    private void checkRange(){
        long time = super.getTime();
        if( !( 0xFFFCAE8C71E60F9BL <= time && time <= 0x000683218A10A8CBL ) )
            throw new IllegalArgumentException( "outside of range of Windows FILETIME format. " );
    }

}
